# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 container_network_type: pulumi.Input[_builtins.str],
                 flavor_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authenticating_proxy_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]] = None,
                 container_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_all: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_efs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eni: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_evs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_net: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_obs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_sfs: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_distribute_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 eni_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]] = None,
                 hibernate: Optional[pulumi.Input[_builtins.bool]] = None,
                 highway_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lts_reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]] = None,
                 multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 support_istio: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] container_network_type: Specifies the container network type.
               Changing this parameter will create a new cluster resource. Possible values:
               + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
               + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
               + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
               capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
               ELB and containers to provide high performance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the cluster specifications.
               Possible values:
               + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
               + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
               + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
               + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
               + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
               + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).
               
               > Changing the number of control nodes or reducing cluster flavor is not supported.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet used to create the node which should be
               configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC used to create the node.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] alias: Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
               and display names of other clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: schema: Internal
        :param pulumi.Input[_builtins.str] authenticating_proxy_ca: Specifies the CA root certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_cert: Specifies the Client certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_private_key: Specifies the private key of the client certificate
               provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authentication_mode: Specifies the authentication mode of the cluster, possible values
               are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the cluster Type, possible values are **VirtualMachine** and
               **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the cluster version, defaults to the latest supported
               version. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]] component_configurations: Specifies the kubernetes component configurations.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] container_network_cidr: Specifies the container network segments.
               In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
               segments, separated with comma (,). In other situations, only the first segment takes effect.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_sans: Specifies the custom san to add to certificate (array of string).
        :param pulumi.Input[_builtins.str] delete_all: Specified whether to delete all associated storage resources when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_efs: Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_eni: schema: Internal
        :param pulumi.Input[_builtins.str] delete_evs: Specified whether to delete associated EVS disks when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_net: schema: Internal
        :param pulumi.Input[_builtins.str] delete_obs: Specified whether to delete associated OBS buckets when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_sfs: Specified whether to delete associated SFS file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] description: Specifies the cluster description.
        :param pulumi.Input[_builtins.str] eip: Specifies the EIP address of the cluster.
        :param pulumi.Input[_builtins.str] eni_subnet_cidr: The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        :param pulumi.Input[_builtins.str] eni_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
               Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
               Only adding subnets is allowed, removing subnets is not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID of the CCE cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]] extend_params: Specifies the extended parameter.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] hibernate: Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
               hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
               deleted.
               
               <a name="cce_cluster_masters"></a>
               The `masters` block supports:
        :param pulumi.Input[_builtins.str] highway_subnet_id: schema: Internal
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to enable IPv6 in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] kube_proxy_mode: Specifies the service forwarding mode.
               Changing this parameter will create a new cluster resource. Two modes are available:
               
               + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
               iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
               latency and even obvious performance issues in the case of heavy service traffic.
               + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
               and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]] masters: Specifies the advanced configuration of master nodes.
               The object structure is documented below.
               This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] multi_az: Specifies whether to enable multiple AZs for the cluster, only when using HA
               flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        :param pulumi.Input[_builtins.str] name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE cluster.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE cluster.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE cluster resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the default worker node security group ID of the cluster.
               If left empty, the system will automatically create a default worker node security group for you.
               The default worker node security group needs to allow access from certain ports to ensure normal communications.
               If updated, the modified security group will only be applied to nodes newly created or accepted.
               For existing nodes, you need to manually modify the security group rules for them.
        :param pulumi.Input[_builtins.str] service_network_cidr: Specifies the service network segment.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] support_istio: Specifies whether to support Istio in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the CCE cluster, key/value pair format.
        """
        pulumi.set(__self__, "container_network_type", container_network_type)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authenticating_proxy_ca is not None:
            pulumi.set(__self__, "authenticating_proxy_ca", authenticating_proxy_ca)
        if authenticating_proxy_cert is not None:
            pulumi.set(__self__, "authenticating_proxy_cert", authenticating_proxy_cert)
        if authenticating_proxy_private_key is not None:
            pulumi.set(__self__, "authenticating_proxy_private_key", authenticating_proxy_private_key)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if billing_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""billing_mode is deprecated: use charging_mode instead""")
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_configurations is not None:
            pulumi.set(__self__, "component_configurations", component_configurations)
        if container_network_cidr is not None:
            pulumi.set(__self__, "container_network_cidr", container_network_cidr)
        if custom_sans is not None:
            pulumi.set(__self__, "custom_sans", custom_sans)
        if delete_all is not None:
            pulumi.set(__self__, "delete_all", delete_all)
        if delete_efs is not None:
            pulumi.set(__self__, "delete_efs", delete_efs)
        if delete_eni is not None:
            pulumi.set(__self__, "delete_eni", delete_eni)
        if delete_evs is not None:
            pulumi.set(__self__, "delete_evs", delete_evs)
        if delete_net is not None:
            pulumi.set(__self__, "delete_net", delete_net)
        if delete_obs is not None:
            pulumi.set(__self__, "delete_obs", delete_obs)
        if delete_sfs is not None:
            pulumi.set(__self__, "delete_sfs", delete_sfs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if enable_distribute_management is not None:
            pulumi.set(__self__, "enable_distribute_management", enable_distribute_management)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if eni_subnet_cidr is not None:
            pulumi.set(__self__, "eni_subnet_cidr", eni_subnet_cidr)
        if eni_subnet_id is not None:
            pulumi.set(__self__, "eni_subnet_id", eni_subnet_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hibernate is not None:
            pulumi.set(__self__, "hibernate", hibernate)
        if highway_subnet_id is not None:
            pulumi.set(__self__, "highway_subnet_id", highway_subnet_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if kube_proxy_mode is not None:
            pulumi.set(__self__, "kube_proxy_mode", kube_proxy_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lts_reclaim_policy is not None:
            pulumi.set(__self__, "lts_reclaim_policy", lts_reclaim_policy)
        if masters is not None:
            pulumi.set(__self__, "masters", masters)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_network_cidr is not None:
            pulumi.set(__self__, "service_network_cidr", service_network_cidr)
        if support_istio is not None:
            pulumi.set(__self__, "support_istio", support_istio)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="containerNetworkType")
    def container_network_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the container network type.
        Changing this parameter will create a new cluster resource. Possible values:
        + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
        + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
        + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
        capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
        ELB and containers to provide high performance.
        """
        return pulumi.get(self, "container_network_type")

    @container_network_type.setter
    def container_network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_network_type", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the cluster specifications.
        Possible values:
        + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
        + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
        + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
        + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
        + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
        + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).

        > Changing the number of control nodes or reducing cluster flavor is not supported.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the subnet used to create the node which should be
        configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the VPC used to create the node.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
        and display names of other clusters.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCa")
    def authenticating_proxy_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the CA root certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_ca")

    @authenticating_proxy_ca.setter
    def authenticating_proxy_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_ca", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCert")
    def authenticating_proxy_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Client certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_cert")

    @authenticating_proxy_cert.setter
    def authenticating_proxy_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_cert", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyPrivateKey")
    def authenticating_proxy_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private key of the client certificate
        provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_private_key")

    @authenticating_proxy_private_key.setter
    def authenticating_proxy_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_private_key", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the authentication mode of the cluster, possible values
        are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="billingMode")
    @_utilities.deprecated("""use charging_mode instead""")
    def billing_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "billing_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the CCE cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster Type, possible values are **VirtualMachine** and
        **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster version, defaults to the latest supported
        version. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentConfigurations")
    def component_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]]:
        """
        Specifies the kubernetes component configurations.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "component_configurations")

    @component_configurations.setter
    def component_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]]):
        pulumi.set(self, "component_configurations", value)

    @_builtins.property
    @pulumi.getter(name="containerNetworkCidr")
    def container_network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the container network segments.
        In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
        segments, separated with comma (,). In other situations, only the first segment takes effect.
        """
        return pulumi.get(self, "container_network_cidr")

    @container_network_cidr.setter
    def container_network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the custom san to add to certificate (array of string).
        """
        return pulumi.get(self, "custom_sans")

    @custom_sans.setter
    def custom_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_sans", value)

    @_builtins.property
    @pulumi.getter(name="deleteAll")
    def delete_all(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete all associated storage resources when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_all")

    @delete_all.setter
    def delete_all(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_all", value)

    @_builtins.property
    @pulumi.getter(name="deleteEfs")
    def delete_efs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_efs")

    @delete_efs.setter
    def delete_efs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_efs", value)

    @_builtins.property
    @pulumi.getter(name="deleteEni")
    def delete_eni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_eni")

    @delete_eni.setter
    def delete_eni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_eni", value)

    @_builtins.property
    @pulumi.getter(name="deleteEvs")
    def delete_evs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated EVS disks when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_evs")

    @delete_evs.setter
    def delete_evs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_evs", value)

    @_builtins.property
    @pulumi.getter(name="deleteNet")
    def delete_net(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_net")

    @delete_net.setter
    def delete_net(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_net", value)

    @_builtins.property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated OBS buckets when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_obs")

    @delete_obs.setter
    def delete_obs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_obs", value)

    @_builtins.property
    @pulumi.getter(name="deleteSfs")
    def delete_sfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated SFS file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_sfs")

    @delete_sfs.setter
    def delete_sfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_sfs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP address of the cluster.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip", value)

    @_builtins.property
    @pulumi.getter(name="enableDistributeManagement")
    def enable_distribute_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_distribute_management")

    @enable_distribute_management.setter
    def enable_distribute_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_distribute_management", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @_builtins.property
    @pulumi.getter(name="eniSubnetCidr")
    def eni_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        """
        return pulumi.get(self, "eni_subnet_cidr")

    @eni_subnet_cidr.setter
    def eni_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="eniSubnetId")
    def eni_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
        Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
        Only adding subnets is allowed, removing subnets is not allowed.
        """
        return pulumi.get(self, "eni_subnet_id")

    @eni_subnet_id.setter
    def eni_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extend_param", value)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]]:
        """
        Specifies the extended parameter.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]]):
        pulumi.set(self, "extend_params", value)

    @_builtins.property
    @pulumi.getter
    def hibernate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
        hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
        deleted.

        <a name="cce_cluster_masters"></a>
        The `masters` block supports:
        """
        return pulumi.get(self, "hibernate")

    @hibernate.setter
    def hibernate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernate", value)

    @_builtins.property
    @pulumi.getter(name="highwaySubnetId")
    def highway_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "highway_subnet_id")

    @highway_subnet_id.setter
    def highway_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "highway_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable IPv6 in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service forwarding mode.
        Changing this parameter will create a new cluster resource. Two modes are available:

        + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
        iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
        latency and even obvious performance issues in the case of heavy service traffic.
        + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
        and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @kube_proxy_mode.setter
    def kube_proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_proxy_mode", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="ltsReclaimPolicy")
    def lts_reclaim_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "lts_reclaim_policy")

    @lts_reclaim_policy.setter
    def lts_reclaim_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_reclaim_policy", value)

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]]:
        """
        Specifies the advanced configuration of master nodes.
        The object structure is documented below.
        This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "masters")

    @masters.setter
    def masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]]):
        pulumi.set(self, "masters", value)

    @_builtins.property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multiple AZs for the cluster, only when using HA
        flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_az", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the CCE cluster.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE cluster.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CCE cluster resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default worker node security group ID of the cluster.
        If left empty, the system will automatically create a default worker node security group for you.
        The default worker node security group needs to allow access from certain ports to ensure normal communications.
        If updated, the modified security group will only be applied to nodes newly created or accepted.
        For existing nodes, you need to manually modify the security group rules for them.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceNetworkCidr")
    def service_network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service network segment.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "service_network_cidr")

    @service_network_cidr.setter
    def service_network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="supportIstio")
    def support_istio(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to support Istio in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "support_istio")

    @support_istio.setter
    def support_istio(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_istio", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the CCE cluster, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authenticating_proxy_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateClusterArgs']]]] = None,
                 certificate_users: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateUserArgs']]]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]] = None,
                 container_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 container_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_all: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_efs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eni: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_evs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_net: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_obs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_sfs: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_distribute_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterEncryptionConfigArgs']] = None,
                 eni_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernate: Optional[pulumi.Input[_builtins.bool]] = None,
                 highway_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lts_reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]] = None,
                 multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 support_istio: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] alias: Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
               and display names of other clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: schema: Internal
        :param pulumi.Input[_builtins.str] authenticating_proxy_ca: Specifies the CA root certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_cert: Specifies the Client certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_private_key: Specifies the private key of the client certificate
               provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authentication_mode: Specifies the authentication mode of the cluster, possible values
               are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.str] category: The category of the cluster. The value can be **CCE** and **Turbo**.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCertificateClusterArgs']]] certificate_clusters: The certificate clusters. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCertificateUserArgs']]] certificate_users: The certificate users. Structure is documented below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the cluster Type, possible values are **VirtualMachine** and
               **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the cluster version, defaults to the latest supported
               version. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]] component_configurations: Specifies the kubernetes component configurations.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] container_network_cidr: Specifies the container network segments.
               In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
               segments, separated with comma (,). In other situations, only the first segment takes effect.
        :param pulumi.Input[_builtins.str] container_network_type: Specifies the container network type.
               Changing this parameter will create a new cluster resource. Possible values:
               + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
               + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
               + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
               capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
               ELB and containers to provide high performance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_sans: Specifies the custom san to add to certificate (array of string).
        :param pulumi.Input[_builtins.str] delete_all: Specified whether to delete all associated storage resources when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_efs: Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_eni: schema: Internal
        :param pulumi.Input[_builtins.str] delete_evs: Specified whether to delete associated EVS disks when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_net: schema: Internal
        :param pulumi.Input[_builtins.str] delete_obs: Specified whether to delete associated OBS buckets when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_sfs: Specified whether to delete associated SFS file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] description: Specifies the cluster description.
        :param pulumi.Input[_builtins.str] eip: Specifies the EIP address of the cluster.
        :param pulumi.Input[_builtins.str] eni_subnet_cidr: The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        :param pulumi.Input[_builtins.str] eni_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
               Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
               Only adding subnets is allowed, removing subnets is not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID of the CCE cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]] extend_params: Specifies the extended parameter.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the cluster specifications.
               Possible values:
               + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
               + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
               + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
               + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
               + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
               + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).
               
               > Changing the number of control nodes or reducing cluster flavor is not supported.
        :param pulumi.Input[_builtins.bool] hibernate: Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
               hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
               deleted.
               
               <a name="cce_cluster_masters"></a>
               The `masters` block supports:
        :param pulumi.Input[_builtins.str] highway_subnet_id: schema: Internal
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to enable IPv6 in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] kube_config_raw: Raw Kubernetes config to be used by kubectl and other compatible tools.
        :param pulumi.Input[_builtins.str] kube_proxy_mode: Specifies the service forwarding mode.
               Changing this parameter will create a new cluster resource. Two modes are available:
               
               + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
               iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
               latency and even obvious performance issues in the case of heavy service traffic.
               + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
               and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]] masters: Specifies the advanced configuration of master nodes.
               The object structure is documented below.
               This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] multi_az: Specifies whether to enable multiple AZs for the cluster, only when using HA
               flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        :param pulumi.Input[_builtins.str] name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE cluster.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE cluster.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE cluster resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the default worker node security group ID of the cluster.
               If left empty, the system will automatically create a default worker node security group for you.
               The default worker node security group needs to allow access from certain ports to ensure normal communications.
               If updated, the modified security group will only be applied to nodes newly created or accepted.
               For existing nodes, you need to manually modify the security group rules for them.
        :param pulumi.Input[_builtins.str] service_network_cidr: Specifies the service network segment.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] status: Cluster status information.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet used to create the node which should be
               configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] support_istio: Specifies whether to support Istio in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the CCE cluster, key/value pair format.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC used to create the node.
               Changing this parameter will create a new cluster resource.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authenticating_proxy_ca is not None:
            pulumi.set(__self__, "authenticating_proxy_ca", authenticating_proxy_ca)
        if authenticating_proxy_cert is not None:
            pulumi.set(__self__, "authenticating_proxy_cert", authenticating_proxy_cert)
        if authenticating_proxy_private_key is not None:
            pulumi.set(__self__, "authenticating_proxy_private_key", authenticating_proxy_private_key)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if billing_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""billing_mode is deprecated: use charging_mode instead""")
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if certificate_clusters is not None:
            pulumi.set(__self__, "certificate_clusters", certificate_clusters)
        if certificate_users is not None:
            pulumi.set(__self__, "certificate_users", certificate_users)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_configurations is not None:
            pulumi.set(__self__, "component_configurations", component_configurations)
        if container_network_cidr is not None:
            pulumi.set(__self__, "container_network_cidr", container_network_cidr)
        if container_network_type is not None:
            pulumi.set(__self__, "container_network_type", container_network_type)
        if custom_sans is not None:
            pulumi.set(__self__, "custom_sans", custom_sans)
        if delete_all is not None:
            pulumi.set(__self__, "delete_all", delete_all)
        if delete_efs is not None:
            pulumi.set(__self__, "delete_efs", delete_efs)
        if delete_eni is not None:
            pulumi.set(__self__, "delete_eni", delete_eni)
        if delete_evs is not None:
            pulumi.set(__self__, "delete_evs", delete_evs)
        if delete_net is not None:
            pulumi.set(__self__, "delete_net", delete_net)
        if delete_obs is not None:
            pulumi.set(__self__, "delete_obs", delete_obs)
        if delete_sfs is not None:
            pulumi.set(__self__, "delete_sfs", delete_sfs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip is not None:
            pulumi.set(__self__, "eip", eip)
        if enable_distribute_management is not None:
            pulumi.set(__self__, "enable_distribute_management", enable_distribute_management)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if eni_subnet_cidr is not None:
            pulumi.set(__self__, "eni_subnet_cidr", eni_subnet_cidr)
        if eni_subnet_id is not None:
            pulumi.set(__self__, "eni_subnet_id", eni_subnet_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if hibernate is not None:
            pulumi.set(__self__, "hibernate", hibernate)
        if highway_subnet_id is not None:
            pulumi.set(__self__, "highway_subnet_id", highway_subnet_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if kube_config_raw is not None:
            pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        if kube_proxy_mode is not None:
            pulumi.set(__self__, "kube_proxy_mode", kube_proxy_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lts_reclaim_policy is not None:
            pulumi.set(__self__, "lts_reclaim_policy", lts_reclaim_policy)
        if masters is not None:
            pulumi.set(__self__, "masters", masters)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_network_cidr is not None:
            pulumi.set(__self__, "service_network_cidr", service_network_cidr)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if support_istio is not None:
            pulumi.set(__self__, "support_istio", support_istio)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
        and display names of other clusters.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCa")
    def authenticating_proxy_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the CA root certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_ca")

    @authenticating_proxy_ca.setter
    def authenticating_proxy_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_ca", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCert")
    def authenticating_proxy_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Client certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_cert")

    @authenticating_proxy_cert.setter
    def authenticating_proxy_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_cert", value)

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyPrivateKey")
    def authenticating_proxy_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private key of the client certificate
        provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_private_key")

    @authenticating_proxy_private_key.setter
    def authenticating_proxy_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticating_proxy_private_key", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the authentication mode of the cluster, possible values
        are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="billingMode")
    @_utilities.deprecated("""use charging_mode instead""")
    def billing_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "billing_mode", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the cluster. The value can be **CCE** and **Turbo**.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="certificateClusters")
    def certificate_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateClusterArgs']]]]:
        """
        The certificate clusters. Structure is documented below.
        """
        return pulumi.get(self, "certificate_clusters")

    @certificate_clusters.setter
    def certificate_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateClusterArgs']]]]):
        pulumi.set(self, "certificate_clusters", value)

    @_builtins.property
    @pulumi.getter(name="certificateUsers")
    def certificate_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateUserArgs']]]]:
        """
        The certificate users. Structure is documented below.
        """
        return pulumi.get(self, "certificate_users")

    @certificate_users.setter
    def certificate_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCertificateUserArgs']]]]):
        pulumi.set(self, "certificate_users", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the CCE cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster Type, possible values are **VirtualMachine** and
        **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster version, defaults to the latest supported
        version. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentConfigurations")
    def component_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]]:
        """
        Specifies the kubernetes component configurations.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "component_configurations")

    @component_configurations.setter
    def component_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentConfigurationArgs']]]]):
        pulumi.set(self, "component_configurations", value)

    @_builtins.property
    @pulumi.getter(name="containerNetworkCidr")
    def container_network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the container network segments.
        In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
        segments, separated with comma (,). In other situations, only the first segment takes effect.
        """
        return pulumi.get(self, "container_network_cidr")

    @container_network_cidr.setter
    def container_network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="containerNetworkType")
    def container_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the container network type.
        Changing this parameter will create a new cluster resource. Possible values:
        + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
        + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
        + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
        capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
        ELB and containers to provide high performance.
        """
        return pulumi.get(self, "container_network_type")

    @container_network_type.setter
    def container_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_network_type", value)

    @_builtins.property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the custom san to add to certificate (array of string).
        """
        return pulumi.get(self, "custom_sans")

    @custom_sans.setter
    def custom_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_sans", value)

    @_builtins.property
    @pulumi.getter(name="deleteAll")
    def delete_all(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete all associated storage resources when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_all")

    @delete_all.setter
    def delete_all(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_all", value)

    @_builtins.property
    @pulumi.getter(name="deleteEfs")
    def delete_efs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_efs")

    @delete_efs.setter
    def delete_efs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_efs", value)

    @_builtins.property
    @pulumi.getter(name="deleteEni")
    def delete_eni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_eni")

    @delete_eni.setter
    def delete_eni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_eni", value)

    @_builtins.property
    @pulumi.getter(name="deleteEvs")
    def delete_evs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated EVS disks when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_evs")

    @delete_evs.setter
    def delete_evs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_evs", value)

    @_builtins.property
    @pulumi.getter(name="deleteNet")
    def delete_net(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_net")

    @delete_net.setter
    def delete_net(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_net", value)

    @_builtins.property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated OBS buckets when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_obs")

    @delete_obs.setter
    def delete_obs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_obs", value)

    @_builtins.property
    @pulumi.getter(name="deleteSfs")
    def delete_sfs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified whether to delete associated SFS file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_sfs")

    @delete_sfs.setter
    def delete_sfs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_sfs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def eip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP address of the cluster.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip", value)

    @_builtins.property
    @pulumi.getter(name="enableDistributeManagement")
    def enable_distribute_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_distribute_management")

    @enable_distribute_management.setter
    def enable_distribute_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_distribute_management", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterEncryptionConfigArgs']]:
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @_builtins.property
    @pulumi.getter(name="eniSubnetCidr")
    def eni_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        """
        return pulumi.get(self, "eni_subnet_cidr")

    @eni_subnet_cidr.setter
    def eni_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="eniSubnetId")
    def eni_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
        Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
        Only adding subnets is allowed, removing subnets is not allowed.
        """
        return pulumi.get(self, "eni_subnet_id")

    @eni_subnet_id.setter
    def eni_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extend_param", value)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]]:
        """
        Specifies the extended parameter.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterExtendParamArgs']]]]):
        pulumi.set(self, "extend_params", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster specifications.
        Possible values:
        + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
        + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
        + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
        + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
        + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
        + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).

        > Changing the number of control nodes or reducing cluster flavor is not supported.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter
    def hibernate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
        hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
        deleted.

        <a name="cce_cluster_masters"></a>
        The `masters` block supports:
        """
        return pulumi.get(self, "hibernate")

    @hibernate.setter
    def hibernate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernate", value)

    @_builtins.property
    @pulumi.getter(name="highwaySubnetId")
    def highway_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "highway_subnet_id")

    @highway_subnet_id.setter
    def highway_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "highway_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable IPv6 in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Raw Kubernetes config to be used by kubectl and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @kube_config_raw.setter
    def kube_config_raw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config_raw", value)

    @_builtins.property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service forwarding mode.
        Changing this parameter will create a new cluster resource. Two modes are available:

        + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
        iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
        latency and even obvious performance issues in the case of heavy service traffic.
        + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
        and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @kube_proxy_mode.setter
    def kube_proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_proxy_mode", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="ltsReclaimPolicy")
    def lts_reclaim_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "lts_reclaim_policy")

    @lts_reclaim_policy.setter
    def lts_reclaim_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_reclaim_policy", value)

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]]:
        """
        Specifies the advanced configuration of master nodes.
        The object structure is documented below.
        This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "masters")

    @masters.setter
    def masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterArgs']]]]):
        pulumi.set(self, "masters", value)

    @_builtins.property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multiple AZs for the cluster, only when using HA
        flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_az", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the CCE cluster.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE cluster.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CCE cluster resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default worker node security group ID of the cluster.
        If left empty, the system will automatically create a default worker node security group for you.
        The default worker node security group needs to allow access from certain ports to ensure normal communications.
        If updated, the modified security group will only be applied to nodes newly created or accepted.
        For existing nodes, you need to manually modify the security group rules for them.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceNetworkCidr")
    def service_network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service network segment.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "service_network_cidr")

    @service_network_cidr.setter
    def service_network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_network_cidr", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster status information.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the subnet used to create the node which should be
        configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="supportIstio")
    def support_istio(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to support Istio in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "support_istio")

    @support_istio.setter
    def support_istio(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_istio", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the CCE cluster, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the VPC used to create the node.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Cce/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authenticating_proxy_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentConfigurationArgs', 'ClusterComponentConfigurationArgsDict']]]]] = None,
                 container_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 container_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_all: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_efs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eni: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_evs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_net: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_obs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_sfs: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_distribute_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 eni_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterExtendParamArgs', 'ClusterExtendParamArgsDict']]]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernate: Optional[pulumi.Input[_builtins.bool]] = None,
                 highway_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lts_reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterArgs', 'ClusterMasterArgsDict']]]]] = None,
                 multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 support_istio: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CCE cluster resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        myvpc = sbercloud.vpc.Vpc("myvpc",
            name="vpc",
            cidr="192.168.0.0/16")
        mysubnet = sbercloud.vpc.Subnet("mysubnet",
            name="subnet",
            cidr="192.168.0.0/16",
            gateway_ip="192.168.0.1",
            primary_dns="100.125.13.59",
            secondary_dns="100.125.65.14",
            vpc_id=myvpc.id)
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            flavor_id="cce.s1.small",
            vpc_id=myvpc.id,
            subnet_id=mysubnet.id,
            container_network_type="overlay_l2")
        ```

        ### Cluster With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        myvpc = sbercloud.vpc.Vpc("myvpc",
            name="vpc",
            cidr="192.168.0.0/16")
        mysubnet = sbercloud.vpc.Subnet("mysubnet",
            name="subnet",
            cidr="192.168.0.0/16",
            gateway_ip="192.168.0.1",
            primary_dns="100.125.13.59",
            secondary_dns="100.125.65.14",
            vpc_id=myvpc.id)
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            cluster_type="VirtualMachine",
            flavor_id="cce.s1.small",
            vpc_id=myvpc.id,
            subnet_id=mysubnet.id,
            container_network_type="overlay_l2",
            authentication_mode="rbac",
            eip=myeip.address)
        ```

        ### CCE HA Cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            flavor_id="cce.s2.small",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            container_network_type="overlay_l2",
            masters=[
                {
                    "availability_zone": "cn-north-4a",
                },
                {
                    "availability_zone": "cn-north-4b",
                },
                {
                    "availability_zone": "cn-north-4c",
                },
            ])
        ```

        ## Import

        Cluster can be imported using the cluster ID, e.g.

        ```sh
        $ pulumi import sbercloud:Cce/cluster:Cluster  sbercloud_cce_cluster.cluster_1 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `delete_efs`, `delete_eni`, `delete_evs`, `delete_net`, `delete_obs`, `delete_sfs` and `delete_all`. It is generally

        recommended running `pulumi preview` after importing an CCE cluster. You can then decide if changes should be applied to

        the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as

        below.

        resource "sbercloud_cce_cluster" "cluster_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              delete_efs, delete_obs,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
               and display names of other clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: schema: Internal
        :param pulumi.Input[_builtins.str] authenticating_proxy_ca: Specifies the CA root certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_cert: Specifies the Client certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_private_key: Specifies the private key of the client certificate
               provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authentication_mode: Specifies the authentication mode of the cluster, possible values
               are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the cluster Type, possible values are **VirtualMachine** and
               **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the cluster version, defaults to the latest supported
               version. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentConfigurationArgs', 'ClusterComponentConfigurationArgsDict']]]] component_configurations: Specifies the kubernetes component configurations.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] container_network_cidr: Specifies the container network segments.
               In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
               segments, separated with comma (,). In other situations, only the first segment takes effect.
        :param pulumi.Input[_builtins.str] container_network_type: Specifies the container network type.
               Changing this parameter will create a new cluster resource. Possible values:
               + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
               + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
               + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
               capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
               ELB and containers to provide high performance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_sans: Specifies the custom san to add to certificate (array of string).
        :param pulumi.Input[_builtins.str] delete_all: Specified whether to delete all associated storage resources when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_efs: Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_eni: schema: Internal
        :param pulumi.Input[_builtins.str] delete_evs: Specified whether to delete associated EVS disks when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_net: schema: Internal
        :param pulumi.Input[_builtins.str] delete_obs: Specified whether to delete associated OBS buckets when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_sfs: Specified whether to delete associated SFS file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] description: Specifies the cluster description.
        :param pulumi.Input[_builtins.str] eip: Specifies the EIP address of the cluster.
        :param pulumi.Input[_builtins.str] eni_subnet_cidr: The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        :param pulumi.Input[_builtins.str] eni_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
               Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
               Only adding subnets is allowed, removing subnets is not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID of the CCE cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterExtendParamArgs', 'ClusterExtendParamArgsDict']]]] extend_params: Specifies the extended parameter.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the cluster specifications.
               Possible values:
               + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
               + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
               + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
               + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
               + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
               + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).
               
               > Changing the number of control nodes or reducing cluster flavor is not supported.
        :param pulumi.Input[_builtins.bool] hibernate: Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
               hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
               deleted.
               
               <a name="cce_cluster_masters"></a>
               The `masters` block supports:
        :param pulumi.Input[_builtins.str] highway_subnet_id: schema: Internal
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to enable IPv6 in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] kube_proxy_mode: Specifies the service forwarding mode.
               Changing this parameter will create a new cluster resource. Two modes are available:
               
               + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
               iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
               latency and even obvious performance issues in the case of heavy service traffic.
               + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
               and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterArgs', 'ClusterMasterArgsDict']]]] masters: Specifies the advanced configuration of master nodes.
               The object structure is documented below.
               This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] multi_az: Specifies whether to enable multiple AZs for the cluster, only when using HA
               flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        :param pulumi.Input[_builtins.str] name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE cluster.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE cluster.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE cluster resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the default worker node security group ID of the cluster.
               If left empty, the system will automatically create a default worker node security group for you.
               The default worker node security group needs to allow access from certain ports to ensure normal communications.
               If updated, the modified security group will only be applied to nodes newly created or accepted.
               For existing nodes, you need to manually modify the security group rules for them.
        :param pulumi.Input[_builtins.str] service_network_cidr: Specifies the service network segment.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet used to create the node which should be
               configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] support_istio: Specifies whether to support Istio in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the CCE cluster, key/value pair format.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC used to create the node.
               Changing this parameter will create a new cluster resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CCE cluster resource.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        myvpc = sbercloud.vpc.Vpc("myvpc",
            name="vpc",
            cidr="192.168.0.0/16")
        mysubnet = sbercloud.vpc.Subnet("mysubnet",
            name="subnet",
            cidr="192.168.0.0/16",
            gateway_ip="192.168.0.1",
            primary_dns="100.125.13.59",
            secondary_dns="100.125.65.14",
            vpc_id=myvpc.id)
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            flavor_id="cce.s1.small",
            vpc_id=myvpc.id,
            subnet_id=mysubnet.id,
            container_network_type="overlay_l2")
        ```

        ### Cluster With EIP

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        myvpc = sbercloud.vpc.Vpc("myvpc",
            name="vpc",
            cidr="192.168.0.0/16")
        mysubnet = sbercloud.vpc.Subnet("mysubnet",
            name="subnet",
            cidr="192.168.0.0/16",
            gateway_ip="192.168.0.1",
            primary_dns="100.125.13.59",
            secondary_dns="100.125.65.14",
            vpc_id=myvpc.id)
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            cluster_type="VirtualMachine",
            flavor_id="cce.s1.small",
            vpc_id=myvpc.id,
            subnet_id=mysubnet.id,
            container_network_type="overlay_l2",
            authentication_mode="rbac",
            eip=myeip.address)
        ```

        ### CCE HA Cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        cluster = sbercloud.cce.Cluster("cluster",
            name="cluster",
            flavor_id="cce.s2.small",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            container_network_type="overlay_l2",
            masters=[
                {
                    "availability_zone": "cn-north-4a",
                },
                {
                    "availability_zone": "cn-north-4b",
                },
                {
                    "availability_zone": "cn-north-4c",
                },
            ])
        ```

        ## Import

        Cluster can be imported using the cluster ID, e.g.

        ```sh
        $ pulumi import sbercloud:Cce/cluster:Cluster  sbercloud_cce_cluster.cluster_1 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `delete_efs`, `delete_eni`, `delete_evs`, `delete_net`, `delete_obs`, `delete_sfs` and `delete_all`. It is generally

        recommended running `pulumi preview` after importing an CCE cluster. You can then decide if changes should be applied to

        the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as

        below.

        resource "sbercloud_cce_cluster" "cluster_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              delete_efs, delete_obs,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 authenticating_proxy_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticating_proxy_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentConfigurationArgs', 'ClusterComponentConfigurationArgsDict']]]]] = None,
                 container_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 container_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_all: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_efs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_eni: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_evs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_net: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_obs: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_sfs: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_distribute_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
                 eni_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 eni_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterExtendParamArgs', 'ClusterExtendParamArgsDict']]]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernate: Optional[pulumi.Input[_builtins.bool]] = None,
                 highway_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lts_reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterArgs', 'ClusterMasterArgsDict']]]]] = None,
                 multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 support_istio: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["authenticating_proxy_ca"] = authenticating_proxy_ca
            __props__.__dict__["authenticating_proxy_cert"] = authenticating_proxy_cert
            __props__.__dict__["authenticating_proxy_private_key"] = authenticating_proxy_private_key
            __props__.__dict__["authentication_mode"] = authentication_mode
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["cluster_version"] = cluster_version
            __props__.__dict__["component_configurations"] = component_configurations
            __props__.__dict__["container_network_cidr"] = container_network_cidr
            if container_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'container_network_type'")
            __props__.__dict__["container_network_type"] = container_network_type
            __props__.__dict__["custom_sans"] = custom_sans
            __props__.__dict__["delete_all"] = delete_all
            __props__.__dict__["delete_efs"] = delete_efs
            __props__.__dict__["delete_eni"] = delete_eni
            __props__.__dict__["delete_evs"] = delete_evs
            __props__.__dict__["delete_net"] = delete_net
            __props__.__dict__["delete_obs"] = delete_obs
            __props__.__dict__["delete_sfs"] = delete_sfs
            __props__.__dict__["description"] = description
            __props__.__dict__["eip"] = eip
            __props__.__dict__["enable_distribute_management"] = enable_distribute_management
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["eni_subnet_cidr"] = eni_subnet_cidr
            __props__.__dict__["eni_subnet_id"] = eni_subnet_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["extend_param"] = extend_param
            __props__.__dict__["extend_params"] = extend_params
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["hibernate"] = hibernate
            __props__.__dict__["highway_subnet_id"] = highway_subnet_id
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["kube_proxy_mode"] = kube_proxy_mode
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lts_reclaim_policy"] = lts_reclaim_policy
            __props__.__dict__["masters"] = masters
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_network_cidr"] = service_network_cidr
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["support_istio"] = support_istio
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["category"] = None
            __props__.__dict__["certificate_clusters"] = None
            __props__.__dict__["certificate_users"] = None
            __props__.__dict__["kube_config_raw"] = None
            __props__.__dict__["status"] = None
        super(Cluster, __self__).__init__(
            'sbercloud:Cce/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            authenticating_proxy_ca: Optional[pulumi.Input[_builtins.str]] = None,
            authenticating_proxy_cert: Optional[pulumi.Input[_builtins.str]] = None,
            authenticating_proxy_private_key: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCertificateClusterArgs', 'ClusterCertificateClusterArgsDict']]]]] = None,
            certificate_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCertificateUserArgs', 'ClusterCertificateUserArgsDict']]]]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            component_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentConfigurationArgs', 'ClusterComponentConfigurationArgsDict']]]]] = None,
            container_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            container_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            custom_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            delete_all: Optional[pulumi.Input[_builtins.str]] = None,
            delete_efs: Optional[pulumi.Input[_builtins.str]] = None,
            delete_eni: Optional[pulumi.Input[_builtins.str]] = None,
            delete_evs: Optional[pulumi.Input[_builtins.str]] = None,
            delete_net: Optional[pulumi.Input[_builtins.str]] = None,
            delete_obs: Optional[pulumi.Input[_builtins.str]] = None,
            delete_sfs: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eip: Optional[pulumi.Input[_builtins.str]] = None,
            enable_distribute_management: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_config: Optional[pulumi.Input[Union['ClusterEncryptionConfigArgs', 'ClusterEncryptionConfigArgsDict']]] = None,
            eni_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            eni_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            extend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterExtendParamArgs', 'ClusterExtendParamArgsDict']]]]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            hibernate: Optional[pulumi.Input[_builtins.bool]] = None,
            highway_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            kube_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
            kube_proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lts_reclaim_policy: Optional[pulumi.Input[_builtins.str]] = None,
            masters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterArgs', 'ClusterMasterArgsDict']]]]] = None,
            multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            support_istio: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
               and display names of other clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: schema: Internal
        :param pulumi.Input[_builtins.str] authenticating_proxy_ca: Specifies the CA root certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_cert: Specifies the Client certificate provided in the
               **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authenticating_proxy_private_key: Specifies the private key of the client certificate
               provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] authentication_mode: Specifies the authentication mode of the cluster, possible values
               are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[_builtins.str] category: The category of the cluster. The value can be **CCE** and **Turbo**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCertificateClusterArgs', 'ClusterCertificateClusterArgsDict']]]] certificate_clusters: The certificate clusters. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCertificateUserArgs', 'ClusterCertificateUserArgsDict']]]] certificate_users: The certificate users. Structure is documented below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_type: Specifies the cluster Type, possible values are **VirtualMachine** and
               **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the cluster version, defaults to the latest supported
               version. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentConfigurationArgs', 'ClusterComponentConfigurationArgsDict']]]] component_configurations: Specifies the kubernetes component configurations.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] container_network_cidr: Specifies the container network segments.
               In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
               segments, separated with comma (,). In other situations, only the first segment takes effect.
        :param pulumi.Input[_builtins.str] container_network_type: Specifies the container network type.
               Changing this parameter will create a new cluster resource. Possible values:
               + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
               + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
               + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
               capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
               ELB and containers to provide high performance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_sans: Specifies the custom san to add to certificate (array of string).
        :param pulumi.Input[_builtins.str] delete_all: Specified whether to delete all associated storage resources when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_efs: Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_eni: schema: Internal
        :param pulumi.Input[_builtins.str] delete_evs: Specified whether to delete associated EVS disks when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_net: schema: Internal
        :param pulumi.Input[_builtins.str] delete_obs: Specified whether to delete associated OBS buckets when deleting the CCE cluster.
               valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] delete_sfs: Specified whether to delete associated SFS file systems when deleting the CCE
               cluster. valid values are **true**, **try** and **false**. Default is **false**.
        :param pulumi.Input[_builtins.str] description: Specifies the cluster description.
        :param pulumi.Input[_builtins.str] eip: Specifies the EIP address of the cluster.
        :param pulumi.Input[_builtins.str] eni_subnet_cidr: The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        :param pulumi.Input[_builtins.str] eni_subnet_id: Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
               Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
               Only adding subnets is allowed, removing subnets is not allowed.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID of the CCE cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterExtendParamArgs', 'ClusterExtendParamArgsDict']]]] extend_params: Specifies the extended parameter.
               The object structure is documented below.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the cluster specifications.
               Possible values:
               + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
               + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
               + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
               + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
               + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
               + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).
               
               > Changing the number of control nodes or reducing cluster flavor is not supported.
        :param pulumi.Input[_builtins.bool] hibernate: Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
               hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
               deleted.
               
               <a name="cce_cluster_masters"></a>
               The `masters` block supports:
        :param pulumi.Input[_builtins.str] highway_subnet_id: schema: Internal
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to enable IPv6 in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] kube_config_raw: Raw Kubernetes config to be used by kubectl and other compatible tools.
        :param pulumi.Input[_builtins.str] kube_proxy_mode: Specifies the service forwarding mode.
               Changing this parameter will create a new cluster resource. Two modes are available:
               
               + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
               iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
               latency and even obvious performance issues in the case of heavy service traffic.
               + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
               and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: schema: Internal
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMasterArgs', 'ClusterMasterArgsDict']]]] masters: Specifies the advanced configuration of master nodes.
               The object structure is documented below.
               This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] multi_az: Specifies whether to enable multiple AZs for the cluster, only when using HA
               flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        :param pulumi.Input[_builtins.str] name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE cluster.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE cluster.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE cluster resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the default worker node security group ID of the cluster.
               If left empty, the system will automatically create a default worker node security group for you.
               The default worker node security group needs to allow access from certain ports to ensure normal communications.
               If updated, the modified security group will only be applied to nodes newly created or accepted.
               For existing nodes, you need to manually modify the security group rules for them.
        :param pulumi.Input[_builtins.str] service_network_cidr: Specifies the service network segment.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.str] status: Cluster status information.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet used to create the node which should be
               configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        :param pulumi.Input[_builtins.bool] support_istio: Specifies whether to support Istio in the cluster.
               Changing this parameter will create a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the CCE cluster, key/value pair format.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of the VPC used to create the node.
               Changing this parameter will create a new cluster resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["authenticating_proxy_ca"] = authenticating_proxy_ca
        __props__.__dict__["authenticating_proxy_cert"] = authenticating_proxy_cert
        __props__.__dict__["authenticating_proxy_private_key"] = authenticating_proxy_private_key
        __props__.__dict__["authentication_mode"] = authentication_mode
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["category"] = category
        __props__.__dict__["certificate_clusters"] = certificate_clusters
        __props__.__dict__["certificate_users"] = certificate_users
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_configurations"] = component_configurations
        __props__.__dict__["container_network_cidr"] = container_network_cidr
        __props__.__dict__["container_network_type"] = container_network_type
        __props__.__dict__["custom_sans"] = custom_sans
        __props__.__dict__["delete_all"] = delete_all
        __props__.__dict__["delete_efs"] = delete_efs
        __props__.__dict__["delete_eni"] = delete_eni
        __props__.__dict__["delete_evs"] = delete_evs
        __props__.__dict__["delete_net"] = delete_net
        __props__.__dict__["delete_obs"] = delete_obs
        __props__.__dict__["delete_sfs"] = delete_sfs
        __props__.__dict__["description"] = description
        __props__.__dict__["eip"] = eip
        __props__.__dict__["enable_distribute_management"] = enable_distribute_management
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["eni_subnet_cidr"] = eni_subnet_cidr
        __props__.__dict__["eni_subnet_id"] = eni_subnet_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["extend_param"] = extend_param
        __props__.__dict__["extend_params"] = extend_params
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["hibernate"] = hibernate
        __props__.__dict__["highway_subnet_id"] = highway_subnet_id
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["kube_config_raw"] = kube_config_raw
        __props__.__dict__["kube_proxy_mode"] = kube_proxy_mode
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lts_reclaim_policy"] = lts_reclaim_policy
        __props__.__dict__["masters"] = masters
        __props__.__dict__["multi_az"] = multi_az
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_network_cidr"] = service_network_cidr
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["support_istio"] = support_istio
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["vpc_id"] = vpc_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display name of a cluster. The value of `alias` cannot be the same as the `name`
        and display names of other clusters.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCa")
    def authenticating_proxy_ca(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the CA root certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_ca")

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyCert")
    def authenticating_proxy_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Client certificate provided in the
        **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_cert")

    @_builtins.property
    @pulumi.getter(name="authenticatingProxyPrivateKey")
    def authenticating_proxy_private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the private key of the client certificate
        provided in the **authenticating_proxy** mode. The input value can be a Base64 encoded string or not.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authenticating_proxy_private_key")

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the authentication mode of the cluster, possible values
        are **rbac** and **authenticating_proxy**. Defaults to **rbac**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "authentication_mode")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    @_utilities.deprecated("""use charging_mode instead""")
    def billing_mode(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the cluster. The value can be **CCE** and **Turbo**.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="certificateClusters")
    def certificate_clusters(self) -> pulumi.Output[Sequence['outputs.ClusterCertificateCluster']]:
        """
        The certificate clusters. Structure is documented below.
        """
        return pulumi.get(self, "certificate_clusters")

    @_builtins.property
    @pulumi.getter(name="certificateUsers")
    def certificate_users(self) -> pulumi.Output[Sequence['outputs.ClusterCertificateUser']]:
        """
        The certificate users. Structure is documented below.
        """
        return pulumi.get(self, "certificate_users")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the CCE cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the cluster Type, possible values are **VirtualMachine** and
        **ARM64**. Defaults to **VirtualMachine**. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster version, defaults to the latest supported
        version. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="componentConfigurations")
    def component_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterComponentConfiguration']]]:
        """
        Specifies the kubernetes component configurations.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "component_configurations")

    @_builtins.property
    @pulumi.getter(name="containerNetworkCidr")
    def container_network_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the container network segments.
        In clusters of v1.21 and later, when the `container_network_type` is **vpc-router**, you can add multiple container
        segments, separated with comma (,). In other situations, only the first segment takes effect.
        """
        return pulumi.get(self, "container_network_cidr")

    @_builtins.property
    @pulumi.getter(name="containerNetworkType")
    def container_network_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the container network type.
        Changing this parameter will create a new cluster resource. Possible values:
        + **overlay_l2**: An overlay_l2 network built for containers by using Open vSwitch(OVS).
        + **vpc-router**: An vpc-router network built for containers by using ipvlan and custom VPC routes.
        + **eni**: A Yangtse network built for CCE Turbo cluster. The container network deeply integrates the native ENI
        capability of VPC, uses the VPC CIDR block to allocate container addresses, and supports direct connections between
        ELB and containers to provide high performance.
        """
        return pulumi.get(self, "container_network_type")

    @_builtins.property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the custom san to add to certificate (array of string).
        """
        return pulumi.get(self, "custom_sans")

    @_builtins.property
    @pulumi.getter(name="deleteAll")
    def delete_all(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specified whether to delete all associated storage resources when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_all")

    @_builtins.property
    @pulumi.getter(name="deleteEfs")
    def delete_efs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specified whether to unbind associated SFS Turbo file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_efs")

    @_builtins.property
    @pulumi.getter(name="deleteEni")
    def delete_eni(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_eni")

    @_builtins.property
    @pulumi.getter(name="deleteEvs")
    def delete_evs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specified whether to delete associated EVS disks when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_evs")

    @_builtins.property
    @pulumi.getter(name="deleteNet")
    def delete_net(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "delete_net")

    @_builtins.property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specified whether to delete associated OBS buckets when deleting the CCE cluster.
        valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_obs")

    @_builtins.property
    @pulumi.getter(name="deleteSfs")
    def delete_sfs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specified whether to delete associated SFS file systems when deleting the CCE
        cluster. valid values are **true**, **try** and **false**. Default is **false**.
        """
        return pulumi.get(self, "delete_sfs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def eip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the EIP address of the cluster.
        """
        return pulumi.get(self, "eip")

    @_builtins.property
    @pulumi.getter(name="enableDistributeManagement")
    def enable_distribute_management(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "enable_distribute_management")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output['outputs.ClusterEncryptionConfig']:
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter(name="eniSubnetCidr")
    def eni_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The ENI network segment. This value is valid when only one eni_subnet_id is specified.
        """
        return pulumi.get(self, "eni_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="eniSubnetId")
    def eni_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the **IPv4 subnet ID** of the subnet where the ENI resides.
        Specified when creating a CCE Turbo cluster. You can add multiple IPv4 subnet ID, separated with comma (,).
        Only adding subnets is allowed, removing subnets is not allowed.
        """
        return pulumi.get(self, "eni_subnet_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterExtendParam']]]:
        """
        Specifies the extended parameter.
        The object structure is documented below.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster specifications.
        Possible values:
        + **cce.s1.small**: small-scale single cluster (up to 50 nodes).
        + **cce.s1.medium**: medium-scale single cluster (up to 200 nodes).
        + **cce.s2.small**: small-scale HA cluster (up to 50 nodes).
        + **cce.s2.medium**: medium-scale HA cluster (up to 200 nodes).
        + **cce.s2.large**: large-scale HA cluster (up to 1000 nodes).
        + **cce.s2.xlarge**: large-scale HA cluster (up to 2000 nodes).

        > Changing the number of control nodes or reducing cluster flavor is not supported.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def hibernate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to hibernate the CCE cluster. Defaults to **false**. After a cluster is
        hibernated, resources such as workloads cannot be created or managed in the cluster, and the cluster cannot be
        deleted.

        <a name="cce_cluster_masters"></a>
        The `masters` block supports:
        """
        return pulumi.get(self, "hibernate")

    @_builtins.property
    @pulumi.getter(name="highwaySubnetId")
    def highway_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        schema: Internal
        """
        return pulumi.get(self, "highway_subnet_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable IPv6 in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> pulumi.Output[_builtins.str]:
        """
        Raw Kubernetes config to be used by kubectl and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @_builtins.property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the service forwarding mode.
        Changing this parameter will create a new cluster resource. Two modes are available:

        + **iptables**: Traditional kube-proxy uses iptables rules to implement service load balancing. In this mode, too many
        iptables rules will be generated when many services are deployed. In addition, non-incremental updates will cause a
        latency and even obvious performance issues in the case of heavy service traffic.
        + **ipvs**: Optimized kube-proxy mode with higher throughput and faster speed. This mode supports incremental updates
        and can keep connections uninterrupted during service updates. It is suitable for large-sized clusters.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="ltsReclaimPolicy")
    def lts_reclaim_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "lts_reclaim_policy")

    @_builtins.property
    @pulumi.getter
    def masters(self) -> pulumi.Output[Sequence['outputs.ClusterMaster']]:
        """
        Specifies the advanced configuration of master nodes.
        The object structure is documented below.
        This parameter and `multi_az` are alternative. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "masters")

    @_builtins.property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable multiple AZs for the cluster, only when using HA
        flavors. Changing this parameter will create a new cluster resource. This parameter and `masters` are alternative.
        """
        return pulumi.get(self, "multi_az")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the CCE cluster.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE cluster.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the CCE cluster resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default worker node security group ID of the cluster.
        If left empty, the system will automatically create a default worker node security group for you.
        The default worker node security group needs to allow access from certain ports to ensure normal communications.
        If updated, the modified security group will only be applied to nodes newly created or accepted.
        For existing nodes, you need to manually modify the security group rules for them.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkCidr")
    def service_network_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the service network segment.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "service_network_cidr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster status information.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the subnet used to create the node which should be
        configured with a *DNS address*. Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="supportIstio")
    def support_istio(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to support Istio in the cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "support_istio")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of the CCE cluster, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the VPC used to create the node.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

