# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddonTemplateResult',
    'AwaitableGetAddonTemplateResult',
    'get_addon_template',
    'get_addon_template_output',
]

@pulumi.output_type
class GetAddonTemplateResult:
    """
    A collection of values returned by getAddonTemplate.
    """
    def __init__(__self__, cluster_id=None, description=None, id=None, name=None, region=None, spec=None, stable=None, support_versions=None, version=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if spec and not isinstance(spec, str):
            raise TypeError("Expected argument 'spec' to be a str")
        pulumi.set(__self__, "spec", spec)
        if stable and not isinstance(stable, bool):
            raise TypeError("Expected argument 'stable' to be a bool")
        pulumi.set(__self__, "stable", stable)
        if support_versions and not isinstance(support_versions, list):
            raise TypeError("Expected argument 'support_versions' to be a list")
        pulumi.set(__self__, "support_versions", support_versions)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the add-on.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        The detail configuration of the add-on template.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def stable(self) -> _builtins.bool:
        """
        Whether the add-on template is a stable version.
        """
        return pulumi.get(self, "stable")

    @_builtins.property
    @pulumi.getter(name="supportVersions")
    def support_versions(self) -> Sequence['outputs.GetAddonTemplateSupportVersionResult']:
        return pulumi.get(self, "support_versions")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetAddonTemplateResult(GetAddonTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonTemplateResult(
            cluster_id=self.cluster_id,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            spec=self.spec,
            stable=self.stable,
            support_versions=self.support_versions,
            version=self.version)


def get_addon_template(cluster_id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       version: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonTemplateResult:
    """
    Use this data source to get available SberCloud CCE add-on template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    addon_name = config.require_object("addonName")
    addon_version = config.require_object("addonVersion")
    test = sbercloud.Cce.get_addon_template(cluster_id=cluster_id,
        name=addon_name,
        version=addon_version)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the add-on name.
    :param _builtins.str region: Specifies the region in which to obtain the CCE add-ons. If omitted, the provider-level
           region will be used.
    :param _builtins.str version: Specifies the add-on version.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getAddonTemplate:getAddonTemplate', __args__, opts=opts, typ=GetAddonTemplateResult).value

    return AwaitableGetAddonTemplateResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        spec=pulumi.get(__ret__, 'spec'),
        stable=pulumi.get(__ret__, 'stable'),
        support_versions=pulumi.get(__ret__, 'support_versions'),
        version=pulumi.get(__ret__, 'version'))
def get_addon_template_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[_builtins.str]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              version: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddonTemplateResult]:
    """
    Use this data source to get available SberCloud CCE add-on template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    addon_name = config.require_object("addonName")
    addon_version = config.require_object("addonVersion")
    test = sbercloud.Cce.get_addon_template(cluster_id=cluster_id,
        name=addon_name,
        version=addon_version)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the add-on name.
    :param _builtins.str region: Specifies the region in which to obtain the CCE add-ons. If omitted, the provider-level
           region will be used.
    :param _builtins.str version: Specifies the add-on version.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getAddonTemplate:getAddonTemplate', __args__, opts=opts, typ=GetAddonTemplateResult)
    return __ret__.apply(lambda __response__: GetAddonTemplateResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        spec=pulumi.get(__response__, 'spec'),
        stable=pulumi.get(__response__, 'stable'),
        support_versions=pulumi.get(__response__, 'support_versions'),
        version=pulumi.get(__response__, 'version')))
