# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterCertificatesResult',
    'AwaitableGetClusterCertificatesResult',
    'get_cluster_certificates',
    'get_cluster_certificates_output',
]

@pulumi.output_type
class GetClusterCertificatesResult:
    """
    A collection of values returned by getClusterCertificates.
    """
    def __init__(__self__, cluster_id=None, clusters=None, contexts=None, current_context=None, duration=None, id=None, kube_config_raw=None, region=None, users=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if contexts and not isinstance(contexts, list):
            raise TypeError("Expected argument 'contexts' to be a list")
        pulumi.set(__self__, "contexts", contexts)
        if current_context and not isinstance(current_context, str):
            raise TypeError("Expected argument 'current_context' to be a str")
        pulumi.set(__self__, "current_context", current_context)
        if duration and not isinstance(duration, int):
            raise TypeError("Expected argument 'duration' to be a int")
        pulumi.set(__self__, "duration", duration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kube_config_raw and not isinstance(kube_config_raw, str):
            raise TypeError("Expected argument 'kube_config_raw' to be a str")
        pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetClusterCertificatesClusterResult']:
        """
        The clusters information of the cluster certificate.
        The clusters structure is documented below.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def contexts(self) -> Sequence['outputs.GetClusterCertificatesContextResult']:
        """
        The contexts information of the cluster certificate.
        The contexts structure is documented below.
        """
        return pulumi.get(self, "contexts")

    @_builtins.property
    @pulumi.getter(name="currentContext")
    def current_context(self) -> _builtins.str:
        """
        The current context of the cluster certificate.
        """
        return pulumi.get(self, "current_context")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> _builtins.str:
        """
        Raw Kubernetes config to be used by kubectl and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetClusterCertificatesUserResult']:
        """
        The users information of cluster the certificate.
        The users structure is documented below.
        """
        return pulumi.get(self, "users")


class AwaitableGetClusterCertificatesResult(GetClusterCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterCertificatesResult(
            cluster_id=self.cluster_id,
            clusters=self.clusters,
            contexts=self.contexts,
            current_context=self.current_context,
            duration=self.duration,
            id=self.id,
            kube_config_raw=self.kube_config_raw,
            region=self.region,
            users=self.users)


def get_cluster_certificates(cluster_id: Optional[_builtins.str] = None,
                             duration: Optional[_builtins.int] = None,
                             region: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterCertificatesResult:
    """
    Use this data source to get the certificate of a CCE cluster within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    test = sbercloud.Cce.get_cluster_certificates(cluster_id=cluster_id,
        duration=30)
    ```


    :param _builtins.str cluster_id: Specifies the cluster ID which the cluster certificate in.
    :param _builtins.int duration: Specifies the duration of the cluster certificate. The unit is days. The valid value in
           [1, 1827]. If the input value is -1, it will use the maximum 1827 as `duration` value.
    :param _builtins.str region: Specifies the region in which to obtain the CCE cluster certificate. If omitted, the
           provider-level region will be used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['duration'] = duration
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getClusterCertificates:getClusterCertificates', __args__, opts=opts, typ=GetClusterCertificatesResult).value

    return AwaitableGetClusterCertificatesResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        clusters=pulumi.get(__ret__, 'clusters'),
        contexts=pulumi.get(__ret__, 'contexts'),
        current_context=pulumi.get(__ret__, 'current_context'),
        duration=pulumi.get(__ret__, 'duration'),
        id=pulumi.get(__ret__, 'id'),
        kube_config_raw=pulumi.get(__ret__, 'kube_config_raw'),
        region=pulumi.get(__ret__, 'region'),
        users=pulumi.get(__ret__, 'users'))
def get_cluster_certificates_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    duration: Optional[pulumi.Input[_builtins.int]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterCertificatesResult]:
    """
    Use this data source to get the certificate of a CCE cluster within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    test = sbercloud.Cce.get_cluster_certificates(cluster_id=cluster_id,
        duration=30)
    ```


    :param _builtins.str cluster_id: Specifies the cluster ID which the cluster certificate in.
    :param _builtins.int duration: Specifies the duration of the cluster certificate. The unit is days. The valid value in
           [1, 1827]. If the input value is -1, it will use the maximum 1827 as `duration` value.
    :param _builtins.str region: Specifies the region in which to obtain the CCE cluster certificate. If omitted, the
           provider-level region will be used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['duration'] = duration
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getClusterCertificates:getClusterCertificates', __args__, opts=opts, typ=GetClusterCertificatesResult)
    return __ret__.apply(lambda __response__: GetClusterCertificatesResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        clusters=pulumi.get(__response__, 'clusters'),
        contexts=pulumi.get(__response__, 'contexts'),
        current_context=pulumi.get(__response__, 'current_context'),
        duration=pulumi.get(__response__, 'duration'),
        id=pulumi.get(__response__, 'id'),
        kube_config_raw=pulumi.get(__response__, 'kube_config_raw'),
        region=pulumi.get(__response__, 'region'),
        users=pulumi.get(__response__, 'users')))
