# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_id=None, cluster_type=None, clusters=None, enterprise_project_id=None, id=None, ids=None, name=None, region=None, status=None, vpc_id=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[_builtins.str]:
        """
        The type of the cluster. Possible values: **VirtualMachine**, **ARM64**.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetClustersClusterResult']:
        """
        Indicates a list of CCE clusters found. Structure is documented below.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        Indicates a list of IDs of all CCE clusters found.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The vpc ID of the cluster.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_id=self.cluster_id,
            cluster_type=self.cluster_type,
            clusters=self.clusters,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ids=self.ids,
            name=self.name,
            region=self.region,
            status=self.status,
            vpc_id=self.vpc_id)


def get_clusters(cluster_id: Optional[_builtins.str] = None,
                 cluster_type: Optional[_builtins.str] = None,
                 enterprise_project_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    Use this data source to get a list of CCE clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    clusters = sbercloud.Cce.get_clusters(name=cluster_name,
        status="Available")
    ```


    :param _builtins.str cluster_id: Specifies the ID of the cluster.
    :param _builtins.str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the cluster.
    :param _builtins.str name: Specifies the name of the cluster.
    :param _builtins.str region: Specifies the region in which to obtain the CCE clusters. If omitted, the
           provider-level region will be used.
    :param _builtins.str status: Specifies the status of the cluster.
    :param _builtins.str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterType'] = cluster_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        clusters=pulumi.get(__ret__, 'clusters'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_clusters_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        cluster_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    Use this data source to get a list of CCE clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    clusters = sbercloud.Cce.get_clusters(name=cluster_name,
        status="Available")
    ```


    :param _builtins.str cluster_id: Specifies the ID of the cluster.
    :param _builtins.str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the cluster.
    :param _builtins.str name: Specifies the name of the cluster.
    :param _builtins.str region: Specifies the region in which to obtain the CCE clusters. If omitted, the
           provider-level region will be used.
    :param _builtins.str status: Specifies the status of the cluster.
    :param _builtins.str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterType'] = cluster_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        clusters=pulumi.get(__response__, 'clusters'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
