# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodeResult',
    'AwaitableGetNodeResult',
    'get_node',
    'get_node_output',
]

@pulumi.output_type
class GetNodeResult:
    """
    A collection of values returned by getNode.
    """
    def __init__(__self__, availability_zone=None, billing_mode=None, cluster_id=None, data_volumes=None, ecs_group_id=None, enterprise_project_id=None, flavor_id=None, hostname_configs=None, id=None, key_pair=None, name=None, node_id=None, os=None, private_ip=None, public_ip=None, region=None, root_volumes=None, server_id=None, status=None, subnet_id=None, tags=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if billing_mode and not isinstance(billing_mode, int):
            raise TypeError("Expected argument 'billing_mode' to be a int")
        pulumi.set(__self__, "billing_mode", billing_mode)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if data_volumes and not isinstance(data_volumes, list):
            raise TypeError("Expected argument 'data_volumes' to be a list")
        pulumi.set(__self__, "data_volumes", data_volumes)
        if ecs_group_id and not isinstance(ecs_group_id, str):
            raise TypeError("Expected argument 'ecs_group_id' to be a str")
        pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if hostname_configs and not isinstance(hostname_configs, list):
            raise TypeError("Expected argument 'hostname_configs' to be a list")
        pulumi.set(__self__, "hostname_configs", hostname_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_volumes and not isinstance(root_volumes, list):
            raise TypeError("Expected argument 'root_volumes' to be a list")
        pulumi.set(__self__, "root_volumes", root_volumes)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Available partitions where the node is located.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> _builtins.int:
        """
        Node's billing mode: The value is 0 (on demand).
        """
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Sequence['outputs.GetNodeDataVolumeResult']:
        """
        Represents the data disk to be created. Structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> _builtins.str:
        """
        The ID of ECS group to which the node belongs.
        """
        return pulumi.get(self, "ecs_group_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The flavor ID to be used.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="hostnameConfigs")
    def hostname_configs(self) -> Sequence['outputs.GetNodeHostnameConfigResult']:
        return pulumi.get(self, "hostname_configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> _builtins.str:
        """
        Key pair name when logging in to select the key pair mode.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        Operating System of the node.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        Private IP of the node.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        Elastic IP parameters of the node.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetNodeRootVolumeResult']:
        """
        It corresponds to the system disk related configuration. Structure is documented below.
        """
        return pulumi.get(self, "root_volumes")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The node's virtual machine ID in ECS.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNodeResult(GetNodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeResult(
            availability_zone=self.availability_zone,
            billing_mode=self.billing_mode,
            cluster_id=self.cluster_id,
            data_volumes=self.data_volumes,
            ecs_group_id=self.ecs_group_id,
            enterprise_project_id=self.enterprise_project_id,
            flavor_id=self.flavor_id,
            hostname_configs=self.hostname_configs,
            id=self.id,
            key_pair=self.key_pair,
            name=self.name,
            node_id=self.node_id,
            os=self.os,
            private_ip=self.private_ip,
            public_ip=self.public_ip,
            region=self.region,
            root_volumes=self.root_volumes,
            server_id=self.server_id,
            status=self.status,
            subnet_id=self.subnet_id,
            tags=self.tags)


def get_node(cluster_id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             node_id: Optional[_builtins.str] = None,
             region: Optional[_builtins.str] = None,
             status: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeResult:
    """
    To get the specified node in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = sbercloud.Cce.get_node(cluster_id=cluster_id,
        name=node_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the name of the node.
    :param _builtins.str node_id: Specifies the ID of the node.
    :param _builtins.str region: Specifies the region in which to obtain the CCE nodes.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the state of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getNode:getNode', __args__, opts=opts, typ=GetNodeResult).value

    return AwaitableGetNodeResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        billing_mode=pulumi.get(__ret__, 'billing_mode'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        data_volumes=pulumi.get(__ret__, 'data_volumes'),
        ecs_group_id=pulumi.get(__ret__, 'ecs_group_id'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        hostname_configs=pulumi.get(__ret__, 'hostname_configs'),
        id=pulumi.get(__ret__, 'id'),
        key_pair=pulumi.get(__ret__, 'key_pair'),
        name=pulumi.get(__ret__, 'name'),
        node_id=pulumi.get(__ret__, 'node_id'),
        os=pulumi.get(__ret__, 'os'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        region=pulumi.get(__ret__, 'region'),
        root_volumes=pulumi.get(__ret__, 'root_volumes'),
        server_id=pulumi.get(__ret__, 'server_id'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_node_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    node_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodeResult]:
    """
    To get the specified node in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = sbercloud.Cce.get_node(cluster_id=cluster_id,
        name=node_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the name of the node.
    :param _builtins.str node_id: Specifies the ID of the node.
    :param _builtins.str region: Specifies the region in which to obtain the CCE nodes.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the state of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getNode:getNode', __args__, opts=opts, typ=GetNodeResult)
    return __ret__.apply(lambda __response__: GetNodeResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        billing_mode=pulumi.get(__response__, 'billing_mode'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        data_volumes=pulumi.get(__response__, 'data_volumes'),
        ecs_group_id=pulumi.get(__response__, 'ecs_group_id'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        hostname_configs=pulumi.get(__response__, 'hostname_configs'),
        id=pulumi.get(__response__, 'id'),
        key_pair=pulumi.get(__response__, 'key_pair'),
        name=pulumi.get(__response__, 'name'),
        node_id=pulumi.get(__response__, 'node_id'),
        os=pulumi.get(__response__, 'os'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        region=pulumi.get(__response__, 'region'),
        root_volumes=pulumi.get(__response__, 'root_volumes'),
        server_id=pulumi.get(__response__, 'server_id'),
        status=pulumi.get(__response__, 'status'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags')))
