# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodePoolResult',
    'AwaitableGetNodePoolResult',
    'get_node_pool',
    'get_node_pool_output',
]

@pulumi.output_type
class GetNodePoolResult:
    """
    A collection of values returned by getNodePool.
    """
    def __init__(__self__, availability_zone=None, cluster_id=None, current_node_count=None, data_volumes=None, enterprise_project_id=None, extend_param=None, flavor_id=None, hostname_configs=None, id=None, initial_node_count=None, key_pair=None, labels=None, max_node_count=None, max_pods=None, min_node_count=None, name=None, node_pool_id=None, os=None, priority=None, region=None, root_volumes=None, scale_down_cooldown_time=None, scall_enable=None, status=None, subnet_id=None, tags=None, type=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if current_node_count and not isinstance(current_node_count, int):
            raise TypeError("Expected argument 'current_node_count' to be a int")
        pulumi.set(__self__, "current_node_count", current_node_count)
        if data_volumes and not isinstance(data_volumes, list):
            raise TypeError("Expected argument 'data_volumes' to be a list")
        pulumi.set(__self__, "data_volumes", data_volumes)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_param and not isinstance(extend_param, dict):
            raise TypeError("Expected argument 'extend_param' to be a dict")
        pulumi.set(__self__, "extend_param", extend_param)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if hostname_configs and not isinstance(hostname_configs, list):
            raise TypeError("Expected argument 'hostname_configs' to be a list")
        pulumi.set(__self__, "hostname_configs", hostname_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_node_count and not isinstance(initial_node_count, int):
            raise TypeError("Expected argument 'initial_node_count' to be a int")
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if max_node_count and not isinstance(max_node_count, int):
            raise TypeError("Expected argument 'max_node_count' to be a int")
        pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods and not isinstance(max_pods, int):
            raise TypeError("Expected argument 'max_pods' to be a int")
        pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count and not isinstance(min_node_count, int):
            raise TypeError("Expected argument 'min_node_count' to be a int")
        pulumi.set(__self__, "min_node_count", min_node_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_pool_id and not isinstance(node_pool_id, str):
            raise TypeError("Expected argument 'node_pool_id' to be a str")
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_volumes and not isinstance(root_volumes, list):
            raise TypeError("Expected argument 'root_volumes' to be a list")
        pulumi.set(__self__, "root_volumes", root_volumes)
        if scale_down_cooldown_time and not isinstance(scale_down_cooldown_time, int):
            raise TypeError("Expected argument 'scale_down_cooldown_time' to be a int")
        pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable and not isinstance(scall_enable, bool):
            raise TypeError("Expected argument 'scall_enable' to be a bool")
        pulumi.set(__self__, "scall_enable", scall_enable)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The name of the available partition (AZ).
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> _builtins.int:
        """
        Current number of nodes in the node pool.
        """
        return pulumi.get(self, "current_node_count")

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Sequence['outputs.GetNodePoolDataVolumeResult']:
        """
        Represents the data disk to be created. Structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Mapping[str, _builtins.str]:
        """
        Extended parameter.
        """
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="hostnameConfigs")
    def hostname_configs(self) -> Sequence['outputs.GetNodePoolHostnameConfigResult']:
        return pulumi.get(self, "hostname_configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> _builtins.int:
        """
        Initial number of nodes in the node pool.
        """
        return pulumi.get(self, "initial_node_count")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> _builtins.str:
        """
        Key pair name when logging in to select the key pair mode.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> _builtins.int:
        """
        Maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> _builtins.int:
        """
        The maximum number of instances a node is allowed to create.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> _builtins.int:
        """
        Minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> _builtins.str:
        return pulumi.get(self, "node_pool_id")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        Operating System of the node.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Weight of a node pool. A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetNodePoolRootVolumeResult']:
        """
        It corresponds to the system disk related configuration. Structure is documented below.
        """
        return pulumi.get(self, "root_volumes")

    @_builtins.property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> _builtins.int:
        """
        Interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @_builtins.property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> _builtins.bool:
        """
        Whether auto scaling is enabled.
        """
        return pulumi.get(self, "scall_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Node Pool type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNodePoolResult(GetNodePoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodePoolResult(
            availability_zone=self.availability_zone,
            cluster_id=self.cluster_id,
            current_node_count=self.current_node_count,
            data_volumes=self.data_volumes,
            enterprise_project_id=self.enterprise_project_id,
            extend_param=self.extend_param,
            flavor_id=self.flavor_id,
            hostname_configs=self.hostname_configs,
            id=self.id,
            initial_node_count=self.initial_node_count,
            key_pair=self.key_pair,
            labels=self.labels,
            max_node_count=self.max_node_count,
            max_pods=self.max_pods,
            min_node_count=self.min_node_count,
            name=self.name,
            node_pool_id=self.node_pool_id,
            os=self.os,
            priority=self.priority,
            region=self.region,
            root_volumes=self.root_volumes,
            scale_down_cooldown_time=self.scale_down_cooldown_time,
            scall_enable=self.scall_enable,
            status=self.status,
            subnet_id=self.subnet_id,
            tags=self.tags,
            type=self.type)


def get_node_pool(cluster_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  node_pool_id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodePoolResult:
    """
    To get the specified node pool in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_pool_name = config.require_object("nodePoolName")
    node_pool = sbercloud.Cce.get_node_pool(cluster_id=cluster_id,
        name=node_pool_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the name of the node pool.
    :param _builtins.str node_pool_id: Specifies the ID of the node pool.
    :param _builtins.str region: Specifies the region in which to obtain the CCE node pools.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the state of the node pool.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodePoolId'] = node_pool_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getNodePool:getNodePool', __args__, opts=opts, typ=GetNodePoolResult).value

    return AwaitableGetNodePoolResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        current_node_count=pulumi.get(__ret__, 'current_node_count'),
        data_volumes=pulumi.get(__ret__, 'data_volumes'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        extend_param=pulumi.get(__ret__, 'extend_param'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        hostname_configs=pulumi.get(__ret__, 'hostname_configs'),
        id=pulumi.get(__ret__, 'id'),
        initial_node_count=pulumi.get(__ret__, 'initial_node_count'),
        key_pair=pulumi.get(__ret__, 'key_pair'),
        labels=pulumi.get(__ret__, 'labels'),
        max_node_count=pulumi.get(__ret__, 'max_node_count'),
        max_pods=pulumi.get(__ret__, 'max_pods'),
        min_node_count=pulumi.get(__ret__, 'min_node_count'),
        name=pulumi.get(__ret__, 'name'),
        node_pool_id=pulumi.get(__ret__, 'node_pool_id'),
        os=pulumi.get(__ret__, 'os'),
        priority=pulumi.get(__ret__, 'priority'),
        region=pulumi.get(__ret__, 'region'),
        root_volumes=pulumi.get(__ret__, 'root_volumes'),
        scale_down_cooldown_time=pulumi.get(__ret__, 'scale_down_cooldown_time'),
        scall_enable=pulumi.get(__ret__, 'scall_enable'),
        status=pulumi.get(__ret__, 'status'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_node_pool_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         node_pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodePoolResult]:
    """
    To get the specified node pool in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_pool_name = config.require_object("nodePoolName")
    node_pool = sbercloud.Cce.get_node_pool(cluster_id=cluster_id,
        name=node_pool_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of container cluster.
    :param _builtins.str name: Specifies the name of the node pool.
    :param _builtins.str node_pool_id: Specifies the ID of the node pool.
    :param _builtins.str region: Specifies the region in which to obtain the CCE node pools.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the state of the node pool.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodePoolId'] = node_pool_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getNodePool:getNodePool', __args__, opts=opts, typ=GetNodePoolResult)
    return __ret__.apply(lambda __response__: GetNodePoolResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        current_node_count=pulumi.get(__response__, 'current_node_count'),
        data_volumes=pulumi.get(__response__, 'data_volumes'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        extend_param=pulumi.get(__response__, 'extend_param'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        hostname_configs=pulumi.get(__response__, 'hostname_configs'),
        id=pulumi.get(__response__, 'id'),
        initial_node_count=pulumi.get(__response__, 'initial_node_count'),
        key_pair=pulumi.get(__response__, 'key_pair'),
        labels=pulumi.get(__response__, 'labels'),
        max_node_count=pulumi.get(__response__, 'max_node_count'),
        max_pods=pulumi.get(__response__, 'max_pods'),
        min_node_count=pulumi.get(__response__, 'min_node_count'),
        name=pulumi.get(__response__, 'name'),
        node_pool_id=pulumi.get(__response__, 'node_pool_id'),
        os=pulumi.get(__response__, 'os'),
        priority=pulumi.get(__response__, 'priority'),
        region=pulumi.get(__response__, 'region'),
        root_volumes=pulumi.get(__response__, 'root_volumes'),
        scale_down_cooldown_time=pulumi.get(__response__, 'scale_down_cooldown_time'),
        scall_enable=pulumi.get(__response__, 'scall_enable'),
        status=pulumi.get(__response__, 'status'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
