# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodesResult',
    'AwaitableGetNodesResult',
    'get_nodes',
    'get_nodes_output',
]

@pulumi.output_type
class GetNodesResult:
    """
    A collection of values returned by getNodes.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, ignore_details=None, name=None, node_id=None, nodes=None, region=None, status=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ignore_details and not isinstance(ignore_details, str):
            raise TypeError("Expected argument 'ignore_details' to be a str")
        pulumi.set(__self__, "ignore_details", ignore_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        Indicates a list of IDs of all CCE nodes found.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="ignoreDetails")
    def ignore_details(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ignore_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetNodesNodeResult']:
        """
        Indicates a list of CCE nodes found. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the node.
        """
        return pulumi.get(self, "status")


class AwaitableGetNodesResult(GetNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodesResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            ignore_details=self.ignore_details,
            name=self.name,
            node_id=self.node_id,
            nodes=self.nodes,
            region=self.region,
            status=self.status)


def get_nodes(cluster_id: Optional[_builtins.str] = None,
              ignore_details: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              node_id: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              status: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodesResult:
    """
    Use this data source to get a list of CCE nodes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = sbercloud.Cce.get_nodes(cluster_id=cluster_id,
        name=node_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of CCE cluster.
    :param _builtins.str name: Specifies the of the node.
    :param _builtins.str node_id: Specifies the ID of the node.
    :param _builtins.str region: Specifies the region in which to obtain the CCE nodes. If omitted, the provider-level
           region will be used.
    :param _builtins.str status: Specifies the status of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ignoreDetails'] = ignore_details
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cce/getNodes:getNodes', __args__, opts=opts, typ=GetNodesResult).value

    return AwaitableGetNodesResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ignore_details=pulumi.get(__ret__, 'ignore_details'),
        name=pulumi.get(__ret__, 'name'),
        node_id=pulumi.get(__ret__, 'node_id'),
        nodes=pulumi.get(__ret__, 'nodes'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'))
def get_nodes_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                     ignore_details: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     node_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodesResult]:
    """
    Use this data source to get a list of CCE nodes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = sbercloud.Cce.get_nodes(cluster_id=cluster_id,
        name=node_name)
    ```


    :param _builtins.str cluster_id: Specifies the ID of CCE cluster.
    :param _builtins.str name: Specifies the of the node.
    :param _builtins.str node_id: Specifies the ID of the node.
    :param _builtins.str region: Specifies the region in which to obtain the CCE nodes. If omitted, the provider-level
           region will be used.
    :param _builtins.str status: Specifies the status of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ignoreDetails'] = ignore_details
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cce/getNodes:getNodes', __args__, opts=opts, typ=GetNodesResult)
    return __ret__.apply(lambda __response__: GetNodesResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ignore_details=pulumi.get(__response__, 'ignore_details'),
        name=pulumi.get(__response__, 'name'),
        node_id=pulumi.get(__response__, 'node_id'),
        nodes=pulumi.get(__response__, 'nodes'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status')))
