# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 flavor_id: pulumi.Input[_builtins.str],
                 initial_node_count: pulumi.Input[_builtins.int],
                 root_volume: pulumi.Input['NodePoolRootVolumeArgs'],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]] = None,
                 ecs_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input['NodePoolExtendParamsArgs']] = None,
                 extension_scale_groups: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]] = None,
                 hostname_config: Optional[pulumi.Input['NodePoolHostnameConfigArgs']] = None,
                 initialized_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 label_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 preinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[_builtins.int]] = None,
                 scall_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input['NodePoolStorageArgs']] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taint_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input['NodePoolRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE node pool. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the node pool.
               If updated, the new value will apply only to new nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        :param pulumi.Input['NodePoolExtendParamsArgs'] extend_params: Specifies the extended parameters.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]] extension_scale_groups: Specifies the configurations of extended scaling groups in the node pool.
               The object structure is documented below.
        :param pulumi.Input['NodePoolHostnameConfigArgs'] hostname_config: Specifies the hostname config of the kubernetes node,
               which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initialized_conditions: Specifies the custom initialization flags.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] label_policy_on_existing_nodes: Specifies the label policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[_builtins.int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.int] max_pods: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the node pool name.
        :param pulumi.Input[_builtins.str] os: Specifies the operating system of the node.
               The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
               please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
               This parameter is required when the `node_image_id` in `extend_params` is not specified.
        :param pulumi.Input[_builtins.str] password: Specifies the root password when logging in to select the password mode.
               The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
               lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE node pool. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE node pool.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_security_groups: Specifies the list of security group IDs for the pod.
               Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] postinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.str] preinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[_builtins.str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the CCE node pool. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[_builtins.bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Specifies the list of custom security group IDs for the node pool.
               If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
               the rules of the port on which CCE running depends. For details, see
               [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        :param pulumi.Input['NodePoolStorageArgs'] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_lists: Specifies the ID list of the subnet to which the NIC belongs.
        :param pulumi.Input[_builtins.str] tag_policy_on_existing_nodes: Specifies the tag policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **ignore**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[_builtins.str] taint_policy_on_existing_nodes: Specifies the taint policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[_builtins.str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        pulumi.set(__self__, "root_volume", root_volume)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if extension_scale_groups is not None:
            pulumi.set(__self__, "extension_scale_groups", extension_scale_groups)
        if hostname_config is not None:
            pulumi.set(__self__, "hostname_config", hostname_config)
        if initialized_conditions is not None:
            pulumi.set(__self__, "initialized_conditions", initialized_conditions)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if label_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "label_policy_on_existing_nodes", label_policy_on_existing_nodes)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if pod_security_groups is not None:
            pulumi.set(__self__, "pod_security_groups", pod_security_groups)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if scale_down_cooldown_time is not None:
            pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable is not None:
            pulumi.set(__self__, "scall_enable", scall_enable)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_lists is not None:
            pulumi.set(__self__, "subnet_lists", subnet_lists)
        if tag_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "tag_policy_on_existing_nodes", tag_policy_on_existing_nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taint_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "taint_policy_on_existing_nodes", taint_policy_on_existing_nodes)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "initial_node_count", value)

    @_builtins.property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Input['NodePoolRootVolumeArgs']:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: pulumi.Input['NodePoolRootVolumeArgs']):
        pulumi.set(self, "root_volume", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the CCE node pool. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @ecs_group_id.setter
    def ecs_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_group_id", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the node pool.
        If updated, the new value will apply only to new nodes.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extend_param", value)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input['NodePoolExtendParamsArgs']]:
        """
        Specifies the extended parameters.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input['NodePoolExtendParamsArgs']]):
        pulumi.set(self, "extend_params", value)

    @_builtins.property
    @pulumi.getter(name="extensionScaleGroups")
    def extension_scale_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]]:
        """
        Specifies the configurations of extended scaling groups in the node pool.
        The object structure is documented below.
        """
        return pulumi.get(self, "extension_scale_groups")

    @extension_scale_groups.setter
    def extension_scale_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]]):
        pulumi.set(self, "extension_scale_groups", value)

    @_builtins.property
    @pulumi.getter(name="hostnameConfig")
    def hostname_config(self) -> Optional[pulumi.Input['NodePoolHostnameConfigArgs']]:
        """
        Specifies the hostname config of the kubernetes node,
        which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hostname_config")

    @hostname_config.setter
    def hostname_config(self, value: Optional[pulumi.Input['NodePoolHostnameConfigArgs']]):
        pulumi.set(self, "hostname_config", value)

    @_builtins.property
    @pulumi.getter(name="initializedConditions")
    def initialized_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the custom initialization flags.
        """
        return pulumi.get(self, "initialized_conditions")

    @initialized_conditions.setter
    def initialized_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "initialized_conditions", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter(name="labelPolicyOnExistingNodes")
    def label_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the label policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "label_policy_on_existing_nodes")

    @label_policy_on_existing_nodes.setter
    def label_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_node_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods", value)

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_node_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the operating system of the node.
        The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
        please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
        This parameter is required when the `node_image_id` in `extend_params` is not specified.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the root password when logging in to select the password mode.
        The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
        lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the CCE node pool. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE node pool.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="podSecurityGroups")
    def pod_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of security group IDs for the pod.
        Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pod_security_groups")

    @pod_security_groups.setter
    def pod_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_security_groups", value)

    @_builtins.property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postinstall", value)

    @_builtins.property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preinstall", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the runtime of the CCE node pool. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @scale_down_cooldown_time.setter
    def scale_down_cooldown_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_down_cooldown_time", value)

    @_builtins.property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @scall_enable.setter
    def scall_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scall_enable", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of custom security group IDs for the node pool.
        If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
        the rules of the port on which CCE running depends. For details, see
        [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['NodePoolStorageArgs']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['NodePoolStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetLists")
    def subnet_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the ID list of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_lists")

    @subnet_lists.setter
    def subnet_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_lists", value)

    @_builtins.property
    @pulumi.getter(name="tagPolicyOnExistingNodes")
    def tag_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the tag policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **ignore**.
        """
        return pulumi.get(self, "tag_policy_on_existing_nodes")

    @tag_policy_on_existing_nodes.setter
    def tag_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taintPolicyOnExistingNodes")
    def taint_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the taint policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "taint_policy_on_existing_nodes")

    @taint_policy_on_existing_nodes.setter
    def taint_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "taint_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 current_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]] = None,
                 ecs_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input['NodePoolExtendParamsArgs']] = None,
                 extension_scale_groups: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_config: Optional[pulumi.Input['NodePoolHostnameConfigArgs']] = None,
                 initial_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initialized_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 label_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 preinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_volume: Optional[pulumi.Input['NodePoolRootVolumeArgs']] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[_builtins.int]] = None,
                 scall_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['NodePoolStorageArgs']] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taint_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] billing_mode: Billing mode of a node.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE node pool. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] current_node_count: The current number of the nodes.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the node pool.
               If updated, the new value will apply only to new nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        :param pulumi.Input['NodePoolExtendParamsArgs'] extend_params: Specifies the extended parameters.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]] extension_scale_groups: Specifies the configurations of extended scaling groups in the node pool.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input['NodePoolHostnameConfigArgs'] hostname_config: Specifies the hostname config of the kubernetes node,
               which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initialized_conditions: Specifies the custom initialization flags.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] label_policy_on_existing_nodes: Specifies the label policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[_builtins.int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.int] max_pods: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the node pool name.
        :param pulumi.Input[_builtins.str] os: Specifies the operating system of the node.
               The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
               please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
               This parameter is required when the `node_image_id` in `extend_params` is not specified.
        :param pulumi.Input[_builtins.str] password: Specifies the root password when logging in to select the password mode.
               The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
               lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE node pool. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE node pool.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_security_groups: Specifies the list of security group IDs for the pod.
               Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] postinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.str] preinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[_builtins.str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input['NodePoolRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the CCE node pool. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[_builtins.bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Specifies the list of custom security group IDs for the node pool.
               If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
               the rules of the port on which CCE running depends. For details, see
               [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        :param pulumi.Input[_builtins.str] status: Node status information.
        :param pulumi.Input['NodePoolStorageArgs'] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_lists: Specifies the ID list of the subnet to which the NIC belongs.
        :param pulumi.Input[_builtins.str] tag_policy_on_existing_nodes: Specifies the tag policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **ignore**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[_builtins.str] taint_policy_on_existing_nodes: Specifies the taint policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[_builtins.str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if current_node_count is not None:
            pulumi.set(__self__, "current_node_count", current_node_count)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if extension_scale_groups is not None:
            pulumi.set(__self__, "extension_scale_groups", extension_scale_groups)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if hostname_config is not None:
            pulumi.set(__self__, "hostname_config", hostname_config)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if initialized_conditions is not None:
            pulumi.set(__self__, "initialized_conditions", initialized_conditions)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if label_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "label_policy_on_existing_nodes", label_policy_on_existing_nodes)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if pod_security_groups is not None:
            pulumi.set(__self__, "pod_security_groups", pod_security_groups)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if scale_down_cooldown_time is not None:
            pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable is not None:
            pulumi.set(__self__, "scall_enable", scall_enable)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_lists is not None:
            pulumi.set(__self__, "subnet_lists", subnet_lists)
        if tag_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "tag_policy_on_existing_nodes", tag_policy_on_existing_nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taint_policy_on_existing_nodes is not None:
            pulumi.set(__self__, "taint_policy_on_existing_nodes", taint_policy_on_existing_nodes)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Billing mode of a node.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "billing_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the CCE node pool. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The current number of the nodes.
        """
        return pulumi.get(self, "current_node_count")

    @current_node_count.setter
    def current_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "current_node_count", value)

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @ecs_group_id.setter
    def ecs_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecs_group_id", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the node pool.
        If updated, the new value will apply only to new nodes.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extend_param", value)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input['NodePoolExtendParamsArgs']]:
        """
        Specifies the extended parameters.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input['NodePoolExtendParamsArgs']]):
        pulumi.set(self, "extend_params", value)

    @_builtins.property
    @pulumi.getter(name="extensionScaleGroups")
    def extension_scale_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]]:
        """
        Specifies the configurations of extended scaling groups in the node pool.
        The object structure is documented below.
        """
        return pulumi.get(self, "extension_scale_groups")

    @extension_scale_groups.setter
    def extension_scale_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolExtensionScaleGroupArgs']]]]):
        pulumi.set(self, "extension_scale_groups", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="hostnameConfig")
    def hostname_config(self) -> Optional[pulumi.Input['NodePoolHostnameConfigArgs']]:
        """
        Specifies the hostname config of the kubernetes node,
        which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hostname_config")

    @hostname_config.setter
    def hostname_config(self, value: Optional[pulumi.Input['NodePoolHostnameConfigArgs']]):
        pulumi.set(self, "hostname_config", value)

    @_builtins.property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_node_count", value)

    @_builtins.property
    @pulumi.getter(name="initializedConditions")
    def initialized_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the custom initialization flags.
        """
        return pulumi.get(self, "initialized_conditions")

    @initialized_conditions.setter
    def initialized_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "initialized_conditions", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter(name="labelPolicyOnExistingNodes")
    def label_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the label policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "label_policy_on_existing_nodes")

    @label_policy_on_existing_nodes.setter
    def label_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_node_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods", value)

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_node_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the operating system of the node.
        The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
        please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
        This parameter is required when the `node_image_id` in `extend_params` is not specified.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the root password when logging in to select the password mode.
        The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
        lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the CCE node pool. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE node pool.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="podSecurityGroups")
    def pod_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of security group IDs for the pod.
        Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pod_security_groups")

    @pod_security_groups.setter
    def pod_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_security_groups", value)

    @_builtins.property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postinstall", value)

    @_builtins.property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preinstall", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['NodePoolRootVolumeArgs']]:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['NodePoolRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the runtime of the CCE node pool. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @scale_down_cooldown_time.setter
    def scale_down_cooldown_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scale_down_cooldown_time", value)

    @_builtins.property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @scall_enable.setter
    def scall_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scall_enable", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of custom security group IDs for the node pool.
        If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
        the rules of the port on which CCE running depends. For details, see
        [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['NodePoolStorageArgs']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['NodePoolStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetLists")
    def subnet_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the ID list of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_lists")

    @subnet_lists.setter
    def subnet_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_lists", value)

    @_builtins.property
    @pulumi.getter(name="tagPolicyOnExistingNodes")
    def tag_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the tag policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **ignore**.
        """
        return pulumi.get(self, "tag_policy_on_existing_nodes")

    @tag_policy_on_existing_nodes.setter
    def tag_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taintPolicyOnExistingNodes")
    def taint_policy_on_existing_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the taint policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "taint_policy_on_existing_nodes")

    @taint_policy_on_existing_nodes.setter
    def taint_policy_on_existing_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "taint_policy_on_existing_nodes", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Cce/nodePool:NodePool")
class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataVolumeArgs', 'NodePoolDataVolumeArgsDict']]]]] = None,
                 ecs_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Union['NodePoolExtendParamsArgs', 'NodePoolExtendParamsArgsDict']]] = None,
                 extension_scale_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolExtensionScaleGroupArgs', 'NodePoolExtensionScaleGroupArgsDict']]]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_config: Optional[pulumi.Input[Union['NodePoolHostnameConfigArgs', 'NodePoolHostnameConfigArgsDict']]] = None,
                 initial_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initialized_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 label_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 preinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_volume: Optional[pulumi.Input[Union['NodePoolRootVolumeArgs', 'NodePoolRootVolumeArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[_builtins.int]] = None,
                 scall_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[Union['NodePoolStorageArgs', 'NodePoolStorageArgsDict']]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taint_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Add a node pool to a container cluster.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }])
        ```

        ### PrePaid node pool

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }])
        ```

        > You need to remove all nodes in the node pool on the console, before deleting a prepaid node pool.

        ## Node pool with extension scale groups

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone1 = config.require_object("availabilityZone1")
        availability_zone2 = config.require_object("availabilityZone2")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone1,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }],
            extension_scale_groups=[
                {
                    "metadata": {
                        "name": "group1",
                    },
                    "spec": {
                        "flavor": "s3.large.4",
                        "az": availability_zone1,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
                {
                    "metadata": {
                        "name": "group2",
                    },
                    "spec": {
                        "flavor": "s3.xlarge.4",
                        "az": availability_zone1,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
                {
                    "metadata": {
                        "name": "group3",
                    },
                    "spec": {
                        "flavor": "s3.xlarge.4",
                        "az": availability_zone2,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
            ])
        ```

        ## Import

        CCE node pool can be imported using the cluster ID and node pool ID separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cce/nodePool:NodePool my_node_pool <cluster_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `extend_params`, `taints`, `initial_node_count`, `pod_security_groups` and `extension_scale_groups`.

        It is generally recommended running `pulumi preview` after importing a node pool.

        You can then decide if changes should be applied to the node pool, or the resource

        definition should be updated to align with the node pool. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cce_node_pool" "my_node_pool" {

          ...

          lifecycle {

            ignore_changes = [
            
              password, extend_params,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE node pool. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataVolumeArgs', 'NodePoolDataVolumeArgsDict']]]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the node pool.
               If updated, the new value will apply only to new nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        :param pulumi.Input[Union['NodePoolExtendParamsArgs', 'NodePoolExtendParamsArgsDict']] extend_params: Specifies the extended parameters.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolExtensionScaleGroupArgs', 'NodePoolExtensionScaleGroupArgsDict']]]] extension_scale_groups: Specifies the configurations of extended scaling groups in the node pool.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Union['NodePoolHostnameConfigArgs', 'NodePoolHostnameConfigArgsDict']] hostname_config: Specifies the hostname config of the kubernetes node,
               which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initialized_conditions: Specifies the custom initialization flags.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] label_policy_on_existing_nodes: Specifies the label policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[_builtins.int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.int] max_pods: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the node pool name.
        :param pulumi.Input[_builtins.str] os: Specifies the operating system of the node.
               The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
               please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
               This parameter is required when the `node_image_id` in `extend_params` is not specified.
        :param pulumi.Input[_builtins.str] password: Specifies the root password when logging in to select the password mode.
               The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
               lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE node pool. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE node pool.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_security_groups: Specifies the list of security group IDs for the pod.
               Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] postinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.str] preinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[_builtins.str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[Union['NodePoolRootVolumeArgs', 'NodePoolRootVolumeArgsDict']] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the CCE node pool. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[_builtins.bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Specifies the list of custom security group IDs for the node pool.
               If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
               the rules of the port on which CCE running depends. For details, see
               [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        :param pulumi.Input[Union['NodePoolStorageArgs', 'NodePoolStorageArgsDict']] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_lists: Specifies the ID list of the subnet to which the NIC belongs.
        :param pulumi.Input[_builtins.str] tag_policy_on_existing_nodes: Specifies the tag policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **ignore**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[_builtins.str] taint_policy_on_existing_nodes: Specifies the taint policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[_builtins.str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Add a node pool to a container cluster.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }])
        ```

        ### PrePaid node pool

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }])
        ```

        > You need to remove all nodes in the node pool on the console, before deleting a prepaid node pool.

        ## Node pool with extension scale groups

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone1 = config.require_object("availabilityZone1")
        availability_zone2 = config.require_object("availabilityZone2")
        node_pool = sbercloud.cce.NodePool("node_pool",
            cluster_id=cluster_id,
            name="testpool",
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone1,
            key_pair=keypair,
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume={
                "size": 40,
                "volumetype": "SAS",
            },
            data_volumes=[{
                "size": 100,
                "volumetype": "SAS",
            }],
            extension_scale_groups=[
                {
                    "metadata": {
                        "name": "group1",
                    },
                    "spec": {
                        "flavor": "s3.large.4",
                        "az": availability_zone1,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
                {
                    "metadata": {
                        "name": "group2",
                    },
                    "spec": {
                        "flavor": "s3.xlarge.4",
                        "az": availability_zone1,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
                {
                    "metadata": {
                        "name": "group3",
                    },
                    "spec": {
                        "flavor": "s3.xlarge.4",
                        "az": availability_zone2,
                        "autoscaling": {
                            "extension_priority": 1,
                            "enable": True,
                        },
                    },
                },
            ])
        ```

        ## Import

        CCE node pool can be imported using the cluster ID and node pool ID separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cce/nodePool:NodePool my_node_pool <cluster_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `extend_params`, `taints`, `initial_node_count`, `pod_security_groups` and `extension_scale_groups`.

        It is generally recommended running `pulumi preview` after importing a node pool.

        You can then decide if changes should be applied to the node pool, or the resource

        definition should be updated to align with the node pool. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cce_node_pool" "my_node_pool" {

          ...

          lifecycle {

            ignore_changes = [
            
              password, extend_params,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataVolumeArgs', 'NodePoolDataVolumeArgsDict']]]]] = None,
                 ecs_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 extend_params: Optional[pulumi.Input[Union['NodePoolExtendParamsArgs', 'NodePoolExtendParamsArgsDict']]] = None,
                 extension_scale_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolExtensionScaleGroupArgs', 'NodePoolExtensionScaleGroupArgsDict']]]]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_config: Optional[pulumi.Input[Union['NodePoolHostnameConfigArgs', 'NodePoolHostnameConfigArgsDict']]] = None,
                 initial_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 initialized_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 label_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 preinstall: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_volume: Optional[pulumi.Input[Union['NodePoolRootVolumeArgs', 'NodePoolRootVolumeArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[_builtins.int]] = None,
                 scall_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[Union['NodePoolStorageArgs', 'NodePoolStorageArgsDict']]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tag_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taint_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["charging_mode"] = charging_mode
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["data_volumes"] = data_volumes
            __props__.__dict__["ecs_group_id"] = ecs_group_id
            __props__.__dict__["enable_force_new"] = enable_force_new
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["extend_param"] = extend_param
            __props__.__dict__["extend_params"] = extend_params
            __props__.__dict__["extension_scale_groups"] = extension_scale_groups
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["hostname_config"] = hostname_config
            if initial_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'initial_node_count'")
            __props__.__dict__["initial_node_count"] = initial_node_count
            __props__.__dict__["initialized_conditions"] = initialized_conditions
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["label_policy_on_existing_nodes"] = label_policy_on_existing_nodes
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_node_count"] = max_node_count
            __props__.__dict__["max_pods"] = max_pods
            __props__.__dict__["min_node_count"] = min_node_count
            __props__.__dict__["name"] = name
            __props__.__dict__["os"] = os
            __props__.__dict__["partition"] = partition
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["pod_security_groups"] = pod_security_groups
            __props__.__dict__["postinstall"] = postinstall
            __props__.__dict__["preinstall"] = preinstall
            __props__.__dict__["priority"] = priority
            __props__.__dict__["region"] = region
            if root_volume is None and not opts.urn:
                raise TypeError("Missing required property 'root_volume'")
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["scale_down_cooldown_time"] = scale_down_cooldown_time
            __props__.__dict__["scall_enable"] = scall_enable
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["storage"] = storage
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["subnet_lists"] = subnet_lists
            __props__.__dict__["tag_policy_on_existing_nodes"] = tag_policy_on_existing_nodes
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taint_policy_on_existing_nodes"] = taint_policy_on_existing_nodes
            __props__.__dict__["taints"] = taints
            __props__.__dict__["type"] = type
            __props__.__dict__["billing_mode"] = None
            __props__.__dict__["current_node_count"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodePool, __self__).__init__(
            'sbercloud:Cce/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            billing_mode: Optional[pulumi.Input[_builtins.int]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            current_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataVolumeArgs', 'NodePoolDataVolumeArgsDict']]]]] = None,
            ecs_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            extend_params: Optional[pulumi.Input[Union['NodePoolExtendParamsArgs', 'NodePoolExtendParamsArgsDict']]] = None,
            extension_scale_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolExtensionScaleGroupArgs', 'NodePoolExtensionScaleGroupArgsDict']]]]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_config: Optional[pulumi.Input[Union['NodePoolHostnameConfigArgs', 'NodePoolHostnameConfigArgsDict']]] = None,
            initial_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            initialized_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_pair: Optional[pulumi.Input[_builtins.str]] = None,
            label_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            max_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_pods: Optional[pulumi.Input[_builtins.int]] = None,
            min_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            pod_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            postinstall: Optional[pulumi.Input[_builtins.str]] = None,
            preinstall: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_volume: Optional[pulumi.Input[Union['NodePoolRootVolumeArgs', 'NodePoolRootVolumeArgsDict']]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            scale_down_cooldown_time: Optional[pulumi.Input[_builtins.int]] = None,
            scall_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage: Optional[pulumi.Input[Union['NodePoolStorageArgs', 'NodePoolStorageArgsDict']]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tag_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            taint_policy_on_existing_nodes: Optional[pulumi.Input[_builtins.str]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] billing_mode: Billing mode of a node.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CCE node pool. Valid values are
               *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] current_node_count: The current number of the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataVolumeArgs', 'NodePoolDataVolumeArgsDict']]]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the node pool.
               If updated, the new value will apply only to new nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extend_param: schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        :param pulumi.Input[Union['NodePoolExtendParamsArgs', 'NodePoolExtendParamsArgsDict']] extend_params: Specifies the extended parameters.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolExtensionScaleGroupArgs', 'NodePoolExtensionScaleGroupArgsDict']]]] extension_scale_groups: Specifies the configurations of extended scaling groups in the node pool.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Union['NodePoolHostnameConfigArgs', 'NodePoolHostnameConfigArgsDict']] hostname_config: Specifies the hostname config of the kubernetes node,
               which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] initialized_conditions: Specifies the custom initialization flags.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] label_policy_on_existing_nodes: Specifies the label policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[_builtins.int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.int] max_pods: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the node pool name.
        :param pulumi.Input[_builtins.str] os: Specifies the operating system of the node.
               The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
               please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
               This parameter is required when the `node_image_id` in `extend_params` is not specified.
        :param pulumi.Input[_builtins.str] password: Specifies the root password when logging in to select the password mode.
               The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
               lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CCE node pool. If `period_unit` is set to
               *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
               is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the CCE node pool.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_security_groups: Specifies the list of security group IDs for the pod.
               Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] postinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.str] preinstall: schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        :param pulumi.Input[_builtins.int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[_builtins.str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[Union['NodePoolRootVolumeArgs', 'NodePoolRootVolumeArgsDict']] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] runtime: Specifies the runtime of the CCE node pool. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[_builtins.bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Specifies the list of custom security group IDs for the node pool.
               If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
               the rules of the port on which CCE running depends. For details, see
               [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        :param pulumi.Input[_builtins.str] status: Node status information.
        :param pulumi.Input[Union['NodePoolStorageArgs', 'NodePoolStorageArgsDict']] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_lists: Specifies the ID list of the subnet to which the NIC belongs.
        :param pulumi.Input[_builtins.str] tag_policy_on_existing_nodes: Specifies the tag policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **ignore**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[_builtins.str] taint_policy_on_existing_nodes: Specifies the taint policy on existing nodes.
               The value can be **ignore** and **refresh**, defaults to **refresh**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[_builtins.str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["current_node_count"] = current_node_count
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["ecs_group_id"] = ecs_group_id
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["extend_param"] = extend_param
        __props__.__dict__["extend_params"] = extend_params
        __props__.__dict__["extension_scale_groups"] = extension_scale_groups
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["hostname_config"] = hostname_config
        __props__.__dict__["initial_node_count"] = initial_node_count
        __props__.__dict__["initialized_conditions"] = initialized_conditions
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["label_policy_on_existing_nodes"] = label_policy_on_existing_nodes
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_node_count"] = max_node_count
        __props__.__dict__["max_pods"] = max_pods
        __props__.__dict__["min_node_count"] = min_node_count
        __props__.__dict__["name"] = name
        __props__.__dict__["os"] = os
        __props__.__dict__["partition"] = partition
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["pod_security_groups"] = pod_security_groups
        __props__.__dict__["postinstall"] = postinstall
        __props__.__dict__["preinstall"] = preinstall
        __props__.__dict__["priority"] = priority
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["scale_down_cooldown_time"] = scale_down_cooldown_time
        __props__.__dict__["scall_enable"] = scall_enable
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["storage"] = storage
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subnet_lists"] = subnet_lists
        __props__.__dict__["tag_policy_on_existing_nodes"] = tag_policy_on_existing_nodes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taint_policy_on_existing_nodes"] = taint_policy_on_existing_nodes
        __props__.__dict__["taints"] = taints
        __props__.__dict__["type"] = type
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[_builtins.int]:
        """
        Billing mode of a node.
        """
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the CCE node pool. Valid values are
        *prePaid* and *postPaid*, defaults to *postPaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The current number of the nodes.
        """
        return pulumi.get(self, "current_node_count")

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.NodePoolDataVolume']]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID of the node pool.
        If updated, the new value will apply only to new nodes.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        schema: Deprecated; This parameter has been replaced by the 'extend_params' parameter.
        """
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> pulumi.Output['outputs.NodePoolExtendParams']:
        """
        Specifies the extended parameters.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="extensionScaleGroups")
    def extension_scale_groups(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolExtensionScaleGroup']]]:
        """
        Specifies the configurations of extended scaling groups in the node pool.
        The object structure is documented below.
        """
        return pulumi.get(self, "extension_scale_groups")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="hostnameConfig")
    def hostname_config(self) -> pulumi.Output['outputs.NodePoolHostnameConfig']:
        """
        Specifies the hostname config of the kubernetes node,
        which is supported by clusters of v1.23.6-r0 to v1.25 or clusters of v1.25.2-r0 or later versions.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hostname_config")

    @_builtins.property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @_builtins.property
    @pulumi.getter(name="initializedConditions")
    def initialized_conditions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the custom initialization flags.
        """
        return pulumi.get(self, "initialized_conditions")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter(name="labelPolicyOnExistingNodes")
    def label_policy_on_existing_nodes(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the label policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "label_policy_on_existing_nodes")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> pulumi.Output[_builtins.int]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def os(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the operating system of the node.
        The value can be **EulerOS 2.9** and **CentOS 7.6** e.g. For more details,
        please see [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_10_0476.html).
        This parameter is required when the `node_image_id` in `extend_params` is not specified.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the root password when logging in to select the password mode.
        The password consists of 8 to 26 characters and must contain at least three of following: uppercase letters,
        lowercase letters, digits, special characters(!@$%^-_=+[{}]:,./?~#*).
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the CCE node pool. If `period_unit` is set to
        *month*, the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter
        is mandatory if `charging_mode` is set to *prePaid*. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the CCE node pool.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="podSecurityGroups")
    def pod_security_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of security group IDs for the pod.
        Only supported in CCE Turbo clusters of v1.19 and above. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "pod_security_groups")

    @_builtins.property
    @pulumi.getter
    def postinstall(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "postinstall")

    @_builtins.property
    @pulumi.getter
    def preinstall(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Deprecated; This parameter can be configured in the 'extend_params' parameter.
        """
        return pulumi.get(self, "preinstall")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.NodePoolRootVolume']:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the runtime of the CCE node pool. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @_builtins.property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of custom security group IDs for the node pool.
        If specified, the nodes will be put in these security groups. When specifying a security group, do not modify
        the rules of the port on which CCE running depends. For details, see
        [documentation](https://support.hc.sbercloud.ru/usermanual/cce/cce_faq_00265.html).
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional['outputs.NodePoolStorage']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetLists")
    def subnet_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the ID list of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_lists")

    @_builtins.property
    @pulumi.getter(name="tagPolicyOnExistingNodes")
    def tag_policy_on_existing_nodes(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the tag policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **ignore**.
        """
        return pulumi.get(self, "tag_policy_on_existing_nodes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="taintPolicyOnExistingNodes")
    def taint_policy_on_existing_nodes(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the taint policy on existing nodes.
        The value can be **ignore** and **refresh**, defaults to **refresh**.
        """
        return pulumi.get(self, "taint_policy_on_existing_nodes")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolTaint']]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

