# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddonValues',
    'ClusterCertificateCluster',
    'ClusterCertificateUser',
    'ClusterComponentConfiguration',
    'ClusterEncryptionConfig',
    'ClusterExtendParam',
    'ClusterMaster',
    'NodeAttachDataVolume',
    'NodeAttachExtensionNic',
    'NodeAttachHostnameConfig',
    'NodeAttachRootVolume',
    'NodeAttachStorage',
    'NodeAttachStorageGroup',
    'NodeAttachStorageGroupVirtualSpace',
    'NodeAttachStorageSelector',
    'NodeAttachTaint',
    'NodeDataVolume',
    'NodeExtendParams',
    'NodeExtensionNic',
    'NodeHostnameConfig',
    'NodePoolDataVolume',
    'NodePoolExtendParams',
    'NodePoolExtensionScaleGroup',
    'NodePoolExtensionScaleGroupMetadata',
    'NodePoolExtensionScaleGroupSpec',
    'NodePoolExtensionScaleGroupSpecAutoscaling',
    'NodePoolExtensionScaleGroupSpecCapacityReservationSpecification',
    'NodePoolHostnameConfig',
    'NodePoolRootVolume',
    'NodePoolStorage',
    'NodePoolStorageGroup',
    'NodePoolStorageGroupVirtualSpace',
    'NodePoolStorageSelector',
    'NodePoolTaint',
    'NodeRootVolume',
    'NodeStorage',
    'NodeStorageGroup',
    'NodeStorageGroupVirtualSpace',
    'NodeStorageSelector',
    'NodeTaint',
    'GetAddonTemplateSupportVersionResult',
    'GetClusterCertificateClusterResult',
    'GetClusterCertificateUserResult',
    'GetClusterCertificatesClusterResult',
    'GetClusterCertificatesContextResult',
    'GetClusterCertificatesUserResult',
    'GetClusterEndpointResult',
    'GetClusterMasterResult',
    'GetClustersClusterResult',
    'GetClustersClusterCertificateClusterResult',
    'GetClustersClusterCertificateUserResult',
    'GetClustersClusterEndpointResult',
    'GetClustersClusterMasterResult',
    'GetNodeDataVolumeResult',
    'GetNodeHostnameConfigResult',
    'GetNodePoolDataVolumeResult',
    'GetNodePoolHostnameConfigResult',
    'GetNodePoolRootVolumeResult',
    'GetNodeRootVolumeResult',
    'GetNodesNodeResult',
    'GetNodesNodeDataVolumeResult',
    'GetNodesNodeHostnameConfigResult',
    'GetNodesNodeRootVolumeResult',
]

@pulumi.output_type
class AddonValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicJson":
            suggest = "basic_json"
        elif key == "customJson":
            suggest = "custom_json"
        elif key == "flavorJson":
            suggest = "flavor_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic: Optional[Mapping[str, _builtins.str]] = None,
                 basic_json: Optional[_builtins.str] = None,
                 custom: Optional[Mapping[str, _builtins.str]] = None,
                 custom_json: Optional[_builtins.str] = None,
                 flavor: Optional[Mapping[str, _builtins.str]] = None,
                 flavor_json: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] basic: Specifies the key/value pairs vary depending on the add-on.
               Only supports non-nested structure and only supports string type elements.
               This is an alternative to `basic_json`, but it is not recommended.
               Changing this parameter will create a new resource.
        :param _builtins.str basic_json: Specifies the json string vary depending on the add-on.
               Changing this parameter will create a new resource.
        :param Mapping[str, _builtins.str] custom: Specifies the key/value pairs vary depending on the add-on.
               Only supports non-nested structure and only supports string type elements.
               This is an alternative to `custom_json`, but it is not recommended.
               Changing this parameter will create a new resource.
        :param _builtins.str custom_json: Specifies the json string vary depending on the add-on.
               Changing this parameter will create a new resource.
        :param Mapping[str, _builtins.str] flavor: Specifies the key/value pairs vary depending on the add-on.
               Only supports non-nested structure and only supports string type elements.
               This is an alternative to `flavor_json`, but it is not recommended.
               Changing this parameter will create a new resource.
               
               Arguments which can be passed to the `basic_json`, `custom_json` and `flavor_json` add-on parameters depends on
               the add-on type and version. For more detailed description of add-ons
               see add-ons description
        :param _builtins.str flavor_json: Specifies the json string vary depending on the add-on.
               Changing this parameter will create a new resource.
        """
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if basic_json is not None:
            pulumi.set(__self__, "basic_json", basic_json)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if custom_json is not None:
            pulumi.set(__self__, "custom_json", custom_json)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if flavor_json is not None:
            pulumi.set(__self__, "flavor_json", flavor_json)

    @_builtins.property
    @pulumi.getter
    def basic(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the key/value pairs vary depending on the add-on.
        Only supports non-nested structure and only supports string type elements.
        This is an alternative to `basic_json`, but it is not recommended.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "basic")

    @_builtins.property
    @pulumi.getter(name="basicJson")
    def basic_json(self) -> Optional[_builtins.str]:
        """
        Specifies the json string vary depending on the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "basic_json")

    @_builtins.property
    @pulumi.getter
    def custom(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the key/value pairs vary depending on the add-on.
        Only supports non-nested structure and only supports string type elements.
        This is an alternative to `custom_json`, but it is not recommended.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "custom")

    @_builtins.property
    @pulumi.getter(name="customJson")
    def custom_json(self) -> Optional[_builtins.str]:
        """
        Specifies the json string vary depending on the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "custom_json")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the key/value pairs vary depending on the add-on.
        Only supports non-nested structure and only supports string type elements.
        This is an alternative to `flavor_json`, but it is not recommended.
        Changing this parameter will create a new resource.

        Arguments which can be passed to the `basic_json`, `custom_json` and `flavor_json` add-on parameters depends on
        the add-on type and version. For more detailed description of add-ons
        see add-ons description
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="flavorJson")
    def flavor_json(self) -> Optional[_builtins.str]:
        """
        Specifies the json string vary depending on the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor_json")


@pulumi.output_type
class ClusterCertificateCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityData":
            suggest = "certificate_authority_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificateCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificateCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificateCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_data: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 server: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_authority_data: The certificate data.
        :param _builtins.str name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param _builtins.str server: The server IP address.
        """
        if certificate_authority_data is not None:
            pulumi.set(__self__, "certificate_authority_data", certificate_authority_data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityData")
    def certificate_authority_data(self) -> Optional[_builtins.str]:
        """
        The certificate data.
        """
        return pulumi.get(self, "certificate_authority_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.str]:
        """
        The server IP address.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class ClusterCertificateUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificateData":
            suggest = "client_certificate_data"
        elif key == "clientKeyData":
            suggest = "client_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificateUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificateUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificateUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate_data: Optional[_builtins.str] = None,
                 client_key_data: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_certificate_data: The client certificate data.
        :param _builtins.str client_key_data: The client key data.
        :param _builtins.str name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        """
        if client_certificate_data is not None:
            pulumi.set(__self__, "client_certificate_data", client_certificate_data)
        if client_key_data is not None:
            pulumi.set(__self__, "client_key_data", client_key_data)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clientCertificateData")
    def client_certificate_data(self) -> Optional[_builtins.str]:
        """
        The client certificate data.
        """
        return pulumi.get(self, "client_certificate_data")

    @_builtins.property
    @pulumi.getter(name="clientKeyData")
    def client_key_data(self) -> Optional[_builtins.str]:
        """
        The client key data.
        """
        return pulumi.get(self, "client_key_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterComponentConfiguration(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 configurations: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the component name.
               Changing this parameter will create a new cluster resource.
        :param _builtins.str configurations: Specifies JSON string of the component configurations.
               Changing this parameter will create a new cluster resource.
        """
        pulumi.set(__self__, "name", name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the component name.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[_builtins.str]:
        """
        Specifies JSON string of the component configurations.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.str] = None):
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mode")


@pulumi.output_type
class ClusterExtendParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterAz":
            suggest = "cluster_az"
        elif key == "cpuManagerPolicy":
            suggest = "cpu_manager_policy"
        elif key == "decMasterFlavor":
            suggest = "dec_master_flavor"
        elif key == "dockerUmaskMode":
            suggest = "docker_umask_mode"
        elif key == "dssMasterVolumes":
            suggest = "dss_master_volumes"
        elif key == "fixPoolMask":
            suggest = "fix_pool_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExtendParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExtendParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExtendParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_az: Optional[_builtins.str] = None,
                 cpu_manager_policy: Optional[_builtins.str] = None,
                 dec_master_flavor: Optional[_builtins.str] = None,
                 docker_umask_mode: Optional[_builtins.str] = None,
                 dss_master_volumes: Optional[_builtins.str] = None,
                 fix_pool_mask: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_az: Specifies the AZ of master nodes in the cluster. The value can be:
               + **multi_az**: The cluster will span across AZs. This field is configurable only for high-availability clusters.
               + **AZ of the dedicated cloud computing pool**: The cluster will be deployed in the AZ of Dedicated Cloud (DeC).
               This parameter is mandatory for dedicated CCE clusters.
               
               Changing this parameter will create a new cluster resource.
        :param _builtins.str cpu_manager_policy: Specifies the cluster CPU management policy.
               The value can be:
               + **none**: CPU cores will not be exclusively allocated to workload pods.
               Select this value if you want a large pool of shareable CPU cores.
               + **static**: CPU cores can be exclusively allocated to workload pods.
               Select this value if your workload is sensitive to latency in CPU cache and scheduling.In a CCE Turbo cluster,
               this setting is valid only for nodes where common containers, not Kata containers, run.
               
               Defaults to none.
               Changing this parameter will create a new cluster resource.
               
               <a name="cce_cluster_component_configurations"></a>
               The `component_configurations` block supports:
        :param _builtins.str dec_master_flavor: Specifies the specifications of the master node
               in the dedicated hybrid cluster.
               Changing this parameter will create a new cluster resource.
        :param _builtins.str docker_umask_mode: Specifies the default UmaskMode configuration of Docker in a
               cluster. The value can be **secure** or **normal**, defaults to normal.
               Changing this parameter will create a new cluster resource.
        :param _builtins.str dss_master_volumes: Specifies whether the system and data disks of a master node
               use dedicated distributed storage. If left unspecified, EVS disks are used by default.
               This parameter is mandatory for dedicated CCE clusters.
               It is in the following format:
               
               ```bash
               <rootVol.dssPoolID>.<rootVol.volType>;<dataVol.dssPoolID>.<dataVol.volType>
               ```
               
               Changing this parameter will create a new cluster resource.
        :param _builtins.str fix_pool_mask: Specifies the number of mask bits of the fixed IP address pool
               of the container network model. This field can only be used when `container_network_type` is set to **vpc-router**.
               Changing this parameter will create a new cluster resource.
        """
        if cluster_az is not None:
            pulumi.set(__self__, "cluster_az", cluster_az)
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if dec_master_flavor is not None:
            pulumi.set(__self__, "dec_master_flavor", dec_master_flavor)
        if docker_umask_mode is not None:
            pulumi.set(__self__, "docker_umask_mode", docker_umask_mode)
        if dss_master_volumes is not None:
            pulumi.set(__self__, "dss_master_volumes", dss_master_volumes)
        if fix_pool_mask is not None:
            pulumi.set(__self__, "fix_pool_mask", fix_pool_mask)

    @_builtins.property
    @pulumi.getter(name="clusterAz")
    def cluster_az(self) -> Optional[_builtins.str]:
        """
        Specifies the AZ of master nodes in the cluster. The value can be:
        + **multi_az**: The cluster will span across AZs. This field is configurable only for high-availability clusters.
        + **AZ of the dedicated cloud computing pool**: The cluster will be deployed in the AZ of Dedicated Cloud (DeC).
        This parameter is mandatory for dedicated CCE clusters.

        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "cluster_az")

    @_builtins.property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[_builtins.str]:
        """
        Specifies the cluster CPU management policy.
        The value can be:
        + **none**: CPU cores will not be exclusively allocated to workload pods.
        Select this value if you want a large pool of shareable CPU cores.
        + **static**: CPU cores can be exclusively allocated to workload pods.
        Select this value if your workload is sensitive to latency in CPU cache and scheduling.In a CCE Turbo cluster,
        this setting is valid only for nodes where common containers, not Kata containers, run.

        Defaults to none.
        Changing this parameter will create a new cluster resource.

        <a name="cce_cluster_component_configurations"></a>
        The `component_configurations` block supports:
        """
        return pulumi.get(self, "cpu_manager_policy")

    @_builtins.property
    @pulumi.getter(name="decMasterFlavor")
    def dec_master_flavor(self) -> Optional[_builtins.str]:
        """
        Specifies the specifications of the master node
        in the dedicated hybrid cluster.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "dec_master_flavor")

    @_builtins.property
    @pulumi.getter(name="dockerUmaskMode")
    def docker_umask_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the default UmaskMode configuration of Docker in a
        cluster. The value can be **secure** or **normal**, defaults to normal.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "docker_umask_mode")

    @_builtins.property
    @pulumi.getter(name="dssMasterVolumes")
    def dss_master_volumes(self) -> Optional[_builtins.str]:
        """
        Specifies whether the system and data disks of a master node
        use dedicated distributed storage. If left unspecified, EVS disks are used by default.
        This parameter is mandatory for dedicated CCE clusters.
        It is in the following format:

        ```bash
        <rootVol.dssPoolID>.<rootVol.volType>;<dataVol.dssPoolID>.<dataVol.volType>
        ```

        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "dss_master_volumes")

    @_builtins.property
    @pulumi.getter(name="fixPoolMask")
    def fix_pool_mask(self) -> Optional[_builtins.str]:
        """
        Specifies the number of mask bits of the fixed IP address pool
        of the container network model. This field can only be used when `container_network_type` is set to **vpc-router**.
        Changing this parameter will create a new cluster resource.
        """
        return pulumi.get(self, "fix_pool_mask")


@pulumi.output_type
class ClusterMaster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_zone: Specifies the availability zone of the master node.
               Changing this parameter will create a new cluster resource.
               
               <a name="cce_cluster_extend_params"></a>
               The `extend_params` block supports:
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        Specifies the availability zone of the master node.
        Changing this parameter will create a new cluster resource.

        <a name="cce_cluster_extend_params"></a>
        The `extend_params` block supports:
        """
        return pulumi.get(self, "availability_zone")


@pulumi.output_type
class NodeAttachDataVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachDataVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachDataVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachDataVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 throughput: Optional[_builtins.int] = None,
                 volumetype: Optional[_builtins.str] = None):
        """
        :param _builtins.bool hw_passthrough: schema: Internal
        """
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volumetype is not None:
            pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class NodeAttachExtensionNic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachExtensionNic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachExtensionNic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachExtensionNic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnet_id: The ID of the subnet to which the NIC belongs.
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NodeAttachHostnameConfig(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeAttachRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 throughput: Optional[_builtins.int] = None,
                 volumetype: Optional[_builtins.str] = None):
        """
        :param _builtins.bool hw_passthrough: schema: Internal
        """
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volumetype is not None:
            pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class NodeAttachStorage(dict):
    def __init__(__self__, *,
                 groups: Sequence['outputs.NodeAttachStorageGroup'],
                 selectors: Sequence['outputs.NodeAttachStorageSelector']):
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "selectors", selectors)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.NodeAttachStorageGroup']:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> Sequence['outputs.NodeAttachStorageSelector']:
        return pulumi.get(self, "selectors")


@pulumi.output_type
class NodeAttachStorageGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectorNames":
            suggest = "selector_names"
        elif key == "virtualSpaces":
            suggest = "virtual_spaces"
        elif key == "cceManaged":
            suggest = "cce_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachStorageGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachStorageGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachStorageGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 selector_names: Sequence[_builtins.str],
                 virtual_spaces: Sequence['outputs.NodeAttachStorageGroupVirtualSpace'],
                 cce_managed: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Specifies the Node Name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "selector_names", selector_names)
        pulumi.set(__self__, "virtual_spaces", virtual_spaces)
        if cce_managed is not None:
            pulumi.set(__self__, "cce_managed", cce_managed)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selectorNames")
    def selector_names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "selector_names")

    @_builtins.property
    @pulumi.getter(name="virtualSpaces")
    def virtual_spaces(self) -> Sequence['outputs.NodeAttachStorageGroupVirtualSpace']:
        return pulumi.get(self, "virtual_spaces")

    @_builtins.property
    @pulumi.getter(name="cceManaged")
    def cce_managed(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "cce_managed")


@pulumi.output_type
class NodeAttachStorageGroupVirtualSpace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lvmLvType":
            suggest = "lvm_lv_type"
        elif key == "lvmPath":
            suggest = "lvm_path"
        elif key == "runtimeLvType":
            suggest = "runtime_lv_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachStorageGroupVirtualSpace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachStorageGroupVirtualSpace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachStorageGroupVirtualSpace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 size: _builtins.str,
                 lvm_lv_type: Optional[_builtins.str] = None,
                 lvm_path: Optional[_builtins.str] = None,
                 runtime_lv_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the Node Name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if lvm_lv_type is not None:
            pulumi.set(__self__, "lvm_lv_type", lvm_lv_type)
        if lvm_path is not None:
            pulumi.set(__self__, "lvm_path", lvm_path)
        if runtime_lv_type is not None:
            pulumi.set(__self__, "runtime_lv_type", runtime_lv_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="lvmLvType")
    def lvm_lv_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lvm_lv_type")

    @_builtins.property
    @pulumi.getter(name="lvmPath")
    def lvm_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lvm_path")

    @_builtins.property
    @pulumi.getter(name="runtimeLvType")
    def runtime_lv_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "runtime_lv_type")


@pulumi.output_type
class NodeAttachStorageSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchLabelCount":
            suggest = "match_label_count"
        elif key == "matchLabelMetadataCmkid":
            suggest = "match_label_metadata_cmkid"
        elif key == "matchLabelMetadataEncrypted":
            suggest = "match_label_metadata_encrypted"
        elif key == "matchLabelSize":
            suggest = "match_label_size"
        elif key == "matchLabelVolumeType":
            suggest = "match_label_volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAttachStorageSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAttachStorageSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAttachStorageSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 match_label_count: Optional[_builtins.str] = None,
                 match_label_metadata_cmkid: Optional[_builtins.str] = None,
                 match_label_metadata_encrypted: Optional[_builtins.str] = None,
                 match_label_size: Optional[_builtins.str] = None,
                 match_label_volume_type: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the Node Name.
        """
        pulumi.set(__self__, "name", name)
        if match_label_count is not None:
            pulumi.set(__self__, "match_label_count", match_label_count)
        if match_label_metadata_cmkid is not None:
            pulumi.set(__self__, "match_label_metadata_cmkid", match_label_metadata_cmkid)
        if match_label_metadata_encrypted is not None:
            pulumi.set(__self__, "match_label_metadata_encrypted", match_label_metadata_encrypted)
        if match_label_size is not None:
            pulumi.set(__self__, "match_label_size", match_label_size)
        if match_label_volume_type is not None:
            pulumi.set(__self__, "match_label_volume_type", match_label_volume_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="matchLabelCount")
    def match_label_count(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_label_count")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataCmkid")
    def match_label_metadata_cmkid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_label_metadata_cmkid")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataEncrypted")
    def match_label_metadata_encrypted(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_label_metadata_encrypted")

    @_builtins.property
    @pulumi.getter(name="matchLabelSize")
    def match_label_size(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_label_size")

    @_builtins.property
    @pulumi.getter(name="matchLabelVolumeType")
    def match_label_volume_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_label_volume_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeAttachTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str effect: Available options are NoSchedule, PreferNoSchedule, and NoExecute.
               Changing this parameter will create a new resource.
        :param _builtins.str key: A key must contain 1 to 63 characters starting with a letter or digit.
               Only letters, digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used
               as the prefix of a key. Changing this parameter will create a new resource.
        :param _builtins.str value: A value must start with a letter or digit and can contain a maximum of 63
               characters, including letters, digits, hyphens (-), underscores (_), and periods (.). Changing this parameter will
               create a new resource.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Available options are NoSchedule, PreferNoSchedule, and NoExecute.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A key must contain 1 to 63 characters starting with a letter or digit.
        Only letters, digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used
        as the prefix of a key. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A value must start with a letter or digit and can contain a maximum of 63
        characters, including letters, digits, hyphens (-), underscores (_), and periods (.). Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodeDataVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeDataVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeDataVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeDataVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 volumetype: _builtins.str,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the disk size in GB.
               Changing this parameter will create a new resource.
        :param _builtins.str volumetype: Specifies the disk type.
               Changing this parameter will create a new resource.
        :param _builtins.str extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
               
               The following is an example default configuration:
        :param Mapping[str, _builtins.str] extend_params: Specifies the disk expansion parameters.
               Changing this parameter will create a new resource.
        :param _builtins.bool hw_passthrough: schema: Internal
        :param _builtins.str kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the volume.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the disk size in GB.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Specifies the disk type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volumetype")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.

        The following is an example default configuration:
        """
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the disk expansion parameters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")


@pulumi.output_type
class NodeExtendParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agencyName":
            suggest = "agency_name"
        elif key == "dockerBaseSize":
            suggest = "docker_base_size"
        elif key == "kubeReservedMem":
            suggest = "kube_reserved_mem"
        elif key == "marketType":
            suggest = "market_type"
        elif key == "maxPods":
            suggest = "max_pods"
        elif key == "nicThreshold":
            suggest = "nic_threshold"
        elif key == "nodeImageId":
            suggest = "node_image_id"
        elif key == "nodeMultiQueue":
            suggest = "node_multi_queue"
        elif key == "securityReinforcementType":
            suggest = "security_reinforcement_type"
        elif key == "spotPrice":
            suggest = "spot_price"
        elif key == "systemReservedMem":
            suggest = "system_reserved_mem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeExtendParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeExtendParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeExtendParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agency_name: Optional[_builtins.str] = None,
                 docker_base_size: Optional[_builtins.int] = None,
                 kube_reserved_mem: Optional[_builtins.int] = None,
                 market_type: Optional[_builtins.str] = None,
                 max_pods: Optional[_builtins.int] = None,
                 nic_threshold: Optional[_builtins.str] = None,
                 node_image_id: Optional[_builtins.str] = None,
                 node_multi_queue: Optional[_builtins.str] = None,
                 postinstall: Optional[_builtins.str] = None,
                 preinstall: Optional[_builtins.str] = None,
                 security_reinforcement_type: Optional[_builtins.str] = None,
                 spot_price: Optional[_builtins.str] = None,
                 system_reserved_mem: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param _builtins.str postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param _builtins.str preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if docker_base_size is not None:
            pulumi.set(__self__, "docker_base_size", docker_base_size)
        if kube_reserved_mem is not None:
            pulumi.set(__self__, "kube_reserved_mem", kube_reserved_mem)
        if market_type is not None:
            pulumi.set(__self__, "market_type", market_type)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if nic_threshold is not None:
            pulumi.set(__self__, "nic_threshold", nic_threshold)
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_multi_queue is not None:
            pulumi.set(__self__, "node_multi_queue", node_multi_queue)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if security_reinforcement_type is not None:
            pulumi.set(__self__, "security_reinforcement_type", security_reinforcement_type)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if system_reserved_mem is not None:
            pulumi.set(__self__, "system_reserved_mem", system_reserved_mem)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="dockerBaseSize")
    def docker_base_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "docker_base_size")

    @_builtins.property
    @pulumi.getter(name="kubeReservedMem")
    def kube_reserved_mem(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "kube_reserved_mem")

    @_builtins.property
    @pulumi.getter(name="marketType")
    def market_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "market_type")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="nicThreshold")
    def nic_threshold(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "nic_threshold")

    @_builtins.property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_image_id")

    @_builtins.property
    @pulumi.getter(name="nodeMultiQueue")
    def node_multi_queue(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_multi_queue")

    @_builtins.property
    @pulumi.getter
    def postinstall(self) -> Optional[_builtins.str]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @_builtins.property
    @pulumi.getter
    def preinstall(self) -> Optional[_builtins.str]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @_builtins.property
    @pulumi.getter(name="securityReinforcementType")
    def security_reinforcement_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "security_reinforcement_type")

    @_builtins.property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "spot_price")

    @_builtins.property
    @pulumi.getter(name="systemReservedMem")
    def system_reserved_mem(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "system_reserved_mem")


@pulumi.output_type
class NodeExtensionNic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeExtensionNic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeExtensionNic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeExtensionNic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NodeHostnameConfig(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
               The default value is **evs**. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
        The default value is **evs**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodePoolDataVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolDataVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolDataVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolDataVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 volumetype: _builtins.str,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the disk size in GB. Changing this parameter will create a new resource.
        :param _builtins.str volumetype: Specifies the disk type. Changing this parameter will create a new resource.
        :param _builtins.str dss_pool_id: Specifies the DSS pool ID. This field is used only for dedicated storage.
               Changing this parameter will create a new resource.
        :param Mapping[str, _builtins.str] extend_params: Specifies the disk expansion parameters.
               Changing this parameter will create a new resource.
        :param _builtins.bool hw_passthrough: schema: Internal
        :param _builtins.int iops: Specifies the iops of the disk,
               required when `volumetype` is **GPSSD2** or **ESSD2**.
        :param _builtins.str kms_key_id: Specifies the KMS key ID. This is used to encrypt the volume.
               Changing this parameter will create a new resource.
        :param _builtins.int throughput: Specifies the throughput of the disk in MiB/s,
               required when `volumetype` is **GPSSD2**.
               
               > You need to create an agency (EVSAccessKMS) when disk encryption is used in the current project for the first time ever.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the disk size in GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Specifies the disk type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volumetype")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        """
        Specifies the DSS pool ID. This field is used only for dedicated storage.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the disk expansion parameters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        """
        Specifies the iops of the disk,
        required when `volumetype` is **GPSSD2** or **ESSD2**.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the KMS key ID. This is used to encrypt the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        """
        Specifies the throughput of the disk in MiB/s,
        required when `volumetype` is **GPSSD2**.

        > You need to create an agency (EVSAccessKMS) when disk encryption is used in the current project for the first time ever.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class NodePoolExtendParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agencyName":
            suggest = "agency_name"
        elif key == "dockerBaseSize":
            suggest = "docker_base_size"
        elif key == "kubeReservedMem":
            suggest = "kube_reserved_mem"
        elif key == "marketType":
            suggest = "market_type"
        elif key == "maxPods":
            suggest = "max_pods"
        elif key == "nicThreshold":
            suggest = "nic_threshold"
        elif key == "nodeImageId":
            suggest = "node_image_id"
        elif key == "nodeMultiQueue":
            suggest = "node_multi_queue"
        elif key == "securityReinforcementType":
            suggest = "security_reinforcement_type"
        elif key == "spotPrice":
            suggest = "spot_price"
        elif key == "systemReservedMem":
            suggest = "system_reserved_mem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolExtendParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolExtendParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolExtendParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agency_name: Optional[_builtins.str] = None,
                 docker_base_size: Optional[_builtins.int] = None,
                 kube_reserved_mem: Optional[_builtins.int] = None,
                 market_type: Optional[_builtins.str] = None,
                 max_pods: Optional[_builtins.int] = None,
                 nic_threshold: Optional[_builtins.str] = None,
                 node_image_id: Optional[_builtins.str] = None,
                 node_multi_queue: Optional[_builtins.str] = None,
                 postinstall: Optional[_builtins.str] = None,
                 preinstall: Optional[_builtins.str] = None,
                 security_reinforcement_type: Optional[_builtins.str] = None,
                 spot_price: Optional[_builtins.str] = None,
                 system_reserved_mem: Optional[_builtins.int] = None):
        """
        :param _builtins.str agency_name: Specifies the agency name.
               Changing this parameter will create a new resource.
        :param _builtins.int docker_base_size: Specifies the available disk space of a single container on a node,
               in GB. Changing this parameter will create a new resource.
        :param _builtins.int kube_reserved_mem: Specifies the reserved node memory, which is reserved for
               Kubernetes-related components. Changing this parameter will create a new resource.
        :param _builtins.int max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param _builtins.str nic_threshold: Specifies the ENI pre-binding thresholds.
               Example setting: **"0.3:0.6"**. Changing this parameter will create a new resource.
        :param _builtins.str node_image_id: Specifies the image ID to create the node.
               Changing this parameter will create a new resource.
        :param _builtins.str node_multi_queue: Specifies the number of ENI queues.
               Example setting: **"[{\\"queue\\":4}]"**. Changing this parameter will create a new resource.
        :param _builtins.str postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param _builtins.str preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param _builtins.int system_reserved_mem: Specifies the reserved node memory, which is reserved
               value for system components. Changing this parameter will create a new resource.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if docker_base_size is not None:
            pulumi.set(__self__, "docker_base_size", docker_base_size)
        if kube_reserved_mem is not None:
            pulumi.set(__self__, "kube_reserved_mem", kube_reserved_mem)
        if market_type is not None:
            pulumi.set(__self__, "market_type", market_type)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if nic_threshold is not None:
            pulumi.set(__self__, "nic_threshold", nic_threshold)
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_multi_queue is not None:
            pulumi.set(__self__, "node_multi_queue", node_multi_queue)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if security_reinforcement_type is not None:
            pulumi.set(__self__, "security_reinforcement_type", security_reinforcement_type)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if system_reserved_mem is not None:
            pulumi.set(__self__, "system_reserved_mem", system_reserved_mem)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[_builtins.str]:
        """
        Specifies the agency name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="dockerBaseSize")
    def docker_base_size(self) -> Optional[_builtins.int]:
        """
        Specifies the available disk space of a single container on a node,
        in GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "docker_base_size")

    @_builtins.property
    @pulumi.getter(name="kubeReservedMem")
    def kube_reserved_mem(self) -> Optional[_builtins.int]:
        """
        Specifies the reserved node memory, which is reserved for
        Kubernetes-related components. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "kube_reserved_mem")

    @_builtins.property
    @pulumi.getter(name="marketType")
    def market_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "market_type")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="nicThreshold")
    def nic_threshold(self) -> Optional[_builtins.str]:
        """
        Specifies the ENI pre-binding thresholds.
        Example setting: **"0.3:0.6"**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "nic_threshold")

    @_builtins.property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> Optional[_builtins.str]:
        """
        Specifies the image ID to create the node.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_image_id")

    @_builtins.property
    @pulumi.getter(name="nodeMultiQueue")
    def node_multi_queue(self) -> Optional[_builtins.str]:
        """
        Specifies the number of ENI queues.
        Example setting: **"[{\\"queue\\":4}]"**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_multi_queue")

    @_builtins.property
    @pulumi.getter
    def postinstall(self) -> Optional[_builtins.str]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @_builtins.property
    @pulumi.getter
    def preinstall(self) -> Optional[_builtins.str]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @_builtins.property
    @pulumi.getter(name="securityReinforcementType")
    def security_reinforcement_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "security_reinforcement_type")

    @_builtins.property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "spot_price")

    @_builtins.property
    @pulumi.getter(name="systemReservedMem")
    def system_reserved_mem(self) -> Optional[_builtins.int]:
        """
        Specifies the reserved node memory, which is reserved
        value for system components. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "system_reserved_mem")


@pulumi.output_type
class NodePoolExtensionScaleGroup(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.NodePoolExtensionScaleGroupMetadata'] = None,
                 spec: Optional['outputs.NodePoolExtensionScaleGroupSpec'] = None):
        """
        :param 'NodePoolExtensionScaleGroupMetadataArgs' metadata: Specifies the basic information about the extended scaling group.
               The object structure is documented below.
        :param 'NodePoolExtensionScaleGroupSpecArgs' spec: Specifies the configurations of the extended scaling group,
               which carry different configurations from those of the default scaling group.
               The object structure is documented below.
               
               <a name="metadata"></a>
               The `metadata` block supports:
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.NodePoolExtensionScaleGroupMetadata']:
        """
        Specifies the basic information about the extended scaling group.
        The object structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.NodePoolExtensionScaleGroupSpec']:
        """
        Specifies the configurations of the extended scaling group,
        which carry different configurations from those of the default scaling group.
        The object structure is documented below.

        <a name="metadata"></a>
        The `metadata` block supports:
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class NodePoolExtensionScaleGroupMetadata(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the node pool name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NodePoolExtensionScaleGroupSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityReservationSpecification":
            suggest = "capacity_reservation_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolExtensionScaleGroupSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolExtensionScaleGroupSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolExtensionScaleGroupSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: Optional['outputs.NodePoolExtensionScaleGroupSpecAutoscaling'] = None,
                 az: Optional[_builtins.str] = None,
                 capacity_reservation_specification: Optional['outputs.NodePoolExtensionScaleGroupSpecCapacityReservationSpecification'] = None,
                 flavor: Optional[_builtins.str] = None):
        """
        :param 'NodePoolExtensionScaleGroupSpecAutoscalingArgs' autoscaling: Specifies the auto scaling configurations of the extended scaling group.
               The object structure is documented below.
               
               <a name="capacity_reservation_specification"></a>
               The `capacity_reservation_specification` block supports:
        :param _builtins.str az: Specifies the availability zone of a node.
               If this parameter is not specified or left blank, the default scaling group configurations take effect.
        :param 'NodePoolExtensionScaleGroupSpecCapacityReservationSpecificationArgs' capacity_reservation_specification: Specifies the capacity reservation
               configurations of the extended scaling group.
               The object structure is documented below.
        :param _builtins.str flavor: Specifies the node flavor.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if az is not None:
            pulumi.set(__self__, "az", az)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)

    @_builtins.property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.NodePoolExtensionScaleGroupSpecAutoscaling']:
        """
        Specifies the auto scaling configurations of the extended scaling group.
        The object structure is documented below.

        <a name="capacity_reservation_specification"></a>
        The `capacity_reservation_specification` block supports:
        """
        return pulumi.get(self, "autoscaling")

    @_builtins.property
    @pulumi.getter
    def az(self) -> Optional[_builtins.str]:
        """
        Specifies the availability zone of a node.
        If this parameter is not specified or left blank, the default scaling group configurations take effect.
        """
        return pulumi.get(self, "az")

    @_builtins.property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional['outputs.NodePoolExtensionScaleGroupSpecCapacityReservationSpecification']:
        """
        Specifies the capacity reservation
        configurations of the extended scaling group.
        The object structure is documented below.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[_builtins.str]:
        """
        Specifies the node flavor.
        """
        return pulumi.get(self, "flavor")


@pulumi.output_type
class NodePoolExtensionScaleGroupSpecAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionPriority":
            suggest = "extension_priority"
        elif key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolExtensionScaleGroupSpecAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolExtensionScaleGroupSpecAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolExtensionScaleGroupSpecAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None,
                 extension_priority: Optional[_builtins.int] = None,
                 max_node_count: Optional[_builtins.int] = None,
                 min_node_count: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enable: Specifies whether to enable auto scaling for the scaling group, defaults to **false**.
        :param _builtins.int extension_priority: Specifies the priority of the scaling group, defaults to **0**.
               A higher value indicates a greater priority.
        :param _builtins.int max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param _builtins.int min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if extension_priority is not None:
            pulumi.set(__self__, "extension_priority", extension_priority)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable auto scaling for the scaling group, defaults to **false**.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="extensionPriority")
    def extension_priority(self) -> Optional[_builtins.int]:
        """
        Specifies the priority of the scaling group, defaults to **0**.
        A higher value indicates a greater priority.
        """
        return pulumi.get(self, "extension_priority")

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class NodePoolExtensionScaleGroupSpecCapacityReservationSpecification(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 preference: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The resource ID in UUID format.
        :param _builtins.str preference: Specifies the capacity of a private storage pool. If the value is none,
               the capacity reservation is not specified. If the value is targeted, the capacity reservation is specified.
               In this case, the `id` cannot be left blank.
               
               <a name="autoscaling"></a>
               The `autoscaling` block supports:
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if preference is not None:
            pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> Optional[_builtins.str]:
        """
        Specifies the capacity of a private storage pool. If the value is none,
        the capacity reservation is not specified. If the value is targeted, the capacity reservation is specified.
        In this case, the `id` cannot be left blank.

        <a name="autoscaling"></a>
        The `autoscaling` block supports:
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class NodePoolHostnameConfig(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodePoolRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 volumetype: _builtins.str,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the disk size in GB. Changing this parameter will create a new resource.
        :param _builtins.str volumetype: Specifies the disk type. Changing this parameter will create a new resource.
        :param _builtins.str dss_pool_id: Specifies the DSS pool ID. This field is used only for dedicated storage.
               Changing this parameter will create a new resource.
        :param Mapping[str, _builtins.str] extend_params: Specifies the disk expansion parameters.
               Changing this parameter will create a new resource.
        :param _builtins.bool hw_passthrough: schema: Internal
        :param _builtins.int iops: Specifies the iops of the disk,
               required when `volumetype` is **GPSSD2** or **ESSD2**.
        :param _builtins.str kms_key_id: Specifies the KMS key ID. This is used to encrypt the volume.
               Changing this parameter will create a new resource.
        :param _builtins.int throughput: Specifies the throughput of the disk in MiB/s,
               required when `volumetype` is **GPSSD2**.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the disk size in GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Specifies the disk type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volumetype")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        """
        Specifies the DSS pool ID. This field is used only for dedicated storage.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the disk expansion parameters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        """
        Specifies the iops of the disk,
        required when `volumetype` is **GPSSD2** or **ESSD2**.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the KMS key ID. This is used to encrypt the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        """
        Specifies the throughput of the disk in MiB/s,
        required when `volumetype` is **GPSSD2**.
        """
        return pulumi.get(self, "throughput")


@pulumi.output_type
class NodePoolStorage(dict):
    def __init__(__self__, *,
                 groups: Sequence['outputs.NodePoolStorageGroup'],
                 selectors: Sequence['outputs.NodePoolStorageSelector']):
        """
        :param Sequence['NodePoolStorageGroupArgs'] groups: Specifies the storage group consists of multiple storage devices.
               This is used to divide storage space. Structure is documented below.
               Changing this parameter will create a new resource.
        :param Sequence['NodePoolStorageSelectorArgs'] selectors: Specifies the disk selection.
               Matched disks are managed according to match labels and storage type. Structure is documented below.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "selectors", selectors)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.NodePoolStorageGroup']:
        """
        Specifies the storage group consists of multiple storage devices.
        This is used to divide storage space. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> Sequence['outputs.NodePoolStorageSelector']:
        """
        Specifies the disk selection.
        Matched disks are managed according to match labels and storage type. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class NodePoolStorageGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectorNames":
            suggest = "selector_names"
        elif key == "virtualSpaces":
            suggest = "virtual_spaces"
        elif key == "cceManaged":
            suggest = "cce_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolStorageGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolStorageGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolStorageGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 selector_names: Sequence[_builtins.str],
                 virtual_spaces: Sequence['outputs.NodePoolStorageGroupVirtualSpace'],
                 cce_managed: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Specifies the name of an extended scaling group.
               The value cannot be default and can contain a maximum of 55 characters.
               Only digits, lowercase letters, and hyphens (-) are allowed.
               
               <a name="spec"></a>
               The `spec` block supports:
        :param Sequence[_builtins.str] selector_names: Specifies the list of names of selectors to match.
               This parameter corresponds to name in `selectors`. A group can match multiple selectors,
               but a selector can match only one group. Changing this parameter will create a new resource.
        :param Sequence['NodePoolStorageGroupVirtualSpaceArgs'] virtual_spaces: Specifies the detailed management of space configuration in a group.
               Changing this parameter will create a new resource.
        :param _builtins.bool cce_managed: Specifies the whether the storage space is for **kubernetes** and
               **runtime** components. Only one group can be set to true. The default value is **false**.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "selector_names", selector_names)
        pulumi.set(__self__, "virtual_spaces", virtual_spaces)
        if cce_managed is not None:
            pulumi.set(__self__, "cce_managed", cce_managed)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of an extended scaling group.
        The value cannot be default and can contain a maximum of 55 characters.
        Only digits, lowercase letters, and hyphens (-) are allowed.

        <a name="spec"></a>
        The `spec` block supports:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selectorNames")
    def selector_names(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of names of selectors to match.
        This parameter corresponds to name in `selectors`. A group can match multiple selectors,
        but a selector can match only one group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "selector_names")

    @_builtins.property
    @pulumi.getter(name="virtualSpaces")
    def virtual_spaces(self) -> Sequence['outputs.NodePoolStorageGroupVirtualSpace']:
        """
        Specifies the detailed management of space configuration in a group.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "virtual_spaces")

    @_builtins.property
    @pulumi.getter(name="cceManaged")
    def cce_managed(self) -> Optional[_builtins.bool]:
        """
        Specifies the whether the storage space is for **kubernetes** and
        **runtime** components. Only one group can be set to true. The default value is **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cce_managed")


@pulumi.output_type
class NodePoolStorageGroupVirtualSpace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lvmLvType":
            suggest = "lvm_lv_type"
        elif key == "lvmPath":
            suggest = "lvm_path"
        elif key == "runtimeLvType":
            suggest = "runtime_lv_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolStorageGroupVirtualSpace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolStorageGroupVirtualSpace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolStorageGroupVirtualSpace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 size: _builtins.str,
                 lvm_lv_type: Optional[_builtins.str] = None,
                 lvm_path: Optional[_builtins.str] = None,
                 runtime_lv_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param _builtins.str size: Specifies the size of a virtual space. Only an integer percentage is supported.
               Example: 90%. Note that the total percentage of all virtual spaces in a group cannot exceed 100%.
               Changing this parameter will create a new resource.
        :param _builtins.str lvm_lv_type: Specifies the LVM write mode, values can be **linear** and **striped**.
               This parameter takes effect only in **kubernetes** and **user** configuration. Changing this parameter will create
               a new resource.
        :param _builtins.str lvm_path: Specifies the absolute path to which the disk is attached.
               This parameter takes effect only in **user** configuration. Changing this parameter will create a new resource.
        :param _builtins.str runtime_lv_type: Specifies the LVM write mode, values can be **linear** and **striped**.
               This parameter takes effect only in **runtime** configuration. Changing this parameter will create a new resource.
               
               <a name="hostname_config"></a>
               The `hostname_config` block supports:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if lvm_lv_type is not None:
            pulumi.set(__self__, "lvm_lv_type", lvm_lv_type)
        if lvm_path is not None:
            pulumi.set(__self__, "lvm_path", lvm_path)
        if runtime_lv_type is not None:
            pulumi.set(__self__, "runtime_lv_type", runtime_lv_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
        and **user** are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        Specifies the size of a virtual space. Only an integer percentage is supported.
        Example: 90%. Note that the total percentage of all virtual spaces in a group cannot exceed 100%.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="lvmLvType")
    def lvm_lv_type(self) -> Optional[_builtins.str]:
        """
        Specifies the LVM write mode, values can be **linear** and **striped**.
        This parameter takes effect only in **kubernetes** and **user** configuration. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "lvm_lv_type")

    @_builtins.property
    @pulumi.getter(name="lvmPath")
    def lvm_path(self) -> Optional[_builtins.str]:
        """
        Specifies the absolute path to which the disk is attached.
        This parameter takes effect only in **user** configuration. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lvm_path")

    @_builtins.property
    @pulumi.getter(name="runtimeLvType")
    def runtime_lv_type(self) -> Optional[_builtins.str]:
        """
        Specifies the LVM write mode, values can be **linear** and **striped**.
        This parameter takes effect only in **runtime** configuration. Changing this parameter will create a new resource.

        <a name="hostname_config"></a>
        The `hostname_config` block supports:
        """
        return pulumi.get(self, "runtime_lv_type")


@pulumi.output_type
class NodePoolStorageSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchLabelCount":
            suggest = "match_label_count"
        elif key == "matchLabelMetadataCmkid":
            suggest = "match_label_metadata_cmkid"
        elif key == "matchLabelMetadataEncrypted":
            suggest = "match_label_metadata_encrypted"
        elif key == "matchLabelSize":
            suggest = "match_label_size"
        elif key == "matchLabelVolumeType":
            suggest = "match_label_volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolStorageSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolStorageSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolStorageSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 match_label_count: Optional[_builtins.str] = None,
                 match_label_metadata_cmkid: Optional[_builtins.str] = None,
                 match_label_metadata_encrypted: Optional[_builtins.str] = None,
                 match_label_size: Optional[_builtins.str] = None,
                 match_label_volume_type: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the selector name, used as the index of `selector_names` in storage group.
               The name of each selector must be unique. Changing this parameter will create a new resource.
        :param _builtins.str match_label_count: Specifies the number of disks to be selected. If omitted,
               all disks of this type are selected. Changing this parameter will create a new resource.
        :param _builtins.str match_label_metadata_cmkid: Specifies the customer master key ID of an encrypted
               disk. Changing this parameter will create a new resource.
        :param _builtins.str match_label_metadata_encrypted: Specifies the disk encryption identifier.
               Values can be: **0** indicates that the disk is not encrypted and **1** indicates that the disk is encrypted.
               If omitted, whether the disk is encrypted is not limited. Changing this parameter will create a new resource.
        :param _builtins.str match_label_size: Specifies the matched disk size. If omitted,
               the disk size is not limited. Example: 100. Changing this parameter will create a new resource.
        :param _builtins.str match_label_volume_type: Specifies the EVS disk type. Currently,
               **SSD**, **GPSSD**, and **SAS** are supported. If omitted, the disk type is not limited.
               Changing this parameter will create a new resource.
        :param _builtins.str type: Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
               The default value is **evs**. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        if match_label_count is not None:
            pulumi.set(__self__, "match_label_count", match_label_count)
        if match_label_metadata_cmkid is not None:
            pulumi.set(__self__, "match_label_metadata_cmkid", match_label_metadata_cmkid)
        if match_label_metadata_encrypted is not None:
            pulumi.set(__self__, "match_label_metadata_encrypted", match_label_metadata_encrypted)
        if match_label_size is not None:
            pulumi.set(__self__, "match_label_size", match_label_size)
        if match_label_volume_type is not None:
            pulumi.set(__self__, "match_label_volume_type", match_label_volume_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the selector name, used as the index of `selector_names` in storage group.
        The name of each selector must be unique. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="matchLabelCount")
    def match_label_count(self) -> Optional[_builtins.str]:
        """
        Specifies the number of disks to be selected. If omitted,
        all disks of this type are selected. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_count")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataCmkid")
    def match_label_metadata_cmkid(self) -> Optional[_builtins.str]:
        """
        Specifies the customer master key ID of an encrypted
        disk. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_metadata_cmkid")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataEncrypted")
    def match_label_metadata_encrypted(self) -> Optional[_builtins.str]:
        """
        Specifies the disk encryption identifier.
        Values can be: **0** indicates that the disk is not encrypted and **1** indicates that the disk is encrypted.
        If omitted, whether the disk is encrypted is not limited. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_metadata_encrypted")

    @_builtins.property
    @pulumi.getter(name="matchLabelSize")
    def match_label_size(self) -> Optional[_builtins.str]:
        """
        Specifies the matched disk size. If omitted,
        the disk size is not limited. Example: 100. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_size")

    @_builtins.property
    @pulumi.getter(name="matchLabelVolumeType")
    def match_label_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the EVS disk type. Currently,
        **SSD**, **GPSSD**, and **SAS** are supported. If omitted, the disk type is not limited.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_volume_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
        The default value is **evs**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str effect: Available options are NoSchedule, PreferNoSchedule, and NoExecute.
               
               <a name="extend_params"></a>
               The `extend_params` block supports:
        :param _builtins.str key: A key must contain 1 to 63 characters starting with a letter or digit. Only letters,
               digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used as the
               prefix of a key.
        :param _builtins.str value: A value must start with a letter or digit and can contain a maximum of 63 characters,
               including letters, digits, hyphens (-), underscores (_), and periods (.).
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Available options are NoSchedule, PreferNoSchedule, and NoExecute.

        <a name="extend_params"></a>
        The `extend_params` block supports:
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A key must contain 1 to 63 characters starting with a letter or digit. Only letters,
        digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used as the
        prefix of a key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A value must start with a letter or digit and can contain a maximum of 63 characters,
        including letters, digits, hyphens (-), underscores (_), and periods (.).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodeRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "extendParam":
            suggest = "extend_param"
        elif key == "extendParams":
            suggest = "extend_params"
        elif key == "hwPassthrough":
            suggest = "hw_passthrough"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 volumetype: _builtins.str,
                 dss_pool_id: Optional[_builtins.str] = None,
                 extend_param: Optional[_builtins.str] = None,
                 extend_params: Optional[Mapping[str, _builtins.str]] = None,
                 hw_passthrough: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the disk size in GB.
               Changing this parameter will create a new resource.
        :param _builtins.str volumetype: Specifies the disk type.
               Changing this parameter will create a new resource.
        :param _builtins.str extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
               
               The following is an example default configuration:
        :param Mapping[str, _builtins.str] extend_params: Specifies the disk expansion parameters.
               Changing this parameter will create a new resource.
        :param _builtins.bool hw_passthrough: schema: Internal
        :param _builtins.str kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the volume.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if hw_passthrough is not None:
            pulumi.set(__self__, "hw_passthrough", hw_passthrough)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the disk size in GB.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Specifies the disk type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volumetype")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    @_utilities.deprecated("""use extend_params instead""")
    def extend_param(self) -> Optional[_builtins.str]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.

        The following is an example default configuration:
        """
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the disk expansion parameters.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter(name="hwPassthrough")
    def hw_passthrough(self) -> Optional[_builtins.bool]:
        """
        schema: Internal
        """
        return pulumi.get(self, "hw_passthrough")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")


@pulumi.output_type
class NodeStorage(dict):
    def __init__(__self__, *,
                 groups: Sequence['outputs.NodeStorageGroup'],
                 selectors: Sequence['outputs.NodeStorageSelector']):
        """
        :param Sequence['NodeStorageGroupArgs'] groups: Specifies the storage group consists of multiple storage devices.
               This is used to divide storage space. Structure is documented below.
               Changing this parameter will create a new resource.
        :param Sequence['NodeStorageSelectorArgs'] selectors: Specifies the disk selection.
               Matched disks are managed according to match labels and storage type. Structure is documented below.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "selectors", selectors)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.NodeStorageGroup']:
        """
        Specifies the storage group consists of multiple storage devices.
        This is used to divide storage space. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> Sequence['outputs.NodeStorageSelector']:
        """
        Specifies the disk selection.
        Matched disks are managed according to match labels and storage type. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class NodeStorageGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectorNames":
            suggest = "selector_names"
        elif key == "virtualSpaces":
            suggest = "virtual_spaces"
        elif key == "cceManaged":
            suggest = "cce_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStorageGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStorageGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStorageGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 selector_names: Sequence[_builtins.str],
                 virtual_spaces: Sequence['outputs.NodeStorageGroupVirtualSpace'],
                 cce_managed: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Specifies the name of a virtual storage group. Each group name must be unique.
               Changing this parameter will create a new resource.
        :param Sequence[_builtins.str] selector_names: Specifies the list of names of seletors to match.
               This parameter corresponds to name in `selectors`. A group can match multiple selectors,
               but a selector can match only one group. Changing this parameter will create a new resource.
        :param Sequence['NodeStorageGroupVirtualSpaceArgs'] virtual_spaces: Specifies the detailed management of space configuration in a group.
               Changing this parameter will create a new resource.
        :param _builtins.bool cce_managed: Specifies the whether the storage space is for **kubernetes** and
               **runtime** components. Only one group can be set to true. The default value is **false**.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "selector_names", selector_names)
        pulumi.set(__self__, "virtual_spaces", virtual_spaces)
        if cce_managed is not None:
            pulumi.set(__self__, "cce_managed", cce_managed)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of a virtual storage group. Each group name must be unique.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selectorNames")
    def selector_names(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of names of seletors to match.
        This parameter corresponds to name in `selectors`. A group can match multiple selectors,
        but a selector can match only one group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "selector_names")

    @_builtins.property
    @pulumi.getter(name="virtualSpaces")
    def virtual_spaces(self) -> Sequence['outputs.NodeStorageGroupVirtualSpace']:
        """
        Specifies the detailed management of space configuration in a group.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "virtual_spaces")

    @_builtins.property
    @pulumi.getter(name="cceManaged")
    def cce_managed(self) -> Optional[_builtins.bool]:
        """
        Specifies the whether the storage space is for **kubernetes** and
        **runtime** components. Only one group can be set to true. The default value is **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cce_managed")


@pulumi.output_type
class NodeStorageGroupVirtualSpace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lvmLvType":
            suggest = "lvm_lv_type"
        elif key == "lvmPath":
            suggest = "lvm_path"
        elif key == "runtimeLvType":
            suggest = "runtime_lv_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStorageGroupVirtualSpace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStorageGroupVirtualSpace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStorageGroupVirtualSpace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 size: _builtins.str,
                 lvm_lv_type: Optional[_builtins.str] = None,
                 lvm_path: Optional[_builtins.str] = None,
                 runtime_lv_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param _builtins.str size: Specifies the size of a virtual space. Only an integer percentage is supported.
               Example: 90%. Note that the total percentage of all virtual spaces in a group cannot exceed 100%.
               Changing this parameter will create a new resource.
        :param _builtins.str lvm_lv_type: Specifies the LVM write mode, values can be **linear** and **striped**.
               This parameter takes effect only in **kubernetes** and **user** configuration. Changing this parameter will create
               a new resource.
        :param _builtins.str lvm_path: Specifies the absolute path to which the disk is attached.
               This parameter takes effect only in **user** configuration. Changing this parameter will create a new resource.
        :param _builtins.str runtime_lv_type: Specifies the LVM write mode, values can be **linear** and **striped**.
               This parameter takes effect only in **runtime** configuration. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if lvm_lv_type is not None:
            pulumi.set(__self__, "lvm_lv_type", lvm_lv_type)
        if lvm_path is not None:
            pulumi.set(__self__, "lvm_path", lvm_path)
        if runtime_lv_type is not None:
            pulumi.set(__self__, "runtime_lv_type", runtime_lv_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
        and **user** are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        Specifies the size of a virtual space. Only an integer percentage is supported.
        Example: 90%. Note that the total percentage of all virtual spaces in a group cannot exceed 100%.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="lvmLvType")
    def lvm_lv_type(self) -> Optional[_builtins.str]:
        """
        Specifies the LVM write mode, values can be **linear** and **striped**.
        This parameter takes effect only in **kubernetes** and **user** configuration. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "lvm_lv_type")

    @_builtins.property
    @pulumi.getter(name="lvmPath")
    def lvm_path(self) -> Optional[_builtins.str]:
        """
        Specifies the absolute path to which the disk is attached.
        This parameter takes effect only in **user** configuration. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lvm_path")

    @_builtins.property
    @pulumi.getter(name="runtimeLvType")
    def runtime_lv_type(self) -> Optional[_builtins.str]:
        """
        Specifies the LVM write mode, values can be **linear** and **striped**.
        This parameter takes effect only in **runtime** configuration. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "runtime_lv_type")


@pulumi.output_type
class NodeStorageSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchLabelCount":
            suggest = "match_label_count"
        elif key == "matchLabelMetadataCmkid":
            suggest = "match_label_metadata_cmkid"
        elif key == "matchLabelMetadataEncrypted":
            suggest = "match_label_metadata_encrypted"
        elif key == "matchLabelSize":
            suggest = "match_label_size"
        elif key == "matchLabelVolumeType":
            suggest = "match_label_volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStorageSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStorageSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStorageSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 match_label_count: Optional[_builtins.str] = None,
                 match_label_metadata_cmkid: Optional[_builtins.str] = None,
                 match_label_metadata_encrypted: Optional[_builtins.str] = None,
                 match_label_size: Optional[_builtins.str] = None,
                 match_label_volume_type: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the selector name, used as the index of `selector_names` in storage group.
               The name of each selector must be unique. Changing this parameter will create a new resource.
        :param _builtins.str match_label_count: Specifies the number of disks to be selected. If omitted,
               all disks of this type are selected. Changing this parameter will create a new resource.
        :param _builtins.str match_label_metadata_cmkid: Specifies the cstomer master key ID of an encrypted
               disk. Changing this parameter will create a new resource.
        :param _builtins.str match_label_metadata_encrypted: Specifies the disk encryption identifier.
               Values can be: **0** indicates that the disk is not encrypted and **1** indicates that the disk is encrypted.
               If omitted, whether the disk is encrypted is not limited. Changing this parameter will create a new resource.
        :param _builtins.str match_label_size: Specifies the matched disk size. If omitted,
               the disk size is not limited. Example: 100. Changing this parameter will create a new resource.
        :param _builtins.str match_label_volume_type: Specifies the EVS disk type. Currently,
               **SSD** and **SAS** are supported. If omitted, the disk type is not limited.
               Changing this parameter will create a new resource.
        :param _builtins.str type: Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
               The default value is **evs**. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        if match_label_count is not None:
            pulumi.set(__self__, "match_label_count", match_label_count)
        if match_label_metadata_cmkid is not None:
            pulumi.set(__self__, "match_label_metadata_cmkid", match_label_metadata_cmkid)
        if match_label_metadata_encrypted is not None:
            pulumi.set(__self__, "match_label_metadata_encrypted", match_label_metadata_encrypted)
        if match_label_size is not None:
            pulumi.set(__self__, "match_label_size", match_label_size)
        if match_label_volume_type is not None:
            pulumi.set(__self__, "match_label_volume_type", match_label_volume_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the selector name, used as the index of `selector_names` in storage group.
        The name of each selector must be unique. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="matchLabelCount")
    def match_label_count(self) -> Optional[_builtins.str]:
        """
        Specifies the number of disks to be selected. If omitted,
        all disks of this type are selected. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_count")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataCmkid")
    def match_label_metadata_cmkid(self) -> Optional[_builtins.str]:
        """
        Specifies the cstomer master key ID of an encrypted
        disk. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_metadata_cmkid")

    @_builtins.property
    @pulumi.getter(name="matchLabelMetadataEncrypted")
    def match_label_metadata_encrypted(self) -> Optional[_builtins.str]:
        """
        Specifies the disk encryption identifier.
        Values can be: **0** indicates that the disk is not encrypted and **1** indicates that the disk is encrypted.
        If omitted, whether the disk is encrypted is not limited. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_metadata_encrypted")

    @_builtins.property
    @pulumi.getter(name="matchLabelSize")
    def match_label_size(self) -> Optional[_builtins.str]:
        """
        Specifies the matched disk size. If omitted,
        the disk size is not limited. Example: 100. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_size")

    @_builtins.property
    @pulumi.getter(name="matchLabelVolumeType")
    def match_label_volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the EVS disk type. Currently,
        **SSD** and **SAS** are supported. If omitted, the disk type is not limited.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "match_label_volume_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Specifies the storage type. Currently, only **evs (EVS volumes)** is supported.
        The default value is **evs**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: Available options are NoSchedule, PreferNoSchedule, and NoExecute.
               Changing this parameter will create a new resource.
        :param _builtins.str key: A key must contain 1 to 63 characters starting with a letter or digit.
               Only letters, digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used
               as the prefix of a key. Changing this parameter will create a new resource.
        :param _builtins.str value: A value must start with a letter or digit and can contain a maximum of 63
               characters, including letters, digits, hyphens (-), underscores (_), and periods (.). Changing this parameter will
               create a new resource.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Available options are NoSchedule, PreferNoSchedule, and NoExecute.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        A key must contain 1 to 63 characters starting with a letter or digit.
        Only letters, digits, hyphens (-), underscores (_), and periods (.) are allowed. A DNS subdomain name can be used
        as the prefix of a key. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        A value must start with a letter or digit and can contain a maximum of 63
        characters, including letters, digits, hyphens (-), underscores (_), and periods (.). Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonTemplateSupportVersionResult(dict):
    def __init__(__self__, *,
                 bare_metals: Sequence[_builtins.str],
                 virtual_machines: Sequence[_builtins.str]):
        pulumi.set(__self__, "bare_metals", bare_metals)
        pulumi.set(__self__, "virtual_machines", virtual_machines)

    @_builtins.property
    @pulumi.getter(name="bareMetals")
    def bare_metals(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "bare_metals")

    @_builtins.property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "virtual_machines")


@pulumi.output_type
class GetClusterCertificateClusterResult(dict):
    def __init__(__self__, *,
                 certificate_authority_data: _builtins.str,
                 name: _builtins.str,
                 server: _builtins.str):
        """
        :param _builtins.str certificate_authority_data: The certificate data.
        :param _builtins.str name: Specifies the name of the cluster.
        :param _builtins.str server: The server IP address.
        """
        pulumi.set(__self__, "certificate_authority_data", certificate_authority_data)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityData")
    def certificate_authority_data(self) -> _builtins.str:
        """
        The certificate data.
        """
        return pulumi.get(self, "certificate_authority_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server IP address.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetClusterCertificateUserResult(dict):
    def __init__(__self__, *,
                 client_certificate_data: _builtins.str,
                 client_key_data: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str client_certificate_data: The client certificate data.
        :param _builtins.str client_key_data: The client key data.
        :param _builtins.str name: Specifies the name of the cluster.
        """
        pulumi.set(__self__, "client_certificate_data", client_certificate_data)
        pulumi.set(__self__, "client_key_data", client_key_data)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clientCertificateData")
    def client_certificate_data(self) -> _builtins.str:
        """
        The client certificate data.
        """
        return pulumi.get(self, "client_certificate_data")

    @_builtins.property
    @pulumi.getter(name="clientKeyData")
    def client_key_data(self) -> _builtins.str:
        """
        The client key data.
        """
        return pulumi.get(self, "client_key_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetClusterCertificatesClusterResult(dict):
    def __init__(__self__, *,
                 certificate_authority_data: _builtins.str,
                 insecure_skip_tls_verify: _builtins.bool,
                 name: _builtins.str,
                 server: _builtins.str):
        """
        :param _builtins.str certificate_authority_data: The certificate authority data of the cluster certificate.
        :param _builtins.bool insecure_skip_tls_verify: Whether insecure skip tls verify of the cluster certificate.
        :param _builtins.str name: The context name of the cluster certificate.
        :param _builtins.str server: The server address of the cluster certificate.
        """
        pulumi.set(__self__, "certificate_authority_data", certificate_authority_data)
        pulumi.set(__self__, "insecure_skip_tls_verify", insecure_skip_tls_verify)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityData")
    def certificate_authority_data(self) -> _builtins.str:
        """
        The certificate authority data of the cluster certificate.
        """
        return pulumi.get(self, "certificate_authority_data")

    @_builtins.property
    @pulumi.getter(name="insecureSkipTlsVerify")
    def insecure_skip_tls_verify(self) -> _builtins.bool:
        """
        Whether insecure skip tls verify of the cluster certificate.
        """
        return pulumi.get(self, "insecure_skip_tls_verify")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The context name of the cluster certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server address of the cluster certificate.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetClusterCertificatesContextResult(dict):
    def __init__(__self__, *,
                 cluster: _builtins.str,
                 name: _builtins.str,
                 user: _builtins.str):
        """
        :param _builtins.str cluster: The context cluster of the cluster certificate.
        :param _builtins.str name: The context name of the cluster certificate.
        :param _builtins.str user: The context user of the cluster certificate.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        The context cluster of the cluster certificate.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The context name of the cluster certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The context user of the cluster certificate.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetClusterCertificatesUserResult(dict):
    def __init__(__self__, *,
                 client_certificate_data: _builtins.str,
                 client_key_data: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str client_certificate_data: The client certificate data of the cluster certificate.
        :param _builtins.str client_key_data: The client key data of the cluster certificate.
        :param _builtins.str name: The context name of the cluster certificate.
        """
        pulumi.set(__self__, "client_certificate_data", client_certificate_data)
        pulumi.set(__self__, "client_key_data", client_key_data)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clientCertificateData")
    def client_certificate_data(self) -> _builtins.str:
        """
        The client certificate data of the cluster certificate.
        """
        return pulumi.get(self, "client_certificate_data")

    @_builtins.property
    @pulumi.getter(name="clientKeyData")
    def client_key_data(self) -> _builtins.str:
        """
        The client key data of the cluster certificate.
        """
        return pulumi.get(self, "client_key_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The context name of the cluster certificate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetClusterEndpointResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str type: The type of the cluster access address.
               + **Internal**: The user's subnet access address.
               + **External**: The public network access address.
        :param _builtins.str url: The URL of the cluster access address.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the cluster access address.
        + **Internal**: The user's subnet access address.
        + **External**: The public network access address.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the cluster access address.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetClusterMasterResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str):
        """
        :param _builtins.str availability_zone: The availability zone (AZ) of the master node.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone (AZ) of the master node.
        """
        return pulumi.get(self, "availability_zone")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 authentication_mode: _builtins.str,
                 billing_mode: _builtins.int,
                 certificate_clusters: Sequence['outputs.GetClustersClusterCertificateClusterResult'],
                 certificate_users: Sequence['outputs.GetClustersClusterCertificateUserResult'],
                 cluster_type: _builtins.str,
                 cluster_version: _builtins.str,
                 container_network_cidr: _builtins.str,
                 container_network_type: _builtins.str,
                 description: _builtins.str,
                 endpoints: Sequence['outputs.GetClustersClusterEndpointResult'],
                 eni_subnet_cidr: _builtins.str,
                 eni_subnet_id: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 flavor_id: _builtins.str,
                 id: _builtins.str,
                 kube_config_raw: _builtins.str,
                 masters: Sequence['outputs.GetClustersClusterMasterResult'],
                 name: _builtins.str,
                 security_group_id: _builtins.str,
                 service_network_cidr: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str authentication_mode: The authentication mode of the cluster, possible values are x509 and rbac. Defaults to **rbac**.
        :param _builtins.int billing_mode: The charging mode of the cluster.
        :param Sequence['GetClustersClusterCertificateClusterArgs'] certificate_clusters: The certificate clusters. Structure is documented below.
        :param Sequence['GetClustersClusterCertificateUserArgs'] certificate_users: The certificate users. Structure is documented below.
        :param _builtins.str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
        :param _builtins.str cluster_version: The version of the cluster.
        :param _builtins.str container_network_cidr: The container network segment.
        :param _builtins.str container_network_type: The container network type: **overlay_l2** , **underlay_ipvlan**, **vpc-router** or **eni**.
        :param _builtins.str description: The description of the cluster.
        :param Sequence['GetClustersClusterEndpointArgs'] endpoints: The access addresses of kube-apiserver in the cluster. Structure is documented below.
        :param _builtins.str eni_subnet_cidr: The ENI network segment.
        :param _builtins.str eni_subnet_id: The ENI**IPv4 subnet ID** of the subnet where the ENI resides.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the cluster.
        :param _builtins.str flavor_id: The specification of the cluster.
        :param _builtins.str id: The ID of the cluster.
        :param _builtins.str kube_config_raw: The raw Kubernetes config to be used by kubectl and other compatible tools.
        :param Sequence['GetClustersClusterMasterArgs'] masters: The advanced configuration of master nodes.
        :param _builtins.str name: Specifies the name of the cluster.
        :param _builtins.str security_group_id: The security group ID of the cluster.
        :param _builtins.str service_network_cidr: The service network segment.
        :param _builtins.str status: Specifies the status of the cluster.
        :param _builtins.str subnet_id: The ID of the subnet used to create the node.
        :param _builtins.str vpc_id: Specifies the VPC ID to which the cluster belongs.
        """
        pulumi.set(__self__, "authentication_mode", authentication_mode)
        pulumi.set(__self__, "billing_mode", billing_mode)
        pulumi.set(__self__, "certificate_clusters", certificate_clusters)
        pulumi.set(__self__, "certificate_users", certificate_users)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "container_network_cidr", container_network_cidr)
        pulumi.set(__self__, "container_network_type", container_network_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "eni_subnet_cidr", eni_subnet_cidr)
        pulumi.set(__self__, "eni_subnet_id", eni_subnet_id)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        pulumi.set(__self__, "masters", masters)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "service_network_cidr", service_network_cidr)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> _builtins.str:
        """
        The authentication mode of the cluster, possible values are x509 and rbac. Defaults to **rbac**.
        """
        return pulumi.get(self, "authentication_mode")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> _builtins.int:
        """
        The charging mode of the cluster.
        """
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter(name="certificateClusters")
    def certificate_clusters(self) -> Sequence['outputs.GetClustersClusterCertificateClusterResult']:
        """
        The certificate clusters. Structure is documented below.
        """
        return pulumi.get(self, "certificate_clusters")

    @_builtins.property
    @pulumi.getter(name="certificateUsers")
    def certificate_users(self) -> Sequence['outputs.GetClustersClusterCertificateUserResult']:
        """
        The certificate users. Structure is documented below.
        """
        return pulumi.get(self, "certificate_users")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> _builtins.str:
        """
        The version of the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="containerNetworkCidr")
    def container_network_cidr(self) -> _builtins.str:
        """
        The container network segment.
        """
        return pulumi.get(self, "container_network_cidr")

    @_builtins.property
    @pulumi.getter(name="containerNetworkType")
    def container_network_type(self) -> _builtins.str:
        """
        The container network type: **overlay_l2** , **underlay_ipvlan**, **vpc-router** or **eni**.
        """
        return pulumi.get(self, "container_network_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClustersClusterEndpointResult']:
        """
        The access addresses of kube-apiserver in the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="eniSubnetCidr")
    def eni_subnet_cidr(self) -> _builtins.str:
        """
        The ENI network segment.
        """
        return pulumi.get(self, "eni_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="eniSubnetId")
    def eni_subnet_id(self) -> _builtins.str:
        """
        The ENI**IPv4 subnet ID** of the subnet where the ENI resides.
        """
        return pulumi.get(self, "eni_subnet_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID of the cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The specification of the cluster.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> _builtins.str:
        """
        The raw Kubernetes config to be used by kubectl and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Sequence['outputs.GetClustersClusterMasterResult']:
        """
        The advanced configuration of master nodes.
        """
        return pulumi.get(self, "masters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID of the cluster.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkCidr")
    def service_network_cidr(self) -> _builtins.str:
        """
        The service network segment.
        """
        return pulumi.get(self, "service_network_cidr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the subnet used to create the node.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Specifies the VPC ID to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetClustersClusterCertificateClusterResult(dict):
    def __init__(__self__, *,
                 certificate_authority_data: _builtins.str,
                 name: _builtins.str,
                 server: _builtins.str):
        """
        :param _builtins.str certificate_authority_data: The certificate data.
        :param _builtins.str name: Specifies the name of the cluster.
        :param _builtins.str server: The server IP address.
        """
        pulumi.set(__self__, "certificate_authority_data", certificate_authority_data)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityData")
    def certificate_authority_data(self) -> _builtins.str:
        """
        The certificate data.
        """
        return pulumi.get(self, "certificate_authority_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The server IP address.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetClustersClusterCertificateUserResult(dict):
    def __init__(__self__, *,
                 client_certificate_data: _builtins.str,
                 client_key_data: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str client_certificate_data: The client certificate data.
        :param _builtins.str client_key_data: The client key data.
        :param _builtins.str name: Specifies the name of the cluster.
        """
        pulumi.set(__self__, "client_certificate_data", client_certificate_data)
        pulumi.set(__self__, "client_key_data", client_key_data)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clientCertificateData")
    def client_certificate_data(self) -> _builtins.str:
        """
        The client certificate data.
        """
        return pulumi.get(self, "client_certificate_data")

    @_builtins.property
    @pulumi.getter(name="clientKeyData")
    def client_key_data(self) -> _builtins.str:
        """
        The client key data.
        """
        return pulumi.get(self, "client_key_data")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetClustersClusterEndpointResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str type: The type of the cluster access address.
               + **Internal**: The user's subnet access address.
               + **External**: The public network access address.
        :param _builtins.str url: The URL of the cluster access address.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the cluster access address.
        + **Internal**: The user's subnet access address.
        + **External**: The public network access address.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the cluster access address.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetClustersClusterMasterResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str):
        """
        :param _builtins.str availability_zone: The availability zone (AZ) of the master node.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone (AZ) of the master node.
        """
        return pulumi.get(self, "availability_zone")


@pulumi.output_type
class GetNodeDataVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetNodeHostnameConfigResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolDataVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetNodePoolHostnameConfigResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: Node Pool type.
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Node Pool type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolRootVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetNodeRootVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetNodesNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 billing_mode: _builtins.int,
                 data_volumes: Sequence['outputs.GetNodesNodeDataVolumeResult'],
                 ecs_group_id: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 flavor_id: _builtins.str,
                 hostname_configs: Sequence['outputs.GetNodesNodeHostnameConfigResult'],
                 id: _builtins.str,
                 key_pair: _builtins.str,
                 name: _builtins.str,
                 os: _builtins.str,
                 private_ip: _builtins.str,
                 public_ip: _builtins.str,
                 root_volumes: Sequence['outputs.GetNodesNodeRootVolumeResult'],
                 server_id: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str availability_zone: The available partitions where the node is located.
        :param _builtins.int billing_mode: The node's billing mode: The value is 0 (on demand).
        :param Sequence['GetNodesNodeDataVolumeArgs'] data_volumes: The data related configuration. Structure is documented below.
        :param _builtins.str ecs_group_id: The ID of ECS group to which the node belongs.
        :param _builtins.str flavor_id: The flavor ID to be used.
        :param _builtins.str id: The ID of the node.
        :param _builtins.str key_pair: The key pair name when logging in to select the key pair mode.
        :param _builtins.str name: Specifies the of the node.
        :param _builtins.str os: The operating System of the node.
        :param _builtins.str private_ip: The private IP of the node.
        :param _builtins.str public_ip: The elastic IP parameters of the node.
        :param Sequence['GetNodesNodeRootVolumeArgs'] root_volumes: The system disk related configuration. Structure is documented below.
        :param _builtins.str server_id: The node's virtual machine ID in ECS.
        :param _builtins.str status: Specifies the status of the node.
        :param _builtins.str subnet_id: The ID of the subnet to which the NIC belongs.
        :param Mapping[str, _builtins.str] tags: The tags of a VM node, key/value pair format.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "billing_mode", billing_mode)
        pulumi.set(__self__, "data_volumes", data_volumes)
        pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "hostname_configs", hostname_configs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_pair", key_pair)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os", os)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "root_volumes", root_volumes)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The available partitions where the node is located.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> _builtins.int:
        """
        The node's billing mode: The value is 0 (on demand).
        """
        return pulumi.get(self, "billing_mode")

    @_builtins.property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Sequence['outputs.GetNodesNodeDataVolumeResult']:
        """
        The data related configuration. Structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> _builtins.str:
        """
        The ID of ECS group to which the node belongs.
        """
        return pulumi.get(self, "ecs_group_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The flavor ID to be used.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="hostnameConfigs")
    def hostname_configs(self) -> Sequence['outputs.GetNodesNodeHostnameConfigResult']:
        return pulumi.get(self, "hostname_configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> _builtins.str:
        """
        The key pair name when logging in to select the key pair mode.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the of the node.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operating System of the node.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> _builtins.str:
        """
        The private IP of the node.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The elastic IP parameters of the node.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetNodesNodeRootVolumeResult']:
        """
        The system disk related configuration. Structure is documented below.
        """
        return pulumi.get(self, "root_volumes")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The node's virtual machine ID in ECS.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetNodesNodeDataVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetNodesNodeHostnameConfigResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodesNodeRootVolumeResult(dict):
    def __init__(__self__, *,
                 extend_params: Mapping[str, _builtins.str],
                 size: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Mapping[str, _builtins.str] extend_params: Disk expansion parameters.
        :param _builtins.int size: Disk size in GB.
        :param _builtins.str volumetype: Disk type.
        """
        pulumi.set(__self__, "extend_params", extend_params)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Mapping[str, _builtins.str]:
        """
        Disk expansion parameters.
        """
        return pulumi.get(self, "extend_params")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "volumetype")


