# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 flavor_id: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_nums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_boot_time: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_off_time: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies available zone.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies flavor id. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies email address for receiving notifications when a table/file migration
               job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_auto_off: Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
               startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
               the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
               running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies cluster name. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] phone_nums: Specifies phone number for receiving notifications when a table/file
               migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_boot_time: Specifies time for scheduled startup of a CDM cluster.
               The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
               enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_off_time: Specifies time for scheduled shutdown of a CDM cluster.
               The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
               The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
               The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the cluster version. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_auto_off is not None:
            pulumi.set(__self__, "is_auto_off", is_auto_off)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone_nums is not None:
            pulumi.set(__self__, "phone_nums", phone_nums)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_boot_time is not None:
            pulumi.set(__self__, "schedule_boot_time", schedule_boot_time)
        if schedule_off_time is not None:
            pulumi.set(__self__, "schedule_off_time", schedule_off_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies available zone.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies flavor id. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies email address for receiving notifications when a table/file migration
        job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emails", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isAutoOff")
    def is_auto_off(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
        startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
        the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
        running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_auto_off")

    @is_auto_off.setter
    def is_auto_off(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_off", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies cluster name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="phoneNums")
    def phone_nums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies phone number for receiving notifications when a table/file
        migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "phone_nums")

    @phone_nums.setter
    def phone_nums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "phone_nums", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleBootTime")
    def schedule_boot_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies time for scheduled startup of a CDM cluster.
        The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
        enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_boot_time")

    @schedule_boot_time.setter
    def schedule_boot_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_boot_time", value)

    @_builtins.property
    @pulumi.getter(name="scheduleOffTime")
    def schedule_off_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies time for scheduled shutdown of a CDM cluster.
        The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
        The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
        The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_off_time")

    @schedule_off_time.setter
    def schedule_off_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_off_time", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster version. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInstanceArgs']]]] = None,
                 is_auto_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_nums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_boot_time: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_off_time: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies available zone.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created: Create time. The format is: `YYYY-MM-DDThh:mm:ss`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies email address for receiving notifications when a table/file migration
               job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies flavor id. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterInstanceArgs']]] instances: Instance list. Structure is documented below.
        :param pulumi.Input[_builtins.bool] is_auto_off: Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
               startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
               the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
               running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies cluster name. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] phone_nums: Specifies phone number for receiving notifications when a table/file
               migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] public_endpoint: EIP bound to the cluster.
        :param pulumi.Input[_builtins.str] public_ip: Public IP.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_boot_time: Specifies time for scheduled startup of a CDM cluster.
               The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
               enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_off_time: Specifies time for scheduled shutdown of a CDM cluster.
               The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
               The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
               The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the cluster version. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies VPC ID. Changing this parameter will create a new resource.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if is_auto_off is not None:
            pulumi.set(__self__, "is_auto_off", is_auto_off)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone_nums is not None:
            pulumi.set(__self__, "phone_nums", phone_nums)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule_boot_time is not None:
            pulumi.set(__self__, "schedule_boot_time", schedule_boot_time)
        if schedule_off_time is not None:
            pulumi.set(__self__, "schedule_off_time", schedule_off_time)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies available zone.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time. The format is: `YYYY-MM-DDThh:mm:ss`.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies email address for receiving notifications when a table/file migration
        job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emails", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies flavor id. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInstanceArgs']]]]:
        """
        Instance list. Structure is documented below.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="isAutoOff")
    def is_auto_off(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
        startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
        the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
        running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_auto_off")

    @is_auto_off.setter
    def is_auto_off(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_off", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies cluster name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="phoneNums")
    def phone_nums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies phone number for receiving notifications when a table/file
        migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "phone_nums")

    @phone_nums.setter
    def phone_nums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "phone_nums", value)

    @_builtins.property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EIP bound to the cluster.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduleBootTime")
    def schedule_boot_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies time for scheduled startup of a CDM cluster.
        The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
        enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_boot_time")

    @schedule_boot_time.setter
    def schedule_boot_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_boot_time", value)

    @_builtins.property
    @pulumi.getter(name="scheduleOffTime")
    def schedule_off_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies time for scheduled shutdown of a CDM cluster.
        The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
        The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
        The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_off_time")

    @schedule_off_time.setter
    def schedule_off_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_off_time", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster version. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Cdm/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_nums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_boot_time: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_off_time: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages CDM cluster resource within SberCloud.

        ## Example Usage

        ### create a cdm cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        flavor_id = config.require_object("flavorId")
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        test = sbercloud.get_cdm_flavors()
        cluster = sbercloud.cdm.Cluster("cluster",
            name=name,
            availability_zone=availability_zone,
            flavor_id=test.flavors[0].id,
            subnet_id=subnet_id,
            vpc_id=vpc_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        Clusters can be imported by `id`. For example,

        ```sh
        $ pulumi import sbercloud:Cdm/cluster:Cluster test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `email` and `phone_num`.

        It is generally recommended running `pulumi preview` after importing a cluster.

        You can then decide if changes should be applied to the cluster, or the resource definition

        should be updated to align with the cluster. Also you can ignore changes as below.

        resource "sbercloud_cdm_cluster" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              email, phone_num,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies available zone.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies email address for receiving notifications when a table/file migration
               job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies flavor id. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_auto_off: Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
               startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
               the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
               running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies cluster name. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] phone_nums: Specifies phone number for receiving notifications when a table/file
               migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_boot_time: Specifies time for scheduled startup of a CDM cluster.
               The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
               enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_off_time: Specifies time for scheduled shutdown of a CDM cluster.
               The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
               The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
               The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the cluster version. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies VPC ID. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CDM cluster resource within SberCloud.

        ## Example Usage

        ### create a cdm cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        flavor_id = config.require_object("flavorId")
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        test = sbercloud.get_cdm_flavors()
        cluster = sbercloud.cdm.Cluster("cluster",
            name=name,
            availability_zone=availability_zone,
            flavor_id=test.flavors[0].id,
            subnet_id=subnet_id,
            vpc_id=vpc_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        Clusters can be imported by `id`. For example,

        ```sh
        $ pulumi import sbercloud:Cdm/cluster:Cluster test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `email` and `phone_num`.

        It is generally recommended running `pulumi preview` after importing a cluster.

        You can then decide if changes should be applied to the cluster, or the resource definition

        should be updated to align with the cluster. Also you can ignore changes as below.

        resource "sbercloud_cdm_cluster" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              email, phone_num,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_off: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_nums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_boot_time: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_off_time: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["emails"] = emails
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["is_auto_off"] = is_auto_off
            __props__.__dict__["name"] = name
            __props__.__dict__["phone_nums"] = phone_nums
            __props__.__dict__["region"] = region
            __props__.__dict__["schedule_boot_time"] = schedule_boot_time
            __props__.__dict__["schedule_off_time"] = schedule_off_time
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["version"] = version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["flavor_name"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["public_endpoint"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
        super(Cluster, __self__).__init__(
            'sbercloud:Cdm/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterInstanceArgs', 'ClusterInstanceArgsDict']]]]] = None,
            is_auto_off: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            phone_nums: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_boot_time: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_off_time: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies available zone.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] created: Create time. The format is: `YYYY-MM-DDThh:mm:ss`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies email address for receiving notifications when a table/file migration
               job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies flavor id. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterInstanceArgs', 'ClusterInstanceArgsDict']]]] instances: Instance list. Structure is documented below.
        :param pulumi.Input[_builtins.bool] is_auto_off: Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
               startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
               the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
               running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies cluster name. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] phone_nums: Specifies phone number for receiving notifications when a table/file
               migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] public_endpoint: EIP bound to the cluster.
        :param pulumi.Input[_builtins.str] public_ip: Public IP.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_boot_time: Specifies time for scheduled startup of a CDM cluster.
               The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
               enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] schedule_off_time: Specifies time for scheduled shutdown of a CDM cluster.
               The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
               The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
               The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the cluster version. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies VPC ID. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created"] = created
        __props__.__dict__["emails"] = emails
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["instances"] = instances
        __props__.__dict__["is_auto_off"] = is_auto_off
        __props__.__dict__["name"] = name
        __props__.__dict__["phone_nums"] = phone_nums
        __props__.__dict__["public_endpoint"] = public_endpoint
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule_boot_time"] = schedule_boot_time
        __props__.__dict__["schedule_off_time"] = schedule_off_time
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies available zone.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Create time. The format is: `YYYY-MM-DDThh:mm:ss`.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies email address for receiving notifications when a table/file migration
        job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "emails")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies flavor id. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence['outputs.ClusterInstance']]:
        """
        Instance list. Structure is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="isAutoOff")
    def is_auto_off(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies Whether to enable auto shutdown. The auto shutdown and scheduled
        startup/shutdown functions cannot be enabled at the same time. When auto shutdown is enabled, if no job is running in
        the cluster and no scheduled job is created, a cluster will be automatically shut down 15 minutes after it starts
        running to reduce costs. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_auto_off")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies cluster name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="phoneNums")
    def phone_nums(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies phone number for receiving notifications when a table/file
        migration job fails or an EIP exception occurs. The max number is 5. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "phone_nums")

    @_builtins.property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        EIP bound to the cluster.
        """
        return pulumi.get(self, "public_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Public IP.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scheduleBootTime")
    def schedule_boot_time(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies time for scheduled startup of a CDM cluster.
        The CDM cluster starts at this time every day. The scheduled startup/shutdown and auto shutdown function cannot be
        enabled at the same time. The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_boot_time")

    @_builtins.property
    @pulumi.getter(name="scheduleOffTime")
    def schedule_off_time(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies time for scheduled shutdown of a CDM cluster.
        The system shuts down directly at this time every day without waiting for unfinished jobs to complete.
        The scheduled startup/shutdown and auto shutdown function cannot be enabled at the same time.
        The time format is `hh:mm:ss`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schedule_off_time")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster version. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

