# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmruleArgs', 'Alarmrule']

@pulumi.input_type
class AlarmruleArgs:
    def __init__(__self__, *,
                 alarm_name: pulumi.Input[_builtins.str],
                 condition: pulumi.Input['AlarmruleConditionArgs'],
                 metric: pulumi.Input['AlarmruleMetricArgs'],
                 alarm_action_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_level: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Alarmrule resource.
        :param pulumi.Input[_builtins.str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input['AlarmruleConditionArgs'] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input['AlarmruleMetricArgs'] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[_builtins.bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below.
        :param pulumi.Input[_builtins.str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[_builtins.bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[_builtins.str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
               **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
               
               > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
               and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "alarm_name", alarm_name)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "metric", metric)
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if alarm_enabled is not None:
            pulumi.set(__self__, "alarm_enabled", alarm_enabled)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if alarm_type is not None:
            pulumi.set(__self__, "alarm_type", alarm_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if insufficientdata_actions is not None:
            warnings.warn("""insufficientdata_actions is deprecated""", DeprecationWarning)
            pulumi.log.warn("""insufficientdata_actions is deprecated: insufficientdata_actions is deprecated""")
        if insufficientdata_actions is not None:
            pulumi.set(__self__, "insufficientdata_actions", insufficientdata_actions)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alarm_name", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Input['AlarmruleConditionArgs']:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['AlarmruleConditionArgs']):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Input['AlarmruleMetricArgs']:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['AlarmruleMetricArgs']):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]):
        pulumi.set(self, "alarm_actions", value)

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @_builtins.property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @alarm_enabled.setter
    def alarm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alarm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alarm_level", value)

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
        **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.

        > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
        and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="insufficientdataActions")
    @_utilities.deprecated("""insufficientdata_actions is deprecated""")
    def insufficientdata_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]:
        return pulumi.get(self, "insufficientdata_actions")

    @insufficientdata_actions.setter
    def insufficientdata_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]):
        pulumi.set(self, "insufficientdata_actions", value)

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]):
        pulumi.set(self, "ok_actions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AlarmruleState:
    def __init__(__self__, *,
                 alarm_action_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_level: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_state: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input['AlarmruleConditionArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]] = None,
                 metric: Optional[pulumi.Input['AlarmruleMetricArgs']] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Alarmrule resources.
        :param pulumi.Input[_builtins.bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below.
        :param pulumi.Input[_builtins.str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[_builtins.bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[_builtins.str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[_builtins.str] alarm_state: Indicates the alarm status. The value can be:
               + ok: The alarm status is normal;
               + alarm: An alarm is generated;
               + insufficient_data: The required data is insufficient.
        :param pulumi.Input[_builtins.str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
               **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input['AlarmruleConditionArgs'] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
               
               > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
               and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        :param pulumi.Input['AlarmruleMetricArgs'] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] update_time: Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if alarm_enabled is not None:
            pulumi.set(__self__, "alarm_enabled", alarm_enabled)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if alarm_name is not None:
            pulumi.set(__self__, "alarm_name", alarm_name)
        if alarm_state is not None:
            pulumi.set(__self__, "alarm_state", alarm_state)
        if alarm_type is not None:
            pulumi.set(__self__, "alarm_type", alarm_type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if insufficientdata_actions is not None:
            warnings.warn("""insufficientdata_actions is deprecated""", DeprecationWarning)
            pulumi.log.warn("""insufficientdata_actions is deprecated: insufficientdata_actions is deprecated""")
        if insufficientdata_actions is not None:
            pulumi.set(__self__, "insufficientdata_actions", insufficientdata_actions)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]):
        pulumi.set(self, "alarm_actions", value)

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @_builtins.property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @alarm_enabled.setter
    def alarm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alarm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alarm_level", value)

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_name", value)

    @_builtins.property
    @pulumi.getter(name="alarmState")
    def alarm_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the alarm status. The value can be:
        + ok: The alarm status is normal;
        + alarm: An alarm is generated;
        + insufficient_data: The required data is insufficient.
        """
        return pulumi.get(self, "alarm_state")

    @alarm_state.setter
    def alarm_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_state", value)

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
        **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_type", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AlarmruleConditionArgs']]:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AlarmruleConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.

        > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
        and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="insufficientdataActions")
    @_utilities.deprecated("""insufficientdata_actions is deprecated""")
    def insufficientdata_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]:
        return pulumi.get(self, "insufficientdata_actions")

    @insufficientdata_actions.setter
    def insufficientdata_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]):
        pulumi.set(self, "insufficientdata_actions", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['AlarmruleMetricArgs']]:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['AlarmruleMetricArgs']]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]):
        pulumi.set(self, "ok_actions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("sbercloud:Ces/alarmrule:Alarmrule")
class Alarmrule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleAlarmActionArgs', 'AlarmruleAlarmActionArgsDict']]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_level: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['AlarmruleConditionArgs', 'AlarmruleConditionArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleInsufficientdataActionArgs', 'AlarmruleInsufficientdataActionArgsDict']]]]] = None,
                 metric: Optional[pulumi.Input[Union['AlarmruleMetricArgs', 'AlarmruleMetricArgsDict']]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleOkActionArgs', 'AlarmruleOkActionArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cloud Eye alarm rule resource within SberCloud.

        ## Example Usage

        ## Import

        CES alarm rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Ces/alarmrule:Alarmrule alarm_rule al1619578509719Ga0X1RGWv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleAlarmActionArgs', 'AlarmruleAlarmActionArgsDict']]]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below.
        :param pulumi.Input[_builtins.str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[_builtins.bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[_builtins.str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[_builtins.str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
               **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[Union['AlarmruleConditionArgs', 'AlarmruleConditionArgsDict']] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
               
               > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
               and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        :param pulumi.Input[Union['AlarmruleMetricArgs', 'AlarmruleMetricArgsDict']] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleOkActionArgs', 'AlarmruleOkActionArgsDict']]]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmruleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Eye alarm rule resource within SberCloud.

        ## Example Usage

        ## Import

        CES alarm rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Ces/alarmrule:Alarmrule alarm_rule al1619578509719Ga0X1RGWv
        ```

        :param str resource_name: The name of the resource.
        :param AlarmruleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmruleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleAlarmActionArgs', 'AlarmruleAlarmActionArgsDict']]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alarm_level: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['AlarmruleConditionArgs', 'AlarmruleConditionArgsDict']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleInsufficientdataActionArgs', 'AlarmruleInsufficientdataActionArgsDict']]]]] = None,
                 metric: Optional[pulumi.Input[Union['AlarmruleMetricArgs', 'AlarmruleMetricArgsDict']]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleOkActionArgs', 'AlarmruleOkActionArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmruleArgs.__new__(AlarmruleArgs)

            __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
            __props__.__dict__["alarm_actions"] = alarm_actions
            __props__.__dict__["alarm_description"] = alarm_description
            __props__.__dict__["alarm_enabled"] = alarm_enabled
            __props__.__dict__["alarm_level"] = alarm_level
            if alarm_name is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_name'")
            __props__.__dict__["alarm_name"] = alarm_name
            __props__.__dict__["alarm_type"] = alarm_type
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["insufficientdata_actions"] = insufficientdata_actions
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["ok_actions"] = ok_actions
            __props__.__dict__["region"] = region
            __props__.__dict__["alarm_state"] = None
            __props__.__dict__["update_time"] = None
        super(Alarmrule, __self__).__init__(
            'sbercloud:Ces/alarmrule:Alarmrule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_action_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleAlarmActionArgs', 'AlarmruleAlarmActionArgsDict']]]]] = None,
            alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            alarm_level: Optional[pulumi.Input[_builtins.int]] = None,
            alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_state: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_type: Optional[pulumi.Input[_builtins.str]] = None,
            condition: Optional[pulumi.Input[Union['AlarmruleConditionArgs', 'AlarmruleConditionArgsDict']]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleInsufficientdataActionArgs', 'AlarmruleInsufficientdataActionArgsDict']]]]] = None,
            metric: Optional[pulumi.Input[Union['AlarmruleMetricArgs', 'AlarmruleMetricArgsDict']]] = None,
            ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleOkActionArgs', 'AlarmruleOkActionArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'Alarmrule':
        """
        Get an existing Alarmrule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleAlarmActionArgs', 'AlarmruleAlarmActionArgsDict']]]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below.
        :param pulumi.Input[_builtins.str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[_builtins.bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[_builtins.str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[_builtins.str] alarm_state: Indicates the alarm status. The value can be:
               + ok: The alarm status is normal;
               + alarm: An alarm is generated;
               + insufficient_data: The required data is insufficient.
        :param pulumi.Input[_builtins.str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
               **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[Union['AlarmruleConditionArgs', 'AlarmruleConditionArgsDict']] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
               
               > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
               and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        :param pulumi.Input[Union['AlarmruleMetricArgs', 'AlarmruleMetricArgsDict']] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlarmruleOkActionArgs', 'AlarmruleOkActionArgsDict']]]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] update_time: Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmruleState.__new__(_AlarmruleState)

        __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
        __props__.__dict__["alarm_actions"] = alarm_actions
        __props__.__dict__["alarm_description"] = alarm_description
        __props__.__dict__["alarm_enabled"] = alarm_enabled
        __props__.__dict__["alarm_level"] = alarm_level
        __props__.__dict__["alarm_name"] = alarm_name
        __props__.__dict__["alarm_state"] = alarm_state
        __props__.__dict__["alarm_type"] = alarm_type
        __props__.__dict__["condition"] = condition
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["insufficientdata_actions"] = insufficientdata_actions
        __props__.__dict__["metric"] = metric
        __props__.__dict__["ok_actions"] = ok_actions
        __props__.__dict__["region"] = region
        __props__.__dict__["update_time"] = update_time
        return Alarmrule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleAlarmAction']]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below.
        """
        return pulumi.get(self, "alarm_actions")

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @_builtins.property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @_builtins.property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "alarm_level")

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @_builtins.property
    @pulumi.getter(name="alarmState")
    def alarm_state(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the alarm status. The value can be:
        + ok: The alarm status is normal;
        + alarm: An alarm is generated;
        + insufficient_data: The required data is insufficient.
        """
        return pulumi.get(self, "alarm_state")

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**,
        **MULTI_INSTANCE** and **ALL_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output['outputs.AlarmruleCondition']:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.

        > **Note** If alarm_action_enabled is set to true, either alarm_actions or ok_actions cannot be empty. If alarm_actions
        and ok_actions coexist, their corresponding notification_list must be of the **same value**.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="insufficientdataActions")
    @_utilities.deprecated("""insufficientdata_actions is deprecated""")
    def insufficientdata_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleInsufficientdataAction']]]:
        return pulumi.get(self, "insufficientdata_actions")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output['outputs.AlarmruleMetric']:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleOkAction']]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below.
        """
        return pulumi.get(self, "ok_actions")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        return pulumi.get(self, "update_time")

