# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclRuleCustomServiceArgs',
    'AclRuleCustomServiceArgsDict',
    'AclRuleCustomServiceGroupsArgs',
    'AclRuleCustomServiceGroupsArgsDict',
    'AclRuleDestinationRegionListArgs',
    'AclRuleDestinationRegionListArgsDict',
    'AclRulePredefinedServiceGroupsArgs',
    'AclRulePredefinedServiceGroupsArgsDict',
    'AclRuleSequenceArgs',
    'AclRuleSequenceArgsDict',
    'AclRuleSourceRegionListArgs',
    'AclRuleSourceRegionListArgsDict',
    'AntiVirusScanProtocolConfigArgs',
    'AntiVirusScanProtocolConfigArgsDict',
    'CaptureTaskDestinationArgs',
    'CaptureTaskDestinationArgsDict',
    'CaptureTaskServiceArgs',
    'CaptureTaskServiceArgsDict',
    'CaptureTaskSourceArgs',
    'CaptureTaskSourceArgsDict',
    'DomainNameGroupDomainNameArgs',
    'DomainNameGroupDomainNameArgsDict',
    'EipProtectionProtectedEipArgs',
    'EipProtectionProtectedEipArgsDict',
    'FirewallFlavorArgs',
    'FirewallFlavorArgsDict',
    'FirewallProtectObjectArgs',
    'FirewallProtectObjectArgsDict',
]

MYPY = False

if not MYPY:
    class AclRuleCustomServiceArgsDict(TypedDict):
        dest_port: pulumi.Input[_builtins.str]
        """
        The destination port.
        """
        protocol: pulumi.Input[_builtins.int]
        """
        The protocol type.
        """
        source_port: pulumi.Input[_builtins.str]
        """
        The source port.

        <a name="CustomServiceGroups"></a>
        The `custom_service_groups` block supports:
        """
elif False:
    AclRuleCustomServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRuleCustomServiceArgs:
    def __init__(__self__, *,
                 dest_port: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.int],
                 source_port: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] dest_port: The destination port.
        :param pulumi.Input[_builtins.int] protocol: The protocol type.
        :param pulumi.Input[_builtins.str] source_port: The source port.
               
               <a name="CustomServiceGroups"></a>
               The `custom_service_groups` block supports:
        """
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Input[_builtins.str]:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.int]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Input[_builtins.str]:
        """
        The source port.

        <a name="CustomServiceGroups"></a>
        The `custom_service_groups` block supports:
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_port", value)


if not MYPY:
    class AclRuleCustomServiceGroupsArgsDict(TypedDict):
        group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The IDs of the predefined service groups.
        """
        protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
elif False:
    AclRuleCustomServiceGroupsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRuleCustomServiceGroupsArgs:
    def __init__(__self__, *,
                 group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The IDs of the predefined service groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] protocols: The protocols used in the predefined service groups.
               
               <a name="SourceRegionList"></a>
               The `source_region_list` block supports:
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "protocols", protocols)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The IDs of the predefined service groups.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "protocols", value)


if not MYPY:
    class AclRuleDestinationRegionListArgsDict(TypedDict):
        region_id: pulumi.Input[_builtins.str]
        """
        The region ID.
        """
        region_type: pulumi.Input[_builtins.int]
        """
        The region type.
        """
        description_cn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Chinese description of the region.
        """
        description_en: NotRequired[pulumi.Input[_builtins.str]]
        """
        The English description of the region.
        """
elif False:
    AclRuleDestinationRegionListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRuleDestinationRegionListArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[_builtins.str],
                 region_type: pulumi.Input[_builtins.int],
                 description_cn: Optional[pulumi.Input[_builtins.str]] = None,
                 description_en: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.int] region_type: The region type.
        :param pulumi.Input[_builtins.str] description_cn: The Chinese description of the region.
        :param pulumi.Input[_builtins.str] description_en: The English description of the region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)
        if description_cn is not None:
            pulumi.set(__self__, "description_cn", description_cn)
        if description_en is not None:
            pulumi.set(__self__, "description_en", description_en)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> pulumi.Input[_builtins.int]:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")

    @region_type.setter
    def region_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "region_type", value)

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Chinese description of the region.
        """
        return pulumi.get(self, "description_cn")

    @description_cn.setter
    def description_cn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description_cn", value)

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The English description of the region.
        """
        return pulumi.get(self, "description_en")

    @description_en.setter
    def description_en(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description_en", value)


if not MYPY:
    class AclRulePredefinedServiceGroupsArgsDict(TypedDict):
        group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The IDs of the predefined service groups.
        """
        protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
elif False:
    AclRulePredefinedServiceGroupsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRulePredefinedServiceGroupsArgs:
    def __init__(__self__, *,
                 group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The IDs of the predefined service groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] protocols: The protocols used in the predefined service groups.
               
               <a name="SourceRegionList"></a>
               The `source_region_list` block supports:
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "protocols", protocols)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The IDs of the predefined service groups.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "protocols", value)


if not MYPY:
    class AclRuleSequenceArgsDict(TypedDict):
        bottom: NotRequired[pulumi.Input[_builtins.int]]
        """
        Whether to pin on bottom.
        The options are as follows:
        + **0**: no;
        + **1**: yes;
        """
        dest_rule_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the rule that the added rule will follow.
        """
        top: NotRequired[pulumi.Input[_builtins.int]]
        """
        Whether to pin on top.
        The options are as follows:
        + **0**: no;
        + **1**: yes;

        <a name="CustomServices"></a>
        The `custom_services` block supports:
        """
elif False:
    AclRuleSequenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRuleSequenceArgs:
    def __init__(__self__, *,
                 bottom: Optional[pulumi.Input[_builtins.int]] = None,
                 dest_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 top: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] bottom: Whether to pin on bottom.
               The options are as follows:
               + **0**: no;
               + **1**: yes;
        :param pulumi.Input[_builtins.str] dest_rule_id: The ID of the rule that the added rule will follow.
        :param pulumi.Input[_builtins.int] top: Whether to pin on top.
               The options are as follows:
               + **0**: no;
               + **1**: yes;
               
               <a name="CustomServices"></a>
               The `custom_services` block supports:
        """
        if bottom is not None:
            pulumi.set(__self__, "bottom", bottom)
        if dest_rule_id is not None:
            pulumi.set(__self__, "dest_rule_id", dest_rule_id)
        if top is not None:
            pulumi.set(__self__, "top", top)

    @_builtins.property
    @pulumi.getter
    def bottom(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to pin on bottom.
        The options are as follows:
        + **0**: no;
        + **1**: yes;
        """
        return pulumi.get(self, "bottom")

    @bottom.setter
    def bottom(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bottom", value)

    @_builtins.property
    @pulumi.getter(name="destRuleId")
    def dest_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the rule that the added rule will follow.
        """
        return pulumi.get(self, "dest_rule_id")

    @dest_rule_id.setter
    def dest_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def top(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to pin on top.
        The options are as follows:
        + **0**: no;
        + **1**: yes;

        <a name="CustomServices"></a>
        The `custom_services` block supports:
        """
        return pulumi.get(self, "top")

    @top.setter
    def top(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "top", value)


if not MYPY:
    class AclRuleSourceRegionListArgsDict(TypedDict):
        region_id: pulumi.Input[_builtins.str]
        """
        The region ID.
        """
        region_type: pulumi.Input[_builtins.int]
        """
        The region type.
        """
        description_cn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Chinese description of the region.
        """
        description_en: NotRequired[pulumi.Input[_builtins.str]]
        """
        The English description of the region.
        """
elif False:
    AclRuleSourceRegionListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclRuleSourceRegionListArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[_builtins.str],
                 region_type: pulumi.Input[_builtins.int],
                 description_cn: Optional[pulumi.Input[_builtins.str]] = None,
                 description_en: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.int] region_type: The region type.
        :param pulumi.Input[_builtins.str] description_cn: The Chinese description of the region.
        :param pulumi.Input[_builtins.str] description_en: The English description of the region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)
        if description_cn is not None:
            pulumi.set(__self__, "description_cn", description_cn)
        if description_en is not None:
            pulumi.set(__self__, "description_en", description_en)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> pulumi.Input[_builtins.int]:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")

    @region_type.setter
    def region_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "region_type", value)

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Chinese description of the region.
        """
        return pulumi.get(self, "description_cn")

    @description_cn.setter
    def description_cn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description_cn", value)

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The English description of the region.
        """
        return pulumi.get(self, "description_en")

    @description_en.setter
    def description_en(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description_en", value)


if not MYPY:
    class AntiVirusScanProtocolConfigArgsDict(TypedDict):
        action: pulumi.Input[_builtins.int]
        """
        The anti virus action. The valid value can be **0** (observe) or **1** (block).
        """
        protocol_type: pulumi.Input[_builtins.int]
        """
        The protocol type.
        The valid values are as follows:
        + **0**: HTTP;
        + **1**: SMTP;
        + **2**: POP3;
        + **3**: IMAP4;
        + **4**: FTP;
        + **5**: SMB;
        + **6**: Malicious Access Control;
        """
elif False:
    AntiVirusScanProtocolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AntiVirusScanProtocolConfigArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.int],
                 protocol_type: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] action: The anti virus action. The valid value can be **0** (observe) or **1** (block).
        :param pulumi.Input[_builtins.int] protocol_type: The protocol type.
               The valid values are as follows:
               + **0**: HTTP;
               + **1**: SMTP;
               + **2**: POP3;
               + **3**: IMAP4;
               + **4**: FTP;
               + **5**: SMB;
               + **6**: Malicious Access Control;
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol_type", protocol_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.int]:
        """
        The anti virus action. The valid value can be **0** (observe) or **1** (block).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[_builtins.int]:
        """
        The protocol type.
        The valid values are as follows:
        + **0**: HTTP;
        + **1**: SMTP;
        + **2**: POP3;
        + **3**: IMAP4;
        + **4**: FTP;
        + **5**: SMB;
        + **6**: Malicious Access Control;
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol_type", value)


if not MYPY:
    class CaptureTaskDestinationArgsDict(TypedDict):
        address: pulumi.Input[_builtins.str]
        """
        Specifies the address.
        """
        address_type: pulumi.Input[_builtins.int]
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
elif False:
    CaptureTaskDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CaptureTaskDestinationArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 address_type: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The valid values are:
               + **0**: indicates IPv4;
               + **1**: indicates IPv6.
               
               <a name="Service"></a>
               The `service` block supports:
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "address_type", value)


if not MYPY:
    class CaptureTaskServiceArgsDict(TypedDict):
        protocol: pulumi.Input[_builtins.int]
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.
        """
        dest_port: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the destination port.
        """
        source_port: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the source port.
        """
elif False:
    CaptureTaskServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CaptureTaskServiceArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[_builtins.int],
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
        :param pulumi.Input[_builtins.str] dest_port: Specifies the destination port.
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port.
        """
        pulumi.set(__self__, "protocol", protocol)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)


if not MYPY:
    class CaptureTaskSourceArgsDict(TypedDict):
        address: pulumi.Input[_builtins.str]
        """
        Specifies the address.
        """
        address_type: pulumi.Input[_builtins.int]
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
elif False:
    CaptureTaskSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CaptureTaskSourceArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 address_type: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The valid values are:
               + **0**: indicates IPv4;
               + **1**: indicates IPv6.
               
               <a name="Service"></a>
               The `service` block supports:
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "address_type", value)


if not MYPY:
    class DomainNameGroupDomainNameArgsDict(TypedDict):
        domain_name: pulumi.Input[_builtins.str]
        """
        Specifies the domain name.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the description.
        """
        dns_ips: NotRequired[pulumi.Input[_builtins.str]]
        """
        The DNS IP list.
        """
        domain_address_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The domain address ID.
        """
elif False:
    DomainNameGroupDomainNameArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNameGroupDomainNameArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_address_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] domain_name: Specifies the domain name.
        :param pulumi.Input[_builtins.str] description: Specifies the description.
        :param pulumi.Input[_builtins.str] dns_ips: The DNS IP list.
        :param pulumi.Input[_builtins.str] domain_address_id: The domain address ID.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_address_id is not None:
            pulumi.set(__self__, "domain_address_id", domain_address_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS IP list.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_ips", value)

    @_builtins.property
    @pulumi.getter(name="domainAddressId")
    def domain_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain address ID.
        """
        return pulumi.get(self, "domain_address_id")

    @domain_address_id.setter
    def domain_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_address_id", value)


if not MYPY:
    class EipProtectionProtectedEipArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        The ID of the protected EIP.
        """
        public_ipv4: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address of the protected EIP.
        """
        public_ipv6: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv6 address of the protected EIP.

        > At least one of `public_ipv4` and `public_ipv6` must be set.
        """
elif False:
    EipProtectionProtectedEipArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EipProtectionProtectedEipArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 public_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ipv6: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the protected EIP.
        :param pulumi.Input[_builtins.str] public_ipv4: The IPv4 address of the protected EIP.
        :param pulumi.Input[_builtins.str] public_ipv6: The IPv6 address of the protected EIP.
               
               > At least one of `public_ipv4` and `public_ipv6` must be set.
        """
        pulumi.set(__self__, "id", id)
        if public_ipv4 is not None:
            pulumi.set(__self__, "public_ipv4", public_ipv4)
        if public_ipv6 is not None:
            pulumi.set(__self__, "public_ipv6", public_ipv6)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the protected EIP.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpv4")
    def public_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address of the protected EIP.
        """
        return pulumi.get(self, "public_ipv4")

    @public_ipv4.setter
    def public_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address of the protected EIP.

        > At least one of `public_ipv4` and `public_ipv6` must be set.
        """
        return pulumi.get(self, "public_ipv6")

    @public_ipv6.setter
    def public_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ipv6", value)


if not MYPY:
    class FirewallFlavorArgsDict(TypedDict):
        version: pulumi.Input[_builtins.str]
        """
        Specifies the version of the firewall.
        When the charging_mode is **prePaid**: the value can be **Standard** and **Prefessional**.
        When the charging_mode is **postPaid**: the value can be **Prefessional**.
        Changing this parameter will create a new resource.
        """
        bandwidth: NotRequired[pulumi.Input[_builtins.int]]
        """
        The bandwidth of the firewall.
        """
        default_bandwidth: NotRequired[pulumi.Input[_builtins.int]]
        """
        The default bandwidth of the firewall.
        """
        default_eip_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The default EIP number of the firewall.
        """
        default_log_storage: NotRequired[pulumi.Input[_builtins.int]]
        """
        The default log storage of the firewall.
        """
        default_vpc_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The default VPC number of the firewall.
        """
        eip_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The EIP number of the firewall.
        """
        extend_bandwidth: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the extend bandwidth of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        extend_eip_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the extend EIP number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        extend_vpc_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the extend VPC number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        log_storage: NotRequired[pulumi.Input[_builtins.int]]
        """
        The log storage of the firewall.
        """
        total_rule_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The total rule count of the firewall.
        """
        used_rule_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The used rule count of the firewall.
        """
        vpc_bandwidth: NotRequired[pulumi.Input[_builtins.int]]
        """
        The VPC bandwidth of the firewall.
        """
        vpc_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The VPC number of the firewall.
        """
elif False:
    FirewallFlavorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FirewallFlavorArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 default_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 default_eip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 default_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 default_vpc_count: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 extend_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 extend_eip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 extend_vpc_count: Optional[pulumi.Input[_builtins.int]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 total_rule_count: Optional[pulumi.Input[_builtins.int]] = None,
                 used_rule_count: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] version: Specifies the version of the firewall.
               When the charging_mode is **prePaid**: the value can be **Standard** and **Prefessional**.
               When the charging_mode is **postPaid**: the value can be **Prefessional**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the firewall.
        :param pulumi.Input[_builtins.int] default_bandwidth: The default bandwidth of the firewall.
        :param pulumi.Input[_builtins.int] default_eip_count: The default EIP number of the firewall.
        :param pulumi.Input[_builtins.int] default_log_storage: The default log storage of the firewall.
        :param pulumi.Input[_builtins.int] default_vpc_count: The default VPC number of the firewall.
        :param pulumi.Input[_builtins.int] eip_count: The EIP number of the firewall.
        :param pulumi.Input[_builtins.int] extend_bandwidth: Specifies the extend bandwidth of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] extend_eip_count: Specifies the extend EIP number of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] extend_vpc_count: Specifies the extend VPC number of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] log_storage: The log storage of the firewall.
        :param pulumi.Input[_builtins.int] total_rule_count: The total rule count of the firewall.
        :param pulumi.Input[_builtins.int] used_rule_count: The used rule count of the firewall.
        :param pulumi.Input[_builtins.int] vpc_bandwidth: The VPC bandwidth of the firewall.
        :param pulumi.Input[_builtins.int] vpc_count: The VPC number of the firewall.
        """
        pulumi.set(__self__, "version", version)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if default_bandwidth is not None:
            pulumi.set(__self__, "default_bandwidth", default_bandwidth)
        if default_eip_count is not None:
            pulumi.set(__self__, "default_eip_count", default_eip_count)
        if default_log_storage is not None:
            pulumi.set(__self__, "default_log_storage", default_log_storage)
        if default_vpc_count is not None:
            pulumi.set(__self__, "default_vpc_count", default_vpc_count)
        if eip_count is not None:
            pulumi.set(__self__, "eip_count", eip_count)
        if extend_bandwidth is not None:
            pulumi.set(__self__, "extend_bandwidth", extend_bandwidth)
        if extend_eip_count is not None:
            pulumi.set(__self__, "extend_eip_count", extend_eip_count)
        if extend_vpc_count is not None:
            pulumi.set(__self__, "extend_vpc_count", extend_vpc_count)
        if log_storage is not None:
            pulumi.set(__self__, "log_storage", log_storage)
        if total_rule_count is not None:
            pulumi.set(__self__, "total_rule_count", total_rule_count)
        if used_rule_count is not None:
            pulumi.set(__self__, "used_rule_count", used_rule_count)
        if vpc_bandwidth is not None:
            pulumi.set(__self__, "vpc_bandwidth", vpc_bandwidth)
        if vpc_count is not None:
            pulumi.set(__self__, "vpc_count", vpc_count)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the firewall.
        When the charging_mode is **prePaid**: the value can be **Standard** and **Prefessional**.
        When the charging_mode is **postPaid**: the value can be **Prefessional**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the firewall.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="defaultBandwidth")
    def default_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default bandwidth of the firewall.
        """
        return pulumi.get(self, "default_bandwidth")

    @default_bandwidth.setter
    def default_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="defaultEipCount")
    def default_eip_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default EIP number of the firewall.
        """
        return pulumi.get(self, "default_eip_count")

    @default_eip_count.setter
    def default_eip_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_eip_count", value)

    @_builtins.property
    @pulumi.getter(name="defaultLogStorage")
    def default_log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default log storage of the firewall.
        """
        return pulumi.get(self, "default_log_storage")

    @default_log_storage.setter
    def default_log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_log_storage", value)

    @_builtins.property
    @pulumi.getter(name="defaultVpcCount")
    def default_vpc_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default VPC number of the firewall.
        """
        return pulumi.get(self, "default_vpc_count")

    @default_vpc_count.setter
    def default_vpc_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_vpc_count", value)

    @_builtins.property
    @pulumi.getter(name="eipCount")
    def eip_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The EIP number of the firewall.
        """
        return pulumi.get(self, "eip_count")

    @eip_count.setter
    def eip_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_count", value)

    @_builtins.property
    @pulumi.getter(name="extendBandwidth")
    def extend_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the extend bandwidth of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_bandwidth")

    @extend_bandwidth.setter
    def extend_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extend_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="extendEipCount")
    def extend_eip_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the extend EIP number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_eip_count")

    @extend_eip_count.setter
    def extend_eip_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extend_eip_count", value)

    @_builtins.property
    @pulumi.getter(name="extendVpcCount")
    def extend_vpc_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the extend VPC number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_vpc_count")

    @extend_vpc_count.setter
    def extend_vpc_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extend_vpc_count", value)

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The log storage of the firewall.
        """
        return pulumi.get(self, "log_storage")

    @log_storage.setter
    def log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_storage", value)

    @_builtins.property
    @pulumi.getter(name="totalRuleCount")
    def total_rule_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total rule count of the firewall.
        """
        return pulumi.get(self, "total_rule_count")

    @total_rule_count.setter
    def total_rule_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_rule_count", value)

    @_builtins.property
    @pulumi.getter(name="usedRuleCount")
    def used_rule_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The used rule count of the firewall.
        """
        return pulumi.get(self, "used_rule_count")

    @used_rule_count.setter
    def used_rule_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_rule_count", value)

    @_builtins.property
    @pulumi.getter(name="vpcBandwidth")
    def vpc_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VPC bandwidth of the firewall.
        """
        return pulumi.get(self, "vpc_bandwidth")

    @vpc_bandwidth.setter
    def vpc_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="vpcCount")
    def vpc_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VPC number of the firewall.
        """
        return pulumi.get(self, "vpc_count")

    @vpc_count.setter
    def vpc_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_count", value)


if not MYPY:
    class FirewallProtectObjectArgsDict(TypedDict):
        object_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protected object ID.
        """
        object_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protected object name.
        """
        type: NotRequired[pulumi.Input[_builtins.int]]
        """
        The object type.
        The options are as follows: 0: north-south; 1: east-west.
        """
elif False:
    FirewallProtectObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FirewallProtectObjectArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
        :param pulumi.Input[_builtins.str] object_name: The protected object name.
        :param pulumi.Input[_builtins.int] type: The object type.
               The options are as follows: 0: north-south; 1: east-west.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected object name.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The object type.
        The options are as follows: 0: north-south; 1: east-west.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "type", value)


