# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclRuleArgs', 'AclRule']

@pulumi.input_type
class AclRuleArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[_builtins.int],
                 address_type: pulumi.Input[_builtins.int],
                 long_connect_enable: pulumi.Input[_builtins.int],
                 object_id: pulumi.Input[_builtins.str],
                 sequence: pulumi.Input['AclRuleSequenceArgs'],
                 status: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.int],
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_service_groups: Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']] = None,
                 custom_services: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_domain_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 long_connect_time_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_second: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 predefined_service_groups: Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_hit_count: Optional[pulumi.Input[_builtins.str]] = None,
                 source_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_predefined_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AclRule resource.
        :param pulumi.Input[_builtins.int] action_type: The action type.
               The value can be `0` (allow), `1` (deny).
        :param pulumi.Input[_builtins.int] address_type: The address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[_builtins.int] long_connect_enable: Whether to support persistent connections.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
        :param pulumi.Input['AclRuleSequenceArgs'] sequence: The sequence configuration.
               The sequence structure is documented below.
        :param pulumi.Input[_builtins.int] status: The rule status. The options are as follows:
               + **0**: disabled;
               + **1**: enabled;
        :param pulumi.Input[_builtins.int] type: The rule type.
               The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The application list.
               The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
               **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        :param pulumi.Input['AclRuleCustomServiceGroupsArgs'] custom_service_groups: The custom service group list.
               The custom_service_groups structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]] custom_services: The custom service configuration.
               The custom_services structure is documented below.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_address_groups: The destination address group list.
        :param pulumi.Input[_builtins.int] destination_address_type: The destination address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_addresses: The destination IP address list.
        :param pulumi.Input[_builtins.str] destination_domain_address_name: The destination domain address name.
        :param pulumi.Input[_builtins.str] destination_domain_group_id: The destination domain group ID.
        :param pulumi.Input[_builtins.str] destination_domain_group_name: The destination domain group name.
        :param pulumi.Input[_builtins.int] destination_domain_group_type: The destination domain group type.
               The options are as follows:
               + **4**: application domain name group;
               + **6**: network domain name group;
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]] destination_region_lists: The destination region list.
               The destination_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] direction: The rule direction. The options are as follows:
               + **0**: inbound;
               + **1**: outbound;
        :param pulumi.Input[_builtins.int] long_connect_time_hour: The persistent connection duration (hour).
        :param pulumi.Input[_builtins.int] long_connect_time_minute: The persistent connection duration (minute).
        :param pulumi.Input[_builtins.int] long_connect_time_second: The persistent Connection Duration (second).
        :param pulumi.Input[_builtins.str] name: The rule name.
        :param pulumi.Input['AclRulePredefinedServiceGroupsArgs'] predefined_service_groups: The predefined service group list.
               The predefined_service_groups structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_hit_count: The number of times the ACL rule is hit.
               Setting the value to **0** will clear the hit count. Value options: **0**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_address_groups: The source address group list.
        :param pulumi.Input[_builtins.int] source_address_type: The source address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_addresses: The source IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_predefined_groups: The source predefined address group list.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]] source_region_lists: The source region list.
               The source_region_list structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the ACL rule.
               
               <a name="Sequence"></a>
               The `sequence` block supports:
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "long_connect_enable", long_connect_enable)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "sequence", sequence)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if custom_service_groups is not None:
            pulumi.set(__self__, "custom_service_groups", custom_service_groups)
        if custom_services is not None:
            pulumi.set(__self__, "custom_services", custom_services)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_groups is not None:
            pulumi.set(__self__, "destination_address_groups", destination_address_groups)
        if destination_address_type is not None:
            pulumi.set(__self__, "destination_address_type", destination_address_type)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_domain_address_name is not None:
            pulumi.set(__self__, "destination_domain_address_name", destination_domain_address_name)
        if destination_domain_group_id is not None:
            pulumi.set(__self__, "destination_domain_group_id", destination_domain_group_id)
        if destination_domain_group_name is not None:
            pulumi.set(__self__, "destination_domain_group_name", destination_domain_group_name)
        if destination_domain_group_type is not None:
            pulumi.set(__self__, "destination_domain_group_type", destination_domain_group_type)
        if destination_region_lists is not None:
            pulumi.set(__self__, "destination_region_lists", destination_region_lists)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if long_connect_time_hour is not None:
            pulumi.set(__self__, "long_connect_time_hour", long_connect_time_hour)
        if long_connect_time_minute is not None:
            pulumi.set(__self__, "long_connect_time_minute", long_connect_time_minute)
        if long_connect_time_second is not None:
            pulumi.set(__self__, "long_connect_time_second", long_connect_time_second)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if predefined_service_groups is not None:
            pulumi.set(__self__, "predefined_service_groups", predefined_service_groups)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_hit_count is not None:
            pulumi.set(__self__, "rule_hit_count", rule_hit_count)
        if source_address_groups is not None:
            pulumi.set(__self__, "source_address_groups", source_address_groups)
        if source_address_type is not None:
            pulumi.set(__self__, "source_address_type", source_address_type)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_predefined_groups is not None:
            pulumi.set(__self__, "source_predefined_groups", source_predefined_groups)
        if source_region_lists is not None:
            pulumi.set(__self__, "source_region_lists", source_region_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[_builtins.int]:
        """
        The action type.
        The value can be `0` (allow), `1` (deny).
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "action_type", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.int]:
        """
        The address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="longConnectEnable")
    def long_connect_enable(self) -> pulumi.Input[_builtins.int]:
        """
        Whether to support persistent connections.
        """
        return pulumi.get(self, "long_connect_enable")

    @long_connect_enable.setter
    def long_connect_enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "long_connect_enable", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> pulumi.Input['AclRuleSequenceArgs']:
        """
        The sequence configuration.
        The sequence structure is documented below.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: pulumi.Input['AclRuleSequenceArgs']):
        pulumi.set(self, "sequence", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.int]:
        """
        The rule status. The options are as follows:
        + **0**: disabled;
        + **1**: enabled;
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.int]:
        """
        The rule type.
        The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The application list.
        The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
        **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="customServiceGroups")
    def custom_service_groups(self) -> Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']]:
        """
        The custom service group list.
        The custom_service_groups structure is documented below.
        """
        return pulumi.get(self, "custom_service_groups")

    @custom_service_groups.setter
    def custom_service_groups(self, value: Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']]):
        pulumi.set(self, "custom_service_groups", value)

    @_builtins.property
    @pulumi.getter(name="customServices")
    def custom_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]]:
        """
        The custom service configuration.
        The custom_services structure is documented below.
        """
        return pulumi.get(self, "custom_services")

    @custom_services.setter
    def custom_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]]):
        pulumi.set(self, "custom_services", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddressGroups")
    def destination_address_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination address group list.
        """
        return pulumi.get(self, "destination_address_groups")

    @destination_address_groups.setter
    def destination_address_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_address_groups", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddressType")
    def destination_address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The destination address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "destination_address_type")

    @destination_address_type.setter
    def destination_address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "destination_address_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination IP address list.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainAddressName")
    def destination_domain_address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain address name.
        """
        return pulumi.get(self, "destination_domain_address_name")

    @destination_domain_address_name.setter
    def destination_domain_address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_address_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupId")
    def destination_domain_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain group ID.
        """
        return pulumi.get(self, "destination_domain_group_id")

    @destination_domain_group_id.setter
    def destination_domain_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_group_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupName")
    def destination_domain_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain group name.
        """
        return pulumi.get(self, "destination_domain_group_name")

    @destination_domain_group_name.setter
    def destination_domain_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_group_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupType")
    def destination_domain_group_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The destination domain group type.
        The options are as follows:
        + **4**: application domain name group;
        + **6**: network domain name group;
        """
        return pulumi.get(self, "destination_domain_group_type")

    @destination_domain_group_type.setter
    def destination_domain_group_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "destination_domain_group_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionLists")
    def destination_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]]:
        """
        The destination region list.
        The destination_region_list structure is documented below.
        """
        return pulumi.get(self, "destination_region_lists")

    @destination_region_lists.setter
    def destination_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]]):
        pulumi.set(self, "destination_region_lists", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule direction. The options are as follows:
        + **0**: inbound;
        + **1**: outbound;
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeHour")
    def long_connect_time_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent connection duration (hour).
        """
        return pulumi.get(self, "long_connect_time_hour")

    @long_connect_time_hour.setter
    def long_connect_time_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_hour", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeMinute")
    def long_connect_time_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent connection duration (minute).
        """
        return pulumi.get(self, "long_connect_time_minute")

    @long_connect_time_minute.setter
    def long_connect_time_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_minute", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeSecond")
    def long_connect_time_second(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent Connection Duration (second).
        """
        return pulumi.get(self, "long_connect_time_second")

    @long_connect_time_second.setter
    def long_connect_time_second(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_second", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="predefinedServiceGroups")
    def predefined_service_groups(self) -> Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']]:
        """
        The predefined service group list.
        The predefined_service_groups structure is documented below.
        """
        return pulumi.get(self, "predefined_service_groups")

    @predefined_service_groups.setter
    def predefined_service_groups(self, value: Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']]):
        pulumi.set(self, "predefined_service_groups", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleHitCount")
    def rule_hit_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of times the ACL rule is hit.
        Setting the value to **0** will clear the hit count. Value options: **0**.
        """
        return pulumi.get(self, "rule_hit_count")

    @rule_hit_count.setter
    def rule_hit_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_hit_count", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddressGroups")
    def source_address_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source address group list.
        """
        return pulumi.get(self, "source_address_groups")

    @source_address_groups.setter
    def source_address_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_address_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddressType")
    def source_address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The source address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "source_address_type")

    @source_address_type.setter
    def source_address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_address_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source IP address list.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)

    @_builtins.property
    @pulumi.getter(name="sourcePredefinedGroups")
    def source_predefined_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source predefined address group list.
        """
        return pulumi.get(self, "source_predefined_groups")

    @source_predefined_groups.setter
    def source_predefined_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_predefined_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegionLists")
    def source_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]]:
        """
        The source region list.
        The source_region_list structure is documented below.
        """
        return pulumi.get(self, "source_region_lists")

    @source_region_lists.setter
    def source_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]]):
        pulumi.set(self, "source_region_lists", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the ACL rule.

        <a name="Sequence"></a>
        The `sequence` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AclRuleState:
    def __init__(__self__, *,
                 action_type: Optional[pulumi.Input[_builtins.int]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_service_groups: Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']] = None,
                 custom_services: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_domain_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 long_connect_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_second: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 predefined_service_groups: Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_hit_count: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input['AclRuleSequenceArgs']] = None,
                 source_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_predefined_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AclRule resources.
        :param pulumi.Input[_builtins.int] action_type: The action type.
               The value can be `0` (allow), `1` (deny).
        :param pulumi.Input[_builtins.int] address_type: The address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The application list.
               The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
               **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        :param pulumi.Input['AclRuleCustomServiceGroupsArgs'] custom_service_groups: The custom service group list.
               The custom_service_groups structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]] custom_services: The custom service configuration.
               The custom_services structure is documented below.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_address_groups: The destination address group list.
        :param pulumi.Input[_builtins.int] destination_address_type: The destination address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_addresses: The destination IP address list.
        :param pulumi.Input[_builtins.str] destination_domain_address_name: The destination domain address name.
        :param pulumi.Input[_builtins.str] destination_domain_group_id: The destination domain group ID.
        :param pulumi.Input[_builtins.str] destination_domain_group_name: The destination domain group name.
        :param pulumi.Input[_builtins.int] destination_domain_group_type: The destination domain group type.
               The options are as follows:
               + **4**: application domain name group;
               + **6**: network domain name group;
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]] destination_region_lists: The destination region list.
               The destination_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] direction: The rule direction. The options are as follows:
               + **0**: inbound;
               + **1**: outbound;
        :param pulumi.Input[_builtins.int] long_connect_enable: Whether to support persistent connections.
        :param pulumi.Input[_builtins.int] long_connect_time_hour: The persistent connection duration (hour).
        :param pulumi.Input[_builtins.int] long_connect_time_minute: The persistent connection duration (minute).
        :param pulumi.Input[_builtins.int] long_connect_time_second: The persistent Connection Duration (second).
        :param pulumi.Input[_builtins.str] name: The rule name.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
        :param pulumi.Input['AclRulePredefinedServiceGroupsArgs'] predefined_service_groups: The predefined service group list.
               The predefined_service_groups structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_hit_count: The number of times the ACL rule is hit.
               Setting the value to **0** will clear the hit count. Value options: **0**.
        :param pulumi.Input['AclRuleSequenceArgs'] sequence: The sequence configuration.
               The sequence structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_address_groups: The source address group list.
        :param pulumi.Input[_builtins.int] source_address_type: The source address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_addresses: The source IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_predefined_groups: The source predefined address group list.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]] source_region_lists: The source region list.
               The source_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] status: The rule status. The options are as follows:
               + **0**: disabled;
               + **1**: enabled;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the ACL rule.
               
               <a name="Sequence"></a>
               The `sequence` block supports:
        :param pulumi.Input[_builtins.int] type: The rule type.
               The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if custom_service_groups is not None:
            pulumi.set(__self__, "custom_service_groups", custom_service_groups)
        if custom_services is not None:
            pulumi.set(__self__, "custom_services", custom_services)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_groups is not None:
            pulumi.set(__self__, "destination_address_groups", destination_address_groups)
        if destination_address_type is not None:
            pulumi.set(__self__, "destination_address_type", destination_address_type)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_domain_address_name is not None:
            pulumi.set(__self__, "destination_domain_address_name", destination_domain_address_name)
        if destination_domain_group_id is not None:
            pulumi.set(__self__, "destination_domain_group_id", destination_domain_group_id)
        if destination_domain_group_name is not None:
            pulumi.set(__self__, "destination_domain_group_name", destination_domain_group_name)
        if destination_domain_group_type is not None:
            pulumi.set(__self__, "destination_domain_group_type", destination_domain_group_type)
        if destination_region_lists is not None:
            pulumi.set(__self__, "destination_region_lists", destination_region_lists)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if long_connect_enable is not None:
            pulumi.set(__self__, "long_connect_enable", long_connect_enable)
        if long_connect_time_hour is not None:
            pulumi.set(__self__, "long_connect_time_hour", long_connect_time_hour)
        if long_connect_time_minute is not None:
            pulumi.set(__self__, "long_connect_time_minute", long_connect_time_minute)
        if long_connect_time_second is not None:
            pulumi.set(__self__, "long_connect_time_second", long_connect_time_second)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if predefined_service_groups is not None:
            pulumi.set(__self__, "predefined_service_groups", predefined_service_groups)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_hit_count is not None:
            pulumi.set(__self__, "rule_hit_count", rule_hit_count)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)
        if source_address_groups is not None:
            pulumi.set(__self__, "source_address_groups", source_address_groups)
        if source_address_type is not None:
            pulumi.set(__self__, "source_address_type", source_address_type)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_predefined_groups is not None:
            pulumi.set(__self__, "source_predefined_groups", source_predefined_groups)
        if source_region_lists is not None:
            pulumi.set(__self__, "source_region_lists", source_region_lists)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The action type.
        The value can be `0` (allow), `1` (deny).
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "action_type", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The application list.
        The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
        **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="customServiceGroups")
    def custom_service_groups(self) -> Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']]:
        """
        The custom service group list.
        The custom_service_groups structure is documented below.
        """
        return pulumi.get(self, "custom_service_groups")

    @custom_service_groups.setter
    def custom_service_groups(self, value: Optional[pulumi.Input['AclRuleCustomServiceGroupsArgs']]):
        pulumi.set(self, "custom_service_groups", value)

    @_builtins.property
    @pulumi.getter(name="customServices")
    def custom_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]]:
        """
        The custom service configuration.
        The custom_services structure is documented below.
        """
        return pulumi.get(self, "custom_services")

    @custom_services.setter
    def custom_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleCustomServiceArgs']]]]):
        pulumi.set(self, "custom_services", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddressGroups")
    def destination_address_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination address group list.
        """
        return pulumi.get(self, "destination_address_groups")

    @destination_address_groups.setter
    def destination_address_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_address_groups", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddressType")
    def destination_address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The destination address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "destination_address_type")

    @destination_address_type.setter
    def destination_address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "destination_address_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination IP address list.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainAddressName")
    def destination_domain_address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain address name.
        """
        return pulumi.get(self, "destination_domain_address_name")

    @destination_domain_address_name.setter
    def destination_domain_address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_address_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupId")
    def destination_domain_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain group ID.
        """
        return pulumi.get(self, "destination_domain_group_id")

    @destination_domain_group_id.setter
    def destination_domain_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_group_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupName")
    def destination_domain_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination domain group name.
        """
        return pulumi.get(self, "destination_domain_group_name")

    @destination_domain_group_name.setter
    def destination_domain_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_domain_group_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupType")
    def destination_domain_group_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The destination domain group type.
        The options are as follows:
        + **4**: application domain name group;
        + **6**: network domain name group;
        """
        return pulumi.get(self, "destination_domain_group_type")

    @destination_domain_group_type.setter
    def destination_domain_group_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "destination_domain_group_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionLists")
    def destination_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]]:
        """
        The destination region list.
        The destination_region_list structure is documented below.
        """
        return pulumi.get(self, "destination_region_lists")

    @destination_region_lists.setter
    def destination_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleDestinationRegionListArgs']]]]):
        pulumi.set(self, "destination_region_lists", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule direction. The options are as follows:
        + **0**: inbound;
        + **1**: outbound;
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="longConnectEnable")
    def long_connect_enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whether to support persistent connections.
        """
        return pulumi.get(self, "long_connect_enable")

    @long_connect_enable.setter
    def long_connect_enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_enable", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeHour")
    def long_connect_time_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent connection duration (hour).
        """
        return pulumi.get(self, "long_connect_time_hour")

    @long_connect_time_hour.setter
    def long_connect_time_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_hour", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeMinute")
    def long_connect_time_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent connection duration (minute).
        """
        return pulumi.get(self, "long_connect_time_minute")

    @long_connect_time_minute.setter
    def long_connect_time_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_minute", value)

    @_builtins.property
    @pulumi.getter(name="longConnectTimeSecond")
    def long_connect_time_second(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The persistent Connection Duration (second).
        """
        return pulumi.get(self, "long_connect_time_second")

    @long_connect_time_second.setter
    def long_connect_time_second(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "long_connect_time_second", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="predefinedServiceGroups")
    def predefined_service_groups(self) -> Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']]:
        """
        The predefined service group list.
        The predefined_service_groups structure is documented below.
        """
        return pulumi.get(self, "predefined_service_groups")

    @predefined_service_groups.setter
    def predefined_service_groups(self, value: Optional[pulumi.Input['AclRulePredefinedServiceGroupsArgs']]):
        pulumi.set(self, "predefined_service_groups", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleHitCount")
    def rule_hit_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of times the ACL rule is hit.
        Setting the value to **0** will clear the hit count. Value options: **0**.
        """
        return pulumi.get(self, "rule_hit_count")

    @rule_hit_count.setter
    def rule_hit_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_hit_count", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[pulumi.Input['AclRuleSequenceArgs']]:
        """
        The sequence configuration.
        The sequence structure is documented below.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: Optional[pulumi.Input['AclRuleSequenceArgs']]):
        pulumi.set(self, "sequence", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddressGroups")
    def source_address_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source address group list.
        """
        return pulumi.get(self, "source_address_groups")

    @source_address_groups.setter
    def source_address_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_address_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddressType")
    def source_address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The source address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "source_address_type")

    @source_address_type.setter
    def source_address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "source_address_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source IP address list.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_addresses", value)

    @_builtins.property
    @pulumi.getter(name="sourcePredefinedGroups")
    def source_predefined_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source predefined address group list.
        """
        return pulumi.get(self, "source_predefined_groups")

    @source_predefined_groups.setter
    def source_predefined_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_predefined_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceRegionLists")
    def source_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]]:
        """
        The source region list.
        The source_region_list structure is documented below.
        """
        return pulumi.get(self, "source_region_lists")

    @source_region_lists.setter
    def source_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleSourceRegionListArgs']]]]):
        pulumi.set(self, "source_region_lists", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule status. The options are as follows:
        + **0**: disabled;
        + **1**: enabled;
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the ACL rule.

        <a name="Sequence"></a>
        The `sequence` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule type.
        The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Cfw/aclRule:AclRule")
class AclRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[_builtins.int]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_service_groups: Optional[pulumi.Input[Union['AclRuleCustomServiceGroupsArgs', 'AclRuleCustomServiceGroupsArgsDict']]] = None,
                 custom_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleCustomServiceArgs', 'AclRuleCustomServiceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_domain_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleDestinationRegionListArgs', 'AclRuleDestinationRegionListArgsDict']]]]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 long_connect_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_second: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 predefined_service_groups: Optional[pulumi.Input[Union['AclRulePredefinedServiceGroupsArgs', 'AclRulePredefinedServiceGroupsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_hit_count: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[Union['AclRuleSequenceArgs', 'AclRuleSequenceArgsDict']]] = None,
                 source_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_predefined_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleSourceRegionListArgs', 'AclRuleSourceRegionListArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a CFW ACL rule resource within SberCloud.

        ## Example Usage

        ### Create a basic rule

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with the source address using the region list

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_region_lists=[{
                "description_cn": "中国",
                "description_en": "Chinese Mainland",
                "region_id": "CN",
                "region_type": 0,
            }],
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with the custom service groups

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            custom_service_groups={
                "protocols": [protocol],
                "group_ids": [service_group_id],
            },
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with any service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with any source address

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ## Import

        The ACL rule can be imported using `object_id`, `id`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/aclRule:AclRule test <object_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `sequence`, `type`, `predefined_service_groups` and `source_predefined_groups`.

        It is generally recommended running `pulumi preview` after importing the resource.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cfw_acl_rule" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              sequence, type, predefined_service_groups, source_predefined_groups,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] action_type: The action type.
               The value can be `0` (allow), `1` (deny).
        :param pulumi.Input[_builtins.int] address_type: The address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The application list.
               The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
               **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        :param pulumi.Input[Union['AclRuleCustomServiceGroupsArgs', 'AclRuleCustomServiceGroupsArgsDict']] custom_service_groups: The custom service group list.
               The custom_service_groups structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleCustomServiceArgs', 'AclRuleCustomServiceArgsDict']]]] custom_services: The custom service configuration.
               The custom_services structure is documented below.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_address_groups: The destination address group list.
        :param pulumi.Input[_builtins.int] destination_address_type: The destination address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_addresses: The destination IP address list.
        :param pulumi.Input[_builtins.str] destination_domain_address_name: The destination domain address name.
        :param pulumi.Input[_builtins.str] destination_domain_group_id: The destination domain group ID.
        :param pulumi.Input[_builtins.str] destination_domain_group_name: The destination domain group name.
        :param pulumi.Input[_builtins.int] destination_domain_group_type: The destination domain group type.
               The options are as follows:
               + **4**: application domain name group;
               + **6**: network domain name group;
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleDestinationRegionListArgs', 'AclRuleDestinationRegionListArgsDict']]]] destination_region_lists: The destination region list.
               The destination_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] direction: The rule direction. The options are as follows:
               + **0**: inbound;
               + **1**: outbound;
        :param pulumi.Input[_builtins.int] long_connect_enable: Whether to support persistent connections.
        :param pulumi.Input[_builtins.int] long_connect_time_hour: The persistent connection duration (hour).
        :param pulumi.Input[_builtins.int] long_connect_time_minute: The persistent connection duration (minute).
        :param pulumi.Input[_builtins.int] long_connect_time_second: The persistent Connection Duration (second).
        :param pulumi.Input[_builtins.str] name: The rule name.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
        :param pulumi.Input[Union['AclRulePredefinedServiceGroupsArgs', 'AclRulePredefinedServiceGroupsArgsDict']] predefined_service_groups: The predefined service group list.
               The predefined_service_groups structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_hit_count: The number of times the ACL rule is hit.
               Setting the value to **0** will clear the hit count. Value options: **0**.
        :param pulumi.Input[Union['AclRuleSequenceArgs', 'AclRuleSequenceArgsDict']] sequence: The sequence configuration.
               The sequence structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_address_groups: The source address group list.
        :param pulumi.Input[_builtins.int] source_address_type: The source address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_addresses: The source IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_predefined_groups: The source predefined address group list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleSourceRegionListArgs', 'AclRuleSourceRegionListArgsDict']]]] source_region_lists: The source region list.
               The source_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] status: The rule status. The options are as follows:
               + **0**: disabled;
               + **1**: enabled;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the ACL rule.
               
               <a name="Sequence"></a>
               The `sequence` block supports:
        :param pulumi.Input[_builtins.int] type: The rule type.
               The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW ACL rule resource within SberCloud.

        ## Example Usage

        ### Create a basic rule

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with the source address using the region list

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_region_lists=[{
                "description_cn": "中国",
                "description_en": "Chinese Mainland",
                "region_id": "CN",
                "region_type": 0,
            }],
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with the custom service groups

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            custom_service_groups={
                "protocols": [protocol],
                "group_ids": [service_group_id],
            },
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with any service

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            source_addresses=["1.1.1.1"],
            destination_addresses=["1.1.1.2"],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ### Create a rule with any source address

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        description = config.require_object("description")
        object_id = config.require_object("objectId")
        service_group_id = config.require_object("serviceGroupId")
        protocol = config.require_object("protocol")
        test = sbercloud.cfw.AclRule("test",
            name=name,
            object_id=object_id,
            description=description,
            type=0,
            address_type=0,
            action_type=0,
            long_connect_enable=0,
            status=1,
            destination_addresses=["1.1.1.2"],
            custom_services=[{
                "protocol": 6,
                "source_port": "81",
                "dest_port": "82",
            }],
            sequence={
                "top": 1,
            },
            tags={
                "key": "value",
            })
        ```

        ## Import

        The ACL rule can be imported using `object_id`, `id`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/aclRule:AclRule test <object_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `sequence`, `type`, `predefined_service_groups` and `source_predefined_groups`.

        It is generally recommended running `pulumi preview` after importing the resource.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cfw_acl_rule" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              sequence, type, predefined_service_groups, source_predefined_groups,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param AclRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[_builtins.int]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_service_groups: Optional[pulumi.Input[Union['AclRuleCustomServiceGroupsArgs', 'AclRuleCustomServiceGroupsArgsDict']]] = None,
                 custom_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleCustomServiceArgs', 'AclRuleCustomServiceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_domain_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_domain_group_type: Optional[pulumi.Input[_builtins.int]] = None,
                 destination_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleDestinationRegionListArgs', 'AclRuleDestinationRegionListArgsDict']]]]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 long_connect_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 long_connect_time_second: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 predefined_service_groups: Optional[pulumi.Input[Union['AclRulePredefinedServiceGroupsArgs', 'AclRulePredefinedServiceGroupsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_hit_count: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[Union['AclRuleSequenceArgs', 'AclRuleSequenceArgsDict']]] = None,
                 source_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_predefined_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleSourceRegionListArgs', 'AclRuleSourceRegionListArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclRuleArgs.__new__(AclRuleArgs)

            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            if address_type is None and not opts.urn:
                raise TypeError("Missing required property 'address_type'")
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["applications"] = applications
            __props__.__dict__["custom_service_groups"] = custom_service_groups
            __props__.__dict__["custom_services"] = custom_services
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_address_groups"] = destination_address_groups
            __props__.__dict__["destination_address_type"] = destination_address_type
            __props__.__dict__["destination_addresses"] = destination_addresses
            __props__.__dict__["destination_domain_address_name"] = destination_domain_address_name
            __props__.__dict__["destination_domain_group_id"] = destination_domain_group_id
            __props__.__dict__["destination_domain_group_name"] = destination_domain_group_name
            __props__.__dict__["destination_domain_group_type"] = destination_domain_group_type
            __props__.__dict__["destination_region_lists"] = destination_region_lists
            __props__.__dict__["direction"] = direction
            __props__.__dict__["enable_force_new"] = enable_force_new
            if long_connect_enable is None and not opts.urn:
                raise TypeError("Missing required property 'long_connect_enable'")
            __props__.__dict__["long_connect_enable"] = long_connect_enable
            __props__.__dict__["long_connect_time_hour"] = long_connect_time_hour
            __props__.__dict__["long_connect_time_minute"] = long_connect_time_minute
            __props__.__dict__["long_connect_time_second"] = long_connect_time_second
            __props__.__dict__["name"] = name
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["predefined_service_groups"] = predefined_service_groups
            __props__.__dict__["region"] = region
            __props__.__dict__["rule_hit_count"] = rule_hit_count
            if sequence is None and not opts.urn:
                raise TypeError("Missing required property 'sequence'")
            __props__.__dict__["sequence"] = sequence
            __props__.__dict__["source_address_groups"] = source_address_groups
            __props__.__dict__["source_address_type"] = source_address_type
            __props__.__dict__["source_addresses"] = source_addresses
            __props__.__dict__["source_predefined_groups"] = source_predefined_groups
            __props__.__dict__["source_region_lists"] = source_region_lists
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(AclRule, __self__).__init__(
            'sbercloud:Cfw/aclRule:AclRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_type: Optional[pulumi.Input[_builtins.int]] = None,
            address_type: Optional[pulumi.Input[_builtins.int]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            custom_service_groups: Optional[pulumi.Input[Union['AclRuleCustomServiceGroupsArgs', 'AclRuleCustomServiceGroupsArgsDict']]] = None,
            custom_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleCustomServiceArgs', 'AclRuleCustomServiceArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destination_address_type: Optional[pulumi.Input[_builtins.int]] = None,
            destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destination_domain_address_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_domain_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_domain_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_domain_group_type: Optional[pulumi.Input[_builtins.int]] = None,
            destination_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleDestinationRegionListArgs', 'AclRuleDestinationRegionListArgsDict']]]]] = None,
            direction: Optional[pulumi.Input[_builtins.int]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            long_connect_enable: Optional[pulumi.Input[_builtins.int]] = None,
            long_connect_time_hour: Optional[pulumi.Input[_builtins.int]] = None,
            long_connect_time_minute: Optional[pulumi.Input[_builtins.int]] = None,
            long_connect_time_second: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            predefined_service_groups: Optional[pulumi.Input[Union['AclRulePredefinedServiceGroupsArgs', 'AclRulePredefinedServiceGroupsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rule_hit_count: Optional[pulumi.Input[_builtins.str]] = None,
            sequence: Optional[pulumi.Input[Union['AclRuleSequenceArgs', 'AclRuleSequenceArgsDict']]] = None,
            source_address_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_address_type: Optional[pulumi.Input[_builtins.int]] = None,
            source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_predefined_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleSourceRegionListArgs', 'AclRuleSourceRegionListArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.int]] = None) -> 'AclRule':
        """
        Get an existing AclRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] action_type: The action type.
               The value can be `0` (allow), `1` (deny).
        :param pulumi.Input[_builtins.int] address_type: The address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The application list.
               The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
               **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        :param pulumi.Input[Union['AclRuleCustomServiceGroupsArgs', 'AclRuleCustomServiceGroupsArgsDict']] custom_service_groups: The custom service group list.
               The custom_service_groups structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleCustomServiceArgs', 'AclRuleCustomServiceArgsDict']]]] custom_services: The custom service configuration.
               The custom_services structure is documented below.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_address_groups: The destination address group list.
        :param pulumi.Input[_builtins.int] destination_address_type: The destination address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_addresses: The destination IP address list.
        :param pulumi.Input[_builtins.str] destination_domain_address_name: The destination domain address name.
        :param pulumi.Input[_builtins.str] destination_domain_group_id: The destination domain group ID.
        :param pulumi.Input[_builtins.str] destination_domain_group_name: The destination domain group name.
        :param pulumi.Input[_builtins.int] destination_domain_group_type: The destination domain group type.
               The options are as follows:
               + **4**: application domain name group;
               + **6**: network domain name group;
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleDestinationRegionListArgs', 'AclRuleDestinationRegionListArgsDict']]]] destination_region_lists: The destination region list.
               The destination_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] direction: The rule direction. The options are as follows:
               + **0**: inbound;
               + **1**: outbound;
        :param pulumi.Input[_builtins.int] long_connect_enable: Whether to support persistent connections.
        :param pulumi.Input[_builtins.int] long_connect_time_hour: The persistent connection duration (hour).
        :param pulumi.Input[_builtins.int] long_connect_time_minute: The persistent connection duration (minute).
        :param pulumi.Input[_builtins.int] long_connect_time_second: The persistent Connection Duration (second).
        :param pulumi.Input[_builtins.str] name: The rule name.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
        :param pulumi.Input[Union['AclRulePredefinedServiceGroupsArgs', 'AclRulePredefinedServiceGroupsArgsDict']] predefined_service_groups: The predefined service group list.
               The predefined_service_groups structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_hit_count: The number of times the ACL rule is hit.
               Setting the value to **0** will clear the hit count. Value options: **0**.
        :param pulumi.Input[Union['AclRuleSequenceArgs', 'AclRuleSequenceArgsDict']] sequence: The sequence configuration.
               The sequence structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_address_groups: The source address group list.
        :param pulumi.Input[_builtins.int] source_address_type: The source address type.
               The value can be `0` (IPv4), `1` (IPv6).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_addresses: The source IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_predefined_groups: The source predefined address group list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleSourceRegionListArgs', 'AclRuleSourceRegionListArgsDict']]]] source_region_lists: The source region list.
               The source_region_list structure is documented below.
        :param pulumi.Input[_builtins.int] status: The rule status. The options are as follows:
               + **0**: disabled;
               + **1**: enabled;
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the ACL rule.
               
               <a name="Sequence"></a>
               The `sequence` block supports:
        :param pulumi.Input[_builtins.int] type: The rule type.
               The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclRuleState.__new__(_AclRuleState)

        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["applications"] = applications
        __props__.__dict__["custom_service_groups"] = custom_service_groups
        __props__.__dict__["custom_services"] = custom_services
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_address_groups"] = destination_address_groups
        __props__.__dict__["destination_address_type"] = destination_address_type
        __props__.__dict__["destination_addresses"] = destination_addresses
        __props__.__dict__["destination_domain_address_name"] = destination_domain_address_name
        __props__.__dict__["destination_domain_group_id"] = destination_domain_group_id
        __props__.__dict__["destination_domain_group_name"] = destination_domain_group_name
        __props__.__dict__["destination_domain_group_type"] = destination_domain_group_type
        __props__.__dict__["destination_region_lists"] = destination_region_lists
        __props__.__dict__["direction"] = direction
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["long_connect_enable"] = long_connect_enable
        __props__.__dict__["long_connect_time_hour"] = long_connect_time_hour
        __props__.__dict__["long_connect_time_minute"] = long_connect_time_minute
        __props__.__dict__["long_connect_time_second"] = long_connect_time_second
        __props__.__dict__["name"] = name
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["predefined_service_groups"] = predefined_service_groups
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_hit_count"] = rule_hit_count
        __props__.__dict__["sequence"] = sequence
        __props__.__dict__["source_address_groups"] = source_address_groups
        __props__.__dict__["source_address_type"] = source_address_type
        __props__.__dict__["source_addresses"] = source_addresses
        __props__.__dict__["source_predefined_groups"] = source_predefined_groups
        __props__.__dict__["source_region_lists"] = source_region_lists
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return AclRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[_builtins.int]:
        """
        The action type.
        The value can be `0` (allow), `1` (deny).
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.int]:
        """
        The address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The application list.
        The valid value can be **HTTP**, **HTTPS**, **TLS1**, **DNS**, **SSH**, **MYSQL**, **SMTP**, **RDP**, **RDPS**,
        **VNC**, **POP3**, **IMAP4**, **SMTPS**, **POP3S**, **FTPS**, **ANY**, **BGP** and so on.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="customServiceGroups")
    def custom_service_groups(self) -> pulumi.Output[Optional['outputs.AclRuleCustomServiceGroups']]:
        """
        The custom service group list.
        The custom_service_groups structure is documented below.
        """
        return pulumi.get(self, "custom_service_groups")

    @_builtins.property
    @pulumi.getter(name="customServices")
    def custom_services(self) -> pulumi.Output[Optional[Sequence['outputs.AclRuleCustomService']]]:
        """
        The custom service configuration.
        The custom_services structure is documented below.
        """
        return pulumi.get(self, "custom_services")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationAddressGroups")
    def destination_address_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The destination address group list.
        """
        return pulumi.get(self, "destination_address_groups")

    @_builtins.property
    @pulumi.getter(name="destinationAddressType")
    def destination_address_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The destination address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "destination_address_type")

    @_builtins.property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The destination IP address list.
        """
        return pulumi.get(self, "destination_addresses")

    @_builtins.property
    @pulumi.getter(name="destinationDomainAddressName")
    def destination_domain_address_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination domain address name.
        """
        return pulumi.get(self, "destination_domain_address_name")

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupId")
    def destination_domain_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination domain group ID.
        """
        return pulumi.get(self, "destination_domain_group_id")

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupName")
    def destination_domain_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination domain group name.
        """
        return pulumi.get(self, "destination_domain_group_name")

    @_builtins.property
    @pulumi.getter(name="destinationDomainGroupType")
    def destination_domain_group_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The destination domain group type.
        The options are as follows:
        + **4**: application domain name group;
        + **6**: network domain name group;
        """
        return pulumi.get(self, "destination_domain_group_type")

    @_builtins.property
    @pulumi.getter(name="destinationRegionLists")
    def destination_region_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AclRuleDestinationRegionList']]]:
        """
        The destination region list.
        The destination_region_list structure is documented below.
        """
        return pulumi.get(self, "destination_region_lists")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.int]:
        """
        The rule direction. The options are as follows:
        + **0**: inbound;
        + **1**: outbound;
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="longConnectEnable")
    def long_connect_enable(self) -> pulumi.Output[_builtins.int]:
        """
        Whether to support persistent connections.
        """
        return pulumi.get(self, "long_connect_enable")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeHour")
    def long_connect_time_hour(self) -> pulumi.Output[_builtins.int]:
        """
        The persistent connection duration (hour).
        """
        return pulumi.get(self, "long_connect_time_hour")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeMinute")
    def long_connect_time_minute(self) -> pulumi.Output[_builtins.int]:
        """
        The persistent connection duration (minute).
        """
        return pulumi.get(self, "long_connect_time_minute")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeSecond")
    def long_connect_time_second(self) -> pulumi.Output[_builtins.int]:
        """
        The persistent Connection Duration (second).
        """
        return pulumi.get(self, "long_connect_time_second")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="predefinedServiceGroups")
    def predefined_service_groups(self) -> pulumi.Output[Optional['outputs.AclRulePredefinedServiceGroups']]:
        """
        The predefined service group list.
        The predefined_service_groups structure is documented below.
        """
        return pulumi.get(self, "predefined_service_groups")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleHitCount")
    def rule_hit_count(self) -> pulumi.Output[_builtins.str]:
        """
        The number of times the ACL rule is hit.
        Setting the value to **0** will clear the hit count. Value options: **0**.
        """
        return pulumi.get(self, "rule_hit_count")

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> pulumi.Output['outputs.AclRuleSequence']:
        """
        The sequence configuration.
        The sequence structure is documented below.
        """
        return pulumi.get(self, "sequence")

    @_builtins.property
    @pulumi.getter(name="sourceAddressGroups")
    def source_address_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source address group list.
        """
        return pulumi.get(self, "source_address_groups")

    @_builtins.property
    @pulumi.getter(name="sourceAddressType")
    def source_address_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The source address type.
        The value can be `0` (IPv4), `1` (IPv6).
        """
        return pulumi.get(self, "source_address_type")

    @_builtins.property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source IP address list.
        """
        return pulumi.get(self, "source_addresses")

    @_builtins.property
    @pulumi.getter(name="sourcePredefinedGroups")
    def source_predefined_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The source predefined address group list.
        """
        return pulumi.get(self, "source_predefined_groups")

    @_builtins.property
    @pulumi.getter(name="sourceRegionLists")
    def source_region_lists(self) -> pulumi.Output[Optional[Sequence['outputs.AclRuleSourceRegionList']]]:
        """
        The source region list.
        The source_region_list structure is documented below.
        """
        return pulumi.get(self, "source_region_lists")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The rule status. The options are as follows:
        + **0**: disabled;
        + **1**: enabled;
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the ACL rule.

        <a name="Sequence"></a>
        The `sequence` block supports:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.int]:
        """
        The rule type.
        The value can be `0` (Internet rule), `1` (VPC rule), or `2` (NAT rule).
        """
        return pulumi.get(self, "type")

