# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AddressGroupMemberArgs', 'AddressGroupMember']

@pulumi.input_type
class AddressGroupMemberArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AddressGroupMember resource.
        :param pulumi.Input[_builtins.str] address: Specifies the IP address.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the IP address group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The value can be **0** (IPv4) or **1** (IPv6).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies address description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: schema: Deprecated; Specifies the address name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "group_id", group_id)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IP address.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the IP address group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the address type.
        The value can be **0** (IPv4) or **1** (IPv6).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies address description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; Specifies the address name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AddressGroupMemberState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroupMember resources.
        :param pulumi.Input[_builtins.str] address: Specifies the IP address.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The value can be **0** (IPv4) or **1** (IPv6).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies address description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the IP address group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: schema: Deprecated; Specifies the address name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the address type.
        The value can be **0** (IPv4) or **1** (IPv6).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies address description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the IP address group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; Specifies the address name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Cfw/addressGroupMember:AddressGroupMember")
class AddressGroupMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW IP address group member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_id = config.require_object("groupId")
        address = config.require_object("address")
        test = sbercloud.cfw.AddressGroupMember("test",
            group_id=group_id,
            address=address)
        ```

        ## Import

        The CFW IP address group member can be imported using `group_id`, `id`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/addressGroupMember:AddressGroupMember test <group_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the IP address.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The value can be **0** (IPv4) or **1** (IPv6).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies address description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the IP address group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: schema: Deprecated; Specifies the address name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressGroupMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW IP address group member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_id = config.require_object("groupId")
        address = config.require_object("address")
        test = sbercloud.cfw.AddressGroupMember("test",
            group_id=group_id,
            address=address)
        ```

        ## Import

        The CFW IP address group member can be imported using `group_id`, `id`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/addressGroupMember:AddressGroupMember test <group_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupMemberArgs.__new__(AddressGroupMemberArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["description"] = description
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(AddressGroupMember, __self__).__init__(
            'sbercloud:Cfw/addressGroupMember:AddressGroupMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            address_type: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddressGroupMember':
        """
        Get an existing AddressGroupMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the IP address.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] address_type: Specifies the address type.
               The value can be **0** (IPv4) or **1** (IPv6).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies address description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the IP address group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: schema: Deprecated; Specifies the address name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupMemberState.__new__(_AddressGroupMemberState)

        __props__.__dict__["address"] = address
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return AddressGroupMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the address type.
        The value can be **0** (IPv4) or **1** (IPv6).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies address description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the IP address group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        schema: Deprecated; Specifies the address name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

