# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlarmConfigArgs', 'AlarmConfig']

@pulumi.input_type
class AlarmConfigArgs:
    def __init__(__self__, *,
                 alarm_time_period: pulumi.Input[_builtins.int],
                 alarm_type: pulumi.Input[_builtins.int],
                 frequency_count: pulumi.Input[_builtins.int],
                 frequency_time: pulumi.Input[_builtins.int],
                 fw_instance_id: pulumi.Input[_builtins.str],
                 severity: pulumi.Input[_builtins.str],
                 topic_urn: pulumi.Input[_builtins.str],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AlarmConfig resource.
        :param pulumi.Input[_builtins.int] alarm_time_period: Specifies the alarm period.
               The valid values are as follows:
               + **0**: 8:00 to 22:00;
               + **1**: all day;
        :param pulumi.Input[_builtins.int] alarm_type: Specifies the alarm type.
               The valid values are as follows.
               + **0**: attack;
               + **1**: traffic threshold crossing;
               + **2**: EIP unprotected;
               + **3**: threat intelligence;
        :param pulumi.Input[_builtins.int] frequency_count: Specifies the alarm triggering frequency.
               + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        :param pulumi.Input[_builtins.int] frequency_time: Specifies the alarm frequency time range.
               + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall ID.
        :param pulumi.Input[_builtins.str] severity: Specifies the alarm severity.
               + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
               **MEDIUM**, and **LOW**, separated by commas.
               + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
               + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the alarm URN.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        pulumi.set(__self__, "alarm_time_period", alarm_time_period)
        pulumi.set(__self__, "alarm_type", alarm_type)
        pulumi.set(__self__, "frequency_count", frequency_count)
        pulumi.set(__self__, "frequency_time", frequency_time)
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="alarmTimePeriod")
    def alarm_time_period(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the alarm period.
        The valid values are as follows:
        + **0**: 8:00 to 22:00;
        + **1**: all day;
        """
        return pulumi.get(self, "alarm_time_period")

    @alarm_time_period.setter
    def alarm_time_period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "alarm_time_period", value)

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the alarm type.
        The valid values are as follows.
        + **0**: attack;
        + **1**: traffic threshold crossing;
        + **2**: EIP unprotected;
        + **3**: threat intelligence;
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "alarm_type", value)

    @_builtins.property
    @pulumi.getter(name="frequencyCount")
    def frequency_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the alarm triggering frequency.
        + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        """
        return pulumi.get(self, "frequency_count")

    @frequency_count.setter
    def frequency_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "frequency_count", value)

    @_builtins.property
    @pulumi.getter(name="frequencyTime")
    def frequency_time(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the alarm frequency time range.
        + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        """
        return pulumi.get(self, "frequency_time")

    @frequency_time.setter
    def frequency_time(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "frequency_time", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the firewall ID.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the alarm severity.
        + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
        **MEDIUM**, and **LOW**, separated by commas.
        + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
        + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the alarm URN.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_urn", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AlarmConfigState:
    def __init__(__self__, *,
                 alarm_time_period: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency_count: Optional[pulumi.Input[_builtins.int]] = None,
                 frequency_time: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlarmConfig resources.
        :param pulumi.Input[_builtins.int] alarm_time_period: Specifies the alarm period.
               The valid values are as follows:
               + **0**: 8:00 to 22:00;
               + **1**: all day;
        :param pulumi.Input[_builtins.int] alarm_type: Specifies the alarm type.
               The valid values are as follows.
               + **0**: attack;
               + **1**: traffic threshold crossing;
               + **2**: EIP unprotected;
               + **3**: threat intelligence;
        :param pulumi.Input[_builtins.int] frequency_count: Specifies the alarm triggering frequency.
               + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        :param pulumi.Input[_builtins.int] frequency_time: Specifies the alarm frequency time range.
               + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall ID.
        :param pulumi.Input[_builtins.str] language: The language.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] severity: Specifies the alarm severity.
               + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
               **MEDIUM**, and **LOW**, separated by commas.
               + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
               + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the alarm URN.
        :param pulumi.Input[_builtins.str] username: The username.
        """
        if alarm_time_period is not None:
            pulumi.set(__self__, "alarm_time_period", alarm_time_period)
        if alarm_type is not None:
            pulumi.set(__self__, "alarm_type", alarm_type)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if frequency_count is not None:
            pulumi.set(__self__, "frequency_count", frequency_count)
        if frequency_time is not None:
            pulumi.set(__self__, "frequency_time", frequency_time)
        if fw_instance_id is not None:
            pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="alarmTimePeriod")
    def alarm_time_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the alarm period.
        The valid values are as follows:
        + **0**: 8:00 to 22:00;
        + **1**: all day;
        """
        return pulumi.get(self, "alarm_time_period")

    @alarm_time_period.setter
    def alarm_time_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alarm_time_period", value)

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the alarm type.
        The valid values are as follows.
        + **0**: attack;
        + **1**: traffic threshold crossing;
        + **2**: EIP unprotected;
        + **3**: threat intelligence;
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alarm_type", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="frequencyCount")
    def frequency_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the alarm triggering frequency.
        + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        """
        return pulumi.get(self, "frequency_count")

    @frequency_count.setter
    def frequency_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency_count", value)

    @_builtins.property
    @pulumi.getter(name="frequencyTime")
    def frequency_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the alarm frequency time range.
        + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        """
        return pulumi.get(self, "frequency_time")

    @frequency_time.setter
    def frequency_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency_time", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the firewall ID.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm severity.
        + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
        **MEDIUM**, and **LOW**, separated by commas.
        + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
        + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm URN.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_urn", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("sbercloud:Cfw/alarmConfig:AlarmConfig")
class AlarmConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_time_period: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency_count: Optional[pulumi.Input[_builtins.int]] = None,
                 frequency_time: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW alarm configuration resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        alarm_type = config.require_object("alarmType")
        alarm_time_period = config.require_object("alarmTimePeriod")
        severity = config.require_object("severity")
        frequency_count = config.require_object("frequencyCount")
        frequency_time = config.require_object("frequencyTime")
        topic_urn = config.require_object("topicUrn")
        test = sbercloud.cfw.AlarmConfig("test",
            fw_instance_id=fw_instance_id,
            alarm_type=alarm_type,
            alarm_time_period=alarm_time_period,
            frequency_count=frequency_count,
            frequency_time=frequency_time,
            severity=severity,
            topic_urn=topic_urn)
        ```

        ## Import

        The alarm configuration can be imported using `fw_instance_id`, `alarm_type`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/alarmConfig:AlarmConfig test <fw_instance_id>/<alarm_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alarm_time_period: Specifies the alarm period.
               The valid values are as follows:
               + **0**: 8:00 to 22:00;
               + **1**: all day;
        :param pulumi.Input[_builtins.int] alarm_type: Specifies the alarm type.
               The valid values are as follows.
               + **0**: attack;
               + **1**: traffic threshold crossing;
               + **2**: EIP unprotected;
               + **3**: threat intelligence;
        :param pulumi.Input[_builtins.int] frequency_count: Specifies the alarm triggering frequency.
               + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        :param pulumi.Input[_builtins.int] frequency_time: Specifies the alarm frequency time range.
               + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] severity: Specifies the alarm severity.
               + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
               **MEDIUM**, and **LOW**, separated by commas.
               + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
               + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the alarm URN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW alarm configuration resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        alarm_type = config.require_object("alarmType")
        alarm_time_period = config.require_object("alarmTimePeriod")
        severity = config.require_object("severity")
        frequency_count = config.require_object("frequencyCount")
        frequency_time = config.require_object("frequencyTime")
        topic_urn = config.require_object("topicUrn")
        test = sbercloud.cfw.AlarmConfig("test",
            fw_instance_id=fw_instance_id,
            alarm_type=alarm_type,
            alarm_time_period=alarm_time_period,
            frequency_count=frequency_count,
            frequency_time=frequency_time,
            severity=severity,
            topic_urn=topic_urn)
        ```

        ## Import

        The alarm configuration can be imported using `fw_instance_id`, `alarm_type`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/alarmConfig:AlarmConfig test <fw_instance_id>/<alarm_type>
        ```

        :param str resource_name: The name of the resource.
        :param AlarmConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_time_period: Optional[pulumi.Input[_builtins.int]] = None,
                 alarm_type: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency_count: Optional[pulumi.Input[_builtins.int]] = None,
                 frequency_time: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmConfigArgs.__new__(AlarmConfigArgs)

            if alarm_time_period is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_time_period'")
            __props__.__dict__["alarm_time_period"] = alarm_time_period
            if alarm_type is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_type'")
            __props__.__dict__["alarm_type"] = alarm_type
            __props__.__dict__["enable_force_new"] = enable_force_new
            if frequency_count is None and not opts.urn:
                raise TypeError("Missing required property 'frequency_count'")
            __props__.__dict__["frequency_count"] = frequency_count
            if frequency_time is None and not opts.urn:
                raise TypeError("Missing required property 'frequency_time'")
            __props__.__dict__["frequency_time"] = frequency_time
            if fw_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'fw_instance_id'")
            __props__.__dict__["fw_instance_id"] = fw_instance_id
            __props__.__dict__["region"] = region
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            if topic_urn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_urn'")
            __props__.__dict__["topic_urn"] = topic_urn
            __props__.__dict__["language"] = None
            __props__.__dict__["username"] = None
        super(AlarmConfig, __self__).__init__(
            'sbercloud:Cfw/alarmConfig:AlarmConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_time_period: Optional[pulumi.Input[_builtins.int]] = None,
            alarm_type: Optional[pulumi.Input[_builtins.int]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            frequency_count: Optional[pulumi.Input[_builtins.int]] = None,
            frequency_time: Optional[pulumi.Input[_builtins.int]] = None,
            fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'AlarmConfig':
        """
        Get an existing AlarmConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alarm_time_period: Specifies the alarm period.
               The valid values are as follows:
               + **0**: 8:00 to 22:00;
               + **1**: all day;
        :param pulumi.Input[_builtins.int] alarm_type: Specifies the alarm type.
               The valid values are as follows.
               + **0**: attack;
               + **1**: traffic threshold crossing;
               + **2**: EIP unprotected;
               + **3**: threat intelligence;
        :param pulumi.Input[_builtins.int] frequency_count: Specifies the alarm triggering frequency.
               + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        :param pulumi.Input[_builtins.int] frequency_time: Specifies the alarm frequency time range.
               + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
               + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall ID.
        :param pulumi.Input[_builtins.str] language: The language.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] severity: Specifies the alarm severity.
               + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
               **MEDIUM**, and **LOW**, separated by commas.
               + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
               + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the alarm URN.
        :param pulumi.Input[_builtins.str] username: The username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmConfigState.__new__(_AlarmConfigState)

        __props__.__dict__["alarm_time_period"] = alarm_time_period
        __props__.__dict__["alarm_type"] = alarm_type
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["frequency_count"] = frequency_count
        __props__.__dict__["frequency_time"] = frequency_time
        __props__.__dict__["fw_instance_id"] = fw_instance_id
        __props__.__dict__["language"] = language
        __props__.__dict__["region"] = region
        __props__.__dict__["severity"] = severity
        __props__.__dict__["topic_urn"] = topic_urn
        __props__.__dict__["username"] = username
        return AlarmConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alarmTimePeriod")
    def alarm_time_period(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the alarm period.
        The valid values are as follows:
        + **0**: 8:00 to 22:00;
        + **1**: all day;
        """
        return pulumi.get(self, "alarm_time_period")

    @_builtins.property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the alarm type.
        The valid values are as follows.
        + **0**: attack;
        + **1**: traffic threshold crossing;
        + **2**: EIP unprotected;
        + **3**: threat intelligence;
        """
        return pulumi.get(self, "alarm_type")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="frequencyCount")
    def frequency_count(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the alarm triggering frequency.
        + If `alarm_type` is **0** or **3**, the value of `frequency_count` must be between **1** and **2000**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_count` should be **1**.
        """
        return pulumi.get(self, "frequency_count")

    @_builtins.property
    @pulumi.getter(name="frequencyTime")
    def frequency_time(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the alarm frequency time range.
        + If `alarm_type` is **0** or **3**, the value of `frequency_time` must be between **1** and **60**.
        + If `alarm_type` is **1** or **2**, the value of `frequency_time` should be **1**.
        """
        return pulumi.get(self, "frequency_time")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the firewall ID.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[_builtins.str]:
        """
        The language.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the alarm severity.
        + If `alarm_type` is **0** or **3**, the value of `severity` can be a combination of **CRITICAL**, **HIGH**,
        **MEDIUM**, and **LOW**, separated by commas.
        + If `alarm_type` is **1**, the value of `severity` can be **0** (70%), **1** (80%), or **2** (90%).
        + If `alarm_type` is **2**, the value of `severity` must be **3** (EIP).
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the alarm URN.
        """
        return pulumi.get(self, "topic_urn")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username.
        """
        return pulumi.get(self, "username")

