# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AntiVirusArgs', 'AntiVirus']

@pulumi.input_type
class AntiVirusArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[_builtins.str],
                 scan_protocol_configs: pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AntiVirus resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]] scan_protocol_configs: Specifies the scan protocol configurations.
               The scan_protocol_configs structure is documented below.
               
               <a name="ScanProtocolConfigs"></a>
               The `scan_protocol_configs` block supports:
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "scan_protocol_configs", scan_protocol_configs)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="scanProtocolConfigs")
    def scan_protocol_configs(self) -> pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]]:
        """
        Specifies the scan protocol configurations.
        The scan_protocol_configs structure is documented below.

        <a name="ScanProtocolConfigs"></a>
        The `scan_protocol_configs` block supports:
        """
        return pulumi.get(self, "scan_protocol_configs")

    @scan_protocol_configs.setter
    def scan_protocol_configs(self, value: pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]]):
        pulumi.set(self, "scan_protocol_configs", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AntiVirusState:
    def __init__(__self__, *,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_protocol_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering AntiVirus resources.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]] scan_protocol_configs: Specifies the scan protocol configurations.
               The scan_protocol_configs structure is documented below.
               
               <a name="ScanProtocolConfigs"></a>
               The `scan_protocol_configs` block supports:
        """
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scan_protocol_configs is not None:
            pulumi.set(__self__, "scan_protocol_configs", scan_protocol_configs)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scanProtocolConfigs")
    def scan_protocol_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]]]:
        """
        Specifies the scan protocol configurations.
        The scan_protocol_configs structure is documented below.

        <a name="ScanProtocolConfigs"></a>
        The `scan_protocol_configs` block supports:
        """
        return pulumi.get(self, "scan_protocol_configs")

    @scan_protocol_configs.setter
    def scan_protocol_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AntiVirusScanProtocolConfigArgs']]]]):
        pulumi.set(self, "scan_protocol_configs", value)


@pulumi.type_token("sbercloud:Cfw/antiVirus:AntiVirus")
class AntiVirus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_protocol_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiVirusScanProtocolConfigArgs', 'AntiVirusScanProtocolConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a CFW anti virus resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AntiVirus("test",
            object_id=object_id,
            scan_protocol_configs=[
                {
                    "protocol_type": 3,
                    "action": 1,
                },
                {
                    "protocol_type": 2,
                    "action": 1,
                },
            ])
        ```

        ## Import

        The anti virus can be imported using `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/antiVirus:AntiVirus test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiVirusScanProtocolConfigArgs', 'AntiVirusScanProtocolConfigArgsDict']]]] scan_protocol_configs: Specifies the scan protocol configurations.
               The scan_protocol_configs structure is documented below.
               
               <a name="ScanProtocolConfigs"></a>
               The `scan_protocol_configs` block supports:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AntiVirusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW anti virus resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        object_id = config.require_object("objectId")
        test = sbercloud.cfw.AntiVirus("test",
            object_id=object_id,
            scan_protocol_configs=[
                {
                    "protocol_type": 3,
                    "action": 1,
                },
                {
                    "protocol_type": 2,
                    "action": 1,
                },
            ])
        ```

        ## Import

        The anti virus can be imported using `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/antiVirus:AntiVirus test <id>
        ```

        :param str resource_name: The name of the resource.
        :param AntiVirusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AntiVirusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_protocol_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiVirusScanProtocolConfigArgs', 'AntiVirusScanProtocolConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AntiVirusArgs.__new__(AntiVirusArgs)

            __props__.__dict__["enable_force_new"] = enable_force_new
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["region"] = region
            if scan_protocol_configs is None and not opts.urn:
                raise TypeError("Missing required property 'scan_protocol_configs'")
            __props__.__dict__["scan_protocol_configs"] = scan_protocol_configs
        super(AntiVirus, __self__).__init__(
            'sbercloud:Cfw/antiVirus:AntiVirus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scan_protocol_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AntiVirusScanProtocolConfigArgs', 'AntiVirusScanProtocolConfigArgsDict']]]]] = None) -> 'AntiVirus':
        """
        Get an existing AntiVirus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AntiVirusScanProtocolConfigArgs', 'AntiVirusScanProtocolConfigArgsDict']]]] scan_protocol_configs: Specifies the scan protocol configurations.
               The scan_protocol_configs structure is documented below.
               
               <a name="ScanProtocolConfigs"></a>
               The `scan_protocol_configs` block supports:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AntiVirusState.__new__(_AntiVirusState)

        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["region"] = region
        __props__.__dict__["scan_protocol_configs"] = scan_protocol_configs
        return AntiVirus(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scanProtocolConfigs")
    def scan_protocol_configs(self) -> pulumi.Output[Sequence['outputs.AntiVirusScanProtocolConfig']]:
        """
        Specifies the scan protocol configurations.
        The scan_protocol_configs structure is documented below.

        <a name="ScanProtocolConfigs"></a>
        The `scan_protocol_configs` block supports:
        """
        return pulumi.get(self, "scan_protocol_configs")

