# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BlackWhiteListArgs', 'BlackWhiteList']

@pulumi.input_type
class BlackWhiteListArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 address_type: pulumi.Input[_builtins.int],
                 direction: pulumi.Input[_builtins.int],
                 list_type: pulumi.Input[_builtins.int],
                 object_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BlackWhiteList resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the IP address type.
               The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        :param pulumi.Input[_builtins.int] direction: Specifies the address direction.
               The options are `0` (source address) and `1` (destination address).
        :param pulumi.Input[_builtins.int] list_type: Specifies the list type.
               The options are `4` (blacklist) and `5` (whitelist).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type. The value can be:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol;
        :param pulumi.Input[_builtins.str] description: Specifies the description of the list.
        :param pulumi.Input[_builtins.str] port: Specifies the destination port.
               Required and only available if protocol is **TCP** or **UDP**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "list_type", list_type)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the IP address type.
        The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the address direction.
        The options are `0` (source address) and `1` (destination address).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the list type.
        The options are `4` (blacklist) and `5` (whitelist).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "list_type", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the protocol type. The value can be:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol;
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port.
        Required and only available if protocol is **TCP** or **UDP**.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BlackWhiteListState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 list_type: Optional[pulumi.Input[_builtins.int]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BlackWhiteList resources.
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the IP address type.
               The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        :param pulumi.Input[_builtins.str] description: Specifies the description of the list.
        :param pulumi.Input[_builtins.int] direction: Specifies the address direction.
               The options are `0` (source address) and `1` (destination address).
        :param pulumi.Input[_builtins.int] list_type: Specifies the list type.
               The options are `4` (blacklist) and `5` (whitelist).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] port: Specifies the destination port.
               Required and only available if protocol is **TCP** or **UDP**.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type. The value can be:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol;
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if list_type is not None:
            pulumi.set(__self__, "list_type", list_type)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP address type.
        The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the address direction.
        The options are `0` (source address) and `1` (destination address).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the list type.
        The options are `4` (blacklist) and `5` (whitelist).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "list_type")

    @list_type.setter
    def list_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "list_type", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port.
        Required and only available if protocol is **TCP** or **UDP**.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the protocol type. The value can be:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol;
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Cfw/blackWhiteList:BlackWhiteList")
class BlackWhiteList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 list_type: Optional[pulumi.Input[_builtins.int]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW black white list resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        list_type = config.require_object("listType")
        direction = config.require_object("direction")
        address_type = config.require_object("addressType")
        address = config.require_object("address")
        protocol = config.require_object("protocol")
        port = config.require_object("port")
        test = sbercloud.Cfw.get_firewalls()
        test_black_white_list = sbercloud.cfw.BlackWhiteList("test",
            object_id=test.records[0].protect_objects[0].object_id,
            list_type=list_type,
            direction=direction,
            address_type=address_type,
            address=address,
            protocol=protocol,
            port=port)
        ```

        ## Import

        The black whitelist can be imported using `object_id`, `list_type`, `address`, separated by slashes, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/blackWhiteList:BlackWhiteList test <object_id>/<list_type>/<address>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the IP address type.
               The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        :param pulumi.Input[_builtins.str] description: Specifies the description of the list.
        :param pulumi.Input[_builtins.int] direction: Specifies the address direction.
               The options are `0` (source address) and `1` (destination address).
        :param pulumi.Input[_builtins.int] list_type: Specifies the list type.
               The options are `4` (blacklist) and `5` (whitelist).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] port: Specifies the destination port.
               Required and only available if protocol is **TCP** or **UDP**.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type. The value can be:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol;
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlackWhiteListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW black white list resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        list_type = config.require_object("listType")
        direction = config.require_object("direction")
        address_type = config.require_object("addressType")
        address = config.require_object("address")
        protocol = config.require_object("protocol")
        port = config.require_object("port")
        test = sbercloud.Cfw.get_firewalls()
        test_black_white_list = sbercloud.cfw.BlackWhiteList("test",
            object_id=test.records[0].protect_objects[0].object_id,
            list_type=list_type,
            direction=direction,
            address_type=address_type,
            address=address,
            protocol=protocol,
            port=port)
        ```

        ## Import

        The black whitelist can be imported using `object_id`, `list_type`, `address`, separated by slashes, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/blackWhiteList:BlackWhiteList test <object_id>/<list_type>/<address>
        ```

        :param str resource_name: The name of the resource.
        :param BlackWhiteListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlackWhiteListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.int]] = None,
                 list_type: Optional[pulumi.Input[_builtins.int]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlackWhiteListArgs.__new__(BlackWhiteListArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            if address_type is None and not opts.urn:
                raise TypeError("Missing required property 'address_type'")
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            if list_type is None and not opts.urn:
                raise TypeError("Missing required property 'list_type'")
            __props__.__dict__["list_type"] = list_type
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
        super(BlackWhiteList, __self__).__init__(
            'sbercloud:Cfw/blackWhiteList:BlackWhiteList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            address_type: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.int]] = None,
            list_type: Optional[pulumi.Input[_builtins.int]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'BlackWhiteList':
        """
        Get an existing BlackWhiteList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specifies the address.
        :param pulumi.Input[_builtins.int] address_type: Specifies the IP address type.
               The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        :param pulumi.Input[_builtins.str] description: Specifies the description of the list.
        :param pulumi.Input[_builtins.int] direction: Specifies the address direction.
               The options are `0` (source address) and `1` (destination address).
        :param pulumi.Input[_builtins.int] list_type: Specifies the list type.
               The options are `4` (blacklist) and `5` (whitelist).
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] port: Specifies the destination port.
               Required and only available if protocol is **TCP** or **UDP**.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type. The value can be:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol;
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlackWhiteListState.__new__(_BlackWhiteListState)

        __props__.__dict__["address"] = address
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["list_type"] = list_type
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        return BlackWhiteList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the IP address type.
        The options are `0` (ipv4), `1` (ipv6) and `2` (domain).
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the list.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the address direction.
        The options are `0` (source address) and `1` (destination address).
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the list type.
        The options are `4` (blacklist) and `5` (whitelist).

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "list_type")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination port.
        Required and only available if protocol is **TCP** or **UDP**.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the protocol type. The value can be:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol;
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

