# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CaptureTaskArgs', 'CaptureTask']

@pulumi.input_type
class CaptureTaskArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['CaptureTaskDestinationArgs'],
                 duration: pulumi.Input[_builtins.int],
                 fw_instance_id: pulumi.Input[_builtins.str],
                 max_packets: pulumi.Input[_builtins.int],
                 service: pulumi.Input['CaptureTaskServiceArgs'],
                 source: pulumi.Input['CaptureTaskSourceArgs'],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_capture: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CaptureTask resource.
        :param pulumi.Input['CaptureTaskDestinationArgs'] destination: Specifies the destination configuration.
               The destination structure is documented below.
        :param pulumi.Input[_builtins.int] duration: Specifies the capture task duration.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall instance.
        :param pulumi.Input[_builtins.int] max_packets: Specifies the maximum number of packets captured.
               The Maximum value is `1,000,000`.
        :param pulumi.Input['CaptureTaskServiceArgs'] service: Specifies the service configuration.
               The service structure is documented below.
        :param pulumi.Input['CaptureTaskSourceArgs'] source: Specifies the source configuration.
               The source structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the capture task name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] stop_capture: Specifies whether to stop the capture task.
               
               <a name="Address"></a>
               The `destination` or `source` block supports:
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        pulumi.set(__self__, "max_packets", max_packets)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source", source)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stop_capture is not None:
            pulumi.set(__self__, "stop_capture", stop_capture)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['CaptureTaskDestinationArgs']:
        """
        Specifies the destination configuration.
        The destination structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['CaptureTaskDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the capture task duration.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the firewall instance.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxPackets")
    def max_packets(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum number of packets captured.
        The Maximum value is `1,000,000`.
        """
        return pulumi.get(self, "max_packets")

    @max_packets.setter
    def max_packets(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_packets", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input['CaptureTaskServiceArgs']:
        """
        Specifies the service configuration.
        The service structure is documented below.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input['CaptureTaskServiceArgs']):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['CaptureTaskSourceArgs']:
        """
        Specifies the source configuration.
        The source structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['CaptureTaskSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the capture task name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="stopCapture")
    def stop_capture(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to stop the capture task.

        <a name="Address"></a>
        The `destination` or `source` block supports:
        """
        return pulumi.get(self, "stop_capture")

    @stop_capture.setter
    def stop_capture(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_capture", value)


@pulumi.input_type
class _CaptureTaskState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['CaptureTaskDestinationArgs']] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_packets: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input['CaptureTaskServiceArgs']] = None,
                 source: Optional[pulumi.Input['CaptureTaskSourceArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 stop_capture: Optional[pulumi.Input[_builtins.bool]] = None,
                 task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CaptureTask resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the capture task.
        :param pulumi.Input['CaptureTaskDestinationArgs'] destination: Specifies the destination configuration.
               The destination structure is documented below.
        :param pulumi.Input[_builtins.int] duration: Specifies the capture task duration.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall instance.
        :param pulumi.Input[_builtins.int] max_packets: Specifies the maximum number of packets captured.
               The Maximum value is `1,000,000`.
        :param pulumi.Input[_builtins.str] name: Specifies the capture task name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input['CaptureTaskServiceArgs'] service: Specifies the service configuration.
               The service structure is documented below.
        :param pulumi.Input['CaptureTaskSourceArgs'] source: Specifies the source configuration.
               The source structure is documented below.
        :param pulumi.Input[_builtins.int] status: The status of the capture task.
        :param pulumi.Input[_builtins.bool] stop_capture: Specifies whether to stop the capture task.
               
               <a name="Address"></a>
               The `destination` or `source` block supports:
        :param pulumi.Input[_builtins.str] task_id: The ID of the capture task.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the capture task.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if fw_instance_id is not None:
            pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if max_packets is not None:
            pulumi.set(__self__, "max_packets", max_packets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_capture is not None:
            pulumi.set(__self__, "stop_capture", stop_capture)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the capture task.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['CaptureTaskDestinationArgs']]:
        """
        Specifies the destination configuration.
        The destination structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['CaptureTaskDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the capture task duration.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the firewall instance.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxPackets")
    def max_packets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of packets captured.
        The Maximum value is `1,000,000`.
        """
        return pulumi.get(self, "max_packets")

    @max_packets.setter
    def max_packets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_packets", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the capture task name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['CaptureTaskServiceArgs']]:
        """
        Specifies the service configuration.
        The service structure is documented below.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['CaptureTaskServiceArgs']]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['CaptureTaskSourceArgs']]:
        """
        Specifies the source configuration.
        The source structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['CaptureTaskSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the capture task.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stopCapture")
    def stop_capture(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to stop the capture task.

        <a name="Address"></a>
        The `destination` or `source` block supports:
        """
        return pulumi.get(self, "stop_capture")

    @stop_capture.setter
    def stop_capture(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_capture", value)

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the capture task.
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time of the capture task.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Cfw/captureTask:CaptureTask")
class CaptureTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[Union['CaptureTaskDestinationArgs', 'CaptureTaskDestinationArgsDict']]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_packets: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[Union['CaptureTaskServiceArgs', 'CaptureTaskServiceArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['CaptureTaskSourceArgs', 'CaptureTaskSourceArgsDict']]] = None,
                 stop_capture: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a CFW capture task resource within SberCloud.

        > **NOTE:** For the Cloud Firewall service, you can only initiate up to 20 packet capture tasks per day.
        Beyond this limit, no additional packet capture tasks can be initiated. Furthermore, only one packet capture task can be
        in progress at any given time.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        name = config.require_object("name")
        duration = config.require_object("duration")
        max_packets = config.require_object("maxPackets")
        test = sbercloud.cfw.CaptureTask("test",
            fw_instance_id=fw_instance_id,
            name=name,
            duration=duration,
            max_packets=max_packets,
            destination={
                "address": "1.1.1.1",
                "address_type": 0,
            },
            source={
                "address": "2.2.2.2",
                "address_type": 0,
            },
            service={
                "protocol": -1,
            })
        ```

        ## Import

        The capture task can be imported using `fw_instance_id`, `name`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/captureTask:CaptureTask test <fw_instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes is `stop_capture`. It is generally recommended running `pulumi preview` after importing the resource.

        You can then decide if changes should be applied to the capture task, or the resource definition should be updated to

        align with the capture task. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cfw_capture_task" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              stop_capture,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CaptureTaskDestinationArgs', 'CaptureTaskDestinationArgsDict']] destination: Specifies the destination configuration.
               The destination structure is documented below.
        :param pulumi.Input[_builtins.int] duration: Specifies the capture task duration.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall instance.
        :param pulumi.Input[_builtins.int] max_packets: Specifies the maximum number of packets captured.
               The Maximum value is `1,000,000`.
        :param pulumi.Input[_builtins.str] name: Specifies the capture task name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Union['CaptureTaskServiceArgs', 'CaptureTaskServiceArgsDict']] service: Specifies the service configuration.
               The service structure is documented below.
        :param pulumi.Input[Union['CaptureTaskSourceArgs', 'CaptureTaskSourceArgsDict']] source: Specifies the source configuration.
               The source structure is documented below.
        :param pulumi.Input[_builtins.bool] stop_capture: Specifies whether to stop the capture task.
               
               <a name="Address"></a>
               The `destination` or `source` block supports:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaptureTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW capture task resource within SberCloud.

        > **NOTE:** For the Cloud Firewall service, you can only initiate up to 20 packet capture tasks per day.
        Beyond this limit, no additional packet capture tasks can be initiated. Furthermore, only one packet capture task can be
        in progress at any given time.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        name = config.require_object("name")
        duration = config.require_object("duration")
        max_packets = config.require_object("maxPackets")
        test = sbercloud.cfw.CaptureTask("test",
            fw_instance_id=fw_instance_id,
            name=name,
            duration=duration,
            max_packets=max_packets,
            destination={
                "address": "1.1.1.1",
                "address_type": 0,
            },
            source={
                "address": "2.2.2.2",
                "address_type": 0,
            },
            service={
                "protocol": -1,
            })
        ```

        ## Import

        The capture task can be imported using `fw_instance_id`, `name`, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/captureTask:CaptureTask test <fw_instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes is `stop_capture`. It is generally recommended running `pulumi preview` after importing the resource.

        You can then decide if changes should be applied to the capture task, or the resource definition should be updated to

        align with the capture task. Also you can ignore changes as below.

        hcl

        resource "sbercloud_cfw_capture_task" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              stop_capture,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param CaptureTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaptureTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[Union['CaptureTaskDestinationArgs', 'CaptureTaskDestinationArgsDict']]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_packets: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[Union['CaptureTaskServiceArgs', 'CaptureTaskServiceArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['CaptureTaskSourceArgs', 'CaptureTaskSourceArgsDict']]] = None,
                 stop_capture: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaptureTaskArgs.__new__(CaptureTaskArgs)

            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if duration is None and not opts.urn:
                raise TypeError("Missing required property 'duration'")
            __props__.__dict__["duration"] = duration
            __props__.__dict__["enable_force_new"] = enable_force_new
            if fw_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'fw_instance_id'")
            __props__.__dict__["fw_instance_id"] = fw_instance_id
            if max_packets is None and not opts.urn:
                raise TypeError("Missing required property 'max_packets'")
            __props__.__dict__["max_packets"] = max_packets
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["stop_capture"] = stop_capture
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_id"] = None
            __props__.__dict__["updated_at"] = None
        super(CaptureTask, __self__).__init__(
            'sbercloud:Cfw/captureTask:CaptureTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['CaptureTaskDestinationArgs', 'CaptureTaskDestinationArgsDict']]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_packets: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[Union['CaptureTaskServiceArgs', 'CaptureTaskServiceArgsDict']]] = None,
            source: Optional[pulumi.Input[Union['CaptureTaskSourceArgs', 'CaptureTaskSourceArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            stop_capture: Optional[pulumi.Input[_builtins.bool]] = None,
            task_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'CaptureTask':
        """
        Get an existing CaptureTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the capture task.
        :param pulumi.Input[Union['CaptureTaskDestinationArgs', 'CaptureTaskDestinationArgsDict']] destination: Specifies the destination configuration.
               The destination structure is documented below.
        :param pulumi.Input[_builtins.int] duration: Specifies the capture task duration.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall instance.
        :param pulumi.Input[_builtins.int] max_packets: Specifies the maximum number of packets captured.
               The Maximum value is `1,000,000`.
        :param pulumi.Input[_builtins.str] name: Specifies the capture task name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Union['CaptureTaskServiceArgs', 'CaptureTaskServiceArgsDict']] service: Specifies the service configuration.
               The service structure is documented below.
        :param pulumi.Input[Union['CaptureTaskSourceArgs', 'CaptureTaskSourceArgsDict']] source: Specifies the source configuration.
               The source structure is documented below.
        :param pulumi.Input[_builtins.int] status: The status of the capture task.
        :param pulumi.Input[_builtins.bool] stop_capture: Specifies whether to stop the capture task.
               
               <a name="Address"></a>
               The `destination` or `source` block supports:
        :param pulumi.Input[_builtins.str] task_id: The ID of the capture task.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the capture task.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaptureTaskState.__new__(_CaptureTaskState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["destination"] = destination
        __props__.__dict__["duration"] = duration
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["fw_instance_id"] = fw_instance_id
        __props__.__dict__["max_packets"] = max_packets
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["service"] = service
        __props__.__dict__["source"] = source
        __props__.__dict__["status"] = status
        __props__.__dict__["stop_capture"] = stop_capture
        __props__.__dict__["task_id"] = task_id
        __props__.__dict__["updated_at"] = updated_at
        return CaptureTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the capture task.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.CaptureTaskDestination']:
        """
        Specifies the destination configuration.
        The destination structure is documented below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the capture task duration.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the firewall instance.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="maxPackets")
    def max_packets(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of packets captured.
        The Maximum value is `1,000,000`.
        """
        return pulumi.get(self, "max_packets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the capture task name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output['outputs.CaptureTaskService']:
        """
        Specifies the service configuration.
        The service structure is documented below.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.CaptureTaskSource']:
        """
        Specifies the source configuration.
        The source structure is documented below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the capture task.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stopCapture")
    def stop_capture(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to stop the capture task.

        <a name="Address"></a>
        The `destination` or `source` block supports:
        """
        return pulumi.get(self, "stop_capture")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the capture task.
        """
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time of the capture task.
        """
        return pulumi.get(self, "updated_at")

