# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DnsResolutionArgs', 'DnsResolution']

@pulumi.input_type
class DnsResolutionArgs:
    def __init__(__self__, *,
                 fw_instance_id: pulumi.Input[_builtins.str],
                 custom_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DnsResolution resource.
        :param pulumi.Input[_builtins.str] fw_instance_id: The ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_dns_servers: The custom DNS servers.
               Currently, only two custom DNS server addresses can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_dns_servers: The default DNS servers.
        :param pulumi.Input[_builtins.str] health_check_domain_name: The health check domain name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if custom_dns_servers is not None:
            pulumi.set(__self__, "custom_dns_servers", custom_dns_servers)
        if default_dns_servers is not None:
            pulumi.set(__self__, "default_dns_servers", default_dns_servers)
        if health_check_domain_name is not None:
            pulumi.set(__self__, "health_check_domain_name", health_check_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="customDnsServers")
    def custom_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The custom DNS servers.
        Currently, only two custom DNS server addresses can be specified.
        """
        return pulumi.get(self, "custom_dns_servers")

    @custom_dns_servers.setter
    def custom_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="defaultDnsServers")
    def default_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The default DNS servers.
        """
        return pulumi.get(self, "default_dns_servers")

    @default_dns_servers.setter
    def default_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckDomainName")
    def health_check_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check domain name.
        """
        return pulumi.get(self, "health_check_domain_name")

    @health_check_domain_name.setter
    def health_check_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DnsResolutionState:
    def __init__(__self__, *,
                 custom_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsResolution resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_dns_servers: The custom DNS servers.
               Currently, only two custom DNS server addresses can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_dns_servers: The default DNS servers.
        :param pulumi.Input[_builtins.str] fw_instance_id: The ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] health_check_domain_name: The health check domain name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        if custom_dns_servers is not None:
            pulumi.set(__self__, "custom_dns_servers", custom_dns_servers)
        if default_dns_servers is not None:
            pulumi.set(__self__, "default_dns_servers", default_dns_servers)
        if fw_instance_id is not None:
            pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if health_check_domain_name is not None:
            pulumi.set(__self__, "health_check_domain_name", health_check_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="customDnsServers")
    def custom_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The custom DNS servers.
        Currently, only two custom DNS server addresses can be specified.
        """
        return pulumi.get(self, "custom_dns_servers")

    @custom_dns_servers.setter
    def custom_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="defaultDnsServers")
    def default_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The default DNS servers.
        """
        return pulumi.get(self, "default_dns_servers")

    @default_dns_servers.setter
    def default_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckDomainName")
    def health_check_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check domain name.
        """
        return pulumi.get(self, "health_check_domain_name")

    @health_check_domain_name.setter
    def health_check_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Cfw/dnsResolution:DnsResolution")
class DnsResolution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW DNS resolution resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        default_dns_servers = config.require_object("defaultDnsServers")
        custom_dns_servers = config.require_object("customDnsServers")
        health_check_domain_name = config.require_object("healthCheckDomainName")
        test = sbercloud.cfw.DnsResolution("test",
            fw_instance_id=fw_instance_id,
            default_dns_servers=default_dns_servers,
            custom_dns_servers=custom_dns_servers,
            health_check_domain_name=health_check_domain_name)
        ```

        ## Import

        The DNS resolution resource can be imported using the firewall instance ID, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/dnsResolution:DnsResolution test <fw_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_dns_servers: The custom DNS servers.
               Currently, only two custom DNS server addresses can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_dns_servers: The default DNS servers.
        :param pulumi.Input[_builtins.str] fw_instance_id: The ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] health_check_domain_name: The health check domain name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsResolutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW DNS resolution resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        default_dns_servers = config.require_object("defaultDnsServers")
        custom_dns_servers = config.require_object("customDnsServers")
        health_check_domain_name = config.require_object("healthCheckDomainName")
        test = sbercloud.cfw.DnsResolution("test",
            fw_instance_id=fw_instance_id,
            default_dns_servers=default_dns_servers,
            custom_dns_servers=custom_dns_servers,
            health_check_domain_name=health_check_domain_name)
        ```

        ## Import

        The DNS resolution resource can be imported using the firewall instance ID, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/dnsResolution:DnsResolution test <fw_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param DnsResolutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsResolutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsResolutionArgs.__new__(DnsResolutionArgs)

            __props__.__dict__["custom_dns_servers"] = custom_dns_servers
            __props__.__dict__["default_dns_servers"] = default_dns_servers
            if fw_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'fw_instance_id'")
            __props__.__dict__["fw_instance_id"] = fw_instance_id
            __props__.__dict__["health_check_domain_name"] = health_check_domain_name
            __props__.__dict__["region"] = region
        super(DnsResolution, __self__).__init__(
            'sbercloud:Cfw/dnsResolution:DnsResolution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsResolution':
        """
        Get an existing DnsResolution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_dns_servers: The custom DNS servers.
               Currently, only two custom DNS server addresses can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_dns_servers: The default DNS servers.
        :param pulumi.Input[_builtins.str] fw_instance_id: The ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] health_check_domain_name: The health check domain name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsResolutionState.__new__(_DnsResolutionState)

        __props__.__dict__["custom_dns_servers"] = custom_dns_servers
        __props__.__dict__["default_dns_servers"] = default_dns_servers
        __props__.__dict__["fw_instance_id"] = fw_instance_id
        __props__.__dict__["health_check_domain_name"] = health_check_domain_name
        __props__.__dict__["region"] = region
        return DnsResolution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customDnsServers")
    def custom_dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The custom DNS servers.
        Currently, only two custom DNS server addresses can be specified.
        """
        return pulumi.get(self, "custom_dns_servers")

    @_builtins.property
    @pulumi.getter(name="defaultDnsServers")
    def default_dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The default DNS servers.
        """
        return pulumi.get(self, "default_dns_servers")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomainName")
    def health_check_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The health check domain name.
        """
        return pulumi.get(self, "health_check_domain_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

