# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainNameGroupArgs', 'DomainNameGroup']

@pulumi.input_type
class DomainNameGroupArgs:
    def __init__(__self__, *,
                 fw_instance_id: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainNameGroup resource.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall instance ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] type: Specifies the type of the domain name group.
               The value can be:
               + **0**: means application type;
               + **1**: means network type;
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description.
        :param pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]] domain_names: Specifies the list of domain names.
               The domain_names structure is documented below.
               
               <a name="DomainNameGroup_DomainNames"></a>
               The `domain_names` block supports:
        :param pulumi.Input[_builtins.str] name: Specifies the name of the domain name group.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the firewall instance ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the type of the domain name group.
        The value can be:
        + **0**: means application type;
        + **1**: means network type;

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]]:
        """
        Specifies the list of domain names.
        The domain_names structure is documented below.

        <a name="DomainNameGroup_DomainNames"></a>
        The `domain_names` block supports:
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the domain name group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DomainNameGroupState:
    def __init__(__self__, *,
                 config_status: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_count: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DomainNameGroup resources.
        :param pulumi.Input[_builtins.int] config_status: The config status of the domain name group.
        :param pulumi.Input[_builtins.str] description: Specifies the description.
        :param pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]] domain_names: Specifies the list of domain names.
               The domain_names structure is documented below.
               
               <a name="DomainNameGroup_DomainNames"></a>
               The `domain_names` block supports:
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall instance ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] message: The exception message of the domain name group.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the domain name group.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] ref_count: The reference count of the domain name group.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] type: Specifies the type of the domain name group.
               The value can be:
               + **0**: means application type;
               + **1**: means network type;
               
               Changing this parameter will create a new resource.
        """
        if config_status is not None:
            pulumi.set(__self__, "config_status", config_status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if fw_instance_id is not None:
            pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if ref_count is not None:
            pulumi.set(__self__, "ref_count", ref_count)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configStatus")
    def config_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The config status of the domain name group.
        """
        return pulumi.get(self, "config_status")

    @config_status.setter
    def config_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_status", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]]:
        """
        Specifies the list of domain names.
        The domain_names structure is documented below.

        <a name="DomainNameGroup_DomainNames"></a>
        The `domain_names` block supports:
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameGroupDomainNameArgs']]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the firewall instance ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The exception message of the domain name group.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the domain name group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The reference count of the domain name group.
        """
        return pulumi.get(self, "ref_count")

    @ref_count.setter
    def ref_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ref_count", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the type of the domain name group.
        The value can be:
        + **0**: means application type;
        + **1**: means network type;

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Cfw/domainNameGroup:DomainNameGroup")
class DomainNameGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameGroupDomainNameArgs', 'DomainNameGroupDomainNameArgsDict']]]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a CFW domain name group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        object_id = config.require_object("objectId")
        name = config.require_object("name")
        test = sbercloud.cfw.DomainNameGroup("test",
            fw_instance_id=fw_instance_id,
            object_id=object_id,
            name=name,
            type=0,
            description="created by terraform",
            domain_names=[{
                "domain_name": "www.cfw-test.com",
                "description": "test domain",
            }])
        ```

        ## Import

        The domainnamegroup can be imported using the `fw_instance_id`, `object_id` and `id`, separated by slashes, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/domainNameGroup:DomainNameGroup test <fw_instance_id>/<object_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainNameGroupDomainNameArgs', 'DomainNameGroupDomainNameArgsDict']]]] domain_names: Specifies the list of domain names.
               The domain_names structure is documented below.
               
               <a name="DomainNameGroup_DomainNames"></a>
               The `domain_names` block supports:
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall instance ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the domain name group.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] type: Specifies the type of the domain name group.
               The value can be:
               + **0**: means application type;
               + **1**: means network type;
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainNameGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW domain name group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        fw_instance_id = config.require_object("fwInstanceId")
        object_id = config.require_object("objectId")
        name = config.require_object("name")
        test = sbercloud.cfw.DomainNameGroup("test",
            fw_instance_id=fw_instance_id,
            object_id=object_id,
            name=name,
            type=0,
            description="created by terraform",
            domain_names=[{
                "domain_name": "www.cfw-test.com",
                "description": "test domain",
            }])
        ```

        ## Import

        The domainnamegroup can be imported using the `fw_instance_id`, `object_id` and `id`, separated by slashes, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/domainNameGroup:DomainNameGroup test <fw_instance_id>/<object_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param DomainNameGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainNameGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameGroupDomainNameArgs', 'DomainNameGroupDomainNameArgsDict']]]]] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainNameGroupArgs.__new__(DomainNameGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain_names"] = domain_names
            if fw_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'fw_instance_id'")
            __props__.__dict__["fw_instance_id"] = fw_instance_id
            __props__.__dict__["name"] = name
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["config_status"] = None
            __props__.__dict__["message"] = None
            __props__.__dict__["ref_count"] = None
        super(DomainNameGroup, __self__).__init__(
            'sbercloud:Cfw/domainNameGroup:DomainNameGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_status: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameGroupDomainNameArgs', 'DomainNameGroupDomainNameArgsDict']]]]] = None,
            fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            ref_count: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.int]] = None) -> 'DomainNameGroup':
        """
        Get an existing DomainNameGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_status: The config status of the domain name group.
        :param pulumi.Input[_builtins.str] description: Specifies the description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainNameGroupDomainNameArgs', 'DomainNameGroupDomainNameArgsDict']]]] domain_names: Specifies the list of domain names.
               The domain_names structure is documented below.
               
               <a name="DomainNameGroup_DomainNames"></a>
               The `domain_names` block supports:
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the firewall instance ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] message: The exception message of the domain name group.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the domain name group.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] ref_count: The reference count of the domain name group.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] type: Specifies the type of the domain name group.
               The value can be:
               + **0**: means application type;
               + **1**: means network type;
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainNameGroupState.__new__(_DomainNameGroupState)

        __props__.__dict__["config_status"] = config_status
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_names"] = domain_names
        __props__.__dict__["fw_instance_id"] = fw_instance_id
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["ref_count"] = ref_count
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        return DomainNameGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configStatus")
    def config_status(self) -> pulumi.Output[_builtins.int]:
        """
        The config status of the domain name group.
        """
        return pulumi.get(self, "config_status")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Output[Optional[Sequence['outputs.DomainNameGroupDomainName']]]:
        """
        Specifies the list of domain names.
        The domain_names structure is documented below.

        <a name="DomainNameGroup_DomainNames"></a>
        The `domain_names` block supports:
        """
        return pulumi.get(self, "domain_names")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the firewall instance ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        The exception message of the domain name group.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the domain name group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protected object ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> pulumi.Output[_builtins.int]:
        """
        The reference count of the domain name group.
        """
        return pulumi.get(self, "ref_count")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the type of the domain name group.
        The value can be:
        + **0**: means application type;
        + **1**: means network type;

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

