# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EipProtectionArgs', 'EipProtection']

@pulumi.input_type
class EipProtectionArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[_builtins.str],
                 protected_eips: pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipProtection resource.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]] protected_eips: The protected EIP configurations.
               The object structure is documented below.
               
               <a name="cfw_protected_eip"></a>
               The `protected_eip` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "protected_eips", protected_eips)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The protected object ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="protectedEips")
    def protected_eips(self) -> pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]]:
        """
        The protected EIP configurations.
        The object structure is documented below.

        <a name="cfw_protected_eip"></a>
        The `protected_eip` block supports:
        """
        return pulumi.get(self, "protected_eips")

    @protected_eips.setter
    def protected_eips(self, value: pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]]):
        pulumi.set(self, "protected_eips", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EipProtectionState:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_eips: Optional[pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipProtection resources.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]] protected_eips: The protected EIP configurations.
               The object structure is documented below.
               
               <a name="cfw_protected_eip"></a>
               The `protected_eip` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if protected_eips is not None:
            pulumi.set(__self__, "protected_eips", protected_eips)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected object ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="protectedEips")
    def protected_eips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]]]:
        """
        The protected EIP configurations.
        The object structure is documented below.

        <a name="cfw_protected_eip"></a>
        The `protected_eip` block supports:
        """
        return pulumi.get(self, "protected_eips")

    @protected_eips.setter
    def protected_eips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EipProtectionProtectedEipArgs']]]]):
        pulumi.set(self, "protected_eips", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Cfw/eipProtection:EipProtection")
class EipProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_eips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EipProtectionProtectedEipArgs', 'EipProtectionProtectedEipArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the protected EIPs under the protect object for CFW service within SberCloud.

        > A protection object (`object_id`) can only create one `Cfw.EipProtection` resource for managing
        protected EIPs.

        ## Import

        The protection resource can be imported using their `object_id` or `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/eipProtection:EipProtection test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EipProtectionProtectedEipArgs', 'EipProtectionProtectedEipArgsDict']]]] protected_eips: The protected EIP configurations.
               The object structure is documented below.
               
               <a name="cfw_protected_eip"></a>
               The `protected_eip` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the protected EIPs under the protect object for CFW service within SberCloud.

        > A protection object (`object_id`) can only create one `Cfw.EipProtection` resource for managing
        protected EIPs.

        ## Import

        The protection resource can be imported using their `object_id` or `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/eipProtection:EipProtection test <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_eips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EipProtectionProtectedEipArgs', 'EipProtectionProtectedEipArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipProtectionArgs.__new__(EipProtectionArgs)

            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            if protected_eips is None and not opts.urn:
                raise TypeError("Missing required property 'protected_eips'")
            __props__.__dict__["protected_eips"] = protected_eips
            __props__.__dict__["region"] = region
        super(EipProtection, __self__).__init__(
            'sbercloud:Cfw/eipProtection:EipProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            protected_eips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EipProtectionProtectedEipArgs', 'EipProtectionProtectedEipArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipProtection':
        """
        Get an existing EipProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] object_id: The protected object ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EipProtectionProtectedEipArgs', 'EipProtectionProtectedEipArgsDict']]]] protected_eips: The protected EIP configurations.
               The object structure is documented below.
               
               <a name="cfw_protected_eip"></a>
               The `protected_eip` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipProtectionState.__new__(_EipProtectionState)

        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["protected_eips"] = protected_eips
        __props__.__dict__["region"] = region
        return EipProtection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The protected object ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="protectedEips")
    def protected_eips(self) -> pulumi.Output[Sequence['outputs.EipProtectionProtectedEip']]:
        """
        The protected EIP configurations.
        The object structure is documented below.

        <a name="cfw_protected_eip"></a>
        The `protected_eip` block supports:
        """
        return pulumi.get(self, "protected_eips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

