# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallArgs', 'Firewall']

@pulumi.input_type
class FirewallArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input['FirewallFlavorArgs'],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_inspection_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_status: Optional[pulumi.Input[_builtins.int]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips_protection_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 ips_switch_status: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Firewall resource.
        :param pulumi.Input['FirewallFlavorArgs'] flavor: Specifies the flavor of the firewall.
               Changing this parameter will create a new resource.
               The flavor structure is documented below.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the firewall.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_id: Specifies the ER ID of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_cidr: Specifies the inspection cidr of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_mode: Specifies the mode of the east-west firewall.
               The value can be: **er**.
        :param pulumi.Input[_builtins.int] east_west_firewall_status: Specifies the protection statue of the east-west firewall.
               The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the firewall.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] ips_protection_mode: Specifies the IPS protection mode of the firewall. Defaults to `0`.
               
               Valid values are as follows:
               + **0**: Observation Mode.
               + **1**: Strict Mode.
               + **2**: Medium Mode.
               + **3**: Loose Mode.
        :param pulumi.Input[_builtins.int] ips_switch_status: Specifies the IPS patch switch status of the firewall.
               The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] name: Specifies the firewall name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the firewall.
               
               <a name="Firewall_Flavor"></a>
               The `flavor` block supports:
        """
        pulumi.set(__self__, "flavor", flavor)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if east_west_firewall_er_id is not None:
            pulumi.set(__self__, "east_west_firewall_er_id", east_west_firewall_er_id)
        if east_west_firewall_inspection_cidr is not None:
            pulumi.set(__self__, "east_west_firewall_inspection_cidr", east_west_firewall_inspection_cidr)
        if east_west_firewall_mode is not None:
            pulumi.set(__self__, "east_west_firewall_mode", east_west_firewall_mode)
        if east_west_firewall_status is not None:
            pulumi.set(__self__, "east_west_firewall_status", east_west_firewall_status)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ips_protection_mode is not None:
            pulumi.set(__self__, "ips_protection_mode", ips_protection_mode)
        if ips_switch_status is not None:
            pulumi.set(__self__, "ips_switch_status", ips_switch_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input['FirewallFlavorArgs']:
        """
        Specifies the flavor of the firewall.
        Changing this parameter will create a new resource.
        The flavor structure is documented below.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input['FirewallFlavorArgs']):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the firewall.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallErId")
    def east_west_firewall_er_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ER ID of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_er_id")

    @east_west_firewall_er_id.setter
    def east_west_firewall_er_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_er_id", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallInspectionCidr")
    def east_west_firewall_inspection_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the inspection cidr of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_inspection_cidr")

    @east_west_firewall_inspection_cidr.setter
    def east_west_firewall_inspection_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_inspection_cidr", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallMode")
    def east_west_firewall_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of the east-west firewall.
        The value can be: **er**.
        """
        return pulumi.get(self, "east_west_firewall_mode")

    @east_west_firewall_mode.setter
    def east_west_firewall_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_mode", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallStatus")
    def east_west_firewall_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the protection statue of the east-west firewall.
        The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        """
        return pulumi.get(self, "east_west_firewall_status")

    @east_west_firewall_status.setter
    def east_west_firewall_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "east_west_firewall_status", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the firewall.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipsProtectionMode")
    def ips_protection_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPS protection mode of the firewall. Defaults to `0`.

        Valid values are as follows:
        + **0**: Observation Mode.
        + **1**: Strict Mode.
        + **2**: Medium Mode.
        + **3**: Loose Mode.
        """
        return pulumi.get(self, "ips_protection_mode")

    @ips_protection_mode.setter
    def ips_protection_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ips_protection_mode", value)

    @_builtins.property
    @pulumi.getter(name="ipsSwitchStatus")
    def ips_switch_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPS patch switch status of the firewall.
        The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        """
        return pulumi.get(self, "ips_switch_status")

    @ips_switch_status.setter
    def ips_switch_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ips_switch_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the firewall name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the firewall.

        <a name="Firewall_Flavor"></a>
        The `flavor` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FirewallState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_er_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_inspection_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_inspection_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_status: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.int]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input['FirewallFlavorArgs']] = None,
                 ha_type: Optional[pulumi.Input[_builtins.int]] = None,
                 ips_protection_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 ips_switch_status: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 protect_objects: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallProtectObjectArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Firewall resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the firewall.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_attachment_id: Enterprise Router and Firewall Connection ID.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_id: Specifies the ER ID of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_cidr: Specifies the inspection cidr of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_vpc_id: The east-west firewall inspection VPC ID.
        :param pulumi.Input[_builtins.str] east_west_firewall_mode: Specifies the mode of the east-west firewall.
               The value can be: **er**.
        :param pulumi.Input[_builtins.int] east_west_firewall_status: Specifies the protection statue of the east-west firewall.
               The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        :param pulumi.Input[_builtins.int] engine_type: The engine type
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the firewall.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['FirewallFlavorArgs'] flavor: Specifies the flavor of the firewall.
               Changing this parameter will create a new resource.
               The flavor structure is documented below.
        :param pulumi.Input[_builtins.int] ha_type: The HA type.
        :param pulumi.Input[_builtins.int] ips_protection_mode: Specifies the IPS protection mode of the firewall. Defaults to `0`.
               
               Valid values are as follows:
               + **0**: Observation Mode.
               + **1**: Strict Mode.
               + **2**: Medium Mode.
               + **3**: Loose Mode.
        :param pulumi.Input[_builtins.int] ips_switch_status: Specifies the IPS patch switch status of the firewall.
               The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] name: Specifies the firewall name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallProtectObjectArgs']]] protect_objects: The protect objects list.
               The protect_objects structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] service_type: The service type.
        :param pulumi.Input[_builtins.int] status: The firewall status.
        :param pulumi.Input[_builtins.bool] support_ipv6: Whether IPv6 is supported.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the firewall.
               
               <a name="Firewall_Flavor"></a>
               The `flavor` block supports:
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if east_west_firewall_er_attachment_id is not None:
            pulumi.set(__self__, "east_west_firewall_er_attachment_id", east_west_firewall_er_attachment_id)
        if east_west_firewall_er_id is not None:
            pulumi.set(__self__, "east_west_firewall_er_id", east_west_firewall_er_id)
        if east_west_firewall_inspection_cidr is not None:
            pulumi.set(__self__, "east_west_firewall_inspection_cidr", east_west_firewall_inspection_cidr)
        if east_west_firewall_inspection_vpc_id is not None:
            pulumi.set(__self__, "east_west_firewall_inspection_vpc_id", east_west_firewall_inspection_vpc_id)
        if east_west_firewall_mode is not None:
            pulumi.set(__self__, "east_west_firewall_mode", east_west_firewall_mode)
        if east_west_firewall_status is not None:
            pulumi.set(__self__, "east_west_firewall_status", east_west_firewall_status)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ha_type is not None:
            pulumi.set(__self__, "ha_type", ha_type)
        if ips_protection_mode is not None:
            pulumi.set(__self__, "ips_protection_mode", ips_protection_mode)
        if ips_switch_status is not None:
            pulumi.set(__self__, "ips_switch_status", ips_switch_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if protect_objects is not None:
            pulumi.set(__self__, "protect_objects", protect_objects)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_ipv6 is not None:
            pulumi.set(__self__, "support_ipv6", support_ipv6)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the firewall.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallErAttachmentId")
    def east_west_firewall_er_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enterprise Router and Firewall Connection ID.
        """
        return pulumi.get(self, "east_west_firewall_er_attachment_id")

    @east_west_firewall_er_attachment_id.setter
    def east_west_firewall_er_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_er_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallErId")
    def east_west_firewall_er_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ER ID of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_er_id")

    @east_west_firewall_er_id.setter
    def east_west_firewall_er_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_er_id", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallInspectionCidr")
    def east_west_firewall_inspection_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the inspection cidr of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_inspection_cidr")

    @east_west_firewall_inspection_cidr.setter
    def east_west_firewall_inspection_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_inspection_cidr", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallInspectionVpcId")
    def east_west_firewall_inspection_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The east-west firewall inspection VPC ID.
        """
        return pulumi.get(self, "east_west_firewall_inspection_vpc_id")

    @east_west_firewall_inspection_vpc_id.setter
    def east_west_firewall_inspection_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_inspection_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallMode")
    def east_west_firewall_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of the east-west firewall.
        The value can be: **er**.
        """
        return pulumi.get(self, "east_west_firewall_mode")

    @east_west_firewall_mode.setter
    def east_west_firewall_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "east_west_firewall_mode", value)

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallStatus")
    def east_west_firewall_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the protection statue of the east-west firewall.
        The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        """
        return pulumi.get(self, "east_west_firewall_status")

    @east_west_firewall_status.setter
    def east_west_firewall_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "east_west_firewall_status", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The engine type
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the firewall.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input['FirewallFlavorArgs']]:
        """
        Specifies the flavor of the firewall.
        Changing this parameter will create a new resource.
        The flavor structure is documented below.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input['FirewallFlavorArgs']]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="haType")
    def ha_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HA type.
        """
        return pulumi.get(self, "ha_type")

    @ha_type.setter
    def ha_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ha_type", value)

    @_builtins.property
    @pulumi.getter(name="ipsProtectionMode")
    def ips_protection_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPS protection mode of the firewall. Defaults to `0`.

        Valid values are as follows:
        + **0**: Observation Mode.
        + **1**: Strict Mode.
        + **2**: Medium Mode.
        + **3**: Loose Mode.
        """
        return pulumi.get(self, "ips_protection_mode")

    @ips_protection_mode.setter
    def ips_protection_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ips_protection_mode", value)

    @_builtins.property
    @pulumi.getter(name="ipsSwitchStatus")
    def ips_switch_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPS patch switch status of the firewall.
        The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        """
        return pulumi.get(self, "ips_switch_status")

    @ips_switch_status.setter
    def ips_switch_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ips_switch_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the firewall name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="protectObjects")
    def protect_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallProtectObjectArgs']]]]:
        """
        The protect objects list.
        The protect_objects structure is documented below.
        """
        return pulumi.get(self, "protect_objects")

    @protect_objects.setter
    def protect_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallProtectObjectArgs']]]]):
        pulumi.set(self, "protect_objects", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The service type.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The firewall status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether IPv6 is supported.
        """
        return pulumi.get(self, "support_ipv6")

    @support_ipv6.setter
    def support_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the firewall.

        <a name="Firewall_Flavor"></a>
        The `flavor` block supports:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("sbercloud:Cfw/firewall:Firewall")
class Firewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_inspection_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_status: Optional[pulumi.Input[_builtins.int]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[Union['FirewallFlavorArgs', 'FirewallFlavorArgsDict']]] = None,
                 ips_protection_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 ips_switch_status: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a CFW firewall resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            })
        ```

        ### PrePaid firewall

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            },
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            auto_renew="false")
        ```

        ### firewall with east-west firewall

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            east_west_firewall_inspection_cidr="172.16.1.0/24",
            east_west_firewall_er_id=test_sbercloud_er_instance["id"],
            east_west_firewall_mode="er",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            })
        ```

        ### firewall with IPS switch and IPS protection mode

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            },
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            auto_renew="false",
            ips_switch_status=1,
            ips_protection_mode=1)
        ```

        ## Import

        The firewall can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/firewall:Firewall test 6cb1ce47-9990-447e-b071-d167c5393871
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `period_unit`, `period` and `auto_renew`. It is generally

        recommended running `pulumi preview` after importing an CFW firewall. You can then decide if changes should be applied to

        the firewall, or the resource definition should be updated to align with the firewall. Also you can ignore changes as

        below.

        hcl

        resource "sbercloud_cfw_firewall" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              period_unit, period, auto_renew
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the firewall.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_id: Specifies the ER ID of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_cidr: Specifies the inspection cidr of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_mode: Specifies the mode of the east-west firewall.
               The value can be: **er**.
        :param pulumi.Input[_builtins.int] east_west_firewall_status: Specifies the protection statue of the east-west firewall.
               The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the firewall.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['FirewallFlavorArgs', 'FirewallFlavorArgsDict']] flavor: Specifies the flavor of the firewall.
               Changing this parameter will create a new resource.
               The flavor structure is documented below.
        :param pulumi.Input[_builtins.int] ips_protection_mode: Specifies the IPS protection mode of the firewall. Defaults to `0`.
               
               Valid values are as follows:
               + **0**: Observation Mode.
               + **1**: Strict Mode.
               + **2**: Medium Mode.
               + **3**: Loose Mode.
        :param pulumi.Input[_builtins.int] ips_switch_status: Specifies the IPS patch switch status of the firewall.
               The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] name: Specifies the firewall name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the firewall.
               
               <a name="Firewall_Flavor"></a>
               The `flavor` block supports:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW firewall resource within SberCloud.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            })
        ```

        ### PrePaid firewall

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            },
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            auto_renew="false")
        ```

        ### firewall with east-west firewall

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            east_west_firewall_inspection_cidr="172.16.1.0/24",
            east_west_firewall_er_id=test_sbercloud_er_instance["id"],
            east_west_firewall_mode="er",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            })
        ```

        ### firewall with IPS switch and IPS protection mode

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.cfw.Firewall("test",
            name="test",
            flavor={
                "version": "Professional",
            },
            tags={
                "key": "value",
                "foo": "bar",
            },
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            auto_renew="false",
            ips_switch_status=1,
            ips_protection_mode=1)
        ```

        ## Import

        The firewall can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/firewall:Firewall test 6cb1ce47-9990-447e-b071-d167c5393871
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `period_unit`, `period` and `auto_renew`. It is generally

        recommended running `pulumi preview` after importing an CFW firewall. You can then decide if changes should be applied to

        the firewall, or the resource definition should be updated to align with the firewall. Also you can ignore changes as

        below.

        hcl

        resource "sbercloud_cfw_firewall" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              period_unit, period, auto_renew
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param FirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_er_id: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_inspection_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 east_west_firewall_status: Optional[pulumi.Input[_builtins.int]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[Union['FirewallFlavorArgs', 'FirewallFlavorArgsDict']]] = None,
                 ips_protection_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 ips_switch_status: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallArgs.__new__(FirewallArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["east_west_firewall_er_id"] = east_west_firewall_er_id
            __props__.__dict__["east_west_firewall_inspection_cidr"] = east_west_firewall_inspection_cidr
            __props__.__dict__["east_west_firewall_mode"] = east_west_firewall_mode
            __props__.__dict__["east_west_firewall_status"] = east_west_firewall_status
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["ips_protection_mode"] = ips_protection_mode
            __props__.__dict__["ips_switch_status"] = ips_switch_status
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["east_west_firewall_er_attachment_id"] = None
            __props__.__dict__["east_west_firewall_inspection_vpc_id"] = None
            __props__.__dict__["engine_type"] = None
            __props__.__dict__["ha_type"] = None
            __props__.__dict__["protect_objects"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["support_ipv6"] = None
        super(Firewall, __self__).__init__(
            'sbercloud:Cfw/firewall:Firewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_er_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_er_id: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_inspection_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_inspection_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_mode: Optional[pulumi.Input[_builtins.str]] = None,
            east_west_firewall_status: Optional[pulumi.Input[_builtins.int]] = None,
            engine_type: Optional[pulumi.Input[_builtins.int]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[Union['FirewallFlavorArgs', 'FirewallFlavorArgsDict']]] = None,
            ha_type: Optional[pulumi.Input[_builtins.int]] = None,
            ips_protection_mode: Optional[pulumi.Input[_builtins.int]] = None,
            ips_switch_status: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            protect_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallProtectObjectArgs', 'FirewallProtectObjectArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            support_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Firewall':
        """
        Get an existing Firewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the firewall.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_attachment_id: Enterprise Router and Firewall Connection ID.
        :param pulumi.Input[_builtins.str] east_west_firewall_er_id: Specifies the ER ID of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_cidr: Specifies the inspection cidr of the east-west firewall.
        :param pulumi.Input[_builtins.str] east_west_firewall_inspection_vpc_id: The east-west firewall inspection VPC ID.
        :param pulumi.Input[_builtins.str] east_west_firewall_mode: Specifies the mode of the east-west firewall.
               The value can be: **er**.
        :param pulumi.Input[_builtins.int] east_west_firewall_status: Specifies the protection statue of the east-west firewall.
               The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        :param pulumi.Input[_builtins.int] engine_type: The engine type
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the firewall.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['FirewallFlavorArgs', 'FirewallFlavorArgsDict']] flavor: Specifies the flavor of the firewall.
               Changing this parameter will create a new resource.
               The flavor structure is documented below.
        :param pulumi.Input[_builtins.int] ha_type: The HA type.
        :param pulumi.Input[_builtins.int] ips_protection_mode: Specifies the IPS protection mode of the firewall. Defaults to `0`.
               
               Valid values are as follows:
               + **0**: Observation Mode.
               + **1**: Strict Mode.
               + **2**: Medium Mode.
               + **3**: Loose Mode.
        :param pulumi.Input[_builtins.int] ips_switch_status: Specifies the IPS patch switch status of the firewall.
               The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        :param pulumi.Input[_builtins.str] name: Specifies the firewall name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallProtectObjectArgs', 'FirewallProtectObjectArgsDict']]]] protect_objects: The protect objects list.
               The protect_objects structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] service_type: The service type.
        :param pulumi.Input[_builtins.int] status: The firewall status.
        :param pulumi.Input[_builtins.bool] support_ipv6: Whether IPv6 is supported.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the firewall.
               
               <a name="Firewall_Flavor"></a>
               The `flavor` block supports:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallState.__new__(_FirewallState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["east_west_firewall_er_attachment_id"] = east_west_firewall_er_attachment_id
        __props__.__dict__["east_west_firewall_er_id"] = east_west_firewall_er_id
        __props__.__dict__["east_west_firewall_inspection_cidr"] = east_west_firewall_inspection_cidr
        __props__.__dict__["east_west_firewall_inspection_vpc_id"] = east_west_firewall_inspection_vpc_id
        __props__.__dict__["east_west_firewall_mode"] = east_west_firewall_mode
        __props__.__dict__["east_west_firewall_status"] = east_west_firewall_status
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["ha_type"] = ha_type
        __props__.__dict__["ips_protection_mode"] = ips_protection_mode
        __props__.__dict__["ips_switch_status"] = ips_switch_status
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["protect_objects"] = protect_objects
        __props__.__dict__["region"] = region
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["status"] = status
        __props__.__dict__["support_ipv6"] = support_ipv6
        __props__.__dict__["tags"] = tags
        return Firewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging mode of the firewall.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallErAttachmentId")
    def east_west_firewall_er_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Enterprise Router and Firewall Connection ID.
        """
        return pulumi.get(self, "east_west_firewall_er_attachment_id")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallErId")
    def east_west_firewall_er_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ER ID of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_er_id")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallInspectionCidr")
    def east_west_firewall_inspection_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the inspection cidr of the east-west firewall.
        """
        return pulumi.get(self, "east_west_firewall_inspection_cidr")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallInspectionVpcId")
    def east_west_firewall_inspection_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The east-west firewall inspection VPC ID.
        """
        return pulumi.get(self, "east_west_firewall_inspection_vpc_id")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallMode")
    def east_west_firewall_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of the east-west firewall.
        The value can be: **er**.
        """
        return pulumi.get(self, "east_west_firewall_mode")

    @_builtins.property
    @pulumi.getter(name="eastWestFirewallStatus")
    def east_west_firewall_status(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the protection statue of the east-west firewall.
        The value can be: `0`(enabled) and `1`(disabled). Defaults to `0`.
        """
        return pulumi.get(self, "east_west_firewall_status")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[_builtins.int]:
        """
        The engine type
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID of the firewall.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output['outputs.FirewallFlavor']:
        """
        Specifies the flavor of the firewall.
        Changing this parameter will create a new resource.
        The flavor structure is documented below.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="haType")
    def ha_type(self) -> pulumi.Output[_builtins.int]:
        """
        The HA type.
        """
        return pulumi.get(self, "ha_type")

    @_builtins.property
    @pulumi.getter(name="ipsProtectionMode")
    def ips_protection_mode(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the IPS protection mode of the firewall. Defaults to `0`.

        Valid values are as follows:
        + **0**: Observation Mode.
        + **1**: Strict Mode.
        + **2**: Medium Mode.
        + **3**: Loose Mode.
        """
        return pulumi.get(self, "ips_protection_mode")

    @_builtins.property
    @pulumi.getter(name="ipsSwitchStatus")
    def ips_switch_status(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the IPS patch switch status of the firewall.
        The value can be `0`(disabled) and `1`(enabled). Defaults to `0`.
        """
        return pulumi.get(self, "ips_switch_status")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the firewall name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="protectObjects")
    def protect_objects(self) -> pulumi.Output[Sequence['outputs.FirewallProtectObject']]:
        """
        The protect objects list.
        The protect_objects structure is documented below.
        """
        return pulumi.get(self, "protect_objects")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.int]:
        """
        The service type.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The firewall status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether IPv6 is supported.
        """
        return pulumi.get(self, "support_ipv6")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the firewall.

        <a name="Firewall_Flavor"></a>
        The `flavor` block supports:
        """
        return pulumi.get(self, "tags")

