# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressGroupMembersResult',
    'AwaitableGetAddressGroupMembersResult',
    'get_address_group_members',
    'get_address_group_members_output',
]

@pulumi.output_type
class GetAddressGroupMembersResult:
    """
    A collection of values returned by getAddressGroupMembers.
    """
    def __init__(__self__, address=None, fw_instance_id=None, group_id=None, id=None, item_id=None, key_word=None, query_address_set_type=None, records=None, region=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item_id and not isinstance(item_id, str):
            raise TypeError("Expected argument 'item_id' to be a str")
        pulumi.set(__self__, "item_id", item_id)
        if key_word and not isinstance(key_word, str):
            raise TypeError("Expected argument 'key_word' to be a str")
        pulumi.set(__self__, "key_word", key_word)
        if query_address_set_type and not isinstance(query_address_set_type, str):
            raise TypeError("Expected argument 'query_address_set_type' to be a str")
        pulumi.set(__self__, "query_address_set_type", query_address_set_type)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[_builtins.str]:
        """
        The ID of an address group member.
        """
        return pulumi.get(self, "item_id")

    @_builtins.property
    @pulumi.getter(name="keyWord")
    def key_word(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_word")

    @_builtins.property
    @pulumi.getter(name="queryAddressSetType")
    def query_address_set_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "query_address_set_type")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetAddressGroupMembersRecordResult']:
        """
        The IP address group member list.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAddressGroupMembersResult(GetAddressGroupMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressGroupMembersResult(
            address=self.address,
            fw_instance_id=self.fw_instance_id,
            group_id=self.group_id,
            id=self.id,
            item_id=self.item_id,
            key_word=self.key_word,
            query_address_set_type=self.query_address_set_type,
            records=self.records,
            region=self.region)


def get_address_group_members(address: Optional[_builtins.str] = None,
                              fw_instance_id: Optional[_builtins.str] = None,
                              group_id: Optional[_builtins.str] = None,
                              item_id: Optional[_builtins.str] = None,
                              key_word: Optional[_builtins.str] = None,
                              query_address_set_type: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressGroupMembersResult:
    """
    Use this data source to get the list of CFW address group members.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    group_id = config.require_object("groupId")
    test = sbercloud.Cfw.get_address_group_members(group_id=group_id)
    ```


    :param _builtins.str address: Specifies the IP address
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the ID of the IP address group.
    :param _builtins.str item_id: Specifies the address group member ID.
    :param _builtins.str key_word: Specifies the keyword.
    :param _builtins.str query_address_set_type: Specifies the query address group type.
           + **0** means custom define address set.
           + **1** means predefined address set.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['itemId'] = item_id
    __args__['keyWord'] = key_word
    __args__['queryAddressSetType'] = query_address_set_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getAddressGroupMembers:getAddressGroupMembers', __args__, opts=opts, typ=GetAddressGroupMembersResult).value

    return AwaitableGetAddressGroupMembersResult(
        address=pulumi.get(__ret__, 'address'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        item_id=pulumi.get(__ret__, 'item_id'),
        key_word=pulumi.get(__ret__, 'key_word'),
        query_address_set_type=pulumi.get(__ret__, 'query_address_set_type'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'))
def get_address_group_members_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     item_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     key_word: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     query_address_set_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressGroupMembersResult]:
    """
    Use this data source to get the list of CFW address group members.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    group_id = config.require_object("groupId")
    test = sbercloud.Cfw.get_address_group_members(group_id=group_id)
    ```


    :param _builtins.str address: Specifies the IP address
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the ID of the IP address group.
    :param _builtins.str item_id: Specifies the address group member ID.
    :param _builtins.str key_word: Specifies the keyword.
    :param _builtins.str query_address_set_type: Specifies the query address group type.
           + **0** means custom define address set.
           + **1** means predefined address set.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['itemId'] = item_id
    __args__['keyWord'] = key_word
    __args__['queryAddressSetType'] = query_address_set_type
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getAddressGroupMembers:getAddressGroupMembers', __args__, opts=opts, typ=GetAddressGroupMembersResult)
    return __ret__.apply(lambda __response__: GetAddressGroupMembersResult(
        address=pulumi.get(__response__, 'address'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        item_id=pulumi.get(__response__, 'item_id'),
        key_word=pulumi.get(__response__, 'key_word'),
        query_address_set_type=pulumi.get(__response__, 'query_address_set_type'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region')))
