# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressGroupsResult',
    'AwaitableGetAddressGroupsResult',
    'get_address_groups',
    'get_address_groups_output',
]

@pulumi.output_type
class GetAddressGroupsResult:
    """
    A collection of values returned by getAddressGroups.
    """
    def __init__(__self__, address=None, address_groups=None, address_type=None, enterprise_project_id=None, fw_instance_id=None, id=None, key_word=None, name=None, object_id=None, query_address_set_type=None, region=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if address_groups and not isinstance(address_groups, list):
            raise TypeError("Expected argument 'address_groups' to be a list")
        pulumi.set(__self__, "address_groups", address_groups)
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_word and not isinstance(key_word, str):
            raise TypeError("Expected argument 'key_word' to be a str")
        pulumi.set(__self__, "key_word", key_word)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if query_address_set_type and not isinstance(query_address_set_type, int):
            raise TypeError("Expected argument 'query_address_set_type' to be a int")
        pulumi.set(__self__, "query_address_set_type", query_address_set_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressGroups")
    def address_groups(self) -> Sequence['outputs.GetAddressGroupsAddressGroupResult']:
        """
        The IP address group list.
        """
        return pulumi.get(self, "address_groups")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[_builtins.str]:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyWord")
    def key_word(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_word")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The IP address group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="queryAddressSetType")
    def query_address_set_type(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "query_address_set_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAddressGroupsResult(GetAddressGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressGroupsResult(
            address=self.address,
            address_groups=self.address_groups,
            address_type=self.address_type,
            enterprise_project_id=self.enterprise_project_id,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            key_word=self.key_word,
            name=self.name,
            object_id=self.object_id,
            query_address_set_type=self.query_address_set_type,
            region=self.region)


def get_address_groups(address: Optional[_builtins.str] = None,
                       address_type: Optional[_builtins.str] = None,
                       enterprise_project_id: Optional[_builtins.str] = None,
                       fw_instance_id: Optional[_builtins.str] = None,
                       key_word: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       object_id: Optional[_builtins.str] = None,
                       query_address_set_type: Optional[_builtins.int] = None,
                       region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressGroupsResult:
    """
    Use this data source to get the list of CFW address groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_address_groups(object_id=object_id)
    ```


    :param _builtins.str address: Specifies IP address of the IP address group.
    :param _builtins.str address_type: Specifies the IP address type.
           The value can be **0** (IPv4) or **1** (IPv6).
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id to which the IP address group belongs.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str key_word: Specifies the keyword of the address group description.
    :param _builtins.str name: Specifies the name of the address group.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.int query_address_set_type: Specifies the address group type of the query.
           + **0:** indicates a custom IP address group.
           + **1:** indicates a predefined IP address group.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressType'] = address_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['keyWord'] = key_word
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['queryAddressSetType'] = query_address_set_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getAddressGroups:getAddressGroups', __args__, opts=opts, typ=GetAddressGroupsResult).value

    return AwaitableGetAddressGroupsResult(
        address=pulumi.get(__ret__, 'address'),
        address_groups=pulumi.get(__ret__, 'address_groups'),
        address_type=pulumi.get(__ret__, 'address_type'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        key_word=pulumi.get(__ret__, 'key_word'),
        name=pulumi.get(__ret__, 'name'),
        object_id=pulumi.get(__ret__, 'object_id'),
        query_address_set_type=pulumi.get(__ret__, 'query_address_set_type'),
        region=pulumi.get(__ret__, 'region'))
def get_address_groups_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              address_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              key_word: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              object_id: Optional[pulumi.Input[_builtins.str]] = None,
                              query_address_set_type: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressGroupsResult]:
    """
    Use this data source to get the list of CFW address groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_address_groups(object_id=object_id)
    ```


    :param _builtins.str address: Specifies IP address of the IP address group.
    :param _builtins.str address_type: Specifies the IP address type.
           The value can be **0** (IPv4) or **1** (IPv6).
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id to which the IP address group belongs.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str key_word: Specifies the keyword of the address group description.
    :param _builtins.str name: Specifies the name of the address group.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.int query_address_set_type: Specifies the address group type of the query.
           + **0:** indicates a custom IP address group.
           + **1:** indicates a predefined IP address group.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressType'] = address_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['keyWord'] = key_word
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['queryAddressSetType'] = query_address_set_type
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getAddressGroups:getAddressGroups', __args__, opts=opts, typ=GetAddressGroupsResult)
    return __ret__.apply(lambda __response__: GetAddressGroupsResult(
        address=pulumi.get(__response__, 'address'),
        address_groups=pulumi.get(__response__, 'address_groups'),
        address_type=pulumi.get(__response__, 'address_type'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        key_word=pulumi.get(__response__, 'key_word'),
        name=pulumi.get(__response__, 'name'),
        object_id=pulumi.get(__response__, 'object_id'),
        query_address_set_type=pulumi.get(__response__, 'query_address_set_type'),
        region=pulumi.get(__response__, 'region')))
