# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBlackWhiteListsResult',
    'AwaitableGetBlackWhiteListsResult',
    'get_black_white_lists',
    'get_black_white_lists_output',
]

@pulumi.output_type
class GetBlackWhiteListsResult:
    """
    A collection of values returned by getBlackWhiteLists.
    """
    def __init__(__self__, address=None, address_type=None, description=None, direction=None, fw_instance_id=None, id=None, list_id=None, list_type=None, object_id=None, port=None, protocol=None, records=None, region=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if list_id and not isinstance(list_id, str):
            raise TypeError("Expected argument 'list_id' to be a str")
        pulumi.set(__self__, "list_id", list_id)
        if list_type and not isinstance(list_type, int):
            raise TypeError("Expected argument 'list_type' to be a int")
        pulumi.set(__self__, "list_type", list_type)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if port and not isinstance(port, str):
            raise TypeError("Expected argument 'port' to be a str")
        pulumi.set(__self__, "port", port)
        if protocol and not isinstance(protocol, int):
            raise TypeError("Expected argument 'protocol' to be a int")
        pulumi.set(__self__, "protocol", protocol)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[_builtins.str]:
        """
        The IP address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        The direction of a black or white address.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[_builtins.str]:
        """
        The blacklist/whitelist ID.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter(name="listType")
    def list_type(self) -> _builtins.int:
        return pulumi.get(self, "list_type")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.int]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetBlackWhiteListsRecordResult']:
        """
        The blacklist and whitelist records.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetBlackWhiteListsResult(GetBlackWhiteListsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlackWhiteListsResult(
            address=self.address,
            address_type=self.address_type,
            description=self.description,
            direction=self.direction,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            list_id=self.list_id,
            list_type=self.list_type,
            object_id=self.object_id,
            port=self.port,
            protocol=self.protocol,
            records=self.records,
            region=self.region)


def get_black_white_lists(address: Optional[_builtins.str] = None,
                          address_type: Optional[_builtins.str] = None,
                          description: Optional[_builtins.str] = None,
                          direction: Optional[_builtins.str] = None,
                          fw_instance_id: Optional[_builtins.str] = None,
                          list_id: Optional[_builtins.str] = None,
                          list_type: Optional[_builtins.int] = None,
                          object_id: Optional[_builtins.str] = None,
                          port: Optional[_builtins.str] = None,
                          protocol: Optional[_builtins.int] = None,
                          region: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlackWhiteListsResult:
    """
    Use this data source to get the list of CFW blacklists and whitelists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    list_type = config.require_object("listType")
    test = sbercloud.Cfw.get_black_white_lists(object_id=object_id,
        list_type=list_type)
    ```


    :param _builtins.str address: Specifies the IP address.
    :param _builtins.str address_type: Specifies the IP address type.
           The valid value can be **0** (IPv4).
    :param _builtins.str description: Specifies the description.
    :param _builtins.str direction: Specifies the direction of a black or white address.
           The options are as follows:
           + **0**: source address;
           + **1**: destination address;
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str list_id: Specifies the blacklist/whitelist ID.
    :param _builtins.int list_type: Specifies the blacklist/whitelist type.
           The options are `4` (blacklist) and `5` (whitelist).
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str port: Specifies the port.
    :param _builtins.int protocol: Specifies The protocol type.
           The options are as follows:
           + **6**: TCP;
           + **17**: UDP;
           + **1**: ICMP;
           + **-1**: any protocol;
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressType'] = address_type
    __args__['description'] = description
    __args__['direction'] = direction
    __args__['fwInstanceId'] = fw_instance_id
    __args__['listId'] = list_id
    __args__['listType'] = list_type
    __args__['objectId'] = object_id
    __args__['port'] = port
    __args__['protocol'] = protocol
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getBlackWhiteLists:getBlackWhiteLists', __args__, opts=opts, typ=GetBlackWhiteListsResult).value

    return AwaitableGetBlackWhiteListsResult(
        address=pulumi.get(__ret__, 'address'),
        address_type=pulumi.get(__ret__, 'address_type'),
        description=pulumi.get(__ret__, 'description'),
        direction=pulumi.get(__ret__, 'direction'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        list_id=pulumi.get(__ret__, 'list_id'),
        list_type=pulumi.get(__ret__, 'list_type'),
        object_id=pulumi.get(__ret__, 'object_id'),
        port=pulumi.get(__ret__, 'port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'))
def get_black_white_lists_output(address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 address_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 list_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 list_type: Optional[pulumi.Input[_builtins.int]] = None,
                                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 protocol: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                 region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBlackWhiteListsResult]:
    """
    Use this data source to get the list of CFW blacklists and whitelists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    list_type = config.require_object("listType")
    test = sbercloud.Cfw.get_black_white_lists(object_id=object_id,
        list_type=list_type)
    ```


    :param _builtins.str address: Specifies the IP address.
    :param _builtins.str address_type: Specifies the IP address type.
           The valid value can be **0** (IPv4).
    :param _builtins.str description: Specifies the description.
    :param _builtins.str direction: Specifies the direction of a black or white address.
           The options are as follows:
           + **0**: source address;
           + **1**: destination address;
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str list_id: Specifies the blacklist/whitelist ID.
    :param _builtins.int list_type: Specifies the blacklist/whitelist type.
           The options are `4` (blacklist) and `5` (whitelist).
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str port: Specifies the port.
    :param _builtins.int protocol: Specifies The protocol type.
           The options are as follows:
           + **6**: TCP;
           + **17**: UDP;
           + **1**: ICMP;
           + **-1**: any protocol;
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['address'] = address
    __args__['addressType'] = address_type
    __args__['description'] = description
    __args__['direction'] = direction
    __args__['fwInstanceId'] = fw_instance_id
    __args__['listId'] = list_id
    __args__['listType'] = list_type
    __args__['objectId'] = object_id
    __args__['port'] = port
    __args__['protocol'] = protocol
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getBlackWhiteLists:getBlackWhiteLists', __args__, opts=opts, typ=GetBlackWhiteListsResult)
    return __ret__.apply(lambda __response__: GetBlackWhiteListsResult(
        address=pulumi.get(__response__, 'address'),
        address_type=pulumi.get(__response__, 'address_type'),
        description=pulumi.get(__response__, 'description'),
        direction=pulumi.get(__response__, 'direction'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        list_id=pulumi.get(__response__, 'list_id'),
        list_type=pulumi.get(__response__, 'list_type'),
        object_id=pulumi.get(__response__, 'object_id'),
        port=pulumi.get(__response__, 'port'),
        protocol=pulumi.get(__response__, 'protocol'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region')))
