# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCaptureTaskResultsResult',
    'AwaitableGetCaptureTaskResultsResult',
    'get_capture_task_results',
    'get_capture_task_results_output',
]

@pulumi.output_type
class GetCaptureTaskResultsResult:
    """
    A collection of values returned by getCaptureTaskResults.
    """
    def __init__(__self__, captcha=None, expires=None, file_lists=None, fw_instance_id=None, id=None, ips=None, region=None, request_headers=None, task_id=None, type=None, url=None):
        if captcha and not isinstance(captcha, str):
            raise TypeError("Expected argument 'captcha' to be a str")
        pulumi.set(__self__, "captcha", captcha)
        if expires and not isinstance(expires, int):
            raise TypeError("Expected argument 'expires' to be a int")
        pulumi.set(__self__, "expires", expires)
        if file_lists and not isinstance(file_lists, list):
            raise TypeError("Expected argument 'file_lists' to be a list")
        pulumi.set(__self__, "file_lists", file_lists)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if request_headers and not isinstance(request_headers, list):
            raise TypeError("Expected argument 'request_headers' to be a list")
        pulumi.set(__self__, "request_headers", request_headers)
        if task_id and not isinstance(task_id, str):
            raise TypeError("Expected argument 'task_id' to be a str")
        pulumi.set(__self__, "task_id", task_id)
        if type and not isinstance(type, int):
            raise TypeError("Expected argument 'type' to be a int")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def captcha(self) -> _builtins.str:
        """
        The captcha.
        """
        return pulumi.get(self, "captcha")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> _builtins.int:
        """
        The expiration time of the download link.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter(name="fileLists")
    def file_lists(self) -> Sequence['outputs.GetCaptureTaskResultsFileListResult']:
        """
        The capture file list.
        """
        return pulumi.get(self, "file_lists")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Sequence['outputs.GetCaptureTaskResultsRequestHeaderResult']:
        """
        The request header.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> _builtins.str:
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The download link.
        """
        return pulumi.get(self, "url")


class AwaitableGetCaptureTaskResultsResult(GetCaptureTaskResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCaptureTaskResultsResult(
            captcha=self.captcha,
            expires=self.expires,
            file_lists=self.file_lists,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            ips=self.ips,
            region=self.region,
            request_headers=self.request_headers,
            task_id=self.task_id,
            type=self.type,
            url=self.url)


def get_capture_task_results(fw_instance_id: Optional[_builtins.str] = None,
                             ips: Optional[Sequence[_builtins.str]] = None,
                             region: Optional[_builtins.str] = None,
                             task_id: Optional[_builtins.str] = None,
                             type: Optional[_builtins.int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCaptureTaskResultsResult:
    """
    Use this data source to get the list of CFW capture task results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    task_id = config.require_object("taskId")
    test = sbercloud.Cfw.get_capture_task_results(fw_instance_id=fw_instance_id,
        task_id=task_id)
    ```


    :param _builtins.str fw_instance_id: Specifies the ID of the firewall instance.
    :param Sequence[_builtins.str] ips: Specifies the public IP address ranges.
           A maximum of three address ranges can be specified.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str task_id: Specifies the capture task ID.
    :param _builtins.int type: Specifies whether to set a public IP address for downloading.
           The valid values are as follows:
           + **0**: unlimited;
           + **1**: set a public IP address for downloading. Currently, this feature can be used in the
           following regions: **cn-north-11**, **cn-east-5**, **af-south-1**, **ap-southeast-1**,
           **ap-southeast-3**, **ap-southeast-2**, **ap-southeast-4**, **tr-west-1**, **la-north-2**,
           **sa-brazil-1**, **la-south-2**, **me-east-1**.
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['ips'] = ips
    __args__['region'] = region
    __args__['taskId'] = task_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getCaptureTaskResults:getCaptureTaskResults', __args__, opts=opts, typ=GetCaptureTaskResultsResult).value

    return AwaitableGetCaptureTaskResultsResult(
        captcha=pulumi.get(__ret__, 'captcha'),
        expires=pulumi.get(__ret__, 'expires'),
        file_lists=pulumi.get(__ret__, 'file_lists'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ips=pulumi.get(__ret__, 'ips'),
        region=pulumi.get(__ret__, 'region'),
        request_headers=pulumi.get(__ret__, 'request_headers'),
        task_id=pulumi.get(__ret__, 'task_id'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'))
def get_capture_task_results_output(fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    ips: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    task_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    type: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCaptureTaskResultsResult]:
    """
    Use this data source to get the list of CFW capture task results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    task_id = config.require_object("taskId")
    test = sbercloud.Cfw.get_capture_task_results(fw_instance_id=fw_instance_id,
        task_id=task_id)
    ```


    :param _builtins.str fw_instance_id: Specifies the ID of the firewall instance.
    :param Sequence[_builtins.str] ips: Specifies the public IP address ranges.
           A maximum of three address ranges can be specified.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str task_id: Specifies the capture task ID.
    :param _builtins.int type: Specifies whether to set a public IP address for downloading.
           The valid values are as follows:
           + **0**: unlimited;
           + **1**: set a public IP address for downloading. Currently, this feature can be used in the
           following regions: **cn-north-11**, **cn-east-5**, **af-south-1**, **ap-southeast-1**,
           **ap-southeast-3**, **ap-southeast-2**, **ap-southeast-4**, **tr-west-1**, **la-north-2**,
           **sa-brazil-1**, **la-south-2**, **me-east-1**.
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['ips'] = ips
    __args__['region'] = region
    __args__['taskId'] = task_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getCaptureTaskResults:getCaptureTaskResults', __args__, opts=opts, typ=GetCaptureTaskResultsResult)
    return __ret__.apply(lambda __response__: GetCaptureTaskResultsResult(
        captcha=pulumi.get(__response__, 'captcha'),
        expires=pulumi.get(__response__, 'expires'),
        file_lists=pulumi.get(__response__, 'file_lists'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        ips=pulumi.get(__response__, 'ips'),
        region=pulumi.get(__response__, 'region'),
        request_headers=pulumi.get(__response__, 'request_headers'),
        task_id=pulumi.get(__response__, 'task_id'),
        type=pulumi.get(__response__, 'type'),
        url=pulumi.get(__response__, 'url')))
