# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainNameGroupsResult',
    'AwaitableGetDomainNameGroupsResult',
    'get_domain_name_groups',
    'get_domain_name_groups_output',
]

@pulumi.output_type
class GetDomainNameGroupsResult:
    """
    A collection of values returned by getDomainNameGroups.
    """
    def __init__(__self__, config_status=None, enterprise_project_id=None, fw_instance_id=None, group_id=None, id=None, key_word=None, name=None, object_id=None, records=None, ref_count=None, region=None, type=None):
        if config_status and not isinstance(config_status, str):
            raise TypeError("Expected argument 'config_status' to be a str")
        pulumi.set(__self__, "config_status", config_status)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_word and not isinstance(key_word, str):
            raise TypeError("Expected argument 'key_word' to be a str")
        pulumi.set(__self__, "key_word", key_word)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if ref_count and not isinstance(ref_count, str):
            raise TypeError("Expected argument 'ref_count' to be a str")
        pulumi.set(__self__, "ref_count", ref_count)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configStatus")
    def config_status(self) -> Optional[_builtins.str]:
        """
        The configuration status.
        """
        return pulumi.get(self, "config_status")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        The domain name group ID.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyWord")
    def key_word(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_word")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetDomainNameGroupsRecordResult']:
        """
        The domain name group list.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> Optional[_builtins.str]:
        """
        The domain name group reference count.
        """
        return pulumi.get(self, "ref_count")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The domain name group type.
        """
        return pulumi.get(self, "type")


class AwaitableGetDomainNameGroupsResult(GetDomainNameGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainNameGroupsResult(
            config_status=self.config_status,
            enterprise_project_id=self.enterprise_project_id,
            fw_instance_id=self.fw_instance_id,
            group_id=self.group_id,
            id=self.id,
            key_word=self.key_word,
            name=self.name,
            object_id=self.object_id,
            records=self.records,
            ref_count=self.ref_count,
            region=self.region,
            type=self.type)


def get_domain_name_groups(config_status: Optional[_builtins.str] = None,
                           enterprise_project_id: Optional[_builtins.str] = None,
                           fw_instance_id: Optional[_builtins.str] = None,
                           group_id: Optional[_builtins.str] = None,
                           key_word: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           object_id: Optional[_builtins.str] = None,
                           ref_count: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           type: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainNameGroupsResult:
    """
    Use this data source to get the list of CFW domain name groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_domain_name_groups(fw_instance_id=fw_instance_id,
        object_id=object_id)
    ```


    :param _builtins.str config_status: Specifies the configuration status.
           The valid values are as follows:
           + **-1**: not configured.
           + **0**: configuration failed.
           + **1**: configuration succeeded.
           + **2**: configuration in progress.
           + **3**: normal.
           + **4**: configuration exception - domain group usage.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the domain name group ID.
    :param _builtins.str key_word: Specifies the key word.
    :param _builtins.str name: Specifies the name of a domain name group.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str ref_count: Specifies the domain name group reference count.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the domain name group type.
           The value can be:
           + **0**: means application type;
           + **1**: means network type.
    """
    __args__ = dict()
    __args__['configStatus'] = config_status
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['keyWord'] = key_word
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['refCount'] = ref_count
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getDomainNameGroups:getDomainNameGroups', __args__, opts=opts, typ=GetDomainNameGroupsResult).value

    return AwaitableGetDomainNameGroupsResult(
        config_status=pulumi.get(__ret__, 'config_status'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        key_word=pulumi.get(__ret__, 'key_word'),
        name=pulumi.get(__ret__, 'name'),
        object_id=pulumi.get(__ret__, 'object_id'),
        records=pulumi.get(__ret__, 'records'),
        ref_count=pulumi.get(__ret__, 'ref_count'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_domain_name_groups_output(config_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  key_word: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  object_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  ref_count: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainNameGroupsResult]:
    """
    Use this data source to get the list of CFW domain name groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_domain_name_groups(fw_instance_id=fw_instance_id,
        object_id=object_id)
    ```


    :param _builtins.str config_status: Specifies the configuration status.
           The valid values are as follows:
           + **-1**: not configured.
           + **0**: configuration failed.
           + **1**: configuration succeeded.
           + **2**: configuration in progress.
           + **3**: normal.
           + **4**: configuration exception - domain group usage.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the domain name group ID.
    :param _builtins.str key_word: Specifies the key word.
    :param _builtins.str name: Specifies the name of a domain name group.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str ref_count: Specifies the domain name group reference count.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the domain name group type.
           The value can be:
           + **0**: means application type;
           + **1**: means network type.
    """
    __args__ = dict()
    __args__['configStatus'] = config_status
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['keyWord'] = key_word
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['refCount'] = ref_count
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getDomainNameGroups:getDomainNameGroups', __args__, opts=opts, typ=GetDomainNameGroupsResult)
    return __ret__.apply(lambda __response__: GetDomainNameGroupsResult(
        config_status=pulumi.get(__response__, 'config_status'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        key_word=pulumi.get(__response__, 'key_word'),
        name=pulumi.get(__response__, 'name'),
        object_id=pulumi.get(__response__, 'object_id'),
        records=pulumi.get(__response__, 'records'),
        ref_count=pulumi.get(__response__, 'ref_count'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
