# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDomainNameParseIpListResult',
    'AwaitableGetDomainNameParseIpListResult',
    'get_domain_name_parse_ip_list',
    'get_domain_name_parse_ip_list_output',
]

@pulumi.output_type
class GetDomainNameParseIpListResult:
    """
    A collection of values returned by getDomainNameParseIpList.
    """
    def __init__(__self__, address_type=None, datas=None, domain_address_id=None, domain_name=None, enterprise_project_id=None, fw_instance_id=None, group_id=None, id=None, region=None):
        if address_type and not isinstance(address_type, str):
            raise TypeError("Expected argument 'address_type' to be a str")
        pulumi.set(__self__, "address_type", address_type)
        if datas and not isinstance(datas, list):
            raise TypeError("Expected argument 'datas' to be a list")
        pulumi.set(__self__, "datas", datas)
        if domain_address_id and not isinstance(domain_address_id, str):
            raise TypeError("Expected argument 'domain_address_id' to be a str")
        pulumi.set(__self__, "domain_address_id", domain_address_id)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Sequence[_builtins.str]:
        """
        The IP address list for domain name resolution.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="domainAddressId")
    def domain_address_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain_address_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetDomainNameParseIpListResult(GetDomainNameParseIpListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainNameParseIpListResult(
            address_type=self.address_type,
            datas=self.datas,
            domain_address_id=self.domain_address_id,
            domain_name=self.domain_name,
            enterprise_project_id=self.enterprise_project_id,
            fw_instance_id=self.fw_instance_id,
            group_id=self.group_id,
            id=self.id,
            region=self.region)


def get_domain_name_parse_ip_list(address_type: Optional[_builtins.str] = None,
                                  domain_address_id: Optional[_builtins.str] = None,
                                  domain_name: Optional[_builtins.str] = None,
                                  enterprise_project_id: Optional[_builtins.str] = None,
                                  fw_instance_id: Optional[_builtins.str] = None,
                                  group_id: Optional[_builtins.str] = None,
                                  region: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainNameParseIpListResult:
    """
    Use this data source to get the DNS resolution result of a domain name.

    ## Example Usage

    ### DNS resolution result of a domain name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cfw.get_domain_name_parse_ip_list(domain_name="www.cloud.ru")
    ```

    ### DNS resolution result of a domain name in a domain name group

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    domain_name_group_id = config.require_object("domainNameGroupId")
    domain_address_id = config.require_object("domainAddressId")
    test = sbercloud.Cfw.get_domain_name_parse_ip_list(fw_instance_id=fw_instance_id,
        group_id=domain_name_group_id,
        domain_address_id=domain_address_id)
    ```


    :param _builtins.str address_type: Specifies the address type.
           The valid value can be **0** (IPv4) or **1** (IPv6).
    :param _builtins.str domain_address_id: Specifies the domain name ID in a domain name group.
    :param _builtins.str domain_name: Specifies the domain name.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str group_id: Specifies the domain name group ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['addressType'] = address_type
    __args__['domainAddressId'] = domain_address_id
    __args__['domainName'] = domain_name
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getDomainNameParseIpList:getDomainNameParseIpList', __args__, opts=opts, typ=GetDomainNameParseIpListResult).value

    return AwaitableGetDomainNameParseIpListResult(
        address_type=pulumi.get(__ret__, 'address_type'),
        datas=pulumi.get(__ret__, 'datas'),
        domain_address_id=pulumi.get(__ret__, 'domain_address_id'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_domain_name_parse_ip_list_output(address_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         domain_address_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         domain_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainNameParseIpListResult]:
    """
    Use this data source to get the DNS resolution result of a domain name.

    ## Example Usage

    ### DNS resolution result of a domain name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cfw.get_domain_name_parse_ip_list(domain_name="www.cloud.ru")
    ```

    ### DNS resolution result of a domain name in a domain name group

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    domain_name_group_id = config.require_object("domainNameGroupId")
    domain_address_id = config.require_object("domainAddressId")
    test = sbercloud.Cfw.get_domain_name_parse_ip_list(fw_instance_id=fw_instance_id,
        group_id=domain_name_group_id,
        domain_address_id=domain_address_id)
    ```


    :param _builtins.str address_type: Specifies the address type.
           The valid value can be **0** (IPv4) or **1** (IPv6).
    :param _builtins.str domain_address_id: Specifies the domain name ID in a domain name group.
    :param _builtins.str domain_name: Specifies the domain name.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str group_id: Specifies the domain name group ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['addressType'] = address_type
    __args__['domainAddressId'] = domain_address_id
    __args__['domainName'] = domain_name
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getDomainNameParseIpList:getDomainNameParseIpList', __args__, opts=opts, typ=GetDomainNameParseIpListResult)
    return __ret__.apply(lambda __response__: GetDomainNameParseIpListResult(
        address_type=pulumi.get(__response__, 'address_type'),
        datas=pulumi.get(__response__, 'datas'),
        domain_address_id=pulumi.get(__response__, 'domain_address_id'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
