# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFirewallsResult',
    'AwaitableGetFirewallsResult',
    'get_firewalls',
    'get_firewalls_output',
]

@pulumi.output_type
class GetFirewallsResult:
    """
    A collection of values returned by getFirewalls.
    """
    def __init__(__self__, fw_instance_id=None, id=None, records=None, region=None, service_type=None):
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_type and not isinstance(service_type, int):
            raise TypeError("Expected argument 'service_type' to be a int")
        pulumi.set(__self__, "service_type", service_type)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        """
        The firewall ID.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetFirewallsRecordResult']:
        """
        The firewall instance records.
        The records object structure is documented below.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[_builtins.int]:
        """
        The service type.
        """
        return pulumi.get(self, "service_type")


class AwaitableGetFirewallsResult(GetFirewallsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallsResult(
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            records=self.records,
            region=self.region,
            service_type=self.service_type)


def get_firewalls(fw_instance_id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  service_type: Optional[_builtins.int] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallsResult:
    """
    Use this data source to get the list of CFW firewalls.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cfw.get_firewalls(service_type=0)
    ```


    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
           If not specified, the first instance will be returned.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.int service_type: Specifies the service type. The value can be:
           + **0**: North-south firewall;
           + **1**: East-west firewall;
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    __args__['serviceType'] = service_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getFirewalls:getFirewalls', __args__, opts=opts, typ=GetFirewallsResult).value

    return AwaitableGetFirewallsResult(
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'),
        service_type=pulumi.get(__ret__, 'service_type'))
def get_firewalls_output(fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         service_type: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallsResult]:
    """
    Use this data source to get the list of CFW firewalls.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cfw.get_firewalls(service_type=0)
    ```


    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
           If not specified, the first instance will be returned.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.int service_type: Specifies the service type. The value can be:
           + **0**: North-south firewall;
           + **1**: East-west firewall;
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    __args__['serviceType'] = service_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getFirewalls:getFirewalls', __args__, opts=opts, typ=GetFirewallsResult)
    return __ret__.apply(lambda __response__: GetFirewallsResult(
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region'),
        service_type=pulumi.get(__response__, 'service_type')))
