# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpsCustomRulesResult',
    'AwaitableGetIpsCustomRulesResult',
    'get_ips_custom_rules',
    'get_ips_custom_rules_output',
]

@pulumi.output_type
class GetIpsCustomRulesResult:
    """
    A collection of values returned by getIpsCustomRules.
    """
    def __init__(__self__, action_type=None, affected_os=None, attack_type=None, enterprise_project_id=None, fw_instance_id=None, id=None, ips_name=None, object_id=None, protocol=None, records=None, region=None, severity=None, software=None):
        if action_type and not isinstance(action_type, int):
            raise TypeError("Expected argument 'action_type' to be a int")
        pulumi.set(__self__, "action_type", action_type)
        if affected_os and not isinstance(affected_os, int):
            raise TypeError("Expected argument 'affected_os' to be a int")
        pulumi.set(__self__, "affected_os", affected_os)
        if attack_type and not isinstance(attack_type, int):
            raise TypeError("Expected argument 'attack_type' to be a int")
        pulumi.set(__self__, "attack_type", attack_type)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips_name and not isinstance(ips_name, str):
            raise TypeError("Expected argument 'ips_name' to be a str")
        pulumi.set(__self__, "ips_name", ips_name)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if protocol and not isinstance(protocol, int):
            raise TypeError("Expected argument 'protocol' to be a int")
        pulumi.set(__self__, "protocol", protocol)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if severity and not isinstance(severity, int):
            raise TypeError("Expected argument 'severity' to be a int")
        pulumi.set(__self__, "severity", severity)
        if software and not isinstance(software, int):
            raise TypeError("Expected argument 'software' to be a int")
        pulumi.set(__self__, "software", software)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter(name="affectedOs")
    def affected_os(self) -> Optional[_builtins.int]:
        """
        The affected OS.
        """
        return pulumi.get(self, "affected_os")

    @_builtins.property
    @pulumi.getter(name="attackType")
    def attack_type(self) -> Optional[_builtins.int]:
        """
        The attack type.
        """
        return pulumi.get(self, "attack_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsName")
    def ips_name(self) -> Optional[_builtins.str]:
        """
        The IPS rule name.
        """
        return pulumi.get(self, "ips_name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.int]:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetIpsCustomRulesRecordResult']:
        """
        The custom IPS rule records.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.int]:
        """
        The severity.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def software(self) -> Optional[_builtins.int]:
        """
        The affected software.
        """
        return pulumi.get(self, "software")


class AwaitableGetIpsCustomRulesResult(GetIpsCustomRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsCustomRulesResult(
            action_type=self.action_type,
            affected_os=self.affected_os,
            attack_type=self.attack_type,
            enterprise_project_id=self.enterprise_project_id,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            ips_name=self.ips_name,
            object_id=self.object_id,
            protocol=self.protocol,
            records=self.records,
            region=self.region,
            severity=self.severity,
            software=self.software)


def get_ips_custom_rules(action_type: Optional[_builtins.int] = None,
                         affected_os: Optional[_builtins.int] = None,
                         attack_type: Optional[_builtins.int] = None,
                         enterprise_project_id: Optional[_builtins.str] = None,
                         fw_instance_id: Optional[_builtins.str] = None,
                         ips_name: Optional[_builtins.str] = None,
                         object_id: Optional[_builtins.str] = None,
                         protocol: Optional[_builtins.int] = None,
                         region: Optional[_builtins.str] = None,
                         severity: Optional[_builtins.int] = None,
                         software: Optional[_builtins.int] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsCustomRulesResult:
    """
    Use the data source to get the list of CFW IPS custom rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_ips_custom_rules(fw_instance_id=fw_instance_id,
        object_id=object_id)
    ```


    :param _builtins.int action_type: Specifies the action type.
           The valid value can be **0** (log only) or **1** (reset/block).
    :param _builtins.int affected_os: Specifies the affected OS.
           The valid values are as follows:
           + **1**: Windows;
           + **2**: Linux;
           + **3**: FreeBSD;
           + **4**: Solaris;
           + **5**: Other Unix;
           + **6**: Network device;
           + **7**: MAC OS;
           + **8**: IOS;
           + **9**: Android;
           + **10**: Other;
    :param _builtins.int attack_type: Specifies the attack type.
           The valid values are as follows:
           + **1**: access control;
           + **2**: vulnerability scan;
           + **3**: email phishing;
           + **4**: vulnerability exploits;
           + **5**: web attack;
           + **6**: password cracking;
           + **7**: hijacking attack;
           + **8**: protocol exception;
           + **9**: trojan;
           + **10**: worm;
           + **11**: buffer overflow;
           + **12**: hacker tool;
           + **13**: spyware;
           + **14**: DDoS flood;
           + **15**: application-layer DDoS attack;
           + **16**: other suspicious behavior;
           + **17**: suspicious DNS activity;
           + **18**: phishing;
           + **19**: spam;
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str ips_name: Specifies the IPS custom rule name.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.int protocol: Specifies the protocol.
           The valid values are as follows:
           + **1**: FTP;
           + **2**: TELNET;
           + **3**: SMTP;
           + **4**: DNS-TCP;
           + **5**: DNS-UDP;
           + **6**: DHCP;
           + **7**: TFTP;
           + **8**: FINGER;
           + **9**: HTTP;
           + **10**: POP3;
           + **11**: SUNRPC-TCP;
           + **12**: SUNRPC-UDP;
           + **13**: NNTP;
           + **14**: MSRPC-TCP;
           + **15**: MSRPC-UDP;
           + **16**: NETBIOS-NAME_TCP;
           + **17**: NETBIOS-NAME_UDP;
           + **18**: NETBIOS-SMB;
           + **19**: NETBIOS-DATAGRAM;
           + **20**: IMAP4;
           + **21**: SNMP;
           + **22**: LDAP;
           + **23**: MSSQL;
           + **24**: ORACLE;
           + **25**: MYSQL;
           + **26**: VOIP-SIP-TCP;
           + **27**: VOIP-SIP-UDP;
           + **28**: VOIP-H245;
           + **29**: VOIP-Q931;
           + **30**: OTHER-TCP;
           + **31**: OTHER-UDP;
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.int severity: Specifies the severity.
           The valid values are as follows:
           + **0**: critical;
           + **1**: high;
           + **2**: medium;
           + **3**: low;
    :param _builtins.int software: Specifies the affected software.
           The valid values are as follows:
           + **1**: ADOBE;
           + **2**: APACHE;
           + **3**: APPLE;
           + **4**: CA;
           + **5**: CISCO;
           + **6**: GOOGLE CHROME;
           + **7**: HP;
           + **8**: IBM;
           + **9**: IE;
           + **10**: IIS;
           + **11**: MCAFEE;
           + **12**: MEDIAPLAYER;
           + **13**: MICROSOFT.NET;
           + **14**: MICROSOFT EDGE;
           + **15**: MICROSOFT EXCHANGE;
           + **16**: MICROSOFT OFFICE;
           + **17**: MICROSOFT OUTLOOK;
           + **18**: MICROSOFT SHAREPOINT;
           + **19**: MICROSOFT WINDOWS;
           + **20**: MOZILLA;
           + **21**: MSSQL;
           + **22**: MYSQL;
           + **23**: NOVELL;
           + **24**: ORACLE;
           + **25**: SAMBA;
           + **26**: SAMSUNG;
           + **27**: SAP;
           + **28**: SCADA;
           + **29**: SQUID;
           + **30**: SUN;
           + **31**: SYMANTEC;
           + **32**: TREND MICRO;
           + **33**: VMWARE;
           + **34**: WORDPRESS;
           + **35**: OTHER;
    """
    __args__ = dict()
    __args__['actionType'] = action_type
    __args__['affectedOs'] = affected_os
    __args__['attackType'] = attack_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['ipsName'] = ips_name
    __args__['objectId'] = object_id
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['severity'] = severity
    __args__['software'] = software
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getIpsCustomRules:getIpsCustomRules', __args__, opts=opts, typ=GetIpsCustomRulesResult).value

    return AwaitableGetIpsCustomRulesResult(
        action_type=pulumi.get(__ret__, 'action_type'),
        affected_os=pulumi.get(__ret__, 'affected_os'),
        attack_type=pulumi.get(__ret__, 'attack_type'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ips_name=pulumi.get(__ret__, 'ips_name'),
        object_id=pulumi.get(__ret__, 'object_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'),
        severity=pulumi.get(__ret__, 'severity'),
        software=pulumi.get(__ret__, 'software'))
def get_ips_custom_rules_output(action_type: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                affected_os: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                attack_type: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                ips_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                object_id: Optional[pulumi.Input[_builtins.str]] = None,
                                protocol: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                severity: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                software: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsCustomRulesResult]:
    """
    Use the data source to get the list of CFW IPS custom rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_ips_custom_rules(fw_instance_id=fw_instance_id,
        object_id=object_id)
    ```


    :param _builtins.int action_type: Specifies the action type.
           The valid value can be **0** (log only) or **1** (reset/block).
    :param _builtins.int affected_os: Specifies the affected OS.
           The valid values are as follows:
           + **1**: Windows;
           + **2**: Linux;
           + **3**: FreeBSD;
           + **4**: Solaris;
           + **5**: Other Unix;
           + **6**: Network device;
           + **7**: MAC OS;
           + **8**: IOS;
           + **9**: Android;
           + **10**: Other;
    :param _builtins.int attack_type: Specifies the attack type.
           The valid values are as follows:
           + **1**: access control;
           + **2**: vulnerability scan;
           + **3**: email phishing;
           + **4**: vulnerability exploits;
           + **5**: web attack;
           + **6**: password cracking;
           + **7**: hijacking attack;
           + **8**: protocol exception;
           + **9**: trojan;
           + **10**: worm;
           + **11**: buffer overflow;
           + **12**: hacker tool;
           + **13**: spyware;
           + **14**: DDoS flood;
           + **15**: application-layer DDoS attack;
           + **16**: other suspicious behavior;
           + **17**: suspicious DNS activity;
           + **18**: phishing;
           + **19**: spam;
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str ips_name: Specifies the IPS custom rule name.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.int protocol: Specifies the protocol.
           The valid values are as follows:
           + **1**: FTP;
           + **2**: TELNET;
           + **3**: SMTP;
           + **4**: DNS-TCP;
           + **5**: DNS-UDP;
           + **6**: DHCP;
           + **7**: TFTP;
           + **8**: FINGER;
           + **9**: HTTP;
           + **10**: POP3;
           + **11**: SUNRPC-TCP;
           + **12**: SUNRPC-UDP;
           + **13**: NNTP;
           + **14**: MSRPC-TCP;
           + **15**: MSRPC-UDP;
           + **16**: NETBIOS-NAME_TCP;
           + **17**: NETBIOS-NAME_UDP;
           + **18**: NETBIOS-SMB;
           + **19**: NETBIOS-DATAGRAM;
           + **20**: IMAP4;
           + **21**: SNMP;
           + **22**: LDAP;
           + **23**: MSSQL;
           + **24**: ORACLE;
           + **25**: MYSQL;
           + **26**: VOIP-SIP-TCP;
           + **27**: VOIP-SIP-UDP;
           + **28**: VOIP-H245;
           + **29**: VOIP-Q931;
           + **30**: OTHER-TCP;
           + **31**: OTHER-UDP;
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.int severity: Specifies the severity.
           The valid values are as follows:
           + **0**: critical;
           + **1**: high;
           + **2**: medium;
           + **3**: low;
    :param _builtins.int software: Specifies the affected software.
           The valid values are as follows:
           + **1**: ADOBE;
           + **2**: APACHE;
           + **3**: APPLE;
           + **4**: CA;
           + **5**: CISCO;
           + **6**: GOOGLE CHROME;
           + **7**: HP;
           + **8**: IBM;
           + **9**: IE;
           + **10**: IIS;
           + **11**: MCAFEE;
           + **12**: MEDIAPLAYER;
           + **13**: MICROSOFT.NET;
           + **14**: MICROSOFT EDGE;
           + **15**: MICROSOFT EXCHANGE;
           + **16**: MICROSOFT OFFICE;
           + **17**: MICROSOFT OUTLOOK;
           + **18**: MICROSOFT SHAREPOINT;
           + **19**: MICROSOFT WINDOWS;
           + **20**: MOZILLA;
           + **21**: MSSQL;
           + **22**: MYSQL;
           + **23**: NOVELL;
           + **24**: ORACLE;
           + **25**: SAMBA;
           + **26**: SAMSUNG;
           + **27**: SAP;
           + **28**: SCADA;
           + **29**: SQUID;
           + **30**: SUN;
           + **31**: SYMANTEC;
           + **32**: TREND MICRO;
           + **33**: VMWARE;
           + **34**: WORDPRESS;
           + **35**: OTHER;
    """
    __args__ = dict()
    __args__['actionType'] = action_type
    __args__['affectedOs'] = affected_os
    __args__['attackType'] = attack_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['ipsName'] = ips_name
    __args__['objectId'] = object_id
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['severity'] = severity
    __args__['software'] = software
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getIpsCustomRules:getIpsCustomRules', __args__, opts=opts, typ=GetIpsCustomRulesResult)
    return __ret__.apply(lambda __response__: GetIpsCustomRulesResult(
        action_type=pulumi.get(__response__, 'action_type'),
        affected_os=pulumi.get(__response__, 'affected_os'),
        attack_type=pulumi.get(__response__, 'attack_type'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        ips_name=pulumi.get(__response__, 'ips_name'),
        object_id=pulumi.get(__response__, 'object_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region'),
        severity=pulumi.get(__response__, 'severity'),
        software=pulumi.get(__response__, 'software')))
