# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpsRulesResult',
    'AwaitableGetIpsRulesResult',
    'get_ips_rules',
    'get_ips_rules_output',
]

@pulumi.output_type
class GetIpsRulesResult:
    """
    A collection of values returned by getIpsRules.
    """
    def __init__(__self__, enterprise_project_id=None, id=None, ips_id=None, ips_name_like=None, ips_status=None, is_updated_ips_rule_queried=None, object_id=None, records=None, region=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips_id and not isinstance(ips_id, str):
            raise TypeError("Expected argument 'ips_id' to be a str")
        pulumi.set(__self__, "ips_id", ips_id)
        if ips_name_like and not isinstance(ips_name_like, str):
            raise TypeError("Expected argument 'ips_name_like' to be a str")
        pulumi.set(__self__, "ips_name_like", ips_name_like)
        if ips_status and not isinstance(ips_status, str):
            raise TypeError("Expected argument 'ips_status' to be a str")
        pulumi.set(__self__, "ips_status", ips_status)
        if is_updated_ips_rule_queried and not isinstance(is_updated_ips_rule_queried, bool):
            raise TypeError("Expected argument 'is_updated_ips_rule_queried' to be a bool")
        pulumi.set(__self__, "is_updated_ips_rule_queried", is_updated_ips_rule_queried)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipsId")
    def ips_id(self) -> Optional[_builtins.str]:
        """
        The IPS rule ID.
        """
        return pulumi.get(self, "ips_id")

    @_builtins.property
    @pulumi.getter(name="ipsNameLike")
    def ips_name_like(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ips_name_like")

    @_builtins.property
    @pulumi.getter(name="ipsStatus")
    def ips_status(self) -> Optional[_builtins.str]:
        """
        The current status of the IPS rule.
        """
        return pulumi.get(self, "ips_status")

    @_builtins.property
    @pulumi.getter(name="isUpdatedIpsRuleQueried")
    def is_updated_ips_rule_queried(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_updated_ips_rule_queried")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetIpsRulesRecordResult']:
        """
        The IPS rule list.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetIpsRulesResult(GetIpsRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsRulesResult(
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ips_id=self.ips_id,
            ips_name_like=self.ips_name_like,
            ips_status=self.ips_status,
            is_updated_ips_rule_queried=self.is_updated_ips_rule_queried,
            object_id=self.object_id,
            records=self.records,
            region=self.region)


def get_ips_rules(enterprise_project_id: Optional[_builtins.str] = None,
                  ips_id: Optional[_builtins.str] = None,
                  ips_name_like: Optional[_builtins.str] = None,
                  ips_status: Optional[_builtins.str] = None,
                  is_updated_ips_rule_queried: Optional[_builtins.bool] = None,
                  object_id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsRulesResult:
    """
    Use this data source to get the list of CFW IPS basic protection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_ips_rules(object_id=object_id)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str ips_id: Specifies the IPS rule ID.
    :param _builtins.str ips_name_like: Specifies the IPS rule name.
           This parameter supports fuzzy search.
    :param _builtins.str ips_status: Specifies the IPS rule status.
           The valid value can be **OBSERVE**, **ENABLE**, or **CLOSE**.
    :param _builtins.bool is_updated_ips_rule_queried: Specifies whether to check for new update rules.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ipsId'] = ips_id
    __args__['ipsNameLike'] = ips_name_like
    __args__['ipsStatus'] = ips_status
    __args__['isUpdatedIpsRuleQueried'] = is_updated_ips_rule_queried
    __args__['objectId'] = object_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getIpsRules:getIpsRules', __args__, opts=opts, typ=GetIpsRulesResult).value

    return AwaitableGetIpsRulesResult(
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        ips_id=pulumi.get(__ret__, 'ips_id'),
        ips_name_like=pulumi.get(__ret__, 'ips_name_like'),
        ips_status=pulumi.get(__ret__, 'ips_status'),
        is_updated_ips_rule_queried=pulumi.get(__ret__, 'is_updated_ips_rule_queried'),
        object_id=pulumi.get(__ret__, 'object_id'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'))
def get_ips_rules_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         ips_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         ips_name_like: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         ips_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         is_updated_ips_rule_queried: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         object_id: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpsRulesResult]:
    """
    Use this data source to get the list of CFW IPS basic protection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    test = sbercloud.Cfw.get_ips_rules(object_id=object_id)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str ips_id: Specifies the IPS rule ID.
    :param _builtins.str ips_name_like: Specifies the IPS rule name.
           This parameter supports fuzzy search.
    :param _builtins.str ips_status: Specifies the IPS rule status.
           The valid value can be **OBSERVE**, **ENABLE**, or **CLOSE**.
    :param _builtins.bool is_updated_ips_rule_queried: Specifies whether to check for new update rules.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ipsId'] = ips_id
    __args__['ipsNameLike'] = ips_name_like
    __args__['ipsStatus'] = ips_status
    __args__['isUpdatedIpsRuleQueried'] = is_updated_ips_rule_queried
    __args__['objectId'] = object_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getIpsRules:getIpsRules', __args__, opts=opts, typ=GetIpsRulesResult)
    return __ret__.apply(lambda __response__: GetIpsRulesResult(
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        ips_id=pulumi.get(__response__, 'ips_id'),
        ips_name_like=pulumi.get(__response__, 'ips_name_like'),
        ips_status=pulumi.get(__response__, 'ips_status'),
        is_updated_ips_rule_queried=pulumi.get(__response__, 'is_updated_ips_rule_queried'),
        object_id=pulumi.get(__response__, 'object_id'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region')))
