# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProtectionRulesResult',
    'AwaitableGetProtectionRulesResult',
    'get_protection_rules',
    'get_protection_rules_output',
]

@pulumi.output_type
class GetProtectionRulesResult:
    """
    A collection of values returned by getProtectionRules.
    """
    def __init__(__self__, action_type=None, destination=None, direction=None, fw_instance_id=None, id=None, name=None, object_id=None, records=None, region=None, rule_id=None, source=None, status=None, tags=None, type=None):
        if action_type and not isinstance(action_type, str):
            raise TypeError("Expected argument 'action_type' to be a str")
        pulumi.set(__self__, "action_type", action_type)
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[_builtins.str]:
        """
        The rule action type.
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The destination configuration.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        The direction of a rule.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The custom service name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetProtectionRulesRecordResult']:
        """
        The protection rule list.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.str]:
        """
        The rule ID.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The source configuration.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The rule status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of a rule.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The source type.
        """
        return pulumi.get(self, "type")


class AwaitableGetProtectionRulesResult(GetProtectionRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionRulesResult(
            action_type=self.action_type,
            destination=self.destination,
            direction=self.direction,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            name=self.name,
            object_id=self.object_id,
            records=self.records,
            region=self.region,
            rule_id=self.rule_id,
            source=self.source,
            status=self.status,
            tags=self.tags,
            type=self.type)


def get_protection_rules(action_type: Optional[_builtins.str] = None,
                         destination: Optional[_builtins.str] = None,
                         direction: Optional[_builtins.str] = None,
                         fw_instance_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         object_id: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         rule_id: Optional[_builtins.str] = None,
                         source: Optional[_builtins.str] = None,
                         status: Optional[_builtins.str] = None,
                         tags: Optional[Mapping[str, _builtins.str]] = None,
                         type: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionRulesResult:
    """
    Use this data source to get the list of CFW protection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    name = config.require_object("name")
    test = sbercloud.Cfw.get_protection_rules(object_id=object_id,
        name=name)
    ```


    :param _builtins.str action_type: Specifies the rule action type.
           The options are as follows:
           + **0**: allow;
           + **1**: deny.
    :param _builtins.str destination: Specifies the destination address.
    :param _builtins.str direction: Specifies the rule direction.
           The options are as follows:
           + **0**: inbound;
           + **1**: outbound.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str name: Specifies the rule name.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str rule_id: Specifies the rule ID.
    :param _builtins.str source: Specifies the source address.
    :param _builtins.str status: Specifies the rule status.
           The options are as follows:
           + **0**: disabled;
           + **1**: enabled.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs to associate with the protection rule.
           Tags should have only one key/value pair.
    :param _builtins.str type: Specifies the rule type.
           The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
    """
    __args__ = dict()
    __args__['actionType'] = action_type
    __args__['destination'] = destination
    __args__['direction'] = direction
    __args__['fwInstanceId'] = fw_instance_id
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['region'] = region
    __args__['ruleId'] = rule_id
    __args__['source'] = source
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getProtectionRules:getProtectionRules', __args__, opts=opts, typ=GetProtectionRulesResult).value

    return AwaitableGetProtectionRulesResult(
        action_type=pulumi.get(__ret__, 'action_type'),
        destination=pulumi.get(__ret__, 'destination'),
        direction=pulumi.get(__ret__, 'direction'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        object_id=pulumi.get(__ret__, 'object_id'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        source=pulumi.get(__ret__, 'source'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_protection_rules_output(action_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                destination: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                object_id: Optional[pulumi.Input[_builtins.str]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                rule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                source: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionRulesResult]:
    """
    Use this data source to get the list of CFW protection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    object_id = config.require_object("objectId")
    name = config.require_object("name")
    test = sbercloud.Cfw.get_protection_rules(object_id=object_id,
        name=name)
    ```


    :param _builtins.str action_type: Specifies the rule action type.
           The options are as follows:
           + **0**: allow;
           + **1**: deny.
    :param _builtins.str destination: Specifies the destination address.
    :param _builtins.str direction: Specifies the rule direction.
           The options are as follows:
           + **0**: inbound;
           + **1**: outbound.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str name: Specifies the rule name.
    :param _builtins.str object_id: Specifies the protected object ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str rule_id: Specifies the rule ID.
    :param _builtins.str source: Specifies the source address.
    :param _builtins.str status: Specifies the rule status.
           The options are as follows:
           + **0**: disabled;
           + **1**: enabled.
    :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs to associate with the protection rule.
           Tags should have only one key/value pair.
    :param _builtins.str type: Specifies the rule type.
           The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
    """
    __args__ = dict()
    __args__['actionType'] = action_type
    __args__['destination'] = destination
    __args__['direction'] = direction
    __args__['fwInstanceId'] = fw_instance_id
    __args__['name'] = name
    __args__['objectId'] = object_id
    __args__['region'] = region
    __args__['ruleId'] = rule_id
    __args__['source'] = source
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getProtectionRules:getProtectionRules', __args__, opts=opts, typ=GetProtectionRulesResult)
    return __ret__.apply(lambda __response__: GetProtectionRulesResult(
        action_type=pulumi.get(__response__, 'action_type'),
        destination=pulumi.get(__response__, 'destination'),
        direction=pulumi.get(__response__, 'direction'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        object_id=pulumi.get(__response__, 'object_id'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        source=pulumi.get(__response__, 'source'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
