# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionsResult',
    'AwaitableGetRegionsResult',
    'get_regions',
    'get_regions_output',
]

@pulumi.output_type
class GetRegionsResult:
    """
    A collection of values returned by getRegions.
    """
    def __init__(__self__, data=None, enterprise_project_id=None, fw_instance_id=None, id=None, region=None):
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The region list.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetRegionsResult(GetRegionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionsResult(
            data=self.data,
            enterprise_project_id=self.enterprise_project_id,
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            region=self.region)


def get_regions(enterprise_project_id: Optional[_builtins.str] = None,
                fw_instance_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionsResult:
    """
    Use this data source to get the list of CFW regions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    test = sbercloud.Cfw.get_regions(fw_instance_id=fw_instance_id)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getRegions:getRegions', __args__, opts=opts, typ=GetRegionsResult).value

    return AwaitableGetRegionsResult(
        data=pulumi.get(__ret__, 'data'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_regions_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionsResult]:
    """
    Use this data source to get the list of CFW regions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    test = sbercloud.Cfw.get_regions(fw_instance_id=fw_instance_id)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getRegions:getRegions', __args__, opts=opts, typ=GetRegionsResult)
    return __ret__.apply(lambda __response__: GetRegionsResult(
        data=pulumi.get(__response__, 'data'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
