# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceTagsResult',
    'AwaitableGetResourceTagsResult',
    'get_resource_tags',
    'get_resource_tags_output',
]

@pulumi.output_type
class GetResourceTagsResult:
    """
    A collection of values returned by getResourceTags.
    """
    def __init__(__self__, fw_instance_id=None, id=None, region=None, tags=None):
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetResourceTagsTagResult']:
        """
        The tag list.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceTagsResult(GetResourceTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceTagsResult(
            fw_instance_id=self.fw_instance_id,
            id=self.id,
            region=self.region,
            tags=self.tags)


def get_resource_tags(fw_instance_id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceTagsResult:
    """
    Use this data source to get the list of tags of a specified firewall instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    test = sbercloud.Cfw.get_resource_tags(fw_instance_id=fw_instance_id)
    ```


    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getResourceTags:getResourceTags', __args__, opts=opts, typ=GetResourceTagsResult).value

    return AwaitableGetResourceTagsResult(
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_tags_output(fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceTagsResult]:
    """
    Use this data source to get the list of tags of a specified firewall instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    fw_instance_id = config.require_object("fwInstanceId")
    test = sbercloud.Cfw.get_resource_tags(fw_instance_id=fw_instance_id)
    ```


    :param _builtins.str fw_instance_id: Specifies the firewall ID.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['fwInstanceId'] = fw_instance_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getResourceTags:getResourceTags', __args__, opts=opts, typ=GetResourceTagsResult)
    return __ret__.apply(lambda __response__: GetResourceTagsResult(
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
