# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceGroupMembersResult',
    'AwaitableGetServiceGroupMembersResult',
    'get_service_group_members',
    'get_service_group_members_output',
]

@pulumi.output_type
class GetServiceGroupMembersResult:
    """
    A collection of values returned by getServiceGroupMembers.
    """
    def __init__(__self__, dest_port=None, fw_instance_id=None, group_id=None, group_type=None, id=None, item_id=None, key_word=None, protocol=None, records=None, region=None, source_port=None):
        if dest_port and not isinstance(dest_port, str):
            raise TypeError("Expected argument 'dest_port' to be a str")
        pulumi.set(__self__, "dest_port", dest_port)
        if fw_instance_id and not isinstance(fw_instance_id, str):
            raise TypeError("Expected argument 'fw_instance_id' to be a str")
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item_id and not isinstance(item_id, str):
            raise TypeError("Expected argument 'item_id' to be a str")
        pulumi.set(__self__, "item_id", item_id)
        if key_word and not isinstance(key_word, str):
            raise TypeError("Expected argument 'key_word' to be a str")
        pulumi.set(__self__, "key_word", key_word)
        if protocol and not isinstance(protocol, int):
            raise TypeError("Expected argument 'protocol' to be a int")
        pulumi.set(__self__, "protocol", protocol)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if source_port and not isinstance(source_port, str):
            raise TypeError("Expected argument 'source_port' to be a str")
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[_builtins.str]:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[_builtins.str]:
        """
        The service group member ID.
        """
        return pulumi.get(self, "item_id")

    @_builtins.property
    @pulumi.getter(name="keyWord")
    def key_word(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_word")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.int]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetServiceGroupMembersRecordResult']:
        """
        The service group member list.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[_builtins.str]:
        """
        The source port.
        """
        return pulumi.get(self, "source_port")


class AwaitableGetServiceGroupMembersResult(GetServiceGroupMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceGroupMembersResult(
            dest_port=self.dest_port,
            fw_instance_id=self.fw_instance_id,
            group_id=self.group_id,
            group_type=self.group_type,
            id=self.id,
            item_id=self.item_id,
            key_word=self.key_word,
            protocol=self.protocol,
            records=self.records,
            region=self.region,
            source_port=self.source_port)


def get_service_group_members(dest_port: Optional[_builtins.str] = None,
                              fw_instance_id: Optional[_builtins.str] = None,
                              group_id: Optional[_builtins.str] = None,
                              group_type: Optional[_builtins.str] = None,
                              item_id: Optional[_builtins.str] = None,
                              key_word: Optional[_builtins.str] = None,
                              protocol: Optional[_builtins.int] = None,
                              region: Optional[_builtins.str] = None,
                              source_port: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceGroupMembersResult:
    """
    Use this data source to get the list of CFW service group members.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    group_id = config.require_object("groupId")
    test = sbercloud.Cfw.get_service_group_members(group_id=group_id)
    ```


    :param _builtins.str dest_port: Specifies the destination port.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the service group ID.
    :param _builtins.str group_type: Specifies the service group type.
           The value can be **0** (custom service group), **1** (predefined service group).
    :param _builtins.str item_id: Specifies the service group member ID.
    :param _builtins.str key_word: Specifies the key word.
    :param _builtins.int protocol: Specifies the protocol type.
           The options are as follows:
           + **6**: TCP;
           + **17**: UDP;
           + **1**: ICMP.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str source_port: Specifies the source port.
    """
    __args__ = dict()
    __args__['destPort'] = dest_port
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['groupType'] = group_type
    __args__['itemId'] = item_id
    __args__['keyWord'] = key_word
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['sourcePort'] = source_port
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cfw/getServiceGroupMembers:getServiceGroupMembers', __args__, opts=opts, typ=GetServiceGroupMembersResult).value

    return AwaitableGetServiceGroupMembersResult(
        dest_port=pulumi.get(__ret__, 'dest_port'),
        fw_instance_id=pulumi.get(__ret__, 'fw_instance_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        group_type=pulumi.get(__ret__, 'group_type'),
        id=pulumi.get(__ret__, 'id'),
        item_id=pulumi.get(__ret__, 'item_id'),
        key_word=pulumi.get(__ret__, 'key_word'),
        protocol=pulumi.get(__ret__, 'protocol'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'),
        source_port=pulumi.get(__ret__, 'source_port'))
def get_service_group_members_output(dest_port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     fw_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     group_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     item_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     key_word: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     protocol: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     source_port: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceGroupMembersResult]:
    """
    Use this data source to get the list of CFW service group members.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    group_id = config.require_object("groupId")
    test = sbercloud.Cfw.get_service_group_members(group_id=group_id)
    ```


    :param _builtins.str dest_port: Specifies the destination port.
    :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
    :param _builtins.str group_id: Specifies the service group ID.
    :param _builtins.str group_type: Specifies the service group type.
           The value can be **0** (custom service group), **1** (predefined service group).
    :param _builtins.str item_id: Specifies the service group member ID.
    :param _builtins.str key_word: Specifies the key word.
    :param _builtins.int protocol: Specifies the protocol type.
           The options are as follows:
           + **6**: TCP;
           + **17**: UDP;
           + **1**: ICMP.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str source_port: Specifies the source port.
    """
    __args__ = dict()
    __args__['destPort'] = dest_port
    __args__['fwInstanceId'] = fw_instance_id
    __args__['groupId'] = group_id
    __args__['groupType'] = group_type
    __args__['itemId'] = item_id
    __args__['keyWord'] = key_word
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['sourcePort'] = source_port
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cfw/getServiceGroupMembers:getServiceGroupMembers', __args__, opts=opts, typ=GetServiceGroupMembersResult)
    return __ret__.apply(lambda __response__: GetServiceGroupMembersResult(
        dest_port=pulumi.get(__response__, 'dest_port'),
        fw_instance_id=pulumi.get(__response__, 'fw_instance_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        group_type=pulumi.get(__response__, 'group_type'),
        id=pulumi.get(__response__, 'id'),
        item_id=pulumi.get(__response__, 'item_id'),
        key_word=pulumi.get(__response__, 'key_word'),
        protocol=pulumi.get(__response__, 'protocol'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region'),
        source_port=pulumi.get(__response__, 'source_port')))
