# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpsRuleModeChangeArgs', 'IpsRuleModeChange']

@pulumi.input_type
class IpsRuleModeChangeArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IpsRuleModeChange resource.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] status: Specifies the IPS rule status.
               The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips_ids: Specifies the IPS rule ID list.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "status", status)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ips_ids is not None:
            pulumi.set(__self__, "ips_ids", ips_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IPS rule status.
        The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipsIds")
    def ips_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPS rule ID list.
        """
        return pulumi.get(self, "ips_ids")

    @ips_ids.setter
    def ips_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IpsRuleModeChangeState:
    def __init__(__self__, *,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpsRuleModeChange resources.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips_ids: Specifies the IPS rule ID list.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the IPS rule status.
               The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ips_ids is not None:
            pulumi.set(__self__, "ips_ids", ips_ids)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipsIds")
    def ips_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPS rule ID list.
        """
        return pulumi.get(self, "ips_ids")

    @ips_ids.setter
    def ips_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips_ids", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPS rule status.
        The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:Cfw/ipsRuleModeChange:IpsRuleModeChange")
class IpsRuleModeChange(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW IPS rule mode change resource within SberCloud.

        > This resource is only a one-time action resource for operating the API.
        Deleting this resource will not clear the corresponding request record,
        but will only remove the resource information from the tfstate file.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        object_id = config.require_object("objectId")
        ips_ids = config.require_object("ipsIds")
        status = config.require_object("status")
        test = sbercloud.cfw.IpsRuleModeChange("test",
            object_id=object_id,
            ips_ids=ips_ids,
            status=status)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips_ids: Specifies the IPS rule ID list.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the IPS rule status.
               The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsRuleModeChangeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW IPS rule mode change resource within SberCloud.

        > This resource is only a one-time action resource for operating the API.
        Deleting this resource will not clear the corresponding request record,
        but will only remove the resource information from the tfstate file.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        object_id = config.require_object("objectId")
        ips_ids = config.require_object("ipsIds")
        status = config.require_object("status")
        test = sbercloud.cfw.IpsRuleModeChange("test",
            object_id=object_id,
            ips_ids=ips_ids,
            status=status)
        ```

        :param str resource_name: The name of the resource.
        :param IpsRuleModeChangeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsRuleModeChangeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsRuleModeChangeArgs.__new__(IpsRuleModeChangeArgs)

            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["ips_ids"] = ips_ids
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["region"] = region
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
        super(IpsRuleModeChange, __self__).__init__(
            'sbercloud:Cfw/ipsRuleModeChange:IpsRuleModeChange',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ips_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'IpsRuleModeChange':
        """
        Get an existing IpsRuleModeChange resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips_ids: Specifies the IPS rule ID list.
        :param pulumi.Input[_builtins.str] object_id: Specifies the protected object ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this will create new resource.
        :param pulumi.Input[_builtins.str] status: Specifies the IPS rule status.
               The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsRuleModeChangeState.__new__(_IpsRuleModeChangeState)

        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ips_ids"] = ips_ids
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return IpsRuleModeChange(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="ipsIds")
    def ips_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the IPS rule ID list.
        """
        return pulumi.get(self, "ips_ids")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this will create new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IPS rule status.
        The valid value can be **OBSERVE**, **ENABLE**, **CLOSE**, **DEFAULT** or **ALL_DEFAULT**.
        """
        return pulumi.get(self, "status")

