# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LtsLogArgs', 'LtsLog']

@pulumi.input_type
class LtsLogArgs:
    def __init__(__self__, *,
                 fw_instance_id: pulumi.Input[_builtins.str],
                 lts_access_log_stream_enable: pulumi.Input[_builtins.int],
                 lts_attack_log_stream_enable: pulumi.Input[_builtins.int],
                 lts_flow_log_stream_enable: pulumi.Input[_builtins.int],
                 lts_log_group_id: pulumi.Input[_builtins.str],
                 lts_access_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_attack_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_flow_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LtsLog resource.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lts_access_log_stream_enable: Specifies whether to enable the access log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.int] lts_attack_log_stream_enable: Specifies whether to enable the attack log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.int] lts_flow_log_stream_enable: Specifies whether to enable the flow log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_log_group_id: Specifies the LTS log group ID.
        :param pulumi.Input[_builtins.str] lts_access_log_stream_id: Specifies the access log stream ID.
        :param pulumi.Input[_builtins.str] lts_attack_log_stream_id: Specifies the attack log stream ID.
        :param pulumi.Input[_builtins.str] lts_flow_log_stream_id: Specifies the flow log stream ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        pulumi.set(__self__, "lts_access_log_stream_enable", lts_access_log_stream_enable)
        pulumi.set(__self__, "lts_attack_log_stream_enable", lts_attack_log_stream_enable)
        pulumi.set(__self__, "lts_flow_log_stream_enable", lts_flow_log_stream_enable)
        pulumi.set(__self__, "lts_log_group_id", lts_log_group_id)
        if lts_access_log_stream_id is not None:
            pulumi.set(__self__, "lts_access_log_stream_id", lts_access_log_stream_id)
        if lts_attack_log_stream_id is not None:
            pulumi.set(__self__, "lts_attack_log_stream_id", lts_attack_log_stream_id)
        if lts_flow_log_stream_id is not None:
            pulumi.set(__self__, "lts_flow_log_stream_id", lts_flow_log_stream_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamEnable")
    def lts_access_log_stream_enable(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies whether to enable the access log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_access_log_stream_enable")

    @lts_access_log_stream_enable.setter
    def lts_access_log_stream_enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "lts_access_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamEnable")
    def lts_attack_log_stream_enable(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies whether to enable the attack log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_attack_log_stream_enable")

    @lts_attack_log_stream_enable.setter
    def lts_attack_log_stream_enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "lts_attack_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamEnable")
    def lts_flow_log_stream_enable(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies whether to enable the flow log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_flow_log_stream_enable")

    @lts_flow_log_stream_enable.setter
    def lts_flow_log_stream_enable(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "lts_flow_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsLogGroupId")
    def lts_log_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the LTS log group ID.
        """
        return pulumi.get(self, "lts_log_group_id")

    @lts_log_group_id.setter
    def lts_log_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lts_log_group_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamId")
    def lts_access_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access log stream ID.
        """
        return pulumi.get(self, "lts_access_log_stream_id")

    @lts_access_log_stream_id.setter
    def lts_access_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_access_log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamId")
    def lts_attack_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the attack log stream ID.
        """
        return pulumi.get(self, "lts_attack_log_stream_id")

    @lts_attack_log_stream_id.setter
    def lts_attack_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_attack_log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamId")
    def lts_flow_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flow log stream ID.
        """
        return pulumi.get(self, "lts_flow_log_stream_id")

    @lts_flow_log_stream_id.setter
    def lts_flow_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_flow_log_stream_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LtsLogState:
    def __init__(__self__, *,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_access_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_access_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_attack_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_attack_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_flow_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_flow_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LtsLog resources.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lts_access_log_stream_enable: Specifies whether to enable the access log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_access_log_stream_id: Specifies the access log stream ID.
        :param pulumi.Input[_builtins.int] lts_attack_log_stream_enable: Specifies whether to enable the attack log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_attack_log_stream_id: Specifies the attack log stream ID.
        :param pulumi.Input[_builtins.int] lts_flow_log_stream_enable: Specifies whether to enable the flow log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_flow_log_stream_id: Specifies the flow log stream ID.
        :param pulumi.Input[_builtins.str] lts_log_group_id: Specifies the LTS log group ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        if fw_instance_id is not None:
            pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        if lts_access_log_stream_enable is not None:
            pulumi.set(__self__, "lts_access_log_stream_enable", lts_access_log_stream_enable)
        if lts_access_log_stream_id is not None:
            pulumi.set(__self__, "lts_access_log_stream_id", lts_access_log_stream_id)
        if lts_attack_log_stream_enable is not None:
            pulumi.set(__self__, "lts_attack_log_stream_enable", lts_attack_log_stream_enable)
        if lts_attack_log_stream_id is not None:
            pulumi.set(__self__, "lts_attack_log_stream_id", lts_attack_log_stream_id)
        if lts_flow_log_stream_enable is not None:
            pulumi.set(__self__, "lts_flow_log_stream_enable", lts_flow_log_stream_enable)
        if lts_flow_log_stream_id is not None:
            pulumi.set(__self__, "lts_flow_log_stream_id", lts_flow_log_stream_id)
        if lts_log_group_id is not None:
            pulumi.set(__self__, "lts_log_group_id", lts_log_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @fw_instance_id.setter
    def fw_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fw_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamEnable")
    def lts_access_log_stream_enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable the access log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_access_log_stream_enable")

    @lts_access_log_stream_enable.setter
    def lts_access_log_stream_enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lts_access_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamId")
    def lts_access_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access log stream ID.
        """
        return pulumi.get(self, "lts_access_log_stream_id")

    @lts_access_log_stream_id.setter
    def lts_access_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_access_log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamEnable")
    def lts_attack_log_stream_enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable the attack log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_attack_log_stream_enable")

    @lts_attack_log_stream_enable.setter
    def lts_attack_log_stream_enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lts_attack_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamId")
    def lts_attack_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the attack log stream ID.
        """
        return pulumi.get(self, "lts_attack_log_stream_id")

    @lts_attack_log_stream_id.setter
    def lts_attack_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_attack_log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamEnable")
    def lts_flow_log_stream_enable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable the flow log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_flow_log_stream_enable")

    @lts_flow_log_stream_enable.setter
    def lts_flow_log_stream_enable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lts_flow_log_stream_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamId")
    def lts_flow_log_stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flow log stream ID.
        """
        return pulumi.get(self, "lts_flow_log_stream_id")

    @lts_flow_log_stream_id.setter
    def lts_flow_log_stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_flow_log_stream_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsLogGroupId")
    def lts_log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the LTS log group ID.
        """
        return pulumi.get(self, "lts_log_group_id")

    @lts_log_group_id.setter
    def lts_log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lts_log_group_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Cfw/ltsLog:LtsLog")
class LtsLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_access_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_access_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_attack_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_attack_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_flow_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_flow_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW lts log resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        lts_attack_log_stream_id = config.require_object("ltsAttackLogStreamId")
        lts_flow_log_stream_id = config.require_object("ltsFlowLogStreamId")
        lts_access_log_stream_id = config.require_object("ltsAccessLogStreamId")
        fw_instance_id = config.require_object("fwInstanceId")
        lts_log_group_id = config.require_object("ltsLogGroupId")
        test = sbercloud.cfw.LtsLog("test",
            fw_instance_id=fw_instance_id,
            lts_log_group_id=lts_log_group_id,
            lts_attack_log_stream_enable=1,
            lts_access_log_stream_enable=1,
            lts_flow_log_stream_enable=1,
            lts_attack_log_stream_id=lts_attack_log_stream_id,
            lts_access_log_stream_id=lts_access_log_stream_id,
            lts_flow_log_stream_id=lts_flow_log_stream_id)
        ```

        ## Import

        The lts log resource can be imported using the firewall instance ID, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/ltsLog:LtsLog test <fw_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lts_access_log_stream_enable: Specifies whether to enable the access log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_access_log_stream_id: Specifies the access log stream ID.
        :param pulumi.Input[_builtins.int] lts_attack_log_stream_enable: Specifies whether to enable the attack log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_attack_log_stream_id: Specifies the attack log stream ID.
        :param pulumi.Input[_builtins.int] lts_flow_log_stream_enable: Specifies whether to enable the flow log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_flow_log_stream_id: Specifies the flow log stream ID.
        :param pulumi.Input[_builtins.str] lts_log_group_id: Specifies the LTS log group ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LtsLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW lts log resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        lts_attack_log_stream_id = config.require_object("ltsAttackLogStreamId")
        lts_flow_log_stream_id = config.require_object("ltsFlowLogStreamId")
        lts_access_log_stream_id = config.require_object("ltsAccessLogStreamId")
        fw_instance_id = config.require_object("fwInstanceId")
        lts_log_group_id = config.require_object("ltsLogGroupId")
        test = sbercloud.cfw.LtsLog("test",
            fw_instance_id=fw_instance_id,
            lts_log_group_id=lts_log_group_id,
            lts_attack_log_stream_enable=1,
            lts_access_log_stream_enable=1,
            lts_flow_log_stream_enable=1,
            lts_attack_log_stream_id=lts_attack_log_stream_id,
            lts_access_log_stream_id=lts_access_log_stream_id,
            lts_flow_log_stream_id=lts_flow_log_stream_id)
        ```

        ## Import

        The lts log resource can be imported using the firewall instance ID, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/ltsLog:LtsLog test <fw_instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param LtsLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LtsLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_access_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_access_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_attack_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_attack_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_flow_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
                 lts_flow_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LtsLogArgs.__new__(LtsLogArgs)

            if fw_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'fw_instance_id'")
            __props__.__dict__["fw_instance_id"] = fw_instance_id
            if lts_access_log_stream_enable is None and not opts.urn:
                raise TypeError("Missing required property 'lts_access_log_stream_enable'")
            __props__.__dict__["lts_access_log_stream_enable"] = lts_access_log_stream_enable
            __props__.__dict__["lts_access_log_stream_id"] = lts_access_log_stream_id
            if lts_attack_log_stream_enable is None and not opts.urn:
                raise TypeError("Missing required property 'lts_attack_log_stream_enable'")
            __props__.__dict__["lts_attack_log_stream_enable"] = lts_attack_log_stream_enable
            __props__.__dict__["lts_attack_log_stream_id"] = lts_attack_log_stream_id
            if lts_flow_log_stream_enable is None and not opts.urn:
                raise TypeError("Missing required property 'lts_flow_log_stream_enable'")
            __props__.__dict__["lts_flow_log_stream_enable"] = lts_flow_log_stream_enable
            __props__.__dict__["lts_flow_log_stream_id"] = lts_flow_log_stream_id
            if lts_log_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'lts_log_group_id'")
            __props__.__dict__["lts_log_group_id"] = lts_log_group_id
            __props__.__dict__["region"] = region
        super(LtsLog, __self__).__init__(
            'sbercloud:Cfw/ltsLog:LtsLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fw_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            lts_access_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
            lts_access_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            lts_attack_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
            lts_attack_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            lts_flow_log_stream_enable: Optional[pulumi.Input[_builtins.int]] = None,
            lts_flow_log_stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            lts_log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'LtsLog':
        """
        Get an existing LtsLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] fw_instance_id: Specifies the ID of the firewall.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lts_access_log_stream_enable: Specifies whether to enable the access log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_access_log_stream_id: Specifies the access log stream ID.
        :param pulumi.Input[_builtins.int] lts_attack_log_stream_enable: Specifies whether to enable the attack log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_attack_log_stream_id: Specifies the attack log stream ID.
        :param pulumi.Input[_builtins.int] lts_flow_log_stream_enable: Specifies whether to enable the flow log stream.
               The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        :param pulumi.Input[_builtins.str] lts_flow_log_stream_id: Specifies the flow log stream ID.
        :param pulumi.Input[_builtins.str] lts_log_group_id: Specifies the LTS log group ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LtsLogState.__new__(_LtsLogState)

        __props__.__dict__["fw_instance_id"] = fw_instance_id
        __props__.__dict__["lts_access_log_stream_enable"] = lts_access_log_stream_enable
        __props__.__dict__["lts_access_log_stream_id"] = lts_access_log_stream_id
        __props__.__dict__["lts_attack_log_stream_enable"] = lts_attack_log_stream_enable
        __props__.__dict__["lts_attack_log_stream_id"] = lts_attack_log_stream_id
        __props__.__dict__["lts_flow_log_stream_enable"] = lts_flow_log_stream_enable
        __props__.__dict__["lts_flow_log_stream_id"] = lts_flow_log_stream_id
        __props__.__dict__["lts_log_group_id"] = lts_log_group_id
        __props__.__dict__["region"] = region
        return LtsLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the firewall.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamEnable")
    def lts_access_log_stream_enable(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies whether to enable the access log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_access_log_stream_enable")

    @_builtins.property
    @pulumi.getter(name="ltsAccessLogStreamId")
    def lts_access_log_stream_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the access log stream ID.
        """
        return pulumi.get(self, "lts_access_log_stream_id")

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamEnable")
    def lts_attack_log_stream_enable(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies whether to enable the attack log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_attack_log_stream_enable")

    @_builtins.property
    @pulumi.getter(name="ltsAttackLogStreamId")
    def lts_attack_log_stream_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the attack log stream ID.
        """
        return pulumi.get(self, "lts_attack_log_stream_id")

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamEnable")
    def lts_flow_log_stream_enable(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies whether to enable the flow log stream.
        The valid values are `0` and `1`, where `0` means disable and `1` means enable.
        """
        return pulumi.get(self, "lts_flow_log_stream_enable")

    @_builtins.property
    @pulumi.getter(name="ltsFlowLogStreamId")
    def lts_flow_log_stream_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the flow log stream ID.
        """
        return pulumi.get(self, "lts_flow_log_stream_id")

    @_builtins.property
    @pulumi.getter(name="ltsLogGroupId")
    def lts_log_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the LTS log group ID.
        """
        return pulumi.get(self, "lts_log_group_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

