# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclRuleCustomService',
    'AclRuleCustomServiceGroups',
    'AclRuleDestinationRegionList',
    'AclRulePredefinedServiceGroups',
    'AclRuleSequence',
    'AclRuleSourceRegionList',
    'AntiVirusScanProtocolConfig',
    'CaptureTaskDestination',
    'CaptureTaskService',
    'CaptureTaskSource',
    'DomainNameGroupDomainName',
    'EipProtectionProtectedEip',
    'FirewallFlavor',
    'FirewallProtectObject',
    'GetAccessControlLogsRecordResult',
    'GetAddressGroupMembersRecordResult',
    'GetAddressGroupsAddressGroupResult',
    'GetAttackLogsRecordResult',
    'GetAttackLogsRecordPacketMessageResult',
    'GetBlackWhiteListsRecordResult',
    'GetCaptureTaskResultsFileListResult',
    'GetCaptureTaskResultsRequestHeaderResult',
    'GetCaptureTasksRecordResult',
    'GetDomainNameGroupsRecordResult',
    'GetDomainNameGroupsRecordDomainNameResult',
    'GetDomainNameGroupsRecordRuleResult',
    'GetFirewallsRecordResult',
    'GetFirewallsRecordFlavorResult',
    'GetFirewallsRecordProtectObjectResult',
    'GetFirewallsRecordResourceResult',
    'GetFlowLogsRecordResult',
    'GetIpsCustomRulesRecordResult',
    'GetIpsRuleDetailsDataResult',
    'GetIpsRulesRecordResult',
    'GetProtectionRulesRecordResult',
    'GetProtectionRulesRecordDestinationResult',
    'GetProtectionRulesRecordDestinationRegionListResult',
    'GetProtectionRulesRecordServiceResult',
    'GetProtectionRulesRecordServiceCustomServiceResult',
    'GetProtectionRulesRecordSourceResult',
    'GetProtectionRulesRecordSourceRegionListResult',
    'GetResourceTagsTagResult',
    'GetServiceGroupMembersRecordResult',
    'GetServiceGroupsServiceGroupResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class AclRuleCustomService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destPort":
            suggest = "dest_port"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRuleCustomService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRuleCustomService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRuleCustomService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dest_port: _builtins.str,
                 protocol: _builtins.int,
                 source_port: _builtins.str):
        """
        :param _builtins.str dest_port: The destination port.
        :param _builtins.int protocol: The protocol type.
        :param _builtins.str source_port: The source port.
               
               <a name="CustomServiceGroups"></a>
               The `custom_service_groups` block supports:
        """
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        The source port.

        <a name="CustomServiceGroups"></a>
        The `custom_service_groups` block supports:
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class AclRuleCustomServiceGroups(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRuleCustomServiceGroups. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRuleCustomServiceGroups.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRuleCustomServiceGroups.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Sequence[_builtins.str],
                 protocols: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.str] group_ids: The IDs of the predefined service groups.
        :param Sequence[_builtins.int] protocols: The protocols used in the predefined service groups.
               
               <a name="SourceRegionList"></a>
               The `source_region_list` block supports:
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "protocols", protocols)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[_builtins.str]:
        """
        The IDs of the predefined service groups.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.int]:
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
        return pulumi.get(self, "protocols")


@pulumi.output_type
class AclRuleDestinationRegionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"
        elif key == "regionType":
            suggest = "region_type"
        elif key == "descriptionCn":
            suggest = "description_cn"
        elif key == "descriptionEn":
            suggest = "description_en"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRuleDestinationRegionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRuleDestinationRegionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRuleDestinationRegionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: _builtins.str,
                 region_type: _builtins.int,
                 description_cn: Optional[_builtins.str] = None,
                 description_en: Optional[_builtins.str] = None):
        """
        :param _builtins.str region_id: The region ID.
        :param _builtins.int region_type: The region type.
        :param _builtins.str description_cn: The Chinese description of the region.
        :param _builtins.str description_en: The English description of the region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)
        if description_cn is not None:
            pulumi.set(__self__, "description_cn", description_cn)
        if description_en is not None:
            pulumi.set(__self__, "description_en", description_en)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> _builtins.int:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> Optional[_builtins.str]:
        """
        The Chinese description of the region.
        """
        return pulumi.get(self, "description_cn")

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> Optional[_builtins.str]:
        """
        The English description of the region.
        """
        return pulumi.get(self, "description_en")


@pulumi.output_type
class AclRulePredefinedServiceGroups(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRulePredefinedServiceGroups. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRulePredefinedServiceGroups.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRulePredefinedServiceGroups.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Sequence[_builtins.str],
                 protocols: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.str] group_ids: The IDs of the predefined service groups.
        :param Sequence[_builtins.int] protocols: The protocols used in the predefined service groups.
               
               <a name="SourceRegionList"></a>
               The `source_region_list` block supports:
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "protocols", protocols)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[_builtins.str]:
        """
        The IDs of the predefined service groups.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.int]:
        """
        The protocols used in the predefined service groups.

        <a name="SourceRegionList"></a>
        The `source_region_list` block supports:
        """
        return pulumi.get(self, "protocols")


@pulumi.output_type
class AclRuleSequence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destRuleId":
            suggest = "dest_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRuleSequence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRuleSequence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRuleSequence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bottom: Optional[_builtins.int] = None,
                 dest_rule_id: Optional[_builtins.str] = None,
                 top: Optional[_builtins.int] = None):
        """
        :param _builtins.int bottom: Whether to pin on bottom.
               The options are as follows:
               + **0**: no;
               + **1**: yes;
        :param _builtins.str dest_rule_id: The ID of the rule that the added rule will follow.
        :param _builtins.int top: Whether to pin on top.
               The options are as follows:
               + **0**: no;
               + **1**: yes;
               
               <a name="CustomServices"></a>
               The `custom_services` block supports:
        """
        if bottom is not None:
            pulumi.set(__self__, "bottom", bottom)
        if dest_rule_id is not None:
            pulumi.set(__self__, "dest_rule_id", dest_rule_id)
        if top is not None:
            pulumi.set(__self__, "top", top)

    @_builtins.property
    @pulumi.getter
    def bottom(self) -> Optional[_builtins.int]:
        """
        Whether to pin on bottom.
        The options are as follows:
        + **0**: no;
        + **1**: yes;
        """
        return pulumi.get(self, "bottom")

    @_builtins.property
    @pulumi.getter(name="destRuleId")
    def dest_rule_id(self) -> Optional[_builtins.str]:
        """
        The ID of the rule that the added rule will follow.
        """
        return pulumi.get(self, "dest_rule_id")

    @_builtins.property
    @pulumi.getter
    def top(self) -> Optional[_builtins.int]:
        """
        Whether to pin on top.
        The options are as follows:
        + **0**: no;
        + **1**: yes;

        <a name="CustomServices"></a>
        The `custom_services` block supports:
        """
        return pulumi.get(self, "top")


@pulumi.output_type
class AclRuleSourceRegionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"
        elif key == "regionType":
            suggest = "region_type"
        elif key == "descriptionCn":
            suggest = "description_cn"
        elif key == "descriptionEn":
            suggest = "description_en"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRuleSourceRegionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRuleSourceRegionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRuleSourceRegionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: _builtins.str,
                 region_type: _builtins.int,
                 description_cn: Optional[_builtins.str] = None,
                 description_en: Optional[_builtins.str] = None):
        """
        :param _builtins.str region_id: The region ID.
        :param _builtins.int region_type: The region type.
        :param _builtins.str description_cn: The Chinese description of the region.
        :param _builtins.str description_en: The English description of the region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)
        if description_cn is not None:
            pulumi.set(__self__, "description_cn", description_cn)
        if description_en is not None:
            pulumi.set(__self__, "description_en", description_en)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> _builtins.int:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> Optional[_builtins.str]:
        """
        The Chinese description of the region.
        """
        return pulumi.get(self, "description_cn")

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> Optional[_builtins.str]:
        """
        The English description of the region.
        """
        return pulumi.get(self, "description_en")


@pulumi.output_type
class AntiVirusScanProtocolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolType":
            suggest = "protocol_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AntiVirusScanProtocolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AntiVirusScanProtocolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AntiVirusScanProtocolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.int,
                 protocol_type: _builtins.int):
        """
        :param _builtins.int action: The anti virus action. The valid value can be **0** (observe) or **1** (block).
        :param _builtins.int protocol_type: The protocol type.
               The valid values are as follows:
               + **0**: HTTP;
               + **1**: SMTP;
               + **2**: POP3;
               + **3**: IMAP4;
               + **4**: FTP;
               + **5**: SMB;
               + **6**: Malicious Access Control;
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol_type", protocol_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.int:
        """
        The anti virus action. The valid value can be **0** (observe) or **1** (block).
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.int:
        """
        The protocol type.
        The valid values are as follows:
        + **0**: HTTP;
        + **1**: SMTP;
        + **2**: POP3;
        + **3**: IMAP4;
        + **4**: FTP;
        + **5**: SMB;
        + **6**: Malicious Access Control;
        """
        return pulumi.get(self, "protocol_type")


@pulumi.output_type
class CaptureTaskDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressType":
            suggest = "address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaptureTaskDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaptureTaskDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaptureTaskDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 address_type: _builtins.int):
        """
        :param _builtins.str address: Specifies the address.
        :param _builtins.int address_type: Specifies the address type.
               The valid values are:
               + **0**: indicates IPv4;
               + **1**: indicates IPv6.
               
               <a name="Service"></a>
               The `service` block supports:
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
        return pulumi.get(self, "address_type")


@pulumi.output_type
class CaptureTaskService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destPort":
            suggest = "dest_port"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaptureTaskService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaptureTaskService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaptureTaskService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.int,
                 dest_port: Optional[_builtins.str] = None,
                 source_port: Optional[_builtins.str] = None):
        """
        :param _builtins.int protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
        :param _builtins.str dest_port: Specifies the destination port.
        :param _builtins.str source_port: Specifies the source port.
        """
        pulumi.set(__self__, "protocol", protocol)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[_builtins.str]:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[_builtins.str]:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class CaptureTaskSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressType":
            suggest = "address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaptureTaskSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaptureTaskSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaptureTaskSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 address_type: _builtins.int):
        """
        :param _builtins.str address: Specifies the address.
        :param _builtins.int address_type: Specifies the address type.
               The valid values are:
               + **0**: indicates IPv4;
               + **1**: indicates IPv6.
               
               <a name="Service"></a>
               The `service` block supports:
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Specifies the address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        Specifies the address type.
        The valid values are:
        + **0**: indicates IPv4;
        + **1**: indicates IPv6.

        <a name="Service"></a>
        The `service` block supports:
        """
        return pulumi.get(self, "address_type")


@pulumi.output_type
class DomainNameGroupDomainName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainAddressId":
            suggest = "domain_address_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameGroupDomainName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameGroupDomainName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameGroupDomainName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 dns_ips: Optional[_builtins.str] = None,
                 domain_address_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: Specifies the domain name.
        :param _builtins.str description: Specifies the description.
        :param _builtins.str dns_ips: The DNS IP list.
        :param _builtins.str domain_address_id: The domain address ID.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)
        if domain_address_id is not None:
            pulumi.set(__self__, "domain_address_id", domain_address_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Specifies the domain name.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[_builtins.str]:
        """
        The DNS IP list.
        """
        return pulumi.get(self, "dns_ips")

    @_builtins.property
    @pulumi.getter(name="domainAddressId")
    def domain_address_id(self) -> Optional[_builtins.str]:
        """
        The domain address ID.
        """
        return pulumi.get(self, "domain_address_id")


@pulumi.output_type
class EipProtectionProtectedEip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpv4":
            suggest = "public_ipv4"
        elif key == "publicIpv6":
            suggest = "public_ipv6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EipProtectionProtectedEip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EipProtectionProtectedEip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EipProtectionProtectedEip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 public_ipv4: Optional[_builtins.str] = None,
                 public_ipv6: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the protected EIP.
        :param _builtins.str public_ipv4: The IPv4 address of the protected EIP.
        :param _builtins.str public_ipv6: The IPv6 address of the protected EIP.
               
               > At least one of `public_ipv4` and `public_ipv6` must be set.
        """
        pulumi.set(__self__, "id", id)
        if public_ipv4 is not None:
            pulumi.set(__self__, "public_ipv4", public_ipv4)
        if public_ipv6 is not None:
            pulumi.set(__self__, "public_ipv6", public_ipv6)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the protected EIP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicIpv4")
    def public_ipv4(self) -> Optional[_builtins.str]:
        """
        The IPv4 address of the protected EIP.
        """
        return pulumi.get(self, "public_ipv4")

    @_builtins.property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> Optional[_builtins.str]:
        """
        The IPv6 address of the protected EIP.

        > At least one of `public_ipv4` and `public_ipv6` must be set.
        """
        return pulumi.get(self, "public_ipv6")


@pulumi.output_type
class FirewallFlavor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBandwidth":
            suggest = "default_bandwidth"
        elif key == "defaultEipCount":
            suggest = "default_eip_count"
        elif key == "defaultLogStorage":
            suggest = "default_log_storage"
        elif key == "defaultVpcCount":
            suggest = "default_vpc_count"
        elif key == "eipCount":
            suggest = "eip_count"
        elif key == "extendBandwidth":
            suggest = "extend_bandwidth"
        elif key == "extendEipCount":
            suggest = "extend_eip_count"
        elif key == "extendVpcCount":
            suggest = "extend_vpc_count"
        elif key == "logStorage":
            suggest = "log_storage"
        elif key == "totalRuleCount":
            suggest = "total_rule_count"
        elif key == "usedRuleCount":
            suggest = "used_rule_count"
        elif key == "vpcBandwidth":
            suggest = "vpc_bandwidth"
        elif key == "vpcCount":
            suggest = "vpc_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallFlavor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallFlavor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallFlavor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: _builtins.str,
                 bandwidth: Optional[_builtins.int] = None,
                 default_bandwidth: Optional[_builtins.int] = None,
                 default_eip_count: Optional[_builtins.int] = None,
                 default_log_storage: Optional[_builtins.int] = None,
                 default_vpc_count: Optional[_builtins.int] = None,
                 eip_count: Optional[_builtins.int] = None,
                 extend_bandwidth: Optional[_builtins.int] = None,
                 extend_eip_count: Optional[_builtins.int] = None,
                 extend_vpc_count: Optional[_builtins.int] = None,
                 log_storage: Optional[_builtins.int] = None,
                 total_rule_count: Optional[_builtins.int] = None,
                 used_rule_count: Optional[_builtins.int] = None,
                 vpc_bandwidth: Optional[_builtins.int] = None,
                 vpc_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str version: Specifies the version of the firewall.
               When the charging_mode is **prePaid**: the value can be **Standard** and **Prefessional**.
               When the charging_mode is **postPaid**: the value can be **Prefessional**.
               Changing this parameter will create a new resource.
        :param _builtins.int bandwidth: The bandwidth of the firewall.
        :param _builtins.int default_bandwidth: The default bandwidth of the firewall.
        :param _builtins.int default_eip_count: The default EIP number of the firewall.
        :param _builtins.int default_log_storage: The default log storage of the firewall.
        :param _builtins.int default_vpc_count: The default VPC number of the firewall.
        :param _builtins.int eip_count: The EIP number of the firewall.
        :param _builtins.int extend_bandwidth: Specifies the extend bandwidth of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param _builtins.int extend_eip_count: Specifies the extend EIP number of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param _builtins.int extend_vpc_count: Specifies the extend VPC number of the firewall.
               Only works when the charging_mode is **prePaid**.
               Changing this parameter will create a new resource.
        :param _builtins.int log_storage: The log storage of the firewall.
        :param _builtins.int total_rule_count: The total rule count of the firewall.
        :param _builtins.int used_rule_count: The used rule count of the firewall.
        :param _builtins.int vpc_bandwidth: The VPC bandwidth of the firewall.
        :param _builtins.int vpc_count: The VPC number of the firewall.
        """
        pulumi.set(__self__, "version", version)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if default_bandwidth is not None:
            pulumi.set(__self__, "default_bandwidth", default_bandwidth)
        if default_eip_count is not None:
            pulumi.set(__self__, "default_eip_count", default_eip_count)
        if default_log_storage is not None:
            pulumi.set(__self__, "default_log_storage", default_log_storage)
        if default_vpc_count is not None:
            pulumi.set(__self__, "default_vpc_count", default_vpc_count)
        if eip_count is not None:
            pulumi.set(__self__, "eip_count", eip_count)
        if extend_bandwidth is not None:
            pulumi.set(__self__, "extend_bandwidth", extend_bandwidth)
        if extend_eip_count is not None:
            pulumi.set(__self__, "extend_eip_count", extend_eip_count)
        if extend_vpc_count is not None:
            pulumi.set(__self__, "extend_vpc_count", extend_vpc_count)
        if log_storage is not None:
            pulumi.set(__self__, "log_storage", log_storage)
        if total_rule_count is not None:
            pulumi.set(__self__, "total_rule_count", total_rule_count)
        if used_rule_count is not None:
            pulumi.set(__self__, "used_rule_count", used_rule_count)
        if vpc_bandwidth is not None:
            pulumi.set(__self__, "vpc_bandwidth", vpc_bandwidth)
        if vpc_count is not None:
            pulumi.set(__self__, "vpc_count", vpc_count)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the firewall.
        When the charging_mode is **prePaid**: the value can be **Standard** and **Prefessional**.
        When the charging_mode is **postPaid**: the value can be **Prefessional**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[_builtins.int]:
        """
        The bandwidth of the firewall.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="defaultBandwidth")
    def default_bandwidth(self) -> Optional[_builtins.int]:
        """
        The default bandwidth of the firewall.
        """
        return pulumi.get(self, "default_bandwidth")

    @_builtins.property
    @pulumi.getter(name="defaultEipCount")
    def default_eip_count(self) -> Optional[_builtins.int]:
        """
        The default EIP number of the firewall.
        """
        return pulumi.get(self, "default_eip_count")

    @_builtins.property
    @pulumi.getter(name="defaultLogStorage")
    def default_log_storage(self) -> Optional[_builtins.int]:
        """
        The default log storage of the firewall.
        """
        return pulumi.get(self, "default_log_storage")

    @_builtins.property
    @pulumi.getter(name="defaultVpcCount")
    def default_vpc_count(self) -> Optional[_builtins.int]:
        """
        The default VPC number of the firewall.
        """
        return pulumi.get(self, "default_vpc_count")

    @_builtins.property
    @pulumi.getter(name="eipCount")
    def eip_count(self) -> Optional[_builtins.int]:
        """
        The EIP number of the firewall.
        """
        return pulumi.get(self, "eip_count")

    @_builtins.property
    @pulumi.getter(name="extendBandwidth")
    def extend_bandwidth(self) -> Optional[_builtins.int]:
        """
        Specifies the extend bandwidth of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_bandwidth")

    @_builtins.property
    @pulumi.getter(name="extendEipCount")
    def extend_eip_count(self) -> Optional[_builtins.int]:
        """
        Specifies the extend EIP number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_eip_count")

    @_builtins.property
    @pulumi.getter(name="extendVpcCount")
    def extend_vpc_count(self) -> Optional[_builtins.int]:
        """
        Specifies the extend VPC number of the firewall.
        Only works when the charging_mode is **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "extend_vpc_count")

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> Optional[_builtins.int]:
        """
        The log storage of the firewall.
        """
        return pulumi.get(self, "log_storage")

    @_builtins.property
    @pulumi.getter(name="totalRuleCount")
    def total_rule_count(self) -> Optional[_builtins.int]:
        """
        The total rule count of the firewall.
        """
        return pulumi.get(self, "total_rule_count")

    @_builtins.property
    @pulumi.getter(name="usedRuleCount")
    def used_rule_count(self) -> Optional[_builtins.int]:
        """
        The used rule count of the firewall.
        """
        return pulumi.get(self, "used_rule_count")

    @_builtins.property
    @pulumi.getter(name="vpcBandwidth")
    def vpc_bandwidth(self) -> Optional[_builtins.int]:
        """
        The VPC bandwidth of the firewall.
        """
        return pulumi.get(self, "vpc_bandwidth")

    @_builtins.property
    @pulumi.getter(name="vpcCount")
    def vpc_count(self) -> Optional[_builtins.int]:
        """
        The VPC number of the firewall.
        """
        return pulumi.get(self, "vpc_count")


@pulumi.output_type
class FirewallProtectObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "objectName":
            suggest = "object_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallProtectObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallProtectObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallProtectObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: Optional[_builtins.str] = None,
                 object_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.int] = None):
        """
        :param _builtins.str object_id: The protected object ID.
        :param _builtins.str object_name: The protected object name.
        :param _builtins.int type: The object type.
               The options are as follows: 0: north-south; 1: east-west.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[_builtins.str]:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[_builtins.str]:
        """
        The protected object name.
        """
        return pulumi.get(self, "object_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        The object type.
        The options are as follows: 0: north-south; 1: east-west.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccessControlLogsRecordResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 app: _builtins.str,
                 dst_city_id: _builtins.str,
                 dst_city_name: _builtins.str,
                 dst_host: _builtins.str,
                 dst_ip: _builtins.str,
                 dst_port: _builtins.int,
                 dst_province_id: _builtins.str,
                 dst_province_name: _builtins.str,
                 dst_region_id: _builtins.str,
                 dst_region_name: _builtins.str,
                 hit_time: _builtins.str,
                 log_id: _builtins.str,
                 protocol: _builtins.str,
                 rule_id: _builtins.str,
                 rule_name: _builtins.str,
                 src_city_id: _builtins.str,
                 src_city_name: _builtins.str,
                 src_ip: _builtins.str,
                 src_port: _builtins.int,
                 src_province_id: _builtins.str,
                 src_province_name: _builtins.str,
                 src_region_id: _builtins.str,
                 src_region_name: _builtins.str):
        """
        :param _builtins.str action: Specifies the action. The values can be **allow** and **deny**.
        :param _builtins.str app: Specifies the application protocol.
        :param _builtins.str dst_city_id: The destination city ID.
        :param _builtins.str dst_city_name: Specifies the destination city name.
        :param _builtins.str dst_host: The destination host.
        :param _builtins.str dst_ip: Specifies the destination IP address.
        :param _builtins.int dst_port: Specifies the destination port.
        :param _builtins.str dst_province_id: The destination province ID.
        :param _builtins.str dst_province_name: Specifies the destination province name.
        :param _builtins.str dst_region_id: The destination region ID.
        :param _builtins.str dst_region_name: Specifies the destination region name.
        :param _builtins.str hit_time: The hit time.
        :param _builtins.str log_id: The document ID.
        :param _builtins.str protocol: The protocol type.
        :param _builtins.str rule_id: The rule ID.
        :param _builtins.str rule_name: Specifies the rule name.
        :param _builtins.str src_city_id: The source city ID.
        :param _builtins.str src_city_name: Specifies the source city name.
        :param _builtins.str src_ip: Specifies the source IP address.
        :param _builtins.int src_port: Specifies the source port.
        :param _builtins.str src_province_id: The source province ID.
        :param _builtins.str src_province_name: Specifies the source province name.
        :param _builtins.str src_region_id: The source region ID.
        :param _builtins.str src_region_name: Specifies the source region name.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "dst_city_id", dst_city_id)
        pulumi.set(__self__, "dst_city_name", dst_city_name)
        pulumi.set(__self__, "dst_host", dst_host)
        pulumi.set(__self__, "dst_ip", dst_ip)
        pulumi.set(__self__, "dst_port", dst_port)
        pulumi.set(__self__, "dst_province_id", dst_province_id)
        pulumi.set(__self__, "dst_province_name", dst_province_name)
        pulumi.set(__self__, "dst_region_id", dst_region_id)
        pulumi.set(__self__, "dst_region_name", dst_region_name)
        pulumi.set(__self__, "hit_time", hit_time)
        pulumi.set(__self__, "log_id", log_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "src_city_id", src_city_id)
        pulumi.set(__self__, "src_city_name", src_city_name)
        pulumi.set(__self__, "src_ip", src_ip)
        pulumi.set(__self__, "src_port", src_port)
        pulumi.set(__self__, "src_province_id", src_province_id)
        pulumi.set(__self__, "src_province_name", src_province_name)
        pulumi.set(__self__, "src_region_id", src_region_id)
        pulumi.set(__self__, "src_region_name", src_region_name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Specifies the action. The values can be **allow** and **deny**.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def app(self) -> _builtins.str:
        """
        Specifies the application protocol.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="dstCityId")
    def dst_city_id(self) -> _builtins.str:
        """
        The destination city ID.
        """
        return pulumi.get(self, "dst_city_id")

    @_builtins.property
    @pulumi.getter(name="dstCityName")
    def dst_city_name(self) -> _builtins.str:
        """
        Specifies the destination city name.
        """
        return pulumi.get(self, "dst_city_name")

    @_builtins.property
    @pulumi.getter(name="dstHost")
    def dst_host(self) -> _builtins.str:
        """
        The destination host.
        """
        return pulumi.get(self, "dst_host")

    @_builtins.property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> _builtins.str:
        """
        Specifies the destination IP address.
        """
        return pulumi.get(self, "dst_ip")

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> _builtins.int:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dst_port")

    @_builtins.property
    @pulumi.getter(name="dstProvinceId")
    def dst_province_id(self) -> _builtins.str:
        """
        The destination province ID.
        """
        return pulumi.get(self, "dst_province_id")

    @_builtins.property
    @pulumi.getter(name="dstProvinceName")
    def dst_province_name(self) -> _builtins.str:
        """
        Specifies the destination province name.
        """
        return pulumi.get(self, "dst_province_name")

    @_builtins.property
    @pulumi.getter(name="dstRegionId")
    def dst_region_id(self) -> _builtins.str:
        """
        The destination region ID.
        """
        return pulumi.get(self, "dst_region_id")

    @_builtins.property
    @pulumi.getter(name="dstRegionName")
    def dst_region_name(self) -> _builtins.str:
        """
        Specifies the destination region name.
        """
        return pulumi.get(self, "dst_region_name")

    @_builtins.property
    @pulumi.getter(name="hitTime")
    def hit_time(self) -> _builtins.str:
        """
        The hit time.
        """
        return pulumi.get(self, "hit_time")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The document ID.
        """
        return pulumi.get(self, "log_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        The rule ID.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        Specifies the rule name.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="srcCityId")
    def src_city_id(self) -> _builtins.str:
        """
        The source city ID.
        """
        return pulumi.get(self, "src_city_id")

    @_builtins.property
    @pulumi.getter(name="srcCityName")
    def src_city_name(self) -> _builtins.str:
        """
        Specifies the source city name.
        """
        return pulumi.get(self, "src_city_name")

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> _builtins.str:
        """
        Specifies the source IP address.
        """
        return pulumi.get(self, "src_ip")

    @_builtins.property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> _builtins.int:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "src_port")

    @_builtins.property
    @pulumi.getter(name="srcProvinceId")
    def src_province_id(self) -> _builtins.str:
        """
        The source province ID.
        """
        return pulumi.get(self, "src_province_id")

    @_builtins.property
    @pulumi.getter(name="srcProvinceName")
    def src_province_name(self) -> _builtins.str:
        """
        Specifies the source province name.
        """
        return pulumi.get(self, "src_province_name")

    @_builtins.property
    @pulumi.getter(name="srcRegionId")
    def src_region_id(self) -> _builtins.str:
        """
        The source region ID.
        """
        return pulumi.get(self, "src_region_id")

    @_builtins.property
    @pulumi.getter(name="srcRegionName")
    def src_region_name(self) -> _builtins.str:
        """
        Specifies the source region name.
        """
        return pulumi.get(self, "src_region_name")


@pulumi.output_type
class GetAddressGroupMembersRecordResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_type: _builtins.int,
                 description: _builtins.str,
                 item_id: _builtins.str):
        """
        :param _builtins.str address: Specifies the IP address
        :param _builtins.int address_type: The address type.
        :param _builtins.str description: The address group member description.
        :param _builtins.str item_id: Specifies the address group member ID.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "item_id", item_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Specifies the IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The address group member description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> _builtins.str:
        """
        Specifies the address group member ID.
        """
        return pulumi.get(self, "item_id")


@pulumi.output_type
class GetAddressGroupsAddressGroupResult(dict):
    def __init__(__self__, *,
                 address_type: _builtins.int,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 object_id: _builtins.str,
                 ref_count: _builtins.int,
                 type: _builtins.int):
        """
        :param _builtins.int address_type: Specifies the IP address type.
               The value can be **0** (IPv4) or **1** (IPv6).
        :param _builtins.str description: The address groups description.
        :param _builtins.str id: The ID of the IP address group.
        :param _builtins.str name: Specifies the name of the address group.
        :param _builtins.str object_id: Specifies the protected object ID.
        :param _builtins.int ref_count: The number of times this address group has been referenced.
        :param _builtins.int type: The address group type.
        """
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "ref_count", ref_count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        Specifies the IP address type.
        The value can be **0** (IPv4) or **1** (IPv6).
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The address groups description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the address group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        Specifies the protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> _builtins.int:
        """
        The number of times this address group has been referenced.
        """
        return pulumi.get(self, "ref_count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        The address group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAttackLogsRecordResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 app: _builtins.str,
                 attack_rule: _builtins.str,
                 attack_rule_id: _builtins.str,
                 attack_type: _builtins.str,
                 direction: _builtins.str,
                 dst_city_id: _builtins.str,
                 dst_city_name: _builtins.str,
                 dst_ip: _builtins.str,
                 dst_port: _builtins.int,
                 dst_province_id: _builtins.str,
                 dst_province_name: _builtins.str,
                 dst_region_id: _builtins.str,
                 dst_region_name: _builtins.str,
                 event_time: _builtins.str,
                 level: _builtins.str,
                 log_id: _builtins.str,
                 packet: _builtins.str,
                 packet_length: _builtins.int,
                 packet_messages: Sequence['outputs.GetAttackLogsRecordPacketMessageResult'],
                 protocol: _builtins.str,
                 source: _builtins.str,
                 src_city_id: _builtins.str,
                 src_city_name: _builtins.str,
                 src_ip: _builtins.str,
                 src_port: _builtins.int,
                 src_province_id: _builtins.str,
                 src_province_name: _builtins.str,
                 src_region_id: _builtins.str,
                 src_region_name: _builtins.str):
        """
        :param _builtins.str action: The action.
        :param _builtins.str app: Specifies the application protocol.
        :param _builtins.str attack_rule: Specifies the intrusion event rule.
        :param _builtins.str attack_rule_id: Specifies the attack rule ID.
        :param _builtins.str attack_type: Specifies the intrusion event type.
        :param _builtins.str direction: The direction.
        :param _builtins.str dst_city_id: The destination city ID.
        :param _builtins.str dst_city_name: Specifies the destination city name.
        :param _builtins.str dst_ip: Specifies the destination IP address.
        :param _builtins.int dst_port: Specifies the destination port.
        :param _builtins.str dst_province_id: The destination province ID.
        :param _builtins.str dst_province_name: Specifies the destination province name.
        :param _builtins.str dst_region_id: The destination region ID.
        :param _builtins.str dst_region_name: Specifies the destination region name.
        :param _builtins.str event_time: The event time.
        :param _builtins.str level: Specifies the threat level.
        :param _builtins.str log_id: The log ID.
        :param _builtins.str packet: The attack log packet.
        :param _builtins.int packet_length: The packet length.
        :param Sequence['GetAttackLogsRecordPacketMessageArgs'] packet_messages: The packet messages.
        :param _builtins.str protocol: The protocol.
        :param _builtins.str source: The source.
        :param _builtins.str src_city_id: The source city ID.
        :param _builtins.str src_city_name: Specifies the source city name.
        :param _builtins.str src_ip: Specifies the source IP address.
        :param _builtins.int src_port: Specifies the source port.
        :param _builtins.str src_province_id: The source province ID.
        :param _builtins.str src_province_name: Specifies the source province name.
        :param _builtins.str src_region_id: The source region ID.
        :param _builtins.str src_region_name: Specifies the source region name.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "attack_rule", attack_rule)
        pulumi.set(__self__, "attack_rule_id", attack_rule_id)
        pulumi.set(__self__, "attack_type", attack_type)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "dst_city_id", dst_city_id)
        pulumi.set(__self__, "dst_city_name", dst_city_name)
        pulumi.set(__self__, "dst_ip", dst_ip)
        pulumi.set(__self__, "dst_port", dst_port)
        pulumi.set(__self__, "dst_province_id", dst_province_id)
        pulumi.set(__self__, "dst_province_name", dst_province_name)
        pulumi.set(__self__, "dst_region_id", dst_region_id)
        pulumi.set(__self__, "dst_region_name", dst_region_name)
        pulumi.set(__self__, "event_time", event_time)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "log_id", log_id)
        pulumi.set(__self__, "packet", packet)
        pulumi.set(__self__, "packet_length", packet_length)
        pulumi.set(__self__, "packet_messages", packet_messages)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "src_city_id", src_city_id)
        pulumi.set(__self__, "src_city_name", src_city_name)
        pulumi.set(__self__, "src_ip", src_ip)
        pulumi.set(__self__, "src_port", src_port)
        pulumi.set(__self__, "src_province_id", src_province_id)
        pulumi.set(__self__, "src_province_name", src_province_name)
        pulumi.set(__self__, "src_region_id", src_region_id)
        pulumi.set(__self__, "src_region_name", src_region_name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def app(self) -> _builtins.str:
        """
        Specifies the application protocol.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="attackRule")
    def attack_rule(self) -> _builtins.str:
        """
        Specifies the intrusion event rule.
        """
        return pulumi.get(self, "attack_rule")

    @_builtins.property
    @pulumi.getter(name="attackRuleId")
    def attack_rule_id(self) -> _builtins.str:
        """
        Specifies the attack rule ID.
        """
        return pulumi.get(self, "attack_rule_id")

    @_builtins.property
    @pulumi.getter(name="attackType")
    def attack_type(self) -> _builtins.str:
        """
        Specifies the intrusion event type.
        """
        return pulumi.get(self, "attack_type")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The direction.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="dstCityId")
    def dst_city_id(self) -> _builtins.str:
        """
        The destination city ID.
        """
        return pulumi.get(self, "dst_city_id")

    @_builtins.property
    @pulumi.getter(name="dstCityName")
    def dst_city_name(self) -> _builtins.str:
        """
        Specifies the destination city name.
        """
        return pulumi.get(self, "dst_city_name")

    @_builtins.property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> _builtins.str:
        """
        Specifies the destination IP address.
        """
        return pulumi.get(self, "dst_ip")

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> _builtins.int:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dst_port")

    @_builtins.property
    @pulumi.getter(name="dstProvinceId")
    def dst_province_id(self) -> _builtins.str:
        """
        The destination province ID.
        """
        return pulumi.get(self, "dst_province_id")

    @_builtins.property
    @pulumi.getter(name="dstProvinceName")
    def dst_province_name(self) -> _builtins.str:
        """
        Specifies the destination province name.
        """
        return pulumi.get(self, "dst_province_name")

    @_builtins.property
    @pulumi.getter(name="dstRegionId")
    def dst_region_id(self) -> _builtins.str:
        """
        The destination region ID.
        """
        return pulumi.get(self, "dst_region_id")

    @_builtins.property
    @pulumi.getter(name="dstRegionName")
    def dst_region_name(self) -> _builtins.str:
        """
        Specifies the destination region name.
        """
        return pulumi.get(self, "dst_region_name")

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> _builtins.str:
        """
        The event time.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter
    def level(self) -> _builtins.str:
        """
        Specifies the threat level.
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log ID.
        """
        return pulumi.get(self, "log_id")

    @_builtins.property
    @pulumi.getter
    def packet(self) -> _builtins.str:
        """
        The attack log packet.
        """
        return pulumi.get(self, "packet")

    @_builtins.property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> _builtins.int:
        """
        The packet length.
        """
        return pulumi.get(self, "packet_length")

    @_builtins.property
    @pulumi.getter(name="packetMessages")
    def packet_messages(self) -> Sequence['outputs.GetAttackLogsRecordPacketMessageResult']:
        """
        The packet messages.
        """
        return pulumi.get(self, "packet_messages")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The source.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="srcCityId")
    def src_city_id(self) -> _builtins.str:
        """
        The source city ID.
        """
        return pulumi.get(self, "src_city_id")

    @_builtins.property
    @pulumi.getter(name="srcCityName")
    def src_city_name(self) -> _builtins.str:
        """
        Specifies the source city name.
        """
        return pulumi.get(self, "src_city_name")

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> _builtins.str:
        """
        Specifies the source IP address.
        """
        return pulumi.get(self, "src_ip")

    @_builtins.property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> _builtins.int:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "src_port")

    @_builtins.property
    @pulumi.getter(name="srcProvinceId")
    def src_province_id(self) -> _builtins.str:
        """
        The source province ID.
        """
        return pulumi.get(self, "src_province_id")

    @_builtins.property
    @pulumi.getter(name="srcProvinceName")
    def src_province_name(self) -> _builtins.str:
        """
        Specifies the source province name.
        """
        return pulumi.get(self, "src_province_name")

    @_builtins.property
    @pulumi.getter(name="srcRegionId")
    def src_region_id(self) -> _builtins.str:
        """
        The source region ID.
        """
        return pulumi.get(self, "src_region_id")

    @_builtins.property
    @pulumi.getter(name="srcRegionName")
    def src_region_name(self) -> _builtins.str:
        """
        Specifies the source region name.
        """
        return pulumi.get(self, "src_region_name")


@pulumi.output_type
class GetAttackLogsRecordPacketMessageResult(dict):
    def __init__(__self__, *,
                 hex_index: _builtins.str,
                 hexs: Sequence[_builtins.str],
                 utf8_string: _builtins.str):
        """
        :param _builtins.str hex_index: The hexadecimal index.
        :param Sequence[_builtins.str] hexs: The hexadecimal series.
        :param _builtins.str utf8_string: The utf-8 string.
        """
        pulumi.set(__self__, "hex_index", hex_index)
        pulumi.set(__self__, "hexs", hexs)
        pulumi.set(__self__, "utf8_string", utf8_string)

    @_builtins.property
    @pulumi.getter(name="hexIndex")
    def hex_index(self) -> _builtins.str:
        """
        The hexadecimal index.
        """
        return pulumi.get(self, "hex_index")

    @_builtins.property
    @pulumi.getter
    def hexs(self) -> Sequence[_builtins.str]:
        """
        The hexadecimal series.
        """
        return pulumi.get(self, "hexs")

    @_builtins.property
    @pulumi.getter(name="utf8String")
    def utf8_string(self) -> _builtins.str:
        """
        The utf-8 string.
        """
        return pulumi.get(self, "utf8_string")


@pulumi.output_type
class GetBlackWhiteListsRecordResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_type: _builtins.str,
                 description: _builtins.str,
                 direction: _builtins.str,
                 list_id: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.int):
        """
        :param _builtins.str address: Specifies the IP address.
        :param _builtins.str address_type: Specifies the IP address type.
               The valid value can be **0** (IPv4).
        :param _builtins.str description: Specifies the description.
        :param _builtins.str direction: Specifies the direction of a black or white address.
               The options are as follows:
               + **0**: source address;
               + **1**: destination address;
        :param _builtins.str list_id: Specifies the blacklist/whitelist ID.
        :param _builtins.str port: Specifies the port.
        :param _builtins.int protocol: Specifies The protocol type.
               The options are as follows:
               + **6**: TCP;
               + **17**: UDP;
               + **1**: ICMP;
               + **-1**: any protocol;
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "list_id", list_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Specifies the IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.str:
        """
        Specifies the IP address type.
        The valid value can be **0** (IPv4).
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Specifies the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Specifies the direction of a black or white address.
        The options are as follows:
        + **0**: source address;
        + **1**: destination address;
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> _builtins.str:
        """
        Specifies the blacklist/whitelist ID.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Specifies the port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        Specifies The protocol type.
        The options are as follows:
        + **6**: TCP;
        + **17**: UDP;
        + **1**: ICMP;
        + **-1**: any protocol;
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetCaptureTaskResultsFileListResult(dict):
    def __init__(__self__, *,
                 file_name: _builtins.str,
                 file_path: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str file_name: The file name.
        :param _builtins.str file_path: The file path.
        :param _builtins.str url: The download link.
        """
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        The file name.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> _builtins.str:
        """
        The file path.
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The download link.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetCaptureTaskResultsRequestHeaderResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str):
        """
        :param _builtins.str host: The host header information.
        """
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The host header information.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class GetCaptureTasksRecordResult(dict):
    def __init__(__self__, *,
                 capture_size: _builtins.str,
                 created_at: _builtins.str,
                 dest_address: _builtins.str,
                 dest_address_type: _builtins.int,
                 dest_port: _builtins.str,
                 duration: _builtins.int,
                 is_deleted: _builtins.int,
                 max_packets: _builtins.int,
                 name: _builtins.str,
                 protocol: _builtins.int,
                 remaining_days: _builtins.int,
                 source_address: _builtins.str,
                 source_address_type: _builtins.int,
                 source_port: _builtins.str,
                 status: _builtins.int,
                 task_id: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str capture_size: The capture task size.
        :param _builtins.str created_at: The creation time of the capture task.
        :param _builtins.str dest_address: The destination address.
        :param _builtins.int dest_address_type: The destination address type.
        :param _builtins.str dest_port: The destination port.
        :param _builtins.int duration: The capture task duration.
        :param _builtins.int is_deleted: Whether is deleted.
        :param _builtins.int max_packets: The max packets.
        :param _builtins.str name: The capture task name.
        :param _builtins.int protocol: The protocol type.
        :param _builtins.int remaining_days: The remaining days.
        :param _builtins.str source_address: The source address.
        :param _builtins.int source_address_type: The source address type.
        :param _builtins.str source_port: The source port.
        :param _builtins.int status: The capture task status.
        :param _builtins.str task_id: The capture task ID.
        :param _builtins.str updated_at: The update time of the capture task.
        """
        pulumi.set(__self__, "capture_size", capture_size)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "dest_address", dest_address)
        pulumi.set(__self__, "dest_address_type", dest_address_type)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "is_deleted", is_deleted)
        pulumi.set(__self__, "max_packets", max_packets)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remaining_days", remaining_days)
        pulumi.set(__self__, "source_address", source_address)
        pulumi.set(__self__, "source_address_type", source_address_type)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="captureSize")
    def capture_size(self) -> _builtins.str:
        """
        The capture task size.
        """
        return pulumi.get(self, "capture_size")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the capture task.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="destAddress")
    def dest_address(self) -> _builtins.str:
        """
        The destination address.
        """
        return pulumi.get(self, "dest_address")

    @_builtins.property
    @pulumi.getter(name="destAddressType")
    def dest_address_type(self) -> _builtins.int:
        """
        The destination address type.
        """
        return pulumi.get(self, "dest_address_type")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        The capture task duration.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> _builtins.int:
        """
        Whether is deleted.
        """
        return pulumi.get(self, "is_deleted")

    @_builtins.property
    @pulumi.getter(name="maxPackets")
    def max_packets(self) -> _builtins.int:
        """
        The max packets.
        """
        return pulumi.get(self, "max_packets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The capture task name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remainingDays")
    def remaining_days(self) -> _builtins.int:
        """
        The remaining days.
        """
        return pulumi.get(self, "remaining_days")

    @_builtins.property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> _builtins.str:
        """
        The source address.
        """
        return pulumi.get(self, "source_address")

    @_builtins.property
    @pulumi.getter(name="sourceAddressType")
    def source_address_type(self) -> _builtins.int:
        """
        The source address type.
        """
        return pulumi.get(self, "source_address_type")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        The source port.
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The capture task status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> _builtins.str:
        """
        The capture task ID.
        """
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The update time of the capture task.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetDomainNameGroupsRecordResult(dict):
    def __init__(__self__, *,
                 config_status: _builtins.str,
                 description: _builtins.str,
                 domain_names: Sequence['outputs.GetDomainNameGroupsRecordDomainNameResult'],
                 group_id: _builtins.str,
                 message: _builtins.str,
                 name: _builtins.str,
                 ref_count: _builtins.str,
                 rules: Sequence['outputs.GetDomainNameGroupsRecordRuleResult'],
                 type: _builtins.str):
        """
        :param _builtins.str config_status: Specifies the configuration status.
               The valid values are as follows:
               + **-1**: not configured.
               + **0**: configuration failed.
               + **1**: configuration succeeded.
               + **2**: configuration in progress.
               + **3**: normal.
               + **4**: configuration exception - domain group usage.
        :param _builtins.str description: The description.
        :param Sequence['GetDomainNameGroupsRecordDomainNameArgs'] domain_names: The list of domain names.
        :param _builtins.str group_id: Specifies the domain name group ID.
        :param _builtins.str message: The configuration message.
        :param _builtins.str name: Specifies the name of a domain name group.
        :param _builtins.str ref_count: Specifies the domain name group reference count.
        :param Sequence['GetDomainNameGroupsRecordRuleArgs'] rules: The used rule list.
        :param _builtins.str type: Specifies the domain name group type.
               The value can be:
               + **0**: means application type;
               + **1**: means network type.
        """
        pulumi.set(__self__, "config_status", config_status)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_names", domain_names)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ref_count", ref_count)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configStatus")
    def config_status(self) -> _builtins.str:
        """
        Specifies the configuration status.
        The valid values are as follows:
        + **-1**: not configured.
        + **0**: configuration failed.
        + **1**: configuration succeeded.
        + **2**: configuration in progress.
        + **3**: normal.
        + **4**: configuration exception - domain group usage.
        """
        return pulumi.get(self, "config_status")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence['outputs.GetDomainNameGroupsRecordDomainNameResult']:
        """
        The list of domain names.
        """
        return pulumi.get(self, "domain_names")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        Specifies the domain name group ID.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The configuration message.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of a domain name group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> _builtins.str:
        """
        Specifies the domain name group reference count.
        """
        return pulumi.get(self, "ref_count")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetDomainNameGroupsRecordRuleResult']:
        """
        The used rule list.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the domain name group type.
        The value can be:
        + **0**: means application type;
        + **1**: means network type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDomainNameGroupsRecordDomainNameResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 domain_address_id: _builtins.str,
                 domain_name: _builtins.str):
        """
        :param _builtins.str description: The description.
        :param _builtins.str domain_address_id: The domain address ID.
        :param _builtins.str domain_name: The domain name.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_address_id", domain_address_id)
        pulumi.set(__self__, "domain_name", domain_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainAddressId")
    def domain_address_id(self) -> _builtins.str:
        """
        The domain address ID.
        """
        return pulumi.get(self, "domain_address_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain_name")


@pulumi.output_type
class GetDomainNameGroupsRecordRuleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The rule ID.
        :param _builtins.str name: Specifies the name of a domain name group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The rule ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of a domain name group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetFirewallsRecordResult(dict):
    def __init__(__self__, *,
                 charge_mode: _builtins.int,
                 engine_type: _builtins.int,
                 feature_toggle: Mapping[str, _builtins.bool],
                 flavors: Sequence['outputs.GetFirewallsRecordFlavorResult'],
                 fw_instance_id: _builtins.str,
                 ha_type: _builtins.int,
                 is_old_firewall_instance: _builtins.bool,
                 name: _builtins.str,
                 protect_objects: Sequence['outputs.GetFirewallsRecordProtectObjectResult'],
                 resources: Sequence['outputs.GetFirewallsRecordResourceResult'],
                 service_type: _builtins.int,
                 status: _builtins.int,
                 support_ipv6: _builtins.bool):
        """
        :param _builtins.int charge_mode: The billing mode. The value can be 0 (yearly/monthly) or 1 (pay-per-use).
        :param _builtins.int engine_type: The engine type.
        :param Mapping[str, _builtins.bool] feature_toggle: The map of feature toggle.
        :param Sequence['GetFirewallsRecordFlavorArgs'] flavors: The flavor of the firewall.
               The Flavor structure is documented below.
        :param _builtins.str fw_instance_id: Specifies the firewall instance ID.
               If not specified, the first instance will be returned.
        :param _builtins.int ha_type: The cluster type.
        :param _builtins.bool is_old_firewall_instance: Whether the engine is an old engine.
        :param _builtins.str name: The firewall name.
        :param Sequence['GetFirewallsRecordProtectObjectArgs'] protect_objects: The project list.
               The Protect Object structure is documented below.
        :param Sequence['GetFirewallsRecordResourceArgs'] resources: The firewall instance resources.
               The Firewall Instance Resource structure is
               documented below.
        :param _builtins.int service_type: Specifies the service type. The value can be:
               + **0**: North-south firewall;
               + **1**: East-west firewall;
        :param _builtins.int status: The firewall status. The options are as follows:
               + **-1**: waiting for payment;
               + **0**: creating;
               + **1**: deleting;
               + **2**: running;
               + **3**: upgrading;
               + **4**: deletion completed;
               + **5**: freezing;
               + **6**: creation failed;
               + **7**: deletion failed;
               + **8**: freezing failed;
               + **9**: storage in progress;
               + **10**: storage failed;
               + **11**: upgrade failed;
        :param _builtins.bool support_ipv6: Whether IPv6 is supported.
        """
        pulumi.set(__self__, "charge_mode", charge_mode)
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "feature_toggle", feature_toggle)
        pulumi.set(__self__, "flavors", flavors)
        pulumi.set(__self__, "fw_instance_id", fw_instance_id)
        pulumi.set(__self__, "ha_type", ha_type)
        pulumi.set(__self__, "is_old_firewall_instance", is_old_firewall_instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protect_objects", protect_objects)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "support_ipv6", support_ipv6)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> _builtins.int:
        """
        The billing mode. The value can be 0 (yearly/monthly) or 1 (pay-per-use).
        """
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> _builtins.int:
        """
        The engine type.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="featureToggle")
    def feature_toggle(self) -> Mapping[str, _builtins.bool]:
        """
        The map of feature toggle.
        """
        return pulumi.get(self, "feature_toggle")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFirewallsRecordFlavorResult']:
        """
        The flavor of the firewall.
        The Flavor structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter(name="fwInstanceId")
    def fw_instance_id(self) -> _builtins.str:
        """
        Specifies the firewall instance ID.
        If not specified, the first instance will be returned.
        """
        return pulumi.get(self, "fw_instance_id")

    @_builtins.property
    @pulumi.getter(name="haType")
    def ha_type(self) -> _builtins.int:
        """
        The cluster type.
        """
        return pulumi.get(self, "ha_type")

    @_builtins.property
    @pulumi.getter(name="isOldFirewallInstance")
    def is_old_firewall_instance(self) -> _builtins.bool:
        """
        Whether the engine is an old engine.
        """
        return pulumi.get(self, "is_old_firewall_instance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The firewall name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectObjects")
    def protect_objects(self) -> Sequence['outputs.GetFirewallsRecordProtectObjectResult']:
        """
        The project list.
        The Protect Object structure is documented below.
        """
        return pulumi.get(self, "protect_objects")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetFirewallsRecordResourceResult']:
        """
        The firewall instance resources.
        The Firewall Instance Resource structure is
        documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> _builtins.int:
        """
        Specifies the service type. The value can be:
        + **0**: North-south firewall;
        + **1**: East-west firewall;
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The firewall status. The options are as follows:
        + **-1**: waiting for payment;
        + **0**: creating;
        + **1**: deleting;
        + **2**: running;
        + **3**: upgrading;
        + **4**: deletion completed;
        + **5**: freezing;
        + **6**: creation failed;
        + **7**: deletion failed;
        + **8**: freezing failed;
        + **9**: storage in progress;
        + **10**: storage failed;
        + **11**: upgrade failed;
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> _builtins.bool:
        """
        Whether IPv6 is supported.
        """
        return pulumi.get(self, "support_ipv6")


@pulumi.output_type
class GetFirewallsRecordFlavorResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 eip_count: _builtins.int,
                 log_storage: _builtins.int,
                 version: _builtins.int,
                 vpc_count: _builtins.int):
        """
        :param _builtins.int bandwidth: The bandwidth.
        :param _builtins.int eip_count: The number of EIPs.
        :param _builtins.int log_storage: The log storage.
        :param _builtins.int version: The firewall version. The value can be 0 (standard edition), 1 (professional edition),
               2 (platinum edition), or 3 (basic edition).
        :param _builtins.int vpc_count: The number of VPCs.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "eip_count", eip_count)
        pulumi.set(__self__, "log_storage", log_storage)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vpc_count", vpc_count)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="eipCount")
    def eip_count(self) -> _builtins.int:
        """
        The number of EIPs.
        """
        return pulumi.get(self, "eip_count")

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> _builtins.int:
        """
        The log storage.
        """
        return pulumi.get(self, "log_storage")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The firewall version. The value can be 0 (standard edition), 1 (professional edition),
        2 (platinum edition), or 3 (basic edition).
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcCount")
    def vpc_count(self) -> _builtins.int:
        """
        The number of VPCs.
        """
        return pulumi.get(self, "vpc_count")


@pulumi.output_type
class GetFirewallsRecordProtectObjectResult(dict):
    def __init__(__self__, *,
                 object_id: _builtins.str,
                 object_name: _builtins.str,
                 type: _builtins.int):
        """
        :param _builtins.str object_id: The protected object ID.
        :param _builtins.str object_name: The protected object name.
        :param _builtins.int type: The project type. The options are as follows:
               + **0**: north-south;
               + **1**: east-west;
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        The protected object ID.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> _builtins.str:
        """
        The protected object name.
        """
        return pulumi.get(self, "object_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        The project type. The options are as follows:
        + **0**: north-south;
        + **1**: east-west;
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFirewallsRecordResourceResult(dict):
    def __init__(__self__, *,
                 cloud_service_type: _builtins.str,
                 resource_id: _builtins.str,
                 resource_size: _builtins.int,
                 resource_size_measure_id: _builtins.int,
                 resource_spec_code: _builtins.str,
                 resource_type: _builtins.str):
        """
        :param _builtins.str cloud_service_type: Service type, which is used by CBC. The value is **hws.service.type.cfw**.
        :param _builtins.str resource_id: Resource ID.
        :param _builtins.int resource_size: Resource quantity.
        :param _builtins.int resource_size_measure_id: Resource unit name.
        :param _builtins.str resource_spec_code: Inventory unit code.
        :param _builtins.str resource_type: Resource type. The options are as follows:
               + **CFW**: hws.resource.type.cfw;
               + **EIP**: hws.resource.type.cfw.exp.eip;
               + **Bandwidth**: hws.resource.type.cfw.exp.bandwidth;
               + **VPC**: hws.resource.type.cfw.exp.vpc;
               + **Log storage**: hws.resource.type.cfw.exp.logaudit;
        """
        pulumi.set(__self__, "cloud_service_type", cloud_service_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_size", resource_size)
        pulumi.set(__self__, "resource_size_measure_id", resource_size_measure_id)
        pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter(name="cloudServiceType")
    def cloud_service_type(self) -> _builtins.str:
        """
        Service type, which is used by CBC. The value is **hws.service.type.cfw**.
        """
        return pulumi.get(self, "cloud_service_type")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        Resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceSize")
    def resource_size(self) -> _builtins.int:
        """
        Resource quantity.
        """
        return pulumi.get(self, "resource_size")

    @_builtins.property
    @pulumi.getter(name="resourceSizeMeasureId")
    def resource_size_measure_id(self) -> _builtins.int:
        """
        Resource unit name.
        """
        return pulumi.get(self, "resource_size_measure_id")

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> _builtins.str:
        """
        Inventory unit code.
        """
        return pulumi.get(self, "resource_spec_code")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Resource type. The options are as follows:
        + **CFW**: hws.resource.type.cfw;
        + **EIP**: hws.resource.type.cfw.exp.eip;
        + **Bandwidth**: hws.resource.type.cfw.exp.bandwidth;
        + **VPC**: hws.resource.type.cfw.exp.vpc;
        + **Log storage**: hws.resource.type.cfw.exp.logaudit;
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetFlowLogsRecordResult(dict):
    def __init__(__self__, *,
                 app: _builtins.str,
                 bytes: _builtins.float,
                 direction: _builtins.str,
                 dst_city_id: _builtins.str,
                 dst_city_name: _builtins.str,
                 dst_host: _builtins.str,
                 dst_ip: _builtins.str,
                 dst_port: _builtins.int,
                 dst_province_id: _builtins.str,
                 dst_province_name: _builtins.str,
                 dst_region_id: _builtins.str,
                 dst_region_name: _builtins.str,
                 end_time: _builtins.str,
                 log_id: _builtins.str,
                 packets: _builtins.int,
                 protocol: _builtins.str,
                 src_city_id: _builtins.str,
                 src_city_name: _builtins.str,
                 src_ip: _builtins.str,
                 src_port: _builtins.int,
                 src_province_id: _builtins.str,
                 src_province_name: _builtins.str,
                 src_region_id: _builtins.str,
                 src_region_name: _builtins.str,
                 start_time: _builtins.str):
        """
        :param _builtins.str app: Specifies the application protocol.
        :param _builtins.float bytes: The flow log bytes.
        :param _builtins.str direction: Specifies the direction. The values can be **out2in** and **in2out**.
        :param _builtins.str dst_city_id: The destination city ID.
        :param _builtins.str dst_city_name: Specifies the destination city name.
        :param _builtins.str dst_host: The destination host.
        :param _builtins.str dst_ip: Specifies the destination IP address.
        :param _builtins.int dst_port: Specifies the destination port.
        :param _builtins.str dst_province_id: The destination province ID.
        :param _builtins.str dst_province_name: Specifies the destination province name.
        :param _builtins.str dst_region_id: The destination region ID.
        :param _builtins.str dst_region_name: Specifies the destination region name.
        :param _builtins.str end_time: Specifies the end time. The time is in UTC.
               The format is **yyyy-MM-dd HH:mm:ss**.
        :param _builtins.str log_id: The document ID.
        :param _builtins.int packets: The number of packets.
        :param _builtins.str protocol: The protocol type.
        :param _builtins.str src_city_id: The source city ID.
        :param _builtins.str src_city_name: Specifies the source city name.
        :param _builtins.str src_ip: Specifies the source IP address.
        :param _builtins.int src_port: Specifies the source port.
        :param _builtins.str src_province_id: The source province ID.
        :param _builtins.str src_province_name: Specifies the source province name.
        :param _builtins.str src_region_id: The source region ID.
        :param _builtins.str src_region_name: Specifies the source region name.
        :param _builtins.str start_time: Specifies the start time. The time is in UTC.
               The format is **yyyy-MM-dd HH:mm:ss**.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "bytes", bytes)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "dst_city_id", dst_city_id)
        pulumi.set(__self__, "dst_city_name", dst_city_name)
        pulumi.set(__self__, "dst_host", dst_host)
        pulumi.set(__self__, "dst_ip", dst_ip)
        pulumi.set(__self__, "dst_port", dst_port)
        pulumi.set(__self__, "dst_province_id", dst_province_id)
        pulumi.set(__self__, "dst_province_name", dst_province_name)
        pulumi.set(__self__, "dst_region_id", dst_region_id)
        pulumi.set(__self__, "dst_region_name", dst_region_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "log_id", log_id)
        pulumi.set(__self__, "packets", packets)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "src_city_id", src_city_id)
        pulumi.set(__self__, "src_city_name", src_city_name)
        pulumi.set(__self__, "src_ip", src_ip)
        pulumi.set(__self__, "src_port", src_port)
        pulumi.set(__self__, "src_province_id", src_province_id)
        pulumi.set(__self__, "src_province_name", src_province_name)
        pulumi.set(__self__, "src_region_id", src_region_id)
        pulumi.set(__self__, "src_region_name", src_region_name)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def app(self) -> _builtins.str:
        """
        Specifies the application protocol.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter
    def bytes(self) -> _builtins.float:
        """
        The flow log bytes.
        """
        return pulumi.get(self, "bytes")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Specifies the direction. The values can be **out2in** and **in2out**.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="dstCityId")
    def dst_city_id(self) -> _builtins.str:
        """
        The destination city ID.
        """
        return pulumi.get(self, "dst_city_id")

    @_builtins.property
    @pulumi.getter(name="dstCityName")
    def dst_city_name(self) -> _builtins.str:
        """
        Specifies the destination city name.
        """
        return pulumi.get(self, "dst_city_name")

    @_builtins.property
    @pulumi.getter(name="dstHost")
    def dst_host(self) -> _builtins.str:
        """
        The destination host.
        """
        return pulumi.get(self, "dst_host")

    @_builtins.property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> _builtins.str:
        """
        Specifies the destination IP address.
        """
        return pulumi.get(self, "dst_ip")

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> _builtins.int:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dst_port")

    @_builtins.property
    @pulumi.getter(name="dstProvinceId")
    def dst_province_id(self) -> _builtins.str:
        """
        The destination province ID.
        """
        return pulumi.get(self, "dst_province_id")

    @_builtins.property
    @pulumi.getter(name="dstProvinceName")
    def dst_province_name(self) -> _builtins.str:
        """
        Specifies the destination province name.
        """
        return pulumi.get(self, "dst_province_name")

    @_builtins.property
    @pulumi.getter(name="dstRegionId")
    def dst_region_id(self) -> _builtins.str:
        """
        The destination region ID.
        """
        return pulumi.get(self, "dst_region_id")

    @_builtins.property
    @pulumi.getter(name="dstRegionName")
    def dst_region_name(self) -> _builtins.str:
        """
        Specifies the destination region name.
        """
        return pulumi.get(self, "dst_region_name")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        Specifies the end time. The time is in UTC.
        The format is **yyyy-MM-dd HH:mm:ss**.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The document ID.
        """
        return pulumi.get(self, "log_id")

    @_builtins.property
    @pulumi.getter
    def packets(self) -> _builtins.int:
        """
        The number of packets.
        """
        return pulumi.get(self, "packets")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="srcCityId")
    def src_city_id(self) -> _builtins.str:
        """
        The source city ID.
        """
        return pulumi.get(self, "src_city_id")

    @_builtins.property
    @pulumi.getter(name="srcCityName")
    def src_city_name(self) -> _builtins.str:
        """
        Specifies the source city name.
        """
        return pulumi.get(self, "src_city_name")

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> _builtins.str:
        """
        Specifies the source IP address.
        """
        return pulumi.get(self, "src_ip")

    @_builtins.property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> _builtins.int:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "src_port")

    @_builtins.property
    @pulumi.getter(name="srcProvinceId")
    def src_province_id(self) -> _builtins.str:
        """
        The source province ID.
        """
        return pulumi.get(self, "src_province_id")

    @_builtins.property
    @pulumi.getter(name="srcProvinceName")
    def src_province_name(self) -> _builtins.str:
        """
        Specifies the source province name.
        """
        return pulumi.get(self, "src_province_name")

    @_builtins.property
    @pulumi.getter(name="srcRegionId")
    def src_region_id(self) -> _builtins.str:
        """
        The source region ID.
        """
        return pulumi.get(self, "src_region_id")

    @_builtins.property
    @pulumi.getter(name="srcRegionName")
    def src_region_name(self) -> _builtins.str:
        """
        Specifies the source region name.
        """
        return pulumi.get(self, "src_region_name")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Specifies the start time. The time is in UTC.
        The format is **yyyy-MM-dd HH:mm:ss**.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetIpsCustomRulesRecordResult(dict):
    def __init__(__self__, *,
                 action: _builtins.int,
                 affected_os: _builtins.int,
                 attack_type: _builtins.int,
                 config_status: _builtins.int,
                 content: _builtins.str,
                 dst_port_type: _builtins.int,
                 dst_ports: _builtins.str,
                 group_id: _builtins.str,
                 ips_cfw_id: _builtins.str,
                 ips_id: _builtins.str,
                 ips_name: _builtins.str,
                 protocol: _builtins.int,
                 severity: _builtins.int,
                 software: _builtins.int,
                 src_port_type: _builtins.int,
                 src_ports: _builtins.str):
        """
        :param _builtins.int action: The action.
        :param _builtins.int affected_os: Specifies the affected OS.
               The valid values are as follows:
               + **1**: Windows;
               + **2**: Linux;
               + **3**: FreeBSD;
               + **4**: Solaris;
               + **5**: Other Unix;
               + **6**: Network device;
               + **7**: MAC OS;
               + **8**: IOS;
               + **9**: Android;
               + **10**: Other;
        :param _builtins.int attack_type: Specifies the attack type.
               The valid values are as follows:
               + **1**: access control;
               + **2**: vulnerability scan;
               + **3**: email phishing;
               + **4**: vulnerability exploits;
               + **5**: web attack;
               + **6**: password cracking;
               + **7**: hijacking attack;
               + **8**: protocol exception;
               + **9**: trojan;
               + **10**: worm;
               + **11**: buffer overflow;
               + **12**: hacker tool;
               + **13**: spyware;
               + **14**: DDoS flood;
               + **15**: application-layer DDoS attack;
               + **16**: other suspicious behavior;
               + **17**: suspicious DNS activity;
               + **18**: phishing;
               + **19**: spam;
        :param _builtins.int config_status: The rule status.
        :param _builtins.str content: The content storage in JSON format.
        :param _builtins.int dst_port_type: The destination port type.
        :param _builtins.str dst_ports: The destination port.
        :param _builtins.str group_id: The firewall cluster ID.
        :param _builtins.str ips_cfw_id: The ID of a custom IPS rule in CFW.
        :param _builtins.str ips_id: The ID of a rule in Hillstone.
        :param _builtins.str ips_name: Specifies the IPS custom rule name.
        :param _builtins.int protocol: Specifies the protocol.
               The valid values are as follows:
               + **1**: FTP;
               + **2**: TELNET;
               + **3**: SMTP;
               + **4**: DNS-TCP;
               + **5**: DNS-UDP;
               + **6**: DHCP;
               + **7**: TFTP;
               + **8**: FINGER;
               + **9**: HTTP;
               + **10**: POP3;
               + **11**: SUNRPC-TCP;
               + **12**: SUNRPC-UDP;
               + **13**: NNTP;
               + **14**: MSRPC-TCP;
               + **15**: MSRPC-UDP;
               + **16**: NETBIOS-NAME_TCP;
               + **17**: NETBIOS-NAME_UDP;
               + **18**: NETBIOS-SMB;
               + **19**: NETBIOS-DATAGRAM;
               + **20**: IMAP4;
               + **21**: SNMP;
               + **22**: LDAP;
               + **23**: MSSQL;
               + **24**: ORACLE;
               + **25**: MYSQL;
               + **26**: VOIP-SIP-TCP;
               + **27**: VOIP-SIP-UDP;
               + **28**: VOIP-H245;
               + **29**: VOIP-Q931;
               + **30**: OTHER-TCP;
               + **31**: OTHER-UDP;
        :param _builtins.int severity: Specifies the severity.
               The valid values are as follows:
               + **0**: critical;
               + **1**: high;
               + **2**: medium;
               + **3**: low;
        :param _builtins.int software: Specifies the affected software.
               The valid values are as follows:
               + **1**: ADOBE;
               + **2**: APACHE;
               + **3**: APPLE;
               + **4**: CA;
               + **5**: CISCO;
               + **6**: GOOGLE CHROME;
               + **7**: HP;
               + **8**: IBM;
               + **9**: IE;
               + **10**: IIS;
               + **11**: MCAFEE;
               + **12**: MEDIAPLAYER;
               + **13**: MICROSOFT.NET;
               + **14**: MICROSOFT EDGE;
               + **15**: MICROSOFT EXCHANGE;
               + **16**: MICROSOFT OFFICE;
               + **17**: MICROSOFT OUTLOOK;
               + **18**: MICROSOFT SHAREPOINT;
               + **19**: MICROSOFT WINDOWS;
               + **20**: MOZILLA;
               + **21**: MSSQL;
               + **22**: MYSQL;
               + **23**: NOVELL;
               + **24**: ORACLE;
               + **25**: SAMBA;
               + **26**: SAMSUNG;
               + **27**: SAP;
               + **28**: SCADA;
               + **29**: SQUID;
               + **30**: SUN;
               + **31**: SYMANTEC;
               + **32**: TREND MICRO;
               + **33**: VMWARE;
               + **34**: WORDPRESS;
               + **35**: OTHER;
        :param _builtins.int src_port_type: The source port type.
        :param _builtins.str src_ports: The source port.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "affected_os", affected_os)
        pulumi.set(__self__, "attack_type", attack_type)
        pulumi.set(__self__, "config_status", config_status)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "dst_port_type", dst_port_type)
        pulumi.set(__self__, "dst_ports", dst_ports)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "ips_cfw_id", ips_cfw_id)
        pulumi.set(__self__, "ips_id", ips_id)
        pulumi.set(__self__, "ips_name", ips_name)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "software", software)
        pulumi.set(__self__, "src_port_type", src_port_type)
        pulumi.set(__self__, "src_ports", src_ports)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.int:
        """
        The action.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="affectedOs")
    def affected_os(self) -> _builtins.int:
        """
        Specifies the affected OS.
        The valid values are as follows:
        + **1**: Windows;
        + **2**: Linux;
        + **3**: FreeBSD;
        + **4**: Solaris;
        + **5**: Other Unix;
        + **6**: Network device;
        + **7**: MAC OS;
        + **8**: IOS;
        + **9**: Android;
        + **10**: Other;
        """
        return pulumi.get(self, "affected_os")

    @_builtins.property
    @pulumi.getter(name="attackType")
    def attack_type(self) -> _builtins.int:
        """
        Specifies the attack type.
        The valid values are as follows:
        + **1**: access control;
        + **2**: vulnerability scan;
        + **3**: email phishing;
        + **4**: vulnerability exploits;
        + **5**: web attack;
        + **6**: password cracking;
        + **7**: hijacking attack;
        + **8**: protocol exception;
        + **9**: trojan;
        + **10**: worm;
        + **11**: buffer overflow;
        + **12**: hacker tool;
        + **13**: spyware;
        + **14**: DDoS flood;
        + **15**: application-layer DDoS attack;
        + **16**: other suspicious behavior;
        + **17**: suspicious DNS activity;
        + **18**: phishing;
        + **19**: spam;
        """
        return pulumi.get(self, "attack_type")

    @_builtins.property
    @pulumi.getter(name="configStatus")
    def config_status(self) -> _builtins.int:
        """
        The rule status.
        """
        return pulumi.get(self, "config_status")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content storage in JSON format.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="dstPortType")
    def dst_port_type(self) -> _builtins.int:
        """
        The destination port type.
        """
        return pulumi.get(self, "dst_port_type")

    @_builtins.property
    @pulumi.getter(name="dstPorts")
    def dst_ports(self) -> _builtins.str:
        """
        The destination port.
        """
        return pulumi.get(self, "dst_ports")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The firewall cluster ID.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="ipsCfwId")
    def ips_cfw_id(self) -> _builtins.str:
        """
        The ID of a custom IPS rule in CFW.
        """
        return pulumi.get(self, "ips_cfw_id")

    @_builtins.property
    @pulumi.getter(name="ipsId")
    def ips_id(self) -> _builtins.str:
        """
        The ID of a rule in Hillstone.
        """
        return pulumi.get(self, "ips_id")

    @_builtins.property
    @pulumi.getter(name="ipsName")
    def ips_name(self) -> _builtins.str:
        """
        Specifies the IPS custom rule name.
        """
        return pulumi.get(self, "ips_name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        Specifies the protocol.
        The valid values are as follows:
        + **1**: FTP;
        + **2**: TELNET;
        + **3**: SMTP;
        + **4**: DNS-TCP;
        + **5**: DNS-UDP;
        + **6**: DHCP;
        + **7**: TFTP;
        + **8**: FINGER;
        + **9**: HTTP;
        + **10**: POP3;
        + **11**: SUNRPC-TCP;
        + **12**: SUNRPC-UDP;
        + **13**: NNTP;
        + **14**: MSRPC-TCP;
        + **15**: MSRPC-UDP;
        + **16**: NETBIOS-NAME_TCP;
        + **17**: NETBIOS-NAME_UDP;
        + **18**: NETBIOS-SMB;
        + **19**: NETBIOS-DATAGRAM;
        + **20**: IMAP4;
        + **21**: SNMP;
        + **22**: LDAP;
        + **23**: MSSQL;
        + **24**: ORACLE;
        + **25**: MYSQL;
        + **26**: VOIP-SIP-TCP;
        + **27**: VOIP-SIP-UDP;
        + **28**: VOIP-H245;
        + **29**: VOIP-Q931;
        + **30**: OTHER-TCP;
        + **31**: OTHER-UDP;
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.int:
        """
        Specifies the severity.
        The valid values are as follows:
        + **0**: critical;
        + **1**: high;
        + **2**: medium;
        + **3**: low;
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def software(self) -> _builtins.int:
        """
        Specifies the affected software.
        The valid values are as follows:
        + **1**: ADOBE;
        + **2**: APACHE;
        + **3**: APPLE;
        + **4**: CA;
        + **5**: CISCO;
        + **6**: GOOGLE CHROME;
        + **7**: HP;
        + **8**: IBM;
        + **9**: IE;
        + **10**: IIS;
        + **11**: MCAFEE;
        + **12**: MEDIAPLAYER;
        + **13**: MICROSOFT.NET;
        + **14**: MICROSOFT EDGE;
        + **15**: MICROSOFT EXCHANGE;
        + **16**: MICROSOFT OFFICE;
        + **17**: MICROSOFT OUTLOOK;
        + **18**: MICROSOFT SHAREPOINT;
        + **19**: MICROSOFT WINDOWS;
        + **20**: MOZILLA;
        + **21**: MSSQL;
        + **22**: MYSQL;
        + **23**: NOVELL;
        + **24**: ORACLE;
        + **25**: SAMBA;
        + **26**: SAMSUNG;
        + **27**: SAP;
        + **28**: SCADA;
        + **29**: SQUID;
        + **30**: SUN;
        + **31**: SYMANTEC;
        + **32**: TREND MICRO;
        + **33**: VMWARE;
        + **34**: WORDPRESS;
        + **35**: OTHER;
        """
        return pulumi.get(self, "software")

    @_builtins.property
    @pulumi.getter(name="srcPortType")
    def src_port_type(self) -> _builtins.int:
        """
        The source port type.
        """
        return pulumi.get(self, "src_port_type")

    @_builtins.property
    @pulumi.getter(name="srcPorts")
    def src_ports(self) -> _builtins.str:
        """
        The source port.
        """
        return pulumi.get(self, "src_ports")


@pulumi.output_type
class GetIpsRuleDetailsDataResult(dict):
    def __init__(__self__, *,
                 ips_type: _builtins.int,
                 ips_version: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.int ips_type: The IPS type.
        :param _builtins.str ips_version: The IPS version.
        :param _builtins.str update_time: The update time.
        """
        pulumi.set(__self__, "ips_type", ips_type)
        pulumi.set(__self__, "ips_version", ips_version)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="ipsType")
    def ips_type(self) -> _builtins.int:
        """
        The IPS type.
        """
        return pulumi.get(self, "ips_type")

    @_builtins.property
    @pulumi.getter(name="ipsVersion")
    def ips_version(self) -> _builtins.str:
        """
        The IPS version.
        """
        return pulumi.get(self, "ips_version")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetIpsRulesRecordResult(dict):
    def __init__(__self__, *,
                 affected_application: _builtins.str,
                 create_time: _builtins.str,
                 default_status: _builtins.str,
                 ips_cve: _builtins.str,
                 ips_group: _builtins.str,
                 ips_id: _builtins.str,
                 ips_level: _builtins.str,
                 ips_name: _builtins.str,
                 ips_rules_type: _builtins.str,
                 ips_status: _builtins.str):
        """
        :param _builtins.str affected_application: The application affected by the rule.
        :param _builtins.str create_time: The creation time.
        :param _builtins.str default_status: The default status of the IPS rule.
        :param _builtins.str ips_cve: The CVE.
        :param _builtins.str ips_group: The IPS rule group.
        :param _builtins.str ips_id: Specifies the IPS rule ID.
        :param _builtins.str ips_level: The risk level.
        :param _builtins.str ips_name: The IPS rule name.
        :param _builtins.str ips_rules_type: The IPS rule type.
        :param _builtins.str ips_status: Specifies the IPS rule status.
               The valid value can be **OBSERVE**, **ENABLE**, or **CLOSE**.
        """
        pulumi.set(__self__, "affected_application", affected_application)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "default_status", default_status)
        pulumi.set(__self__, "ips_cve", ips_cve)
        pulumi.set(__self__, "ips_group", ips_group)
        pulumi.set(__self__, "ips_id", ips_id)
        pulumi.set(__self__, "ips_level", ips_level)
        pulumi.set(__self__, "ips_name", ips_name)
        pulumi.set(__self__, "ips_rules_type", ips_rules_type)
        pulumi.set(__self__, "ips_status", ips_status)

    @_builtins.property
    @pulumi.getter(name="affectedApplication")
    def affected_application(self) -> _builtins.str:
        """
        The application affected by the rule.
        """
        return pulumi.get(self, "affected_application")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultStatus")
    def default_status(self) -> _builtins.str:
        """
        The default status of the IPS rule.
        """
        return pulumi.get(self, "default_status")

    @_builtins.property
    @pulumi.getter(name="ipsCve")
    def ips_cve(self) -> _builtins.str:
        """
        The CVE.
        """
        return pulumi.get(self, "ips_cve")

    @_builtins.property
    @pulumi.getter(name="ipsGroup")
    def ips_group(self) -> _builtins.str:
        """
        The IPS rule group.
        """
        return pulumi.get(self, "ips_group")

    @_builtins.property
    @pulumi.getter(name="ipsId")
    def ips_id(self) -> _builtins.str:
        """
        Specifies the IPS rule ID.
        """
        return pulumi.get(self, "ips_id")

    @_builtins.property
    @pulumi.getter(name="ipsLevel")
    def ips_level(self) -> _builtins.str:
        """
        The risk level.
        """
        return pulumi.get(self, "ips_level")

    @_builtins.property
    @pulumi.getter(name="ipsName")
    def ips_name(self) -> _builtins.str:
        """
        The IPS rule name.
        """
        return pulumi.get(self, "ips_name")

    @_builtins.property
    @pulumi.getter(name="ipsRulesType")
    def ips_rules_type(self) -> _builtins.str:
        """
        The IPS rule type.
        """
        return pulumi.get(self, "ips_rules_type")

    @_builtins.property
    @pulumi.getter(name="ipsStatus")
    def ips_status(self) -> _builtins.str:
        """
        Specifies the IPS rule status.
        The valid value can be **OBSERVE**, **ENABLE**, or **CLOSE**.
        """
        return pulumi.get(self, "ips_status")


@pulumi.output_type
class GetProtectionRulesRecordResult(dict):
    def __init__(__self__, *,
                 action_type: _builtins.str,
                 address_type: _builtins.int,
                 created_date: _builtins.str,
                 description: _builtins.str,
                 destinations: Sequence['outputs.GetProtectionRulesRecordDestinationResult'],
                 direction: _builtins.str,
                 last_open_time: _builtins.str,
                 long_connect_enable: _builtins.int,
                 long_connect_time: _builtins.int,
                 long_connect_time_hour: _builtins.int,
                 long_connect_time_minute: _builtins.int,
                 long_connect_time_second: _builtins.int,
                 name: _builtins.str,
                 rule_id: _builtins.str,
                 services: Sequence['outputs.GetProtectionRulesRecordServiceResult'],
                 sources: Sequence['outputs.GetProtectionRulesRecordSourceResult'],
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str):
        """
        :param _builtins.str action_type: Specifies the rule action type.
               The options are as follows:
               + **0**: allow;
               + **1**: deny.
        :param _builtins.int address_type: The address type.
        :param _builtins.str created_date: The created time of a rule.
        :param _builtins.str description: The custom service description.
        :param Sequence['GetProtectionRulesRecordDestinationArgs'] destinations: Specifies the destination address.
        :param _builtins.str direction: Specifies the rule direction.
               The options are as follows:
               + **0**: inbound;
               + **1**: outbound.
        :param _builtins.str last_open_time: The last open time.
        :param _builtins.int long_connect_enable: Whether to support persistent connections.
        :param _builtins.int long_connect_time: The persistent connection duration.
        :param _builtins.int long_connect_time_hour: The persistent connection duration (hour).
        :param _builtins.int long_connect_time_minute: The persistent connection duration (minute).
        :param _builtins.int long_connect_time_second: The persistent connection duration (second).
        :param _builtins.str name: Specifies the rule name.
        :param _builtins.str rule_id: Specifies the rule ID.
        :param Sequence['GetProtectionRulesRecordServiceArgs'] services: The service.
        :param Sequence['GetProtectionRulesRecordSourceArgs'] sources: Specifies the source address.
        :param _builtins.str status: Specifies the rule status.
               The options are as follows:
               + **0**: disabled;
               + **1**: enabled.
        :param Mapping[str, _builtins.str] tags: Specifies the key/value pairs to associate with the protection rule.
               Tags should have only one key/value pair.
        :param _builtins.str type: Specifies the rule type.
               The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "last_open_time", last_open_time)
        pulumi.set(__self__, "long_connect_enable", long_connect_enable)
        pulumi.set(__self__, "long_connect_time", long_connect_time)
        pulumi.set(__self__, "long_connect_time_hour", long_connect_time_hour)
        pulumi.set(__self__, "long_connect_time_minute", long_connect_time_minute)
        pulumi.set(__self__, "long_connect_time_second", long_connect_time_second)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        Specifies the rule action type.
        The options are as follows:
        + **0**: allow;
        + **1**: deny.
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        The created time of a rule.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The custom service description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetProtectionRulesRecordDestinationResult']:
        """
        Specifies the destination address.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Specifies the rule direction.
        The options are as follows:
        + **0**: inbound;
        + **1**: outbound.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="lastOpenTime")
    def last_open_time(self) -> _builtins.str:
        """
        The last open time.
        """
        return pulumi.get(self, "last_open_time")

    @_builtins.property
    @pulumi.getter(name="longConnectEnable")
    def long_connect_enable(self) -> _builtins.int:
        """
        Whether to support persistent connections.
        """
        return pulumi.get(self, "long_connect_enable")

    @_builtins.property
    @pulumi.getter(name="longConnectTime")
    def long_connect_time(self) -> _builtins.int:
        """
        The persistent connection duration.
        """
        return pulumi.get(self, "long_connect_time")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeHour")
    def long_connect_time_hour(self) -> _builtins.int:
        """
        The persistent connection duration (hour).
        """
        return pulumi.get(self, "long_connect_time_hour")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeMinute")
    def long_connect_time_minute(self) -> _builtins.int:
        """
        The persistent connection duration (minute).
        """
        return pulumi.get(self, "long_connect_time_minute")

    @_builtins.property
    @pulumi.getter(name="longConnectTimeSecond")
    def long_connect_time_second(self) -> _builtins.int:
        """
        The persistent connection duration (second).
        """
        return pulumi.get(self, "long_connect_time_second")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        Specifies the rule ID.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetProtectionRulesRecordServiceResult']:
        """
        The service.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetProtectionRulesRecordSourceResult']:
        """
        Specifies the source address.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the rule status.
        The options are as follows:
        + **0**: disabled;
        + **1**: enabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the key/value pairs to associate with the protection rule.
        Tags should have only one key/value pair.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the rule type.
        The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProtectionRulesRecordDestinationResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_groups: Sequence[_builtins.str],
                 address_set_id: _builtins.str,
                 address_set_name: _builtins.str,
                 address_set_type: _builtins.int,
                 address_type: _builtins.int,
                 domain_address_name: _builtins.str,
                 domain_set_id: _builtins.str,
                 domain_set_name: _builtins.str,
                 ip_addresses: Sequence[_builtins.str],
                 region_lists: Sequence['outputs.GetProtectionRulesRecordDestinationRegionListResult'],
                 type: _builtins.int):
        """
        :param _builtins.str address: The source IP address.
        :param Sequence[_builtins.str] address_groups: The address group.
        :param _builtins.str address_set_id: The ID of the associated IP address group.
        :param _builtins.str address_set_name: The IP address group name.
        :param _builtins.int address_set_type: The address set type.
        :param _builtins.int address_type: The address type.
        :param _builtins.str domain_address_name: The name of the domain address.
        :param _builtins.str domain_set_id: The ID of the domain group.
        :param _builtins.str domain_set_name: The name of domain group.
        :param Sequence[_builtins.str] ip_addresses: The IP address list.
        :param Sequence['GetProtectionRulesRecordDestinationRegionListArgs'] region_lists: The region list of a rule.
        :param _builtins.int type: Specifies the rule type.
               The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_groups", address_groups)
        pulumi.set(__self__, "address_set_id", address_set_id)
        pulumi.set(__self__, "address_set_name", address_set_name)
        pulumi.set(__self__, "address_set_type", address_set_type)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "domain_address_name", domain_address_name)
        pulumi.set(__self__, "domain_set_id", domain_set_id)
        pulumi.set(__self__, "domain_set_name", domain_set_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "region_lists", region_lists)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The source IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressGroups")
    def address_groups(self) -> Sequence[_builtins.str]:
        """
        The address group.
        """
        return pulumi.get(self, "address_groups")

    @_builtins.property
    @pulumi.getter(name="addressSetId")
    def address_set_id(self) -> _builtins.str:
        """
        The ID of the associated IP address group.
        """
        return pulumi.get(self, "address_set_id")

    @_builtins.property
    @pulumi.getter(name="addressSetName")
    def address_set_name(self) -> _builtins.str:
        """
        The IP address group name.
        """
        return pulumi.get(self, "address_set_name")

    @_builtins.property
    @pulumi.getter(name="addressSetType")
    def address_set_type(self) -> _builtins.int:
        """
        The address set type.
        """
        return pulumi.get(self, "address_set_type")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="domainAddressName")
    def domain_address_name(self) -> _builtins.str:
        """
        The name of the domain address.
        """
        return pulumi.get(self, "domain_address_name")

    @_builtins.property
    @pulumi.getter(name="domainSetId")
    def domain_set_id(self) -> _builtins.str:
        """
        The ID of the domain group.
        """
        return pulumi.get(self, "domain_set_id")

    @_builtins.property
    @pulumi.getter(name="domainSetName")
    def domain_set_name(self) -> _builtins.str:
        """
        The name of domain group.
        """
        return pulumi.get(self, "domain_set_name")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        The IP address list.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="regionLists")
    def region_lists(self) -> Sequence['outputs.GetProtectionRulesRecordDestinationRegionListResult']:
        """
        The region list of a rule.
        """
        return pulumi.get(self, "region_lists")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        Specifies the rule type.
        The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProtectionRulesRecordDestinationRegionListResult(dict):
    def __init__(__self__, *,
                 description_cn: _builtins.str,
                 description_en: _builtins.str,
                 region_id: _builtins.str,
                 region_type: _builtins.int):
        """
        :param _builtins.str description_cn: The Chinese description of a region.
        :param _builtins.str description_en: The English description of a region.
        :param _builtins.str region_id: The region ID.
        :param _builtins.int region_type: The region type.
        """
        pulumi.set(__self__, "description_cn", description_cn)
        pulumi.set(__self__, "description_en", description_en)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> _builtins.str:
        """
        The Chinese description of a region.
        """
        return pulumi.get(self, "description_cn")

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> _builtins.str:
        """
        The English description of a region.
        """
        return pulumi.get(self, "description_en")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> _builtins.int:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")


@pulumi.output_type
class GetProtectionRulesRecordServiceResult(dict):
    def __init__(__self__, *,
                 custom_services: Sequence['outputs.GetProtectionRulesRecordServiceCustomServiceResult'],
                 dest_port: _builtins.str,
                 protocol: _builtins.int,
                 protocols: Sequence[_builtins.int],
                 service_groups: Sequence[_builtins.str],
                 service_set_id: _builtins.str,
                 service_set_name: _builtins.str,
                 service_set_type: _builtins.int,
                 source_port: _builtins.str,
                 type: _builtins.int):
        """
        :param Sequence['GetProtectionRulesRecordServiceCustomServiceArgs'] custom_services: The custom service.
        :param _builtins.str dest_port: The destination port.
        :param _builtins.int protocol: The protocol type of the custom service.
        :param Sequence[_builtins.int] protocols: The protocols.
        :param Sequence[_builtins.str] service_groups: The service group list.
        :param _builtins.str service_set_id: The service group ID.
        :param _builtins.str service_set_name: The service group name.
        :param _builtins.int service_set_type: The service set type.
        :param _builtins.str source_port: The source port of the custom service.
        :param _builtins.int type: Specifies the rule type.
               The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        pulumi.set(__self__, "custom_services", custom_services)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "service_groups", service_groups)
        pulumi.set(__self__, "service_set_id", service_set_id)
        pulumi.set(__self__, "service_set_name", service_set_name)
        pulumi.set(__self__, "service_set_type", service_set_type)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="customServices")
    def custom_services(self) -> Sequence['outputs.GetProtectionRulesRecordServiceCustomServiceResult']:
        """
        The custom service.
        """
        return pulumi.get(self, "custom_services")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        The protocol type of the custom service.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.int]:
        """
        The protocols.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="serviceGroups")
    def service_groups(self) -> Sequence[_builtins.str]:
        """
        The service group list.
        """
        return pulumi.get(self, "service_groups")

    @_builtins.property
    @pulumi.getter(name="serviceSetId")
    def service_set_id(self) -> _builtins.str:
        """
        The service group ID.
        """
        return pulumi.get(self, "service_set_id")

    @_builtins.property
    @pulumi.getter(name="serviceSetName")
    def service_set_name(self) -> _builtins.str:
        """
        The service group name.
        """
        return pulumi.get(self, "service_set_name")

    @_builtins.property
    @pulumi.getter(name="serviceSetType")
    def service_set_type(self) -> _builtins.int:
        """
        The service set type.
        """
        return pulumi.get(self, "service_set_type")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        The source port of the custom service.
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        Specifies the rule type.
        The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProtectionRulesRecordServiceCustomServiceResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 dest_port: _builtins.str,
                 name: _builtins.str,
                 protocol: _builtins.int,
                 source_port: _builtins.str):
        """
        :param _builtins.str description: The custom service description.
        :param _builtins.str dest_port: The destination port.
        :param _builtins.str name: Specifies the rule name.
        :param _builtins.int protocol: The protocol type of the custom service.
        :param _builtins.str source_port: The source port of the custom service.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The custom service description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        The destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the rule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        The protocol type of the custom service.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        The source port of the custom service.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class GetProtectionRulesRecordSourceResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 address_groups: Sequence[_builtins.str],
                 address_set_id: _builtins.str,
                 address_set_name: _builtins.str,
                 address_set_type: _builtins.int,
                 address_type: _builtins.int,
                 domain_address_name: _builtins.str,
                 ip_addresses: Sequence[_builtins.str],
                 region_lists: Sequence['outputs.GetProtectionRulesRecordSourceRegionListResult'],
                 type: _builtins.int):
        """
        :param _builtins.str address: The source IP address.
        :param Sequence[_builtins.str] address_groups: The address group.
        :param _builtins.str address_set_id: The ID of the associated IP address group.
        :param _builtins.str address_set_name: The IP address group name.
        :param _builtins.int address_set_type: The address set type.
        :param _builtins.int address_type: The address type.
        :param _builtins.str domain_address_name: The name of the domain address.
        :param Sequence[_builtins.str] ip_addresses: The IP address list.
        :param Sequence['GetProtectionRulesRecordSourceRegionListArgs'] region_lists: The region list of a rule.
        :param _builtins.int type: Specifies the rule type.
               The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_groups", address_groups)
        pulumi.set(__self__, "address_set_id", address_set_id)
        pulumi.set(__self__, "address_set_name", address_set_name)
        pulumi.set(__self__, "address_set_type", address_set_type)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "domain_address_name", domain_address_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "region_lists", region_lists)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The source IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressGroups")
    def address_groups(self) -> Sequence[_builtins.str]:
        """
        The address group.
        """
        return pulumi.get(self, "address_groups")

    @_builtins.property
    @pulumi.getter(name="addressSetId")
    def address_set_id(self) -> _builtins.str:
        """
        The ID of the associated IP address group.
        """
        return pulumi.get(self, "address_set_id")

    @_builtins.property
    @pulumi.getter(name="addressSetName")
    def address_set_name(self) -> _builtins.str:
        """
        The IP address group name.
        """
        return pulumi.get(self, "address_set_name")

    @_builtins.property
    @pulumi.getter(name="addressSetType")
    def address_set_type(self) -> _builtins.int:
        """
        The address set type.
        """
        return pulumi.get(self, "address_set_type")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> _builtins.int:
        """
        The address type.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="domainAddressName")
    def domain_address_name(self) -> _builtins.str:
        """
        The name of the domain address.
        """
        return pulumi.get(self, "domain_address_name")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        The IP address list.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="regionLists")
    def region_lists(self) -> Sequence['outputs.GetProtectionRulesRecordSourceRegionListResult']:
        """
        The region list of a rule.
        """
        return pulumi.get(self, "region_lists")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        Specifies the rule type.
        The value can be **0** (Internet rule), **1** (VPC rule), or **2** (NAT rule).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProtectionRulesRecordSourceRegionListResult(dict):
    def __init__(__self__, *,
                 description_cn: _builtins.str,
                 description_en: _builtins.str,
                 region_id: _builtins.str,
                 region_type: _builtins.int):
        """
        :param _builtins.str description_cn: The Chinese description of a region.
        :param _builtins.str description_en: The English description of a region.
        :param _builtins.str region_id: The region ID.
        :param _builtins.int region_type: The region type.
        """
        pulumi.set(__self__, "description_cn", description_cn)
        pulumi.set(__self__, "description_en", description_en)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_type", region_type)

    @_builtins.property
    @pulumi.getter(name="descriptionCn")
    def description_cn(self) -> _builtins.str:
        """
        The Chinese description of a region.
        """
        return pulumi.get(self, "description_cn")

    @_builtins.property
    @pulumi.getter(name="descriptionEn")
    def description_en(self) -> _builtins.str:
        """
        The English description of a region.
        """
        return pulumi.get(self, "description_en")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionType")
    def region_type(self) -> _builtins.int:
        """
        The region type.
        """
        return pulumi.get(self, "region_type")


@pulumi.output_type
class GetResourceTagsTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The tag key.
        :param _builtins.str value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceGroupMembersRecordResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 dest_port: _builtins.str,
                 item_id: _builtins.str,
                 protocol: _builtins.int,
                 source_port: _builtins.str):
        """
        :param _builtins.str description: The service group member description.
        :param _builtins.str dest_port: Specifies the destination port.
        :param _builtins.str item_id: Specifies the service group member ID.
        :param _builtins.int protocol: Specifies the protocol type.
               The options are as follows:
               + **6**: TCP;
               + **17**: UDP;
               + **1**: ICMP.
        :param _builtins.str source_port: Specifies the source port.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "item_id", item_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The service group member description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> _builtins.str:
        """
        Specifies the destination port.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="itemId")
    def item_id(self) -> _builtins.str:
        """
        Specifies the service group member ID.
        """
        return pulumi.get(self, "item_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.int:
        """
        Specifies the protocol type.
        The options are as follows:
        + **6**: TCP;
        + **17**: UDP;
        + **1**: ICMP.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        Specifies the source port.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class GetServiceGroupsServiceGroupResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 protocols: Sequence[_builtins.int],
                 ref_count: _builtins.int,
                 type: _builtins.int):
        """
        :param _builtins.str description: The description of the service group.
        :param _builtins.str id: The service group ID.
        :param _builtins.str name: Specifies the name of the service group.
        :param Sequence[_builtins.int] protocols: The protocols of the service group.
        :param _builtins.int ref_count: The number of times this service group has been referenced.
        :param _builtins.int type: The type of the Service group.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "ref_count", ref_count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the service group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The service group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the service group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.int]:
        """
        The protocols of the service group.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="refCount")
    def ref_count(self) -> _builtins.int:
        """
        The number of times this service group has been referenced.
        """
        return pulumi.get(self, "ref_count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        The type of the Service group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: The tag key.
        :param Sequence[_builtins.str] values: The tag values.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        The tag values.
        """
        return pulumi.get(self, "values")


