# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceGroupMemberArgs', 'ServiceGroupMember']

@pulumi.input_type
class ServiceGroupMemberArgs:
    def __init__(__self__, *,
                 dest_port: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.int],
                 source_port: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceGroupMember resource.
        :param pulumi.Input[_builtins.str] dest_port: Specifies the destination port.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the service group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the service group member description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the service group member name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "dest_port", dest_port)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_port", source_port)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the service group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the source port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_port", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service group member description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service group member name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServiceGroupMemberState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceGroupMember resources.
        :param pulumi.Input[_builtins.str] description: Specifies the service group member description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] dest_port: Specifies the destination port.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the service group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the service group member name.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port.
               
               Changing this parameter will create a new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_port is not None:
            pulumi.set(__self__, "dest_port", dest_port)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service group member description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dest_port")

    @dest_port.setter
    def dest_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dest_port", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the service group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service group member name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)


@pulumi.type_token("sbercloud:Cfw/serviceGroupMember:ServiceGroupMember")
class ServiceGroupMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CFW service group member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_id = config.require_object("groupId")
        protocol = config.require_object("protocol")
        source_port = config.require_object("sourcePort")
        dest_port = config.require_object("destPort")
        test = sbercloud.cfw.ServiceGroupMember("test",
            group_id=group_id,
            protocol=protocol,
            source_port=source_port,
            dest_port=dest_port)
        ```

        ## Import

        The service group member can be imported using service group ID and member ID, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/serviceGroupMember:ServiceGroupMember test <group_id>/<member_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the service group member description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] dest_port: Specifies the destination port.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the service group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the service group member name.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port.
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceGroupMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CFW service group member resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_id = config.require_object("groupId")
        protocol = config.require_object("protocol")
        source_port = config.require_object("sourcePort")
        dest_port = config.require_object("destPort")
        test = sbercloud.cfw.ServiceGroupMember("test",
            group_id=group_id,
            protocol=protocol,
            source_port=source_port,
            dest_port=dest_port)
        ```

        ## Import

        The service group member can be imported using service group ID and member ID, separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Cfw/serviceGroupMember:ServiceGroupMember test <group_id>/<member_id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceGroupMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceGroupMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dest_port: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceGroupMemberArgs.__new__(ServiceGroupMemberArgs)

            __props__.__dict__["description"] = description
            if dest_port is None and not opts.urn:
                raise TypeError("Missing required property 'dest_port'")
            __props__.__dict__["dest_port"] = dest_port
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if source_port is None and not opts.urn:
                raise TypeError("Missing required property 'source_port'")
            __props__.__dict__["source_port"] = source_port
        super(ServiceGroupMember, __self__).__init__(
            'sbercloud:Cfw/serviceGroupMember:ServiceGroupMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dest_port: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_port: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceGroupMember':
        """
        Get an existing ServiceGroupMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the service group member description.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] dest_port: Specifies the destination port.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] group_id: Specifies the ID of the service group.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the service group member name.
        :param pulumi.Input[_builtins.int] protocol: Specifies the protocol type.
               The valid values are:
               + **6**: indicates TCP;
               + **17**: indicates UDP;
               + **1**: indicates ICMP;
               + **58**: indicates ICMPv6;
               + **-1**: indicates any protocol.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_port: Specifies the source port.
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceGroupMemberState.__new__(_ServiceGroupMemberState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dest_port"] = dest_port
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["source_port"] = source_port
        return ServiceGroupMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the service group member description.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destPort")
    def dest_port(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dest_port")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the service group.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the service group member name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the protocol type.
        The valid values are:
        + **6**: indicates TCP;
        + **17**: indicates UDP;
        + **1**: indicates ICMP;
        + **58**: indicates ICMPv6;
        + **-1**: indicates any protocol.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the source port.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_port")

