# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input['ClusterBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_node_config: Optional[pulumi.Input['ClusterClientNodeConfigArgs']] = None,
                 cold_node_config: Optional[pulumi.Input['ClusterColdNodeConfigArgs']] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ess_node_config: Optional[pulumi.Input['ClusterEssNodeConfigArgs']] = None,
                 expect_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kibana_public_access: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']] = None,
                 master_node_config: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input['ClusterNodeConfigArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access: Optional[pulumi.Input['ClusterPublicAccessArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input['ClusterVpcepEndpointArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the engine version.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               The valid values are **true** and **false**, defaults to **false**.
               
               <a name="Css_ess_node_config"></a>
               The `ess_node_config` and `cold_node_config` block supports:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is **1** at most.
        :param pulumi.Input['ClusterBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the cluster.
               Valid value is **postPaid**, defaults to **postPaid**.
        :param pulumi.Input['ClusterClientNodeConfigArgs'] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input['ClusterColdNodeConfigArgs'] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
               Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the css cluster, The value **0**
               indicates the default enterprise project.
        :param pulumi.Input['ClusterEssNodeConfigArgs'] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[_builtins.bool] https_enabled: Specifies whether to enable HTTPS. Defaults to **false**.
               When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterKibanaPublicAccessArgs'] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to **true**.
               The kibana_public_access structure is documented below.
        :param pulumi.Input['ClusterMasterNodeConfigArgs'] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the cluster name. It contains `4` to `32` characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when `security_mode` is set to true.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `9`.
               
               > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
               from **postPaid** to **prePaid** billing mode.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**.
        :param pulumi.Input['ClusterPublicAccessArgs'] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID.
        :param pulumi.Input[_builtins.bool] security_mode: Specifies whether to enable authentication.
               The value can be **true** or **false**. Authentication is disabled by default.
               + **true:** Authentication is enabled for the cluster.
               + **false:** Authentication is disabled for the cluster.
               
               > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
               The cluster will be restarted to apply the changes. Services will be interrupted for a while.
               After the cluster is restarted, the authentication mode for invoking the cluster changes.
               You need to adjust the authentication mode accordingly.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the Subnet ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterVpcepEndpointArgs'] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_node_config is not None:
            pulumi.set(__self__, "client_node_config", client_node_config)
        if cold_node_config is not None:
            pulumi.set(__self__, "cold_node_config", cold_node_config)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ess_node_config is not None:
            pulumi.set(__self__, "ess_node_config", ess_node_config)
        if expect_node_num is not None:
            warnings.warn("""please use ess_node_config.instance_number instead""", DeprecationWarning)
            pulumi.log.warn("""expect_node_num is deprecated: please use ess_node_config.instance_number instead""")
        if expect_node_num is not None:
            pulumi.set(__self__, "expect_node_num", expect_node_num)
        if https_enabled is not None:
            pulumi.set(__self__, "https_enabled", https_enabled)
        if kibana_public_access is not None:
            pulumi.set(__self__, "kibana_public_access", kibana_public_access)
        if master_node_config is not None:
            pulumi.set(__self__, "master_node_config", master_node_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            warnings.warn("""please use ess_node_config instead""", DeprecationWarning)
            pulumi.log.warn("""node_config is deprecated: please use ess_node_config instead""")
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpcep_endpoint is not None:
            pulumi.set(__self__, "vpcep_endpoint", vpcep_endpoint)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the engine version.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        The valid values are **true** and **false**, defaults to **false**.

        <a name="Css_ess_node_config"></a>
        The `ess_node_config` and `cold_node_config` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is **1** at most.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['ClusterBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['ClusterBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the cluster.
        Valid value is **postPaid**, defaults to **postPaid**.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> Optional[pulumi.Input['ClusterClientNodeConfigArgs']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @client_node_config.setter
    def client_node_config(self, value: Optional[pulumi.Input['ClusterClientNodeConfigArgs']]):
        pulumi.set(self, "client_node_config", value)

    @_builtins.property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> Optional[pulumi.Input['ClusterColdNodeConfigArgs']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @cold_node_config.setter
    def cold_node_config(self, value: Optional[pulumi.Input['ClusterColdNodeConfigArgs']]):
        pulumi.set(self, "cold_node_config", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
        Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the css cluster, The value **0**
        indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> Optional[pulumi.Input['ClusterEssNodeConfigArgs']]:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @ess_node_config.setter
    def ess_node_config(self, value: Optional[pulumi.Input['ClusterEssNodeConfigArgs']]):
        pulumi.set(self, "ess_node_config", value)

    @_builtins.property
    @pulumi.getter(name="expectNodeNum")
    @_utilities.deprecated("""please use ess_node_config.instance_number instead""")
    def expect_node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "expect_node_num")

    @expect_node_num.setter
    def expect_node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expect_node_num", value)

    @_builtins.property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable HTTPS. Defaults to **false**.
        When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "https_enabled")

    @https_enabled.setter
    def https_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to **true**.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @kibana_public_access.setter
    def kibana_public_access(self, value: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]):
        pulumi.set(self, "kibana_public_access", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @master_node_config.setter
    def master_node_config(self, value: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]):
        pulumi.set(self, "master_node_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster name. It contains `4` to `32` characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    @_utilities.deprecated("""please use ess_node_config instead""")
    def node_config(self) -> Optional[pulumi.Input['ClusterNodeConfigArgs']]:
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when `security_mode` is set to true.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `9`.

        > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
        from **postPaid** to **prePaid** billing mode.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[pulumi.Input['ClusterPublicAccessArgs']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @public_access.setter
    def public_access(self, value: Optional[pulumi.Input['ClusterPublicAccessArgs']]):
        pulumi.set(self, "public_access", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable authentication.
        The value can be **true** or **false**. Authentication is disabled by default.
        + **true:** Authentication is enabled for the cluster.
        + **false:** Authentication is disabled for the cluster.

        > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
        The cluster will be restarted to apply the changes. Services will be interrupted for a while.
        After the cluster is restarted, the authentication mode for invoking the cluster changes.
        You need to adjust the authentication mode accordingly.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Subnet ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> Optional[pulumi.Input['ClusterVpcepEndpointArgs']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @vpcep_endpoint.setter
    def vpcep_endpoint(self, value: Optional[pulumi.Input['ClusterVpcepEndpointArgs']]):
        pulumi.set(self, "vpcep_endpoint", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_available: Optional[pulumi.Input[_builtins.bool]] = None,
                 backup_strategy: Optional[pulumi.Input['ClusterBackupStrategyArgs']] = None,
                 bandwidth_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_node_config: Optional[pulumi.Input['ClusterClientNodeConfigArgs']] = None,
                 cold_node_config: Optional[pulumi.Input['ClusterColdNodeConfigArgs']] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ess_node_config: Optional[pulumi.Input['ClusterEssNodeConfigArgs']] = None,
                 expect_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_period: Optional[pulumi.Input[_builtins.bool]] = None,
                 kibana_public_access: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']] = None,
                 master_node_config: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input['ClusterNodeConfigArgs']] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access: Optional[pulumi.Input['ClusterPublicAccessArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input['ClusterVpcepEndpointArgs']] = None,
                 vpcep_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               The valid values are **true** and **false**, defaults to **false**.
               
               <a name="Css_ess_node_config"></a>
               The `ess_node_config` and `cold_node_config` block supports:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is **1** at most.
        :param pulumi.Input[_builtins.bool] backup_available: Whether the snapshot function is enabled.
        :param pulumi.Input['ClusterBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.str] bandwidth_resource_id: The resource ID of bandwidth.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the cluster.
               Valid value is **postPaid**, defaults to **postPaid**.
        :param pulumi.Input['ClusterClientNodeConfigArgs'] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input['ClusterColdNodeConfigArgs'] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] created: schema: Deprecated; use created_at instead
        :param pulumi.Input[_builtins.str] created_at: Time when a cluster is created. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[_builtins.bool] disk_encrypted: Whether disks are encrypted.
        :param pulumi.Input[_builtins.str] endpoint: The IP address and port number.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
               Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the engine version.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the css cluster, The value **0**
               indicates the default enterprise project.
        :param pulumi.Input['ClusterEssNodeConfigArgs'] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[_builtins.bool] https_enabled: Specifies whether to enable HTTPS. Defaults to **false**.
               When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_period: Whether a cluster is billed on the yearly/monthly mode.
        :param pulumi.Input['ClusterKibanaPublicAccessArgs'] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to **true**.
               The kibana_public_access structure is documented below.
        :param pulumi.Input['ClusterMasterNodeConfigArgs'] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the cluster name. It contains `4` to `32` characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]] nodes: List of node objects.
               The nodes structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when `security_mode` is set to true.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `9`.
               
               > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
               from **postPaid** to **prePaid** billing mode.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**.
        :param pulumi.Input['ClusterPublicAccessArgs'] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID.
        :param pulumi.Input[_builtins.bool] security_mode: Specifies whether to enable authentication.
               The value can be **true** or **false**. Authentication is disabled by default.
               + **true:** Authentication is enabled for the cluster.
               + **false:** Authentication is disabled for the cluster.
               
               > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
               The cluster will be restarted to apply the changes. Services will be interrupted for a while.
               After the cluster is restarted, the authentication mode for invoking the cluster changes.
               You need to adjust the authentication mode accordingly.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the Subnet ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] updated_at: Time when a cluster is updated. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterVpcepEndpointArgs'] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        :param pulumi.Input[_builtins.str] vpcep_endpoint_id: The VPC endpoint service ID.
        :param pulumi.Input[_builtins.str] vpcep_ip: The private IP address of VPC endpoint service.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_available is not None:
            pulumi.set(__self__, "backup_available", backup_available)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if bandwidth_resource_id is not None:
            pulumi.set(__self__, "bandwidth_resource_id", bandwidth_resource_id)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_node_config is not None:
            pulumi.set(__self__, "client_node_config", client_node_config)
        if cold_node_config is not None:
            pulumi.set(__self__, "cold_node_config", cold_node_config)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if disk_encrypted is not None:
            pulumi.set(__self__, "disk_encrypted", disk_encrypted)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ess_node_config is not None:
            pulumi.set(__self__, "ess_node_config", ess_node_config)
        if expect_node_num is not None:
            warnings.warn("""please use ess_node_config.instance_number instead""", DeprecationWarning)
            pulumi.log.warn("""expect_node_num is deprecated: please use ess_node_config.instance_number instead""")
        if expect_node_num is not None:
            pulumi.set(__self__, "expect_node_num", expect_node_num)
        if https_enabled is not None:
            pulumi.set(__self__, "https_enabled", https_enabled)
        if is_period is not None:
            pulumi.set(__self__, "is_period", is_period)
        if kibana_public_access is not None:
            pulumi.set(__self__, "kibana_public_access", kibana_public_access)
        if master_node_config is not None:
            pulumi.set(__self__, "master_node_config", master_node_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            warnings.warn("""please use ess_node_config instead""", DeprecationWarning)
            pulumi.log.warn("""node_config is deprecated: please use ess_node_config instead""")
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpcep_endpoint is not None:
            pulumi.set(__self__, "vpcep_endpoint", vpcep_endpoint)
        if vpcep_endpoint_id is not None:
            pulumi.set(__self__, "vpcep_endpoint_id", vpcep_endpoint_id)
        if vpcep_ip is not None:
            pulumi.set(__self__, "vpcep_ip", vpcep_ip)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        The valid values are **true** and **false**, defaults to **false**.

        <a name="Css_ess_node_config"></a>
        The `ess_node_config` and `cold_node_config` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is **1** at most.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupAvailable")
    def backup_available(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the snapshot function is enabled.
        """
        return pulumi.get(self, "backup_available")

    @backup_available.setter
    def backup_available(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backup_available", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['ClusterBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['ClusterBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthResourceId")
    def bandwidth_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of bandwidth.
        """
        return pulumi.get(self, "bandwidth_resource_id")

    @bandwidth_resource_id.setter
    def bandwidth_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the cluster.
        Valid value is **postPaid**, defaults to **postPaid**.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> Optional[pulumi.Input['ClusterClientNodeConfigArgs']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @client_node_config.setter
    def client_node_config(self, value: Optional[pulumi.Input['ClusterClientNodeConfigArgs']]):
        pulumi.set(self, "client_node_config", value)

    @_builtins.property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> Optional[pulumi.Input['ClusterColdNodeConfigArgs']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @cold_node_config.setter
    def cold_node_config(self, value: Optional[pulumi.Input['ClusterColdNodeConfigArgs']]):
        pulumi.set(self, "cold_node_config", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; use created_at instead
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when a cluster is created. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="diskEncrypted")
    def disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether disks are encrypted.
        """
        return pulumi.get(self, "disk_encrypted")

    @disk_encrypted.setter
    def disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address and port number.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
        Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the engine version.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the css cluster, The value **0**
        indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> Optional[pulumi.Input['ClusterEssNodeConfigArgs']]:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @ess_node_config.setter
    def ess_node_config(self, value: Optional[pulumi.Input['ClusterEssNodeConfigArgs']]):
        pulumi.set(self, "ess_node_config", value)

    @_builtins.property
    @pulumi.getter(name="expectNodeNum")
    @_utilities.deprecated("""please use ess_node_config.instance_number instead""")
    def expect_node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "expect_node_num")

    @expect_node_num.setter
    def expect_node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expect_node_num", value)

    @_builtins.property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable HTTPS. Defaults to **false**.
        When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "https_enabled")

    @https_enabled.setter
    def https_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPeriod")
    def is_period(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether a cluster is billed on the yearly/monthly mode.
        """
        return pulumi.get(self, "is_period")

    @is_period.setter
    def is_period(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_period", value)

    @_builtins.property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to **true**.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @kibana_public_access.setter
    def kibana_public_access(self, value: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]):
        pulumi.set(self, "kibana_public_access", value)

    @_builtins.property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @master_node_config.setter
    def master_node_config(self, value: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]):
        pulumi.set(self, "master_node_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster name. It contains `4` to `32` characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    @_utilities.deprecated("""please use ess_node_config instead""")
    def node_config(self) -> Optional[pulumi.Input['ClusterNodeConfigArgs']]:
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]]:
        """
        List of node objects.
        The nodes structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when `security_mode` is set to true.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `9`.

        > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
        from **postPaid** to **prePaid** billing mode.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[pulumi.Input['ClusterPublicAccessArgs']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @public_access.setter
    def public_access(self, value: Optional[pulumi.Input['ClusterPublicAccessArgs']]):
        pulumi.set(self, "public_access", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable authentication.
        The value can be **true** or **false**. Authentication is disabled by default.
        + **true:** Authentication is enabled for the cluster.
        + **false:** Authentication is disabled for the cluster.

        > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
        The cluster will be restarted to apply the changes. Services will be interrupted for a while.
        After the cluster is restarted, the authentication mode for invoking the cluster changes.
        You need to adjust the authentication mode accordingly.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Subnet ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when a cluster is updated. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> Optional[pulumi.Input['ClusterVpcepEndpointArgs']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @vpcep_endpoint.setter
    def vpcep_endpoint(self, value: Optional[pulumi.Input['ClusterVpcepEndpointArgs']]):
        pulumi.set(self, "vpcep_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="vpcepEndpointId")
    def vpcep_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC endpoint service ID.
        """
        return pulumi.get(self, "vpcep_endpoint_id")

    @vpcep_endpoint_id.setter
    def vpcep_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpcep_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcepIp")
    def vpcep_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address of VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_ip")

    @vpcep_ip.setter
    def vpcep_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpcep_ip", value)


@pulumi.type_token("sbercloud:Css/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['ClusterBackupStrategyArgs', 'ClusterBackupStrategyArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_node_config: Optional[pulumi.Input[Union['ClusterClientNodeConfigArgs', 'ClusterClientNodeConfigArgsDict']]] = None,
                 cold_node_config: Optional[pulumi.Input[Union['ClusterColdNodeConfigArgs', 'ClusterColdNodeConfigArgsDict']]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ess_node_config: Optional[pulumi.Input[Union['ClusterEssNodeConfigArgs', 'ClusterEssNodeConfigArgsDict']]] = None,
                 expect_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kibana_public_access: Optional[pulumi.Input[Union['ClusterKibanaPublicAccessArgs', 'ClusterKibanaPublicAccessArgsDict']]] = None,
                 master_node_config: Optional[pulumi.Input[Union['ClusterMasterNodeConfigArgs', 'ClusterMasterNodeConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['ClusterNodeConfigArgs', 'ClusterNodeConfigArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access: Optional[pulumi.Input[Union['ClusterPublicAccessArgs', 'ClusterPublicAccessArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input[Union['ClusterVpcepEndpointArgs', 'ClusterVpcepEndpointArgsDict']]] = None,
                 __props__=None):
        """
        Manages CSS cluster resource within SberCloud

        ## Example Usage

        ### create a cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 1,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ### create a cluster with ess-data node and master node

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 1,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            master_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 3,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ### create a cluster with ess-data node and cold node use local disk

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-ds.xlarge.8",
                "instance_number": 1,
            },
            cold_node_config={
                "flavor": "ess.spec-ds.2xlarge.8",
                "instance_number": 2,
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        The CSS cluster can be imported by `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Css/cluster:Cluster test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               The valid values are **true** and **false**, defaults to **false**.
               
               <a name="Css_ess_node_config"></a>
               The `ess_node_config` and `cold_node_config` block supports:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is **1** at most.
        :param pulumi.Input[Union['ClusterBackupStrategyArgs', 'ClusterBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the cluster.
               Valid value is **postPaid**, defaults to **postPaid**.
        :param pulumi.Input[Union['ClusterClientNodeConfigArgs', 'ClusterClientNodeConfigArgsDict']] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input[Union['ClusterColdNodeConfigArgs', 'ClusterColdNodeConfigArgsDict']] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
               Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the engine version.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the css cluster, The value **0**
               indicates the default enterprise project.
        :param pulumi.Input[Union['ClusterEssNodeConfigArgs', 'ClusterEssNodeConfigArgsDict']] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[_builtins.bool] https_enabled: Specifies whether to enable HTTPS. Defaults to **false**.
               When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ClusterKibanaPublicAccessArgs', 'ClusterKibanaPublicAccessArgsDict']] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to **true**.
               The kibana_public_access structure is documented below.
        :param pulumi.Input[Union['ClusterMasterNodeConfigArgs', 'ClusterMasterNodeConfigArgsDict']] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the cluster name. It contains `4` to `32` characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when `security_mode` is set to true.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `9`.
               
               > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
               from **postPaid** to **prePaid** billing mode.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**.
        :param pulumi.Input[Union['ClusterPublicAccessArgs', 'ClusterPublicAccessArgsDict']] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID.
        :param pulumi.Input[_builtins.bool] security_mode: Specifies whether to enable authentication.
               The value can be **true** or **false**. Authentication is disabled by default.
               + **true:** Authentication is enabled for the cluster.
               + **false:** Authentication is disabled for the cluster.
               
               > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
               The cluster will be restarted to apply the changes. Services will be interrupted for a while.
               After the cluster is restarted, the authentication mode for invoking the cluster changes.
               You need to adjust the authentication mode accordingly.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the Subnet ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ClusterVpcepEndpointArgs', 'ClusterVpcepEndpointArgsDict']] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CSS cluster resource within SberCloud

        ## Example Usage

        ### create a cluster

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 1,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ### create a cluster with ess-data node and master node

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 1,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            master_node_config={
                "flavor": "ess.spec-4u8g",
                "instance_number": 3,
                "volume": {
                    "volume_type": "HIGH",
                    "size": 40,
                },
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ### create a cluster with ess-data node and cold node use local disk

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = sbercloud.css.Cluster("cluster",
            name="terraform_test_cluster",
            engine_version="7.10.2",
            ess_node_config={
                "flavor": "ess.spec-ds.xlarge.8",
                "instance_number": 1,
            },
            cold_node_config={
                "flavor": "ess.spec-ds.2xlarge.8",
                "instance_number": 2,
            },
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        The CSS cluster can be imported by `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Css/cluster:Cluster test <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['ClusterBackupStrategyArgs', 'ClusterBackupStrategyArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_node_config: Optional[pulumi.Input[Union['ClusterClientNodeConfigArgs', 'ClusterClientNodeConfigArgsDict']]] = None,
                 cold_node_config: Optional[pulumi.Input[Union['ClusterColdNodeConfigArgs', 'ClusterColdNodeConfigArgsDict']]] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ess_node_config: Optional[pulumi.Input[Union['ClusterEssNodeConfigArgs', 'ClusterEssNodeConfigArgsDict']]] = None,
                 expect_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kibana_public_access: Optional[pulumi.Input[Union['ClusterKibanaPublicAccessArgs', 'ClusterKibanaPublicAccessArgsDict']]] = None,
                 master_node_config: Optional[pulumi.Input[Union['ClusterMasterNodeConfigArgs', 'ClusterMasterNodeConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['ClusterNodeConfigArgs', 'ClusterNodeConfigArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access: Optional[pulumi.Input[Union['ClusterPublicAccessArgs', 'ClusterPublicAccessArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input[Union['ClusterVpcepEndpointArgs', 'ClusterVpcepEndpointArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["client_node_config"] = client_node_config
            __props__.__dict__["cold_node_config"] = cold_node_config
            __props__.__dict__["enable_force_new"] = enable_force_new
            __props__.__dict__["engine_type"] = engine_type
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["ess_node_config"] = ess_node_config
            __props__.__dict__["expect_node_num"] = expect_node_num
            __props__.__dict__["https_enabled"] = https_enabled
            __props__.__dict__["kibana_public_access"] = kibana_public_access
            __props__.__dict__["master_node_config"] = master_node_config
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["public_access"] = public_access
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpcep_endpoint"] = vpcep_endpoint
            __props__.__dict__["backup_available"] = None
            __props__.__dict__["bandwidth_resource_id"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_encrypted"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["is_period"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["vpcep_endpoint_id"] = None
            __props__.__dict__["vpcep_ip"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'sbercloud:Css/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            backup_available: Optional[pulumi.Input[_builtins.bool]] = None,
            backup_strategy: Optional[pulumi.Input[Union['ClusterBackupStrategyArgs', 'ClusterBackupStrategyArgsDict']]] = None,
            bandwidth_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            client_node_config: Optional[pulumi.Input[Union['ClusterClientNodeConfigArgs', 'ClusterClientNodeConfigArgsDict']]] = None,
            cold_node_config: Optional[pulumi.Input[Union['ClusterColdNodeConfigArgs', 'ClusterColdNodeConfigArgsDict']]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            engine_type: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ess_node_config: Optional[pulumi.Input[Union['ClusterEssNodeConfigArgs', 'ClusterEssNodeConfigArgsDict']]] = None,
            expect_node_num: Optional[pulumi.Input[_builtins.int]] = None,
            https_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_period: Optional[pulumi.Input[_builtins.bool]] = None,
            kibana_public_access: Optional[pulumi.Input[Union['ClusterKibanaPublicAccessArgs', 'ClusterKibanaPublicAccessArgsDict']]] = None,
            master_node_config: Optional[pulumi.Input[Union['ClusterMasterNodeConfigArgs', 'ClusterMasterNodeConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_config: Optional[pulumi.Input[Union['ClusterNodeConfigArgs', 'ClusterNodeConfigArgsDict']]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeArgs', 'ClusterNodeArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            public_access: Optional[pulumi.Input[Union['ClusterPublicAccessArgs', 'ClusterPublicAccessArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpcep_endpoint: Optional[pulumi.Input[Union['ClusterVpcepEndpointArgs', 'ClusterVpcepEndpointArgsDict']]] = None,
            vpcep_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpcep_ip: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               The valid values are **true** and **false**, defaults to **false**.
               
               <a name="Css_ess_node_config"></a>
               The `ess_node_config` and `cold_node_config` block supports:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is **1** at most.
        :param pulumi.Input[_builtins.bool] backup_available: Whether the snapshot function is enabled.
        :param pulumi.Input[Union['ClusterBackupStrategyArgs', 'ClusterBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.str] bandwidth_resource_id: The resource ID of bandwidth.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the cluster.
               Valid value is **postPaid**, defaults to **postPaid**.
        :param pulumi.Input[Union['ClusterClientNodeConfigArgs', 'ClusterClientNodeConfigArgsDict']] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input[Union['ClusterColdNodeConfigArgs', 'ClusterColdNodeConfigArgsDict']] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] created: schema: Deprecated; use created_at instead
        :param pulumi.Input[_builtins.str] created_at: Time when a cluster is created. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[_builtins.bool] disk_encrypted: Whether disks are encrypted.
        :param pulumi.Input[_builtins.str] endpoint: The IP address and port number.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
               Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the engine version.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the css cluster, The value **0**
               indicates the default enterprise project.
        :param pulumi.Input[Union['ClusterEssNodeConfigArgs', 'ClusterEssNodeConfigArgsDict']] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[_builtins.bool] https_enabled: Specifies whether to enable HTTPS. Defaults to **false**.
               When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_period: Whether a cluster is billed on the yearly/monthly mode.
        :param pulumi.Input[Union['ClusterKibanaPublicAccessArgs', 'ClusterKibanaPublicAccessArgsDict']] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to **true**.
               The kibana_public_access structure is documented below.
        :param pulumi.Input[Union['ClusterMasterNodeConfigArgs', 'ClusterMasterNodeConfigArgsDict']] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the cluster name. It contains `4` to `32` characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeArgs', 'ClusterNodeArgsDict']]]] nodes: List of node objects.
               The nodes structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when `security_mode` is set to true.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `9`.
               
               > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
               from **postPaid** to **prePaid** billing mode.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**.
        :param pulumi.Input[Union['ClusterPublicAccessArgs', 'ClusterPublicAccessArgsDict']] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID.
        :param pulumi.Input[_builtins.bool] security_mode: Specifies whether to enable authentication.
               The value can be **true** or **false**. Authentication is disabled by default.
               + **true:** Authentication is enabled for the cluster.
               + **false:** Authentication is disabled for the cluster.
               
               > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
               The cluster will be restarted to apply the changes. Services will be interrupted for a while.
               After the cluster is restarted, the authentication mode for invoking the cluster changes.
               You need to adjust the authentication mode accordingly.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the Subnet ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] updated_at: Time when a cluster is updated. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ClusterVpcepEndpointArgs', 'ClusterVpcepEndpointArgsDict']] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        :param pulumi.Input[_builtins.str] vpcep_endpoint_id: The VPC endpoint service ID.
        :param pulumi.Input[_builtins.str] vpcep_ip: The private IP address of VPC endpoint service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_available"] = backup_available
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["bandwidth_resource_id"] = bandwidth_resource_id
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["client_node_config"] = client_node_config
        __props__.__dict__["cold_node_config"] = cold_node_config
        __props__.__dict__["created"] = created
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["disk_encrypted"] = disk_encrypted
        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ess_node_config"] = ess_node_config
        __props__.__dict__["expect_node_num"] = expect_node_num
        __props__.__dict__["https_enabled"] = https_enabled
        __props__.__dict__["is_period"] = is_period
        __props__.__dict__["kibana_public_access"] = kibana_public_access
        __props__.__dict__["master_node_config"] = master_node_config
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_access"] = public_access
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpcep_endpoint"] = vpcep_endpoint
        __props__.__dict__["vpcep_endpoint_id"] = vpcep_endpoint_id
        __props__.__dict__["vpcep_ip"] = vpcep_ip
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        The valid values are **true** and **false**, defaults to **false**.

        <a name="Css_ess_node_config"></a>
        The `ess_node_config` and `cold_node_config` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is **1** at most.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="backupAvailable")
    def backup_available(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the snapshot function is enabled.
        """
        return pulumi.get(self, "backup_available")

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output[Optional['outputs.ClusterBackupStrategy']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @_builtins.property
    @pulumi.getter(name="bandwidthResourceId")
    def bandwidth_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of bandwidth.
        """
        return pulumi.get(self, "bandwidth_resource_id")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the cluster.
        Valid value is **postPaid**, defaults to **postPaid**.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> pulumi.Output[Optional['outputs.ClusterClientNodeConfig']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @_builtins.property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> pulumi.Output[Optional['outputs.ClusterColdNodeConfig']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        schema: Deprecated; use created_at instead
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when a cluster is created. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="diskEncrypted")
    def disk_encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether disks are encrypted.
        """
        return pulumi.get(self, "disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address and port number.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the engine type. The valid value can be **elasticsearch** or **opensearch**.
        Defaults to **elasticsearch**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the engine version.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the css cluster, The value **0**
        indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> pulumi.Output['outputs.ClusterEssNodeConfig']:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @_builtins.property
    @pulumi.getter(name="expectNodeNum")
    @_utilities.deprecated("""please use ess_node_config.instance_number instead""")
    def expect_node_num(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "expect_node_num")

    @_builtins.property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable HTTPS. Defaults to **false**.
        When `https_enabled` is set to **true**, the `security_mode` needs to be set to **true**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "https_enabled")

    @_builtins.property
    @pulumi.getter(name="isPeriod")
    def is_period(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether a cluster is billed on the yearly/monthly mode.
        """
        return pulumi.get(self, "is_period")

    @_builtins.property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> pulumi.Output[Optional['outputs.ClusterKibanaPublicAccess']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to **true**.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @_builtins.property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> pulumi.Output[Optional['outputs.ClusterMasterNodeConfig']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster name. It contains `4` to `32` characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    @_utilities.deprecated("""please use ess_node_config instead""")
    def node_config(self) -> pulumi.Output['outputs.ClusterNodeConfig']:
        return pulumi.get(self, "node_config")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.ClusterNode']]:
        """
        List of node objects.
        The nodes structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when `security_mode` is set to true.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `9`.

        > **NOTE:** `charging_mode`, `period_unit`, `period` can only be updated when changing
        from **postPaid** to **prePaid** billing mode.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> pulumi.Output[Optional['outputs.ClusterPublicAccess']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable authentication.
        The value can be **true** or **false**. Authentication is disabled by default.
        + **true:** Authentication is enabled for the cluster.
        + **false:** Authentication is disabled for the cluster.

        > **Note:** This parameter is supported in clusters 6.5.4 or later. Exercise caution when performing this operation.
        The cluster will be restarted to apply the changes. Services will be interrupted for a while.
        After the cluster is restarted, the authentication mode for invoking the cluster changes.
        You need to adjust the authentication mode accordingly.
        """
        return pulumi.get(self, "security_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Subnet ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when a cluster is updated. The format is ISO8601: CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> pulumi.Output[Optional['outputs.ClusterVpcepEndpoint']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @_builtins.property
    @pulumi.getter(name="vpcepEndpointId")
    def vpcep_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC endpoint service ID.
        """
        return pulumi.get(self, "vpcep_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="vpcepIp")
    def vpcep_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP address of VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_ip")

