# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, flavors=None, id=None, memory=None, name=None, region=None, type=None, vcpus=None, version=None):
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        The memory size in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the CSS flavor. It is referenced by `node_config.flavor` in `Css.Cluster`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region where the node resides.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The node instance type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[_builtins.int]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "vcpus")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The engine version.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            name=self.name,
            region=self.region,
            type=self.type,
            vcpus=self.vcpus,
            version=self.version)


def get_flavors(memory: Optional[_builtins.int] = None,
                name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                vcpus: Optional[_builtins.int] = None,
                version: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get available flavors of SberCloud CSS node instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Css.get_flavors(type="ess",
        version="7.9.3",
        vcpus=4,
        memory=32)
    ```


    :param _builtins.int memory: Specifies the memory size(GB) in the CSS flavor.
    :param _builtins.str name: Specifies the name of the CSS flavor.
    :param _builtins.str region: Specifies the region in which to obtain the CSS flavors. If omitted, the
           provider-level region will be used.
    :param _builtins.str type: Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
           and `ess-client`.
    :param _builtins.int vcpus: Specifies the number of vCPUs in the CSS flavor.
    :param _builtins.str version: Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
           `7.6.2` and `7.9.3`.
    """
    __args__ = dict()
    __args__['memory'] = memory
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Css/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        memory=pulumi.get(__ret__, 'memory'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'),
        vcpus=pulumi.get(__ret__, 'vcpus'),
        version=pulumi.get(__ret__, 'version'))
def get_flavors_output(memory: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get available flavors of SberCloud CSS node instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Css.get_flavors(type="ess",
        version="7.9.3",
        vcpus=4,
        memory=32)
    ```


    :param _builtins.int memory: Specifies the memory size(GB) in the CSS flavor.
    :param _builtins.str name: Specifies the name of the CSS flavor.
    :param _builtins.str region: Specifies the region in which to obtain the CSS flavors. If omitted, the
           provider-level region will be used.
    :param _builtins.str type: Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
           and `ess-client`.
    :param _builtins.int vcpus: Specifies the number of vCPUs in the CSS flavor.
    :param _builtins.str version: Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
           `7.6.2` and `7.9.3`.
    """
    __args__ = dict()
    __args__['memory'] = memory
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Css/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        memory=pulumi.get(__response__, 'memory'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type'),
        vcpus=pulumi.get(__response__, 'vcpus'),
        version=pulumi.get(__response__, 'version')))
