# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CssConfigurationArgs', 'CssConfiguration']

@pulumi.input_type
class CssConfigurationArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 http_cors_allow_credetials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 indices_queries_cache_size: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reindex_remote_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 thread_pool_force_merge_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CssConfiguration resource.
        :param pulumi.Input[_builtins.str] cluster_id: The CSS cluster ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] http_cors_allow_credetials: Whether to return the Access-Control-Allow-Credentials of
               the header during cross-domain access.
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_allow_headers: Headers allowed for cross-domain access.  
               Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
               Use commas (,) and spaces to separate headers.
        :param pulumi.Input[_builtins.str] http_cors_allow_methods: Methods allowed for cross-domain access.  
               Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
               Use commas (,) and spaces to separate methods.
        :param pulumi.Input[_builtins.str] http_cors_allow_origin: Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] http_cors_enabled: Whether to allow cross-domain access.  
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_max_age: Cache duration of the browser. The cache is automatically cleared
               after the time range you specify.
               Unit: s, Default value: **1,728,000**.
        :param pulumi.Input[_builtins.str] indices_queries_cache_size: Cache size in the query phase. Value range: **1%** to **100%**.  
               Unit: %, Default value: **10%**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] reindex_remote_whitelist: Configured for migrating data from the current cluster to
               the target cluster through the reindex API.
               The example value is **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] thread_pool_force_merge_size: Queue size in the force merge thread pool.  
               Default value: **1**.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if http_cors_allow_credetials is not None:
            pulumi.set(__self__, "http_cors_allow_credetials", http_cors_allow_credetials)
        if http_cors_allow_headers is not None:
            pulumi.set(__self__, "http_cors_allow_headers", http_cors_allow_headers)
        if http_cors_allow_methods is not None:
            pulumi.set(__self__, "http_cors_allow_methods", http_cors_allow_methods)
        if http_cors_allow_origin is not None:
            pulumi.set(__self__, "http_cors_allow_origin", http_cors_allow_origin)
        if http_cors_enabled is not None:
            pulumi.set(__self__, "http_cors_enabled", http_cors_enabled)
        if http_cors_max_age is not None:
            pulumi.set(__self__, "http_cors_max_age", http_cors_max_age)
        if indices_queries_cache_size is not None:
            pulumi.set(__self__, "indices_queries_cache_size", indices_queries_cache_size)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reindex_remote_whitelist is not None:
            pulumi.set(__self__, "reindex_remote_whitelist", reindex_remote_whitelist)
        if thread_pool_force_merge_size is not None:
            pulumi.set(__self__, "thread_pool_force_merge_size", thread_pool_force_merge_size)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The CSS cluster ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowCredetials")
    def http_cors_allow_credetials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to return the Access-Control-Allow-Credentials of
        the header during cross-domain access.
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_allow_credetials")

    @http_cors_allow_credetials.setter
    def http_cors_allow_credetials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_credetials", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowHeaders")
    def http_cors_allow_headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Headers allowed for cross-domain access.  
        Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
        Use commas (,) and spaces to separate headers.
        """
        return pulumi.get(self, "http_cors_allow_headers")

    @http_cors_allow_headers.setter
    def http_cors_allow_headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_headers", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowMethods")
    def http_cors_allow_methods(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Methods allowed for cross-domain access.  
        Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
        Use commas (,) and spaces to separate methods.
        """
        return pulumi.get(self, "http_cors_allow_methods")

    @http_cors_allow_methods.setter
    def http_cors_allow_methods(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_methods", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowOrigin")
    def http_cors_allow_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        """
        return pulumi.get(self, "http_cors_allow_origin")

    @http_cors_allow_origin.setter
    def http_cors_allow_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_origin", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsEnabled")
    def http_cors_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow cross-domain access.  
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_enabled")

    @http_cors_enabled.setter
    def http_cors_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsMaxAge")
    def http_cors_max_age(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache duration of the browser. The cache is automatically cleared
        after the time range you specify.
        Unit: s, Default value: **1,728,000**.
        """
        return pulumi.get(self, "http_cors_max_age")

    @http_cors_max_age.setter
    def http_cors_max_age(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_max_age", value)

    @_builtins.property
    @pulumi.getter(name="indicesQueriesCacheSize")
    def indices_queries_cache_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache size in the query phase. Value range: **1%** to **100%**.  
        Unit: %, Default value: **10%**.
        """
        return pulumi.get(self, "indices_queries_cache_size")

    @indices_queries_cache_size.setter
    def indices_queries_cache_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "indices_queries_cache_size", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reindexRemoteWhitelist")
    def reindex_remote_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configured for migrating data from the current cluster to
        the target cluster through the reindex API.
        The example value is **122.122.122.122:9200**.
        """
        return pulumi.get(self, "reindex_remote_whitelist")

    @reindex_remote_whitelist.setter
    def reindex_remote_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reindex_remote_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="threadPoolForceMergeSize")
    def thread_pool_force_merge_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Queue size in the force merge thread pool.  
        Default value: **1**.
        """
        return pulumi.get(self, "thread_pool_force_merge_size")

    @thread_pool_force_merge_size.setter
    def thread_pool_force_merge_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thread_pool_force_merge_size", value)


@pulumi.input_type
class _CssConfigurationState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_credetials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 indices_queries_cache_size: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reindex_remote_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 thread_pool_force_merge_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CssConfiguration resources.
        :param pulumi.Input[_builtins.str] cluster_id: The CSS cluster ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] http_cors_allow_credetials: Whether to return the Access-Control-Allow-Credentials of
               the header during cross-domain access.
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_allow_headers: Headers allowed for cross-domain access.  
               Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
               Use commas (,) and spaces to separate headers.
        :param pulumi.Input[_builtins.str] http_cors_allow_methods: Methods allowed for cross-domain access.  
               Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
               Use commas (,) and spaces to separate methods.
        :param pulumi.Input[_builtins.str] http_cors_allow_origin: Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] http_cors_enabled: Whether to allow cross-domain access.  
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_max_age: Cache duration of the browser. The cache is automatically cleared
               after the time range you specify.
               Unit: s, Default value: **1,728,000**.
        :param pulumi.Input[_builtins.str] indices_queries_cache_size: Cache size in the query phase. Value range: **1%** to **100%**.  
               Unit: %, Default value: **10%**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] reindex_remote_whitelist: Configured for migrating data from the current cluster to
               the target cluster through the reindex API.
               The example value is **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] thread_pool_force_merge_size: Queue size in the force merge thread pool.  
               Default value: **1**.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if http_cors_allow_credetials is not None:
            pulumi.set(__self__, "http_cors_allow_credetials", http_cors_allow_credetials)
        if http_cors_allow_headers is not None:
            pulumi.set(__self__, "http_cors_allow_headers", http_cors_allow_headers)
        if http_cors_allow_methods is not None:
            pulumi.set(__self__, "http_cors_allow_methods", http_cors_allow_methods)
        if http_cors_allow_origin is not None:
            pulumi.set(__self__, "http_cors_allow_origin", http_cors_allow_origin)
        if http_cors_enabled is not None:
            pulumi.set(__self__, "http_cors_enabled", http_cors_enabled)
        if http_cors_max_age is not None:
            pulumi.set(__self__, "http_cors_max_age", http_cors_max_age)
        if indices_queries_cache_size is not None:
            pulumi.set(__self__, "indices_queries_cache_size", indices_queries_cache_size)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reindex_remote_whitelist is not None:
            pulumi.set(__self__, "reindex_remote_whitelist", reindex_remote_whitelist)
        if thread_pool_force_merge_size is not None:
            pulumi.set(__self__, "thread_pool_force_merge_size", thread_pool_force_merge_size)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CSS cluster ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowCredetials")
    def http_cors_allow_credetials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to return the Access-Control-Allow-Credentials of
        the header during cross-domain access.
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_allow_credetials")

    @http_cors_allow_credetials.setter
    def http_cors_allow_credetials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_credetials", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowHeaders")
    def http_cors_allow_headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Headers allowed for cross-domain access.  
        Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
        Use commas (,) and spaces to separate headers.
        """
        return pulumi.get(self, "http_cors_allow_headers")

    @http_cors_allow_headers.setter
    def http_cors_allow_headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_headers", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowMethods")
    def http_cors_allow_methods(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Methods allowed for cross-domain access.  
        Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
        Use commas (,) and spaces to separate methods.
        """
        return pulumi.get(self, "http_cors_allow_methods")

    @http_cors_allow_methods.setter
    def http_cors_allow_methods(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_methods", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowOrigin")
    def http_cors_allow_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        """
        return pulumi.get(self, "http_cors_allow_origin")

    @http_cors_allow_origin.setter
    def http_cors_allow_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_allow_origin", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsEnabled")
    def http_cors_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow cross-domain access.  
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_enabled")

    @http_cors_enabled.setter
    def http_cors_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpCorsMaxAge")
    def http_cors_max_age(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache duration of the browser. The cache is automatically cleared
        after the time range you specify.
        Unit: s, Default value: **1,728,000**.
        """
        return pulumi.get(self, "http_cors_max_age")

    @http_cors_max_age.setter
    def http_cors_max_age(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_cors_max_age", value)

    @_builtins.property
    @pulumi.getter(name="indicesQueriesCacheSize")
    def indices_queries_cache_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache size in the query phase. Value range: **1%** to **100%**.  
        Unit: %, Default value: **10%**.
        """
        return pulumi.get(self, "indices_queries_cache_size")

    @indices_queries_cache_size.setter
    def indices_queries_cache_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "indices_queries_cache_size", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reindexRemoteWhitelist")
    def reindex_remote_whitelist(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configured for migrating data from the current cluster to
        the target cluster through the reindex API.
        The example value is **122.122.122.122:9200**.
        """
        return pulumi.get(self, "reindex_remote_whitelist")

    @reindex_remote_whitelist.setter
    def reindex_remote_whitelist(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reindex_remote_whitelist", value)

    @_builtins.property
    @pulumi.getter(name="threadPoolForceMergeSize")
    def thread_pool_force_merge_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Queue size in the force merge thread pool.  
        Default value: **1**.
        """
        return pulumi.get(self, "thread_pool_force_merge_size")

    @thread_pool_force_merge_size.setter
    def thread_pool_force_merge_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thread_pool_force_merge_size", value)


@pulumi.type_token("sbercloud:index/cssConfiguration:CssConfiguration")
class CssConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_credetials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 indices_queries_cache_size: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reindex_remote_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 thread_pool_force_merge_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CSS configuration resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        test = sbercloud.CssConfiguration("test",
            cluster_id=cluster_id,
            thread_pool_force_merge_size="3")
        ```

        ## Import

        The CSS configuration can be imported using the `id` which equals the `cluster_id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/cssConfiguration:CssConfiguration test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The CSS cluster ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] http_cors_allow_credetials: Whether to return the Access-Control-Allow-Credentials of
               the header during cross-domain access.
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_allow_headers: Headers allowed for cross-domain access.  
               Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
               Use commas (,) and spaces to separate headers.
        :param pulumi.Input[_builtins.str] http_cors_allow_methods: Methods allowed for cross-domain access.  
               Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
               Use commas (,) and spaces to separate methods.
        :param pulumi.Input[_builtins.str] http_cors_allow_origin: Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] http_cors_enabled: Whether to allow cross-domain access.  
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_max_age: Cache duration of the browser. The cache is automatically cleared
               after the time range you specify.
               Unit: s, Default value: **1,728,000**.
        :param pulumi.Input[_builtins.str] indices_queries_cache_size: Cache size in the query phase. Value range: **1%** to **100%**.  
               Unit: %, Default value: **10%**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] reindex_remote_whitelist: Configured for migrating data from the current cluster to
               the target cluster through the reindex API.
               The example value is **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] thread_pool_force_merge_size: Queue size in the force merge thread pool.  
               Default value: **1**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CssConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CSS configuration resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        test = sbercloud.CssConfiguration("test",
            cluster_id=cluster_id,
            thread_pool_force_merge_size="3")
        ```

        ## Import

        The CSS configuration can be imported using the `id` which equals the `cluster_id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/cssConfiguration:CssConfiguration test <id>
        ```

        :param str resource_name: The name of the resource.
        :param CssConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CssConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_credetials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_headers: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_methods: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_allow_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 http_cors_max_age: Optional[pulumi.Input[_builtins.str]] = None,
                 indices_queries_cache_size: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reindex_remote_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
                 thread_pool_force_merge_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CssConfigurationArgs.__new__(CssConfigurationArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["http_cors_allow_credetials"] = http_cors_allow_credetials
            __props__.__dict__["http_cors_allow_headers"] = http_cors_allow_headers
            __props__.__dict__["http_cors_allow_methods"] = http_cors_allow_methods
            __props__.__dict__["http_cors_allow_origin"] = http_cors_allow_origin
            __props__.__dict__["http_cors_enabled"] = http_cors_enabled
            __props__.__dict__["http_cors_max_age"] = http_cors_max_age
            __props__.__dict__["indices_queries_cache_size"] = indices_queries_cache_size
            __props__.__dict__["region"] = region
            __props__.__dict__["reindex_remote_whitelist"] = reindex_remote_whitelist
            __props__.__dict__["thread_pool_force_merge_size"] = thread_pool_force_merge_size
        super(CssConfiguration, __self__).__init__(
            'sbercloud:index/cssConfiguration:CssConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_allow_credetials: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_allow_headers: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_allow_methods: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_allow_origin: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_enabled: Optional[pulumi.Input[_builtins.str]] = None,
            http_cors_max_age: Optional[pulumi.Input[_builtins.str]] = None,
            indices_queries_cache_size: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reindex_remote_whitelist: Optional[pulumi.Input[_builtins.str]] = None,
            thread_pool_force_merge_size: Optional[pulumi.Input[_builtins.str]] = None) -> 'CssConfiguration':
        """
        Get an existing CssConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The CSS cluster ID.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] http_cors_allow_credetials: Whether to return the Access-Control-Allow-Credentials of
               the header during cross-domain access.
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_allow_headers: Headers allowed for cross-domain access.  
               Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
               Use commas (,) and spaces to separate headers.
        :param pulumi.Input[_builtins.str] http_cors_allow_methods: Methods allowed for cross-domain access.  
               Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
               Use commas (,) and spaces to separate methods.
        :param pulumi.Input[_builtins.str] http_cors_allow_origin: Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] http_cors_enabled: Whether to allow cross-domain access.  
               The value can be **true** or **false**. Default value: **false**.
        :param pulumi.Input[_builtins.str] http_cors_max_age: Cache duration of the browser. The cache is automatically cleared
               after the time range you specify.
               Unit: s, Default value: **1,728,000**.
        :param pulumi.Input[_builtins.str] indices_queries_cache_size: Cache size in the query phase. Value range: **1%** to **100%**.  
               Unit: %, Default value: **10%**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] reindex_remote_whitelist: Configured for migrating data from the current cluster to
               the target cluster through the reindex API.
               The example value is **122.122.122.122:9200**.
        :param pulumi.Input[_builtins.str] thread_pool_force_merge_size: Queue size in the force merge thread pool.  
               Default value: **1**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CssConfigurationState.__new__(_CssConfigurationState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["http_cors_allow_credetials"] = http_cors_allow_credetials
        __props__.__dict__["http_cors_allow_headers"] = http_cors_allow_headers
        __props__.__dict__["http_cors_allow_methods"] = http_cors_allow_methods
        __props__.__dict__["http_cors_allow_origin"] = http_cors_allow_origin
        __props__.__dict__["http_cors_enabled"] = http_cors_enabled
        __props__.__dict__["http_cors_max_age"] = http_cors_max_age
        __props__.__dict__["indices_queries_cache_size"] = indices_queries_cache_size
        __props__.__dict__["region"] = region
        __props__.__dict__["reindex_remote_whitelist"] = reindex_remote_whitelist
        __props__.__dict__["thread_pool_force_merge_size"] = thread_pool_force_merge_size
        return CssConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The CSS cluster ID.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowCredetials")
    def http_cors_allow_credetials(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to return the Access-Control-Allow-Credentials of
        the header during cross-domain access.
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_allow_credetials")

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowHeaders")
    def http_cors_allow_headers(self) -> pulumi.Output[_builtins.str]:
        """
        Headers allowed for cross-domain access.  
        Including **X-Requested-With**, **Content-Type**, and **Content-Length**.
        Use commas (,) and spaces to separate headers.
        """
        return pulumi.get(self, "http_cors_allow_headers")

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowMethods")
    def http_cors_allow_methods(self) -> pulumi.Output[_builtins.str]:
        """
        Methods allowed for cross-domain access.  
        Including **OPTIONS**, **HEAD**, **GET**, **POST**, **PUT**, and **DELETE**.
        Use commas (,) and spaces to separate methods.
        """
        return pulumi.get(self, "http_cors_allow_methods")

    @_builtins.property
    @pulumi.getter(name="httpCorsAllowOrigin")
    def http_cors_allow_origin(self) -> pulumi.Output[_builtins.str]:
        """
        Origin IP address allowed for cross-domain access, for example, **122.122.122.122:9200**.
        """
        return pulumi.get(self, "http_cors_allow_origin")

    @_builtins.property
    @pulumi.getter(name="httpCorsEnabled")
    def http_cors_enabled(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to allow cross-domain access.  
        The value can be **true** or **false**. Default value: **false**.
        """
        return pulumi.get(self, "http_cors_enabled")

    @_builtins.property
    @pulumi.getter(name="httpCorsMaxAge")
    def http_cors_max_age(self) -> pulumi.Output[_builtins.str]:
        """
        Cache duration of the browser. The cache is automatically cleared
        after the time range you specify.
        Unit: s, Default value: **1,728,000**.
        """
        return pulumi.get(self, "http_cors_max_age")

    @_builtins.property
    @pulumi.getter(name="indicesQueriesCacheSize")
    def indices_queries_cache_size(self) -> pulumi.Output[_builtins.str]:
        """
        Cache size in the query phase. Value range: **1%** to **100%**.  
        Unit: %, Default value: **10%**.
        """
        return pulumi.get(self, "indices_queries_cache_size")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reindexRemoteWhitelist")
    def reindex_remote_whitelist(self) -> pulumi.Output[_builtins.str]:
        """
        Configured for migrating data from the current cluster to
        the target cluster through the reindex API.
        The example value is **122.122.122.122:9200**.
        """
        return pulumi.get(self, "reindex_remote_whitelist")

    @_builtins.property
    @pulumi.getter(name="threadPoolForceMergeSize")
    def thread_pool_force_merge_size(self) -> pulumi.Output[_builtins.str]:
        """
        Queue size in the force merge thread pool.  
        Default value: **1**.
        """
        return pulumi.get(self, "thread_pool_force_merge_size")

