# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationArgs', 'Notification']

@pulumi.input_type
class NotificationArgs:
    def __init__(__self__, *,
                 operation_type: pulumi.Input[_builtins.str],
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input['NotificationFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 smn_topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Notification resource.
        :param pulumi.Input[_builtins.str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether notification is enabled, defaults to true.
               
               <a name="notification_operations_object"></a>
               The `operations` block supports:
        :param pulumi.Input[_builtins.str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] smn_topic: Specifies the URN of a topic.
        """
        pulumi.set(__self__, "operation_type", operation_type)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation_users is not None:
            pulumi.set(__self__, "operation_users", operation_users)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)

    @_builtins.property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation_type", value)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether notification is enabled, defaults to true.

        <a name="notification_operations_object"></a>
        The `operations` block supports:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['NotificationFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['NotificationFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @operation_users.setter
    def operation_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]):
        pulumi.set(self, "operation_users", value)

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smn_topic", value)


@pulumi.input_type
class _NotificationState:
    def __init__(__self__, *,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input['NotificationFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_id: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 smn_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Notification resources.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether notification is enabled, defaults to true.
               
               <a name="notification_operations_object"></a>
               The `operations` block supports:
        :param pulumi.Input[_builtins.str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[_builtins.str] notification_id: The notification ID in UUID format.
        :param pulumi.Input[_builtins.str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] smn_topic: Specifies the URN of a topic.
        :param pulumi.Input[_builtins.str] status: The notification status, the value can be **enabled** or **disabled**.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_id is not None:
            pulumi.set(__self__, "notification_id", notification_id)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if operation_users is not None:
            pulumi.set(__self__, "operation_users", operation_users)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether notification is enabled, defaults to true.

        <a name="notification_operations_object"></a>
        The `operations` block supports:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['NotificationFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['NotificationFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationId")
    def notification_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The notification ID in UUID format.
        """
        return pulumi.get(self, "notification_id")

    @notification_id.setter
    def notification_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_id", value)

    @_builtins.property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_type", value)

    @_builtins.property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @operation_users.setter
    def operation_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]):
        pulumi.set(self, "operation_users", value)

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smn_topic", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The notification status, the value can be **enabled** or **disabled**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:Cts/notification:Notification")
class Notification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['NotificationFilterArgs', 'NotificationFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationUserArgs', 'NotificationOperationUserArgsDict']]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationArgs', 'NotificationOperationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 smn_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages CTS key event notification resource within SberCloud.

        ## Example Usage

        ### Complete Notification

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = sbercloud.cts.Notification("notify",
            name="keyOperate_test",
            operation_type="complete",
            smn_topic=topic_urn)
        ```

        ### Customized Notification

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = sbercloud.cts.Notification("notify",
            name="keyOperate_test",
            operation_type="customized",
            smn_topic=topic_urn,
            operations=[{
                "service": "ECS",
                "resource": "ecs",
                "trace_names": [
                    "createServer",
                    "deleteServer",
                ],
            }])
        ```

        ## Import

        CTS notifications can be imported using `name`, e.g.:

        ```sh
        $ pulumi import sbercloud:Cts/notification:Notification tracker your_notification
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether notification is enabled, defaults to true.
               
               <a name="notification_operations_object"></a>
               The `operations` block supports:
        :param pulumi.Input[_builtins.str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[_builtins.str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationUserArgs', 'NotificationOperationUserArgsDict']]]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationArgs', 'NotificationOperationArgsDict']]]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] smn_topic: Specifies the URN of a topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CTS key event notification resource within SberCloud.

        ## Example Usage

        ### Complete Notification

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = sbercloud.cts.Notification("notify",
            name="keyOperate_test",
            operation_type="complete",
            smn_topic=topic_urn)
        ```

        ### Customized Notification

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = sbercloud.cts.Notification("notify",
            name="keyOperate_test",
            operation_type="customized",
            smn_topic=topic_urn,
            operations=[{
                "service": "ECS",
                "resource": "ecs",
                "trace_names": [
                    "createServer",
                    "deleteServer",
                ],
            }])
        ```

        ## Import

        CTS notifications can be imported using `name`, e.g.:

        ```sh
        $ pulumi import sbercloud:Cts/notification:Notification tracker your_notification
        ```

        :param str resource_name: The name of the resource.
        :param NotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['NotificationFilterArgs', 'NotificationFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationUserArgs', 'NotificationOperationUserArgsDict']]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationArgs', 'NotificationOperationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 smn_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationArgs.__new__(NotificationArgs)

            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            __props__.__dict__["name"] = name
            if operation_type is None and not opts.urn:
                raise TypeError("Missing required property 'operation_type'")
            __props__.__dict__["operation_type"] = operation_type
            __props__.__dict__["operation_users"] = operation_users
            __props__.__dict__["operations"] = operations
            __props__.__dict__["region"] = region
            __props__.__dict__["smn_topic"] = smn_topic
            __props__.__dict__["created_at"] = None
            __props__.__dict__["notification_id"] = None
            __props__.__dict__["status"] = None
        super(Notification, __self__).__init__(
            'sbercloud:Cts/notification:Notification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agency_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filter: Optional[pulumi.Input[Union['NotificationFilterArgs', 'NotificationFilterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_id: Optional[pulumi.Input[_builtins.str]] = None,
            operation_type: Optional[pulumi.Input[_builtins.str]] = None,
            operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationUserArgs', 'NotificationOperationUserArgsDict']]]]] = None,
            operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationArgs', 'NotificationOperationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            smn_topic: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Notification':
        """
        Get an existing Notification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether notification is enabled, defaults to true.
               
               <a name="notification_operations_object"></a>
               The `operations` block supports:
        :param pulumi.Input[_builtins.str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[_builtins.str] notification_id: The notification ID in UUID format.
        :param pulumi.Input[_builtins.str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationUserArgs', 'NotificationOperationUserArgsDict']]]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationOperationArgs', 'NotificationOperationArgsDict']]]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] smn_topic: Specifies the URN of a topic.
        :param pulumi.Input[_builtins.str] status: The notification status, the value can be **enabled** or **disabled**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationState.__new__(_NotificationState)

        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_id"] = notification_id
        __props__.__dict__["operation_type"] = operation_type
        __props__.__dict__["operation_users"] = operation_users
        __props__.__dict__["operations"] = operations
        __props__.__dict__["region"] = region
        __props__.__dict__["smn_topic"] = smn_topic
        __props__.__dict__["status"] = status
        return Notification(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether notification is enabled, defaults to true.

        <a name="notification_operations_object"></a>
        The `operations` block supports:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.NotificationFilter']]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationId")
    def notification_id(self) -> pulumi.Output[_builtins.str]:
        """
        The notification ID in UUID format.
        """
        return pulumi.get(self, "notification_id")

    @_builtins.property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @_builtins.property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> pulumi.Output[Optional[Sequence['outputs.NotificationOperationUser']]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @_builtins.property
    @pulumi.getter
    def operations(self) -> pulumi.Output[Optional[Sequence['outputs.NotificationOperation']]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.sbercloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The notification status, the value can be **enabled** or **disabled**.
        """
        return pulumi.get(self, "status")

