# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrackerArgs', 'Tracker']

@pulumi.input_type
class TrackerArgs:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_tracker: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 is_sort_by_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validate_file: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Tracker resource.
        :param pulumi.Input[_builtins.str] bucket_name: Specifies the OBS bucket to which traces will be transferred.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether tracker is enabled.
        :param pulumi.Input[_builtins.str] file_prefix: Specifies the file name prefix to mark trace files that need to be stored
               in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
               and periods (.) are allowed.
        :param pulumi.Input[_builtins.str] kms_id: Specifies the ID of KMS key used for trace file encryption.
        :param pulumi.Input[_builtins.bool] lts_enabled: Specifies whether trace analysis is enabled.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS system tracker resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] validate_file: Specifies whether trace file verification is enabled during trace transfer.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if delete_tracker is not None:
            pulumi.set(__self__, "delete_tracker", delete_tracker)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_services is not None:
            pulumi.set(__self__, "exclude_services", exclude_services)
        if file_prefix is not None:
            pulumi.set(__self__, "file_prefix", file_prefix)
        if is_sort_by_service is not None:
            pulumi.set(__self__, "is_sort_by_service", is_sort_by_service)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if lts_enabled is not None:
            pulumi.set(__self__, "lts_enabled", lts_enabled)
        if organization_enabled is not None:
            pulumi.set(__self__, "organization_enabled", organization_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validate_file is not None:
            pulumi.set(__self__, "validate_file", validate_file)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OBS bucket to which traces will be transferred.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compress_type", value)

    @_builtins.property
    @pulumi.getter(name="deleteTracker")
    def delete_tracker(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_tracker")

    @delete_tracker.setter
    def delete_tracker(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_tracker", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether tracker is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="excludeServices")
    def exclude_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "exclude_services")

    @exclude_services.setter
    def exclude_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_services", value)

    @_builtins.property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name prefix to mark trace files that need to be stored
        in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
        and periods (.) are allowed.
        """
        return pulumi.get(self, "file_prefix")

    @file_prefix.setter
    def file_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_prefix", value)

    @_builtins.property
    @pulumi.getter(name="isSortByService")
    def is_sort_by_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_sort_by_service")

    @is_sort_by_service.setter
    def is_sort_by_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sort_by_service", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of KMS key used for trace file encryption.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter(name="ltsEnabled")
    def lts_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether trace analysis is enabled.
        """
        return pulumi.get(self, "lts_enabled")

    @lts_enabled.setter
    def lts_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lts_enabled", value)

    @_builtins.property
    @pulumi.getter(name="organizationEnabled")
    def organization_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "organization_enabled")

    @organization_enabled.setter
    def organization_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "organization_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to manage the CTS system tracker resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validateFile")
    def validate_file(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether trace file verification is enabled during trace transfer.
        """
        return pulumi.get(self, "validate_file")

    @validate_file.setter
    def validate_file(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate_file", value)


@pulumi.input_type
class _TrackerState:
    def __init__(__self__, *,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_tracker: Optional[pulumi.Input[_builtins.bool]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_authorized_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sort_by_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_file: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Tracker resources.
        :param pulumi.Input[_builtins.str] bucket_name: Specifies the OBS bucket to which traces will be transferred.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether tracker is enabled.
        :param pulumi.Input[_builtins.str] file_prefix: Specifies the file name prefix to mark trace files that need to be stored
               in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
               and periods (.) are allowed.
        :param pulumi.Input[_builtins.str] kms_id: Specifies the ID of KMS key used for trace file encryption.
        :param pulumi.Input[_builtins.bool] lts_enabled: Specifies whether trace analysis is enabled.
        :param pulumi.Input[_builtins.str] name: The tracker name, only **system** is available.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS system tracker resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: The tracker status, the value can be **enabled**, **disabled** or **error**.
        :param pulumi.Input[_builtins.bool] transfer_enabled: Whether traces will be transferred.
        :param pulumi.Input[_builtins.str] type: The tracker type, only **system** is available.
        :param pulumi.Input[_builtins.bool] validate_file: Specifies whether trace file verification is enabled during trace transfer.
        """
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if compress_type is not None:
            pulumi.set(__self__, "compress_type", compress_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_tracker is not None:
            pulumi.set(__self__, "delete_tracker", delete_tracker)
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_services is not None:
            pulumi.set(__self__, "exclude_services", exclude_services)
        if file_prefix is not None:
            pulumi.set(__self__, "file_prefix", file_prefix)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if is_authorized_bucket is not None:
            pulumi.set(__self__, "is_authorized_bucket", is_authorized_bucket)
        if is_sort_by_service is not None:
            pulumi.set(__self__, "is_sort_by_service", is_sort_by_service)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)
        if log_topic_name is not None:
            pulumi.set(__self__, "log_topic_name", log_topic_name)
        if lts_enabled is not None:
            pulumi.set(__self__, "lts_enabled", lts_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_enabled is not None:
            pulumi.set(__self__, "organization_enabled", organization_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transfer_enabled is not None:
            pulumi.set(__self__, "transfer_enabled", transfer_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate_file is not None:
            pulumi.set(__self__, "validate_file", validate_file)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OBS bucket to which traces will be transferred.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "compress_type")

    @compress_type.setter
    def compress_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compress_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteTracker")
    def delete_tracker(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_tracker")

    @delete_tracker.setter
    def delete_tracker(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_tracker", value)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether tracker is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="excludeServices")
    def exclude_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "exclude_services")

    @exclude_services.setter
    def exclude_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_services", value)

    @_builtins.property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file name prefix to mark trace files that need to be stored
        in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
        and periods (.) are allowed.
        """
        return pulumi.get(self, "file_prefix")

    @file_prefix.setter
    def file_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_prefix", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="isAuthorizedBucket")
    def is_authorized_bucket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_authorized_bucket")

    @is_authorized_bucket.setter
    def is_authorized_bucket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_authorized_bucket", value)

    @_builtins.property
    @pulumi.getter(name="isSortByService")
    def is_sort_by_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_sort_by_service")

    @is_sort_by_service.setter
    def is_sort_by_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sort_by_service", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of KMS key used for trace file encryption.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_name", value)

    @_builtins.property
    @pulumi.getter(name="logTopicName")
    def log_topic_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_topic_name")

    @log_topic_name.setter
    def log_topic_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_topic_name", value)

    @_builtins.property
    @pulumi.getter(name="ltsEnabled")
    def lts_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether trace analysis is enabled.
        """
        return pulumi.get(self, "lts_enabled")

    @lts_enabled.setter
    def lts_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lts_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tracker name, only **system** is available.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationEnabled")
    def organization_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "organization_enabled")

    @organization_enabled.setter
    def organization_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "organization_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to manage the CTS system tracker resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tracker status, the value can be **enabled**, **disabled** or **error**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transferEnabled")
    def transfer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether traces will be transferred.
        """
        return pulumi.get(self, "transfer_enabled")

    @transfer_enabled.setter
    def transfer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transfer_enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tracker type, only **system** is available.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="validateFile")
    def validate_file(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether trace file verification is enabled during trace transfer.
        """
        return pulumi.get(self, "validate_file")

    @validate_file.setter
    def validate_file(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate_file", value)


@pulumi.type_token("sbercloud:Cts/tracker:Tracker")
class Tracker(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_tracker: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 is_sort_by_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validate_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages CTS **system** tracker resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        bucket_name = config.require_object("bucketName")
        tracker = sbercloud.cts.Tracker("tracker",
            bucket_name=bucket_name,
            file_prefix="cts",
            lts_enabled=True)
        ```

        ## Import

        CTS tracker can be imported using `name`, only __system__ is available. e.g.

        ```sh
        $ pulumi import sbercloud:Cts/tracker:Tracker tracker system
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: Specifies the OBS bucket to which traces will be transferred.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether tracker is enabled.
        :param pulumi.Input[_builtins.str] file_prefix: Specifies the file name prefix to mark trace files that need to be stored
               in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
               and periods (.) are allowed.
        :param pulumi.Input[_builtins.str] kms_id: Specifies the ID of KMS key used for trace file encryption.
        :param pulumi.Input[_builtins.bool] lts_enabled: Specifies whether trace analysis is enabled.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS system tracker resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] validate_file: Specifies whether trace file verification is enabled during trace transfer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TrackerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CTS **system** tracker resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        bucket_name = config.require_object("bucketName")
        tracker = sbercloud.cts.Tracker("tracker",
            bucket_name=bucket_name,
            file_prefix="cts",
            lts_enabled=True)
        ```

        ## Import

        CTS tracker can be imported using `name`, only __system__ is available. e.g.

        ```sh
        $ pulumi import sbercloud:Cts/tracker:Tracker tracker system
        ```

        :param str resource_name: The name of the resource.
        :param TrackerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrackerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compress_type: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_tracker: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 file_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 is_sort_by_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lts_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validate_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrackerArgs.__new__(TrackerArgs)

            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["compress_type"] = compress_type
            __props__.__dict__["delete_tracker"] = delete_tracker
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["exclude_services"] = exclude_services
            __props__.__dict__["file_prefix"] = file_prefix
            __props__.__dict__["is_sort_by_service"] = is_sort_by_service
            __props__.__dict__["kms_id"] = kms_id
            __props__.__dict__["lts_enabled"] = lts_enabled
            __props__.__dict__["organization_enabled"] = organization_enabled
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["validate_file"] = validate_file
            __props__.__dict__["agency_name"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["detail"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["group_id"] = None
            __props__.__dict__["is_authorized_bucket"] = None
            __props__.__dict__["log_group_name"] = None
            __props__.__dict__["log_topic_name"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["stream_id"] = None
            __props__.__dict__["transfer_enabled"] = None
            __props__.__dict__["type"] = None
        super(Tracker, __self__).__init__(
            'sbercloud:Cts/tracker:Tracker',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agency_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            compress_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            delete_tracker: Optional[pulumi.Input[_builtins.bool]] = None,
            detail: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            exclude_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            file_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_authorized_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sort_by_service: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            log_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
            lts_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transfer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            validate_file: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Tracker':
        """
        Get an existing Tracker resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: Specifies the OBS bucket to which traces will be transferred.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether tracker is enabled.
        :param pulumi.Input[_builtins.str] file_prefix: Specifies the file name prefix to mark trace files that need to be stored
               in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
               and periods (.) are allowed.
        :param pulumi.Input[_builtins.str] kms_id: Specifies the ID of KMS key used for trace file encryption.
        :param pulumi.Input[_builtins.bool] lts_enabled: Specifies whether trace analysis is enabled.
        :param pulumi.Input[_builtins.str] name: The tracker name, only **system** is available.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to manage the CTS system tracker resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: The tracker status, the value can be **enabled**, **disabled** or **error**.
        :param pulumi.Input[_builtins.bool] transfer_enabled: Whether traces will be transferred.
        :param pulumi.Input[_builtins.str] type: The tracker type, only **system** is available.
        :param pulumi.Input[_builtins.bool] validate_file: Specifies whether trace file verification is enabled during trace transfer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrackerState.__new__(_TrackerState)

        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["compress_type"] = compress_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_tracker"] = delete_tracker
        __props__.__dict__["detail"] = detail
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["exclude_services"] = exclude_services
        __props__.__dict__["file_prefix"] = file_prefix
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["is_authorized_bucket"] = is_authorized_bucket
        __props__.__dict__["is_sort_by_service"] = is_sort_by_service
        __props__.__dict__["kms_id"] = kms_id
        __props__.__dict__["log_group_name"] = log_group_name
        __props__.__dict__["log_topic_name"] = log_topic_name
        __props__.__dict__["lts_enabled"] = lts_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_enabled"] = organization_enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["stream_id"] = stream_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transfer_enabled"] = transfer_enabled
        __props__.__dict__["type"] = type
        __props__.__dict__["validate_file"] = validate_file
        return Tracker(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the OBS bucket to which traces will be transferred.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="compressType")
    def compress_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "compress_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteTracker")
    def delete_tracker(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "delete_tracker")

    @_builtins.property
    @pulumi.getter
    def detail(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "detail")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether tracker is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="excludeServices")
    def exclude_services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "exclude_services")

    @_builtins.property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file name prefix to mark trace files that need to be stored
        in an OBS bucket. The value contains 0 to 64 characters. Only letters, numbers, hyphens (-), underscores (_),
        and periods (.) are allowed.
        """
        return pulumi.get(self, "file_prefix")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="isAuthorizedBucket")
    def is_authorized_bucket(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_authorized_bucket")

    @_builtins.property
    @pulumi.getter(name="isSortByService")
    def is_sort_by_service(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "is_sort_by_service")

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of KMS key used for trace file encryption.
        """
        return pulumi.get(self, "kms_id")

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "log_group_name")

    @_builtins.property
    @pulumi.getter(name="logTopicName")
    def log_topic_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "log_topic_name")

    @_builtins.property
    @pulumi.getter(name="ltsEnabled")
    def lts_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether trace analysis is enabled.
        """
        return pulumi.get(self, "lts_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The tracker name, only **system** is available.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationEnabled")
    def organization_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "organization_enabled")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to manage the CTS system tracker resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The tracker status, the value can be **enabled**, **disabled** or **error**.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "stream_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transferEnabled")
    def transfer_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether traces will be transferred.
        """
        return pulumi.get(self, "transfer_enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The tracker type, only **system** is available.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validateFile")
    def validate_file(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether trace file verification is enabled during trace transfer.
        """
        return pulumi.get(self, "validate_file")

