# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, cache_mode=None, capacity=None, cpu_architecture=None, engine=None, engine_version=None, flavors=None, id=None, name=None, region=None):
        if cache_mode and not isinstance(cache_mode, str):
            raise TypeError("Expected argument 'cache_mode' to be a str")
        pulumi.set(__self__, "cache_mode", cache_mode)
        if capacity and not isinstance(capacity, float):
            raise TypeError("Expected argument 'capacity' to be a float")
        pulumi.set(__self__, "capacity", capacity)
        if cpu_architecture and not isinstance(cpu_architecture, str):
            raise TypeError("Expected argument 'cpu_architecture' to be a str")
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[_builtins.str]:
        """
        The mode of a cache instance.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.float]:
        """
        The total memory of the cache, in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[_builtins.str]:
        """
        The CPU architecture of cache instance. Value is *x86_64* or *aarch64*.
        """
        return pulumi.get(self, "cpu_architecture")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[_builtins.str]:
        """
        The engine of the cache instance. Value is *redis* or *memcached*.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        A list of DCS flavors.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The flavor name of the cache instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            cache_mode=self.cache_mode,
            capacity=self.capacity,
            cpu_architecture=self.cpu_architecture,
            engine=self.engine,
            engine_version=self.engine_version,
            flavors=self.flavors,
            id=self.id,
            name=self.name,
            region=self.region)


def get_flavors(cache_mode: Optional[_builtins.str] = None,
                capacity: Optional[_builtins.float] = None,
                cpu_architecture: Optional[_builtins.str] = None,
                engine: Optional[_builtins.str] = None,
                engine_version: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get a list of available DCS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Dcs.get_flavors(capacity=4)
    ```


    :param _builtins.str cache_mode: The mode of a cache engine. The valid values are as follows:
    :param _builtins.float capacity: The total memory of the cache, in GB.
           + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
           `1`, `2`, `4`, `8`, `16`, `32` and `64`.
           Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
           `1024`.
           + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
           Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
           + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
    :param _builtins.str cpu_architecture: The CPU architecture of cache instance.
           Valid values *x86_64* and *aarch64*.
    :param _builtins.str engine: The engine of the cache instance. Valid values are *Redis* and *Memcached*.
           Default value is *Redis*.
    :param _builtins.str engine_version: The version of a cache engine.
           It is mandatory when the engine is *Redis*, the value can be `3.0`, `4.0`, or `5.0`.
    :param _builtins.str name: The flavor name of the cache instance.
    :param _builtins.str region: Specifies the region in which to obtain the DCS flavors.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['cacheMode'] = cache_mode
    __args__['capacity'] = capacity
    __args__['cpuArchitecture'] = cpu_architecture
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dcs/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        cache_mode=pulumi.get(__ret__, 'cache_mode'),
        capacity=pulumi.get(__ret__, 'capacity'),
        cpu_architecture=pulumi.get(__ret__, 'cpu_architecture'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_flavors_output(cache_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       capacity: Optional[pulumi.Input[Optional[_builtins.float]]] = None,
                       cpu_architecture: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       engine: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       engine_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get a list of available DCS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Dcs.get_flavors(capacity=4)
    ```


    :param _builtins.str cache_mode: The mode of a cache engine. The valid values are as follows:
    :param _builtins.float capacity: The total memory of the cache, in GB.
           + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
           `1`, `2`, `4`, `8`, `16`, `32` and `64`.
           Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
           `1024`.
           + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
           Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
           + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
    :param _builtins.str cpu_architecture: The CPU architecture of cache instance.
           Valid values *x86_64* and *aarch64*.
    :param _builtins.str engine: The engine of the cache instance. Valid values are *Redis* and *Memcached*.
           Default value is *Redis*.
    :param _builtins.str engine_version: The version of a cache engine.
           It is mandatory when the engine is *Redis*, the value can be `3.0`, `4.0`, or `5.0`.
    :param _builtins.str name: The flavor name of the cache instance.
    :param _builtins.str region: Specifies the region in which to obtain the DCS flavors.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['cacheMode'] = cache_mode
    __args__['capacity'] = capacity
    __args__['cpuArchitecture'] = cpu_architecture
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dcs/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        cache_mode=pulumi.get(__response__, 'cache_mode'),
        capacity=pulumi.get(__response__, 'capacity'),
        cpu_architecture=pulumi.get(__response__, 'cpu_architecture'),
        engine=pulumi.get(__response__, 'engine'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
