# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.float],
                 engine: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 backup_policy: Optional[pulumi.Input['InstanceBackupPolicyArgs']] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 begin_at: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 save_days: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
               `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
               `384`, `512`, `768` and `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[_builtins.str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBackupPolicyArgs'] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
               
               > **NOTE:** This parameter is not supported when the instance type is single.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] deleted_nodes: Specifies the ID of the replica to delete. This parameter is mandatory when
               you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
               at a time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dcs instance.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `dcs_get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[_builtins.str] maintain_begin: Time at which the maintenance time window starts. Defaults to **02:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The start time must be on the hour, such as **18:00:00**.
               + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
               In this case, the system automatically allocates the default start time **02:00:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Time at which the maintenance time window ends. Defaults to **06:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
               **19:00:00**.
               + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time **06:00:00**.
               
               > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        :param pulumi.Input[_builtins.str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Specify an array of one or more parameters to be set to the DCS instance after
               launched. You can check on console to see which parameters supported.
               The parameters structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of a DCS instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[_builtins.str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ips: Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
               parameter is not set, the system randomly deletes unnecessary shards.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL. Value options: **true**, **false**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[_builtins.str] template_id: The Parameter Template ID.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""Deprecated, please use `availability_zones` instead""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: Deprecated, please use `availability_zones` instead""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if backup_ats is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_ats is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_ats is not None:
            pulumi.set(__self__, "backup_ats", backup_ats)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backup_type is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_type is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if begin_at is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""begin_at is deprecated: Deprecated, please use `backup_policy` instead""")
        if begin_at is not None:
            pulumi.set(__self__, "begin_at", begin_at)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if deleted_nodes is not None:
            pulumi.set(__self__, "deleted_nodes", deleted_nodes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if enterprise_project_name is not None:
            warnings.warn("""Deprecated, this is a non-public attribute.""", DeprecationWarning)
            pulumi.log.warn("""enterprise_project_name is deprecated: Deprecated, this is a non-public attribute.""")
        if enterprise_project_name is not None:
            pulumi.set(__self__, "enterprise_project_name", enterprise_project_name)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            warnings.warn("""Please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""period_type is deprecated: Please use `backup_policy` instead""")
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_id is not None:
            warnings.warn("""Deprecated, please use `flavor` instead""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: Deprecated, please use `flavor` instead""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rename_commands is not None:
            pulumi.set(__self__, "rename_commands", rename_commands)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if save_days is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""save_days is deprecated: Deprecated, please use `backup_policy` instead""")
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if whitelist_enable is not None:
            pulumi.set(__self__, "whitelist_enable", whitelist_enable)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.float]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
        `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
        `384`, `512`, `768` and `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""Deprecated, please use `availability_zones` instead""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="backupAts")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_ats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "backup_ats")

    @backup_ats.setter
    def backup_ats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "backup_ats", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['InstanceBackupPolicyArgs']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.

        > **NOTE:** This parameter is not supported when the instance type is single.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['InstanceBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="beginAt")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def begin_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "begin_at")

    @begin_at.setter
    def begin_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "begin_at", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="deletedNodes")
    def deleted_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the replica to delete. This parameter is mandatory when
        you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
        at a time.
        """
        return pulumi.get(self, "deleted_nodes")

    @deleted_nodes.setter
    def deleted_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deleted_nodes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the dcs instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectName")
    @_utilities.deprecated("""Deprecated, this is a non-public attribute.""")
    def enterprise_project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_name")

    @enterprise_project_name.setter
    def enterprise_project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_name", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `dcs_get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the maintenance time window starts. Defaults to **02:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The start time must be on the hour, such as **18:00:00**.
        + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
        In this case, the system automatically allocates the default start time **02:00:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the maintenance time window ends. Defaults to **06:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
        **19:00:00**.
        + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time **06:00:00**.

        > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Specify an array of one or more parameters to be set to the DCS instance after
        launched. You can check on console to see which parameters supported.
        The parameters structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of a DCS instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodType")
    @_utilities.deprecated("""Please use `backup_policy` instead""")
    def period_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_type", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""Deprecated, please use `flavor` instead""")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        """
        return pulumi.get(self, "rename_commands")

    @rename_commands.setter
    def rename_commands(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rename_commands", value)

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
        parameter is not set, the system randomly deletes unnecessary shards.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reserved_ips", value)

    @_builtins.property
    @pulumi.getter(name="saveDays")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def save_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "save_days")

    @save_days.setter
    def save_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "save_days", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the SSL. Value options: **true**, **false**.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Parameter Template ID.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @whitelist_enable.setter
    def whitelist_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "whitelist_enable", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 backup_policy: Optional[pulumi.Input['InstanceBackupPolicyArgs']] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBandwidthInfoArgs']]]] = None,
                 begin_at: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 launched_at: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 max_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 order_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_type: Optional[pulumi.Input[_builtins.str]] = None,
                 readonly_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 save_days: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sharding_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transparent_client_ip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 used_memory: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBackupPolicyArgs'] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
               
               > **NOTE:** This parameter is not supported when the instance type is single.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBandwidthInfoArgs']]] bandwidth_infos: Indicates the bandwidth information of the instance.
               The bandwidth_info structure is documented below.
        :param pulumi.Input[_builtins.str] cache_mode: Indicates the instance type. The value can be **single**, **ha**, **cluster** or **proxy**.
        :param pulumi.Input[_builtins.float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
               `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
               `384`, `512`, `768` and `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] cpu_type: Indicates the CPU type of the instance. The value can be **x86_64** or **aarch64**.
        :param pulumi.Input[_builtins.str] created_at: Indicates the time when the instance is created, in RFC3339 format.
        :param pulumi.Input[_builtins.str] deleted_nodes: Specifies the ID of the replica to delete. This parameter is mandatory when
               you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
               at a time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[_builtins.str] domain_name: Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        :param pulumi.Input[_builtins.str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dcs instance.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `dcs_get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[_builtins.str] launched_at: Indicates the time when the instance is started, in RFC3339 format.
        :param pulumi.Input[_builtins.str] maintain_begin: Time at which the maintenance time window starts. Defaults to **02:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The start time must be on the hour, such as **18:00:00**.
               + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
               In this case, the system automatically allocates the default start time **02:00:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Time at which the maintenance time window ends. Defaults to **06:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
               **19:00:00**.
               + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time **06:00:00**.
               
               > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        :param pulumi.Input[_builtins.int] max_memory: Total memory size. Unit: MB.
        :param pulumi.Input[_builtins.str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] order_id: The ID of the order that created the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Specify an array of one or more parameters to be set to the DCS instance after
               launched. You can check on console to see which parameters supported.
               The parameters structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of a DCS instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[_builtins.str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] product_type: Indicates the product type of the instance. The value can be: **generic** or **enterprise**.
        :param pulumi.Input[_builtins.str] readonly_domain_name: Indicates the read-only domain name of the instance. This parameter is available
               only for master/standby instances.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        :param pulumi.Input[_builtins.int] replica_count: Indicates the number of replicas in the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ips: Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
               parameter is not set, the system randomly deletes unnecessary shards.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[_builtins.str] security_group_name: The name of security group which the instance belongs to.
        :param pulumi.Input[_builtins.int] sharding_count: Indicates the number of shards in a cluster instance.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL. Value options: **true**, **false**.
        :param pulumi.Input[_builtins.str] status: Cache instance status. The valid values are as follows:
               + `RUNNING`: The instance is running properly.
               Only instances in the Running state can provide in-memory cache service.
               + `ERROR`: The instance is not running properly.
               + `RESTARTING`: The instance is being restarted.
               + `FROZEN`: The instance has been frozen due to low balance.
               You can unfreeze the instance by recharging your account in My Order.
               + `EXTENDING`: The instance is being scaled up.
               + `RESTORING`: The instance data is being restored.
               + `FLUSHING`: The DCS instance is being cleared.
        :param pulumi.Input[_builtins.str] subnet_cidr: Indicates the subnet segment.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] subnet_name: The name of subnet which the instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[_builtins.str] template_id: The Parameter Template ID.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] transparent_client_ip_enable: Indicates whether client IP pass-through is enabled.
        :param pulumi.Input[_builtins.int] used_memory: Size of the used memory. Unit: MB.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_name: The name of VPC which the instance belongs to.
        :param pulumi.Input[_builtins.bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""Deprecated, please use `availability_zones` instead""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: Deprecated, please use `availability_zones` instead""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if backup_ats is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_ats is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_ats is not None:
            pulumi.set(__self__, "backup_ats", backup_ats)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backup_type is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_type is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if bandwidth_infos is not None:
            pulumi.set(__self__, "bandwidth_infos", bandwidth_infos)
        if begin_at is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""begin_at is deprecated: Deprecated, please use `backup_policy` instead""")
        if begin_at is not None:
            pulumi.set(__self__, "begin_at", begin_at)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cpu_type is not None:
            pulumi.set(__self__, "cpu_type", cpu_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deleted_nodes is not None:
            pulumi.set(__self__, "deleted_nodes", deleted_nodes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if enterprise_project_name is not None:
            warnings.warn("""Deprecated, this is a non-public attribute.""", DeprecationWarning)
            pulumi.log.warn("""enterprise_project_name is deprecated: Deprecated, this is a non-public attribute.""")
        if enterprise_project_name is not None:
            pulumi.set(__self__, "enterprise_project_name", enterprise_project_name)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if internal_version is not None:
            warnings.warn("""Deprecated, please us `engine_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""internal_version is deprecated: Deprecated, please us `engine_version` instead.""")
        if internal_version is not None:
            pulumi.set(__self__, "internal_version", internal_version)
        if ip is not None:
            warnings.warn("""Deprecated, please us `private_ip` instead.""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Deprecated, please us `private_ip` instead.""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if launched_at is not None:
            pulumi.set(__self__, "launched_at", launched_at)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if max_memory is not None:
            pulumi.set(__self__, "max_memory", max_memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            warnings.warn("""Please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""period_type is deprecated: Please use `backup_policy` instead""")
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_id is not None:
            warnings.warn("""Deprecated, please use `flavor` instead""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: Deprecated, please use `flavor` instead""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_type is not None:
            pulumi.set(__self__, "product_type", product_type)
        if readonly_domain_name is not None:
            pulumi.set(__self__, "readonly_domain_name", readonly_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rename_commands is not None:
            pulumi.set(__self__, "rename_commands", rename_commands)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if save_days is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""save_days is deprecated: Deprecated, please use `backup_policy` instead""")
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if sharding_count is not None:
            pulumi.set(__self__, "sharding_count", sharding_count)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if transparent_client_ip_enable is not None:
            pulumi.set(__self__, "transparent_client_ip_enable", transparent_client_ip_enable)
        if used_memory is not None:
            pulumi.set(__self__, "used_memory", used_memory)
        if user_id is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""user_id is deprecated: Deprecated""")
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""user_name is deprecated: Deprecated""")
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if whitelist_enable is not None:
            pulumi.set(__self__, "whitelist_enable", whitelist_enable)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""Deprecated, please use `availability_zones` instead""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="backupAts")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_ats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "backup_ats")

    @backup_ats.setter
    def backup_ats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "backup_ats", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['InstanceBackupPolicyArgs']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.

        > **NOTE:** This parameter is not supported when the instance type is single.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['InstanceBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthInfos")
    def bandwidth_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBandwidthInfoArgs']]]]:
        """
        Indicates the bandwidth information of the instance.
        The bandwidth_info structure is documented below.
        """
        return pulumi.get(self, "bandwidth_infos")

    @bandwidth_infos.setter
    def bandwidth_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBandwidthInfoArgs']]]]):
        pulumi.set(self, "bandwidth_infos", value)

    @_builtins.property
    @pulumi.getter(name="beginAt")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def begin_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "begin_at")

    @begin_at.setter
    def begin_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "begin_at", value)

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the instance type. The value can be **single**, **ha**, **cluster** or **proxy**.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_mode", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
        `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
        `384`, `512`, `768` and `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="cpuType")
    def cpu_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the CPU type of the instance. The value can be **x86_64** or **aarch64**.
        """
        return pulumi.get(self, "cpu_type")

    @cpu_type.setter
    def cpu_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_type", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time when the instance is created, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletedNodes")
    def deleted_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the replica to delete. This parameter is mandatory when
        you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
        at a time.
        """
        return pulumi.get(self, "deleted_nodes")

    @deleted_nodes.setter
    def deleted_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deleted_nodes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the dcs instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectName")
    @_utilities.deprecated("""Deprecated, this is a non-public attribute.""")
    def enterprise_project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_name")

    @enterprise_project_name.setter
    def enterprise_project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_name", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `dcs_get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="internalVersion")
    @_utilities.deprecated("""Deprecated, please us `engine_version` instead.""")
    def internal_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "internal_version")

    @internal_version.setter
    def internal_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_version", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated, please us `private_ip` instead.""")
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="launchedAt")
    def launched_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time when the instance is started, in RFC3339 format.
        """
        return pulumi.get(self, "launched_at")

    @launched_at.setter
    def launched_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launched_at", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the maintenance time window starts. Defaults to **02:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The start time must be on the hour, such as **18:00:00**.
        + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
        In this case, the system automatically allocates the default start time **02:00:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the maintenance time window ends. Defaults to **06:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
        **19:00:00**.
        + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time **06:00:00**.

        > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="maxMemory")
    def max_memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total memory size. Unit: MB.
        """
        return pulumi.get(self, "max_memory")

    @max_memory.setter
    def max_memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_memory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the order that created the instance.
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "order_id", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Specify an array of one or more parameters to be set to the DCS instance after
        launched. You can check on console to see which parameters supported.
        The parameters structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of a DCS instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodType")
    @_utilities.deprecated("""Please use `backup_policy` instead""")
    def period_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_type", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""Deprecated, please use `flavor` instead""")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the product type of the instance. The value can be: **generic** or **enterprise**.
        """
        return pulumi.get(self, "product_type")

    @product_type.setter
    def product_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_type", value)

    @_builtins.property
    @pulumi.getter(name="readonlyDomainName")
    def readonly_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the read-only domain name of the instance. This parameter is available
        only for master/standby instances.
        """
        return pulumi.get(self, "readonly_domain_name")

    @readonly_domain_name.setter
    def readonly_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "readonly_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        """
        return pulumi.get(self, "rename_commands")

    @rename_commands.setter
    def rename_commands(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rename_commands", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the number of replicas in the instance.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
        parameter is not set, the system randomly deletes unnecessary shards.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "reserved_ips", value)

    @_builtins.property
    @pulumi.getter(name="saveDays")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def save_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "save_days")

    @save_days.setter
    def save_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "save_days", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of security group which the instance belongs to.
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_name", value)

    @_builtins.property
    @pulumi.getter(name="shardingCount")
    def sharding_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the number of shards in a cluster instance.
        """
        return pulumi.get(self, "sharding_count")

    @sharding_count.setter
    def sharding_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sharding_count", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the SSL. Value options: **true**, **false**.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache instance status. The valid values are as follows:
        + `RUNNING`: The instance is running properly.
        Only instances in the Running state can provide in-memory cache service.
        + `ERROR`: The instance is not running properly.
        + `RESTARTING`: The instance is being restarted.
        + `FROZEN`: The instance has been frozen due to low balance.
        You can unfreeze the instance by recharging your account in My Order.
        + `EXTENDING`: The instance is being scaled up.
        + `RESTORING`: The instance data is being restored.
        + `FLUSHING`: The DCS instance is being cleared.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the subnet segment.
        """
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of subnet which the instance belongs to.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Parameter Template ID.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="transparentClientIpEnable")
    def transparent_client_ip_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether client IP pass-through is enabled.
        """
        return pulumi.get(self, "transparent_client_ip_enable")

    @transparent_client_ip_enable.setter
    def transparent_client_ip_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transparent_client_ip_enable", value)

    @_builtins.property
    @pulumi.getter(name="usedMemory")
    def used_memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the used memory. Unit: MB.
        """
        return pulumi.get(self, "used_memory")

    @used_memory.setter
    def used_memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_memory", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    @_utilities.deprecated("""Deprecated""")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    @_utilities.deprecated("""Deprecated""")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of VPC which the instance belongs to.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_name", value)

    @_builtins.property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @whitelist_enable.setter
    def whitelist_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "whitelist_enable", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.type_token("sbercloud:Dcs/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 backup_policy: Optional[pulumi.Input[Union['InstanceBackupPolicyArgs', 'InstanceBackupPolicyArgsDict']]] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 begin_at: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 save_days: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceWhitelistArgs', 'InstanceWhitelistArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a DCS instance within SberCloud.

        !> **WARNING:** DCS for Memcached is about to become unavailable and is no longer sold in some regions.
        You can use DCS for Redis 4.0, 5.0 or 6.0 instead. It is not possible to create Memcached instances through this resource.
        You can use this resource to manage Memcached instances that exist in SberCloud.

        ## Example Usage

        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        single_flavors = sbercloud.Dcs.get_flavors(cache_mode="single",
            capacity=0.125)
        instance1 = sbercloud.dcs.Instance("instance_1",
            name="redis_single_instance",
            engine="Redis",
            engine_version="5.0",
            capacity=single_flavors.capacity,
            flavor=single_flavors.flavors[0].name,
            availability_zones=["ru-moscow-1a"],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id)
        ```

        ### Create Master/Standby mode Redis instances with backup policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        instance2 = sbercloud.dcs.Instance("instance_2",
            name="redis_name",
            engine="Redis",
            engine_version="5.0",
            capacity=4,
            flavor="redis.ha.xu1.large.r2.4",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            charging_mode="prePaid",
            period_unit="month",
            auto_renew="true",
            period=1,
            backup_policy={
                "backup_type": "auto",
                "save_days": 3,
                "backup_ats": [
                    1,
                    3,
                    5,
                    7,
                ],
                "begin_at": "02:00-04:00",
            },
            whitelists=[
                {
                    "group_name": "test-group1",
                    "ip_addresses": [
                        "192.168.10.100",
                        "192.168.0.0/24",
                    ],
                },
                {
                    "group_name": "test-group2",
                    "ip_addresses": [
                        "172.16.10.100",
                        "172.16.0.0/24",
                    ],
                },
            ],
            parameters=[
                {
                    "id": "1",
                    "name": "timeout",
                    "value": "500",
                },
                {
                    "id": "3",
                    "name": "hash-max-ziplist-entries",
                    "value": "4096",
                },
            ])
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Dcs/instance:Instance instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `auto_renew`, `period`, `period_unit`, `rename_commands`,

        `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`, `parameters`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dcs_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, rename_commands,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceBackupPolicyArgs', 'InstanceBackupPolicyArgsDict']] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
               
               > **NOTE:** This parameter is not supported when the instance type is single.
        :param pulumi.Input[_builtins.float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
               `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
               `384`, `512`, `768` and `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] deleted_nodes: Specifies the ID of the replica to delete. This parameter is mandatory when
               you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
               at a time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[_builtins.str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dcs instance.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `dcs_get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[_builtins.str] maintain_begin: Time at which the maintenance time window starts. Defaults to **02:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The start time must be on the hour, such as **18:00:00**.
               + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
               In this case, the system automatically allocates the default start time **02:00:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Time at which the maintenance time window ends. Defaults to **06:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
               **19:00:00**.
               + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time **06:00:00**.
               
               > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        :param pulumi.Input[_builtins.str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Specify an array of one or more parameters to be set to the DCS instance after
               launched. You can check on console to see which parameters supported.
               The parameters structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of a DCS instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[_builtins.str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ips: Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
               parameter is not set, the system randomly deletes unnecessary shards.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL. Value options: **true**, **false**.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[_builtins.str] template_id: The Parameter Template ID.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceWhitelistArgs', 'InstanceWhitelistArgsDict']]]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DCS instance within SberCloud.

        !> **WARNING:** DCS for Memcached is about to become unavailable and is no longer sold in some regions.
        You can use DCS for Redis 4.0, 5.0 or 6.0 instead. It is not possible to create Memcached instances through this resource.
        You can use this resource to manage Memcached instances that exist in SberCloud.

        ## Example Usage

        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        single_flavors = sbercloud.Dcs.get_flavors(cache_mode="single",
            capacity=0.125)
        instance1 = sbercloud.dcs.Instance("instance_1",
            name="redis_single_instance",
            engine="Redis",
            engine_version="5.0",
            capacity=single_flavors.capacity,
            flavor=single_flavors.flavors[0].name,
            availability_zones=["ru-moscow-1a"],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id)
        ```

        ### Create Master/Standby mode Redis instances with backup policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        instance2 = sbercloud.dcs.Instance("instance_2",
            name="redis_name",
            engine="Redis",
            engine_version="5.0",
            capacity=4,
            flavor="redis.ha.xu1.large.r2.4",
            availability_zones=[
                "ru-moscow-1a",
                "ru-moscow-1b",
            ],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            charging_mode="prePaid",
            period_unit="month",
            auto_renew="true",
            period=1,
            backup_policy={
                "backup_type": "auto",
                "save_days": 3,
                "backup_ats": [
                    1,
                    3,
                    5,
                    7,
                ],
                "begin_at": "02:00-04:00",
            },
            whitelists=[
                {
                    "group_name": "test-group1",
                    "ip_addresses": [
                        "192.168.10.100",
                        "192.168.0.0/24",
                    ],
                },
                {
                    "group_name": "test-group2",
                    "ip_addresses": [
                        "172.16.10.100",
                        "172.16.0.0/24",
                    ],
                },
            ],
            parameters=[
                {
                    "id": "1",
                    "name": "timeout",
                    "value": "500",
                },
                {
                    "id": "3",
                    "name": "hash-max-ziplist-entries",
                    "value": "4096",
                },
            ])
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Dcs/instance:Instance instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `auto_renew`, `period`, `period_unit`, `rename_commands`,

        `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`, `parameters`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dcs_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, rename_commands,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 backup_policy: Optional[pulumi.Input[Union['InstanceBackupPolicyArgs', 'InstanceBackupPolicyArgsDict']]] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 begin_at: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 save_days: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceWhitelistArgs', 'InstanceWhitelistArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["backup_ats"] = backup_ats
            __props__.__dict__["backup_policy"] = backup_policy
            __props__.__dict__["backup_type"] = backup_type
            __props__.__dict__["begin_at"] = begin_at
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["deleted_nodes"] = deleted_nodes
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["enterprise_project_name"] = enterprise_project_name
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_type"] = period_type
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["region"] = region
            __props__.__dict__["rename_commands"] = rename_commands
            __props__.__dict__["reserved_ips"] = reserved_ips
            __props__.__dict__["save_days"] = save_days
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_id"] = template_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["whitelist_enable"] = whitelist_enable
            __props__.__dict__["whitelists"] = whitelists
            __props__.__dict__["bandwidth_infos"] = None
            __props__.__dict__["cache_mode"] = None
            __props__.__dict__["cpu_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["internal_version"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["launched_at"] = None
            __props__.__dict__["max_memory"] = None
            __props__.__dict__["order_id"] = None
            __props__.__dict__["product_type"] = None
            __props__.__dict__["readonly_domain_name"] = None
            __props__.__dict__["replica_count"] = None
            __props__.__dict__["security_group_name"] = None
            __props__.__dict__["sharding_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_cidr"] = None
            __props__.__dict__["subnet_name"] = None
            __props__.__dict__["transparent_client_ip_enable"] = None
            __props__.__dict__["used_memory"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
            __props__.__dict__["vpc_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'sbercloud:Dcs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            backup_policy: Optional[pulumi.Input[Union['InstanceBackupPolicyArgs', 'InstanceBackupPolicyArgsDict']]] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBandwidthInfoArgs', 'InstanceBandwidthInfoArgsDict']]]]] = None,
            begin_at: Optional[pulumi.Input[_builtins.str]] = None,
            cache_mode: Optional[pulumi.Input[_builtins.str]] = None,
            capacity: Optional[pulumi.Input[_builtins.float]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deleted_nodes: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_name: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            internal_version: Optional[pulumi.Input[_builtins.str]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            launched_at: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            max_memory: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            order_id: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_type: Optional[pulumi.Input[_builtins.str]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_type: Optional[pulumi.Input[_builtins.str]] = None,
            readonly_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            save_days: Optional[pulumi.Input[_builtins.int]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sharding_count: Optional[pulumi.Input[_builtins.int]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None,
            transparent_client_ip_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            used_memory: Optional[pulumi.Input[_builtins.int]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_name: Optional[pulumi.Input[_builtins.str]] = None,
            whitelist_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceWhitelistArgs', 'InstanceWhitelistArgsDict']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceBackupPolicyArgs', 'InstanceBackupPolicyArgsDict']] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
               
               > **NOTE:** This parameter is not supported when the instance type is single.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBandwidthInfoArgs', 'InstanceBandwidthInfoArgsDict']]]] bandwidth_infos: Indicates the bandwidth information of the instance.
               The bandwidth_info structure is documented below.
        :param pulumi.Input[_builtins.str] cache_mode: Indicates the instance type. The value can be **single**, **ha**, **cluster** or **proxy**.
        :param pulumi.Input[_builtins.float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
               `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
               `384`, `512`, `768` and `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] cpu_type: Indicates the CPU type of the instance. The value can be **x86_64** or **aarch64**.
        :param pulumi.Input[_builtins.str] created_at: Indicates the time when the instance is created, in RFC3339 format.
        :param pulumi.Input[_builtins.str] deleted_nodes: Specifies the ID of the replica to delete. This parameter is mandatory when
               you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
               at a time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[_builtins.str] domain_name: Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        :param pulumi.Input[_builtins.str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dcs instance.
        :param pulumi.Input[_builtins.str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `dcs_get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[_builtins.str] launched_at: Indicates the time when the instance is started, in RFC3339 format.
        :param pulumi.Input[_builtins.str] maintain_begin: Time at which the maintenance time window starts. Defaults to **02:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The start time must be on the hour, such as **18:00:00**.
               + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
               In this case, the system automatically allocates the default start time **02:00:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Time at which the maintenance time window ends. Defaults to **06:00:00**.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
               **19:00:00**.
               + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time **06:00:00**.
               
               > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        :param pulumi.Input[_builtins.int] max_memory: Total memory size. Unit: MB.
        :param pulumi.Input[_builtins.str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] order_id: The ID of the order that created the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Specify an array of one or more parameters to be set to the DCS instance after
               launched. You can check on console to see which parameters supported.
               The parameters structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the password of a DCS instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[_builtins.str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] product_type: Indicates the product type of the instance. The value can be: **generic** or **enterprise**.
        :param pulumi.Input[_builtins.str] readonly_domain_name: Indicates the read-only domain name of the instance. This parameter is available
               only for master/standby instances.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        :param pulumi.Input[_builtins.int] replica_count: Indicates the number of replicas in the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] reserved_ips: Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
               parameter is not set, the system randomly deletes unnecessary shards.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[_builtins.str] security_group_name: The name of security group which the instance belongs to.
        :param pulumi.Input[_builtins.int] sharding_count: Indicates the number of shards in a cluster instance.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL. Value options: **true**, **false**.
        :param pulumi.Input[_builtins.str] status: Cache instance status. The valid values are as follows:
               + `RUNNING`: The instance is running properly.
               Only instances in the Running state can provide in-memory cache service.
               + `ERROR`: The instance is not running properly.
               + `RESTARTING`: The instance is being restarted.
               + `FROZEN`: The instance has been frozen due to low balance.
               You can unfreeze the instance by recharging your account in My Order.
               + `EXTENDING`: The instance is being scaled up.
               + `RESTORING`: The instance data is being restored.
               + `FLUSHING`: The DCS instance is being cleared.
        :param pulumi.Input[_builtins.str] subnet_cidr: Indicates the subnet segment.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] subnet_name: The name of subnet which the instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[_builtins.str] template_id: The Parameter Template ID.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] transparent_client_ip_enable: Indicates whether client IP pass-through is enabled.
        :param pulumi.Input[_builtins.int] used_memory: Size of the used memory. Unit: MB.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_name: The name of VPC which the instance belongs to.
        :param pulumi.Input[_builtins.bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceWhitelistArgs', 'InstanceWhitelistArgsDict']]]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["backup_ats"] = backup_ats
        __props__.__dict__["backup_policy"] = backup_policy
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["bandwidth_infos"] = bandwidth_infos
        __props__.__dict__["begin_at"] = begin_at
        __props__.__dict__["cache_mode"] = cache_mode
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cpu_type"] = cpu_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deleted_nodes"] = deleted_nodes
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["enterprise_project_name"] = enterprise_project_name
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["internal_version"] = internal_version
        __props__.__dict__["ip"] = ip
        __props__.__dict__["launched_at"] = launched_at
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["max_memory"] = max_memory
        __props__.__dict__["name"] = name
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_type"] = period_type
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["product_type"] = product_type
        __props__.__dict__["readonly_domain_name"] = readonly_domain_name
        __props__.__dict__["region"] = region
        __props__.__dict__["rename_commands"] = rename_commands
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["reserved_ips"] = reserved_ips
        __props__.__dict__["save_days"] = save_days
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_name"] = security_group_name
        __props__.__dict__["sharding_count"] = sharding_count
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_cidr"] = subnet_cidr
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subnet_name"] = subnet_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["transparent_client_ip_enable"] = transparent_client_ip_enable
        __props__.__dict__["used_memory"] = used_memory
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_name"] = vpc_name
        __props__.__dict__["whitelist_enable"] = whitelist_enable
        __props__.__dict__["whitelists"] = whitelists
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""Deprecated, please use `availability_zones` instead""")
    def available_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter(name="backupAts")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_ats(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        return pulumi.get(self, "backup_ats")

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> pulumi.Output[Optional['outputs.InstanceBackupPolicy']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.

        > **NOTE:** This parameter is not supported when the instance type is single.
        """
        return pulumi.get(self, "backup_policy")

    @_builtins.property
    @pulumi.getter(name="backupType")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def backup_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthInfos")
    def bandwidth_infos(self) -> pulumi.Output[Sequence['outputs.InstanceBandwidthInfo']]:
        """
        Indicates the bandwidth information of the instance.
        The bandwidth_info structure is documented below.
        """
        return pulumi.get(self, "bandwidth_infos")

    @_builtins.property
    @pulumi.getter(name="beginAt")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def begin_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "begin_at")

    @_builtins.property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the instance type. The value can be **single**, **ha**, **cluster** or **proxy**.
        """
        return pulumi.get(self, "cache_mode")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.float]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0, Redis5.0 and Redis6.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`,
        `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `4`,`8`,`16`, `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`,
        `384`, `512`, `768` and `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="cpuType")
    def cpu_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the CPU type of the instance. The value can be **x86_64** or **aarch64**.
        """
        return pulumi.get(self, "cpu_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time when the instance is created, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletedNodes")
    def deleted_nodes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the replica to delete. This parameter is mandatory when
        you delete replicas of a master/standby DCS Redis 4.0 or 5.0 instance. Currently, only one replica can be deleted
        at a time.
        """
        return pulumi.get(self, "deleted_nodes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, 5.0 or 6.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the dcs instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectName")
    @_utilities.deprecated("""Deprecated, this is a non-public attribute.""")
    def enterprise_project_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_name")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `dcs_get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.hc.sbercloud.ru/usermanual/dcs/en-us_topic_0054235835.html) + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="internalVersion")
    @_utilities.deprecated("""Deprecated, please us `engine_version` instead.""")
    def internal_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "internal_version")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated, please us `private_ip` instead.""")
    def ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="launchedAt")
    def launched_at(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time when the instance is started, in RFC3339 format.
        """
        return pulumi.get(self, "launched_at")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the maintenance time window starts. Defaults to **02:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The start time must be on the hour, such as **18:00:00**.
        + If parameter `maintain_begin` is left blank, parameter `maintain_end` is also blank.
        In this case, the system automatically allocates the default start time **02:00:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the maintenance time window ends. Defaults to **06:00:00**.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is one hour later than the start time. For example, if the start time is **18:00:00**, the end time is
        **19:00:00**.
        + If parameter `maintain_end` is left blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time **06:00:00**.

        > **NOTE:** Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter(name="maxMemory")
    def max_memory(self) -> pulumi.Output[_builtins.int]:
        """
        Total memory size. Unit: MB.
        """
        return pulumi.get(self, "max_memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only english, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the order that created the instance.
        """
        return pulumi.get(self, "order_id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.InstanceParameter']]:
        """
        Specify an array of one or more parameters to be set to the DCS instance after
        launched. You can check on console to see which parameters supported.
        The parameters structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password of a DCS instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodType")
    @_utilities.deprecated("""Please use `backup_policy` instead""")
    def period_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_type")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""Deprecated, please use `flavor` instead""")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the product type of the instance. The value can be: **generic** or **enterprise**.
        """
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="readonlyDomainName")
    def readonly_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the read-only domain name of the instance. This parameter is available
        only for master/standby instances.
        """
        return pulumi.get(self, "readonly_domain_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: **command**, **keys**, **flushdb**, **flushall** and **hgetall**.
        """
        return pulumi.get(self, "rename_commands")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the number of replicas in the instance.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies IP addresses to retain. Mandatory during cluster scale-in. If this
        parameter is not set, the system randomly deletes unnecessary shards.
        """
        return pulumi.get(self, "reserved_ips")

    @_builtins.property
    @pulumi.getter(name="saveDays")
    @_utilities.deprecated("""Deprecated, please use `backup_policy` instead""")
    def save_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "save_days")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of security group which the instance belongs to.
        """
        return pulumi.get(self, "security_group_name")

    @_builtins.property
    @pulumi.getter(name="shardingCount")
    def sharding_count(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the number of shards in a cluster instance.
        """
        return pulumi.get(self, "sharding_count")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the SSL. Value options: **true**, **false**.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Cache instance status. The valid values are as follows:
        + `RUNNING`: The instance is running properly.
        Only instances in the Running state can provide in-memory cache service.
        + `ERROR`: The instance is not running properly.
        + `RESTARTING`: The instance is being restarted.
        + `FROZEN`: The instance has been frozen due to low balance.
        You can unfreeze the instance by recharging your account in My Order.
        + `EXTENDING`: The instance is being scaled up.
        + `RESTORING`: The instance data is being restored.
        + `FLUSHING`: The DCS instance is being cleared.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the subnet segment.
        """
        return pulumi.get(self, "subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of subnet which the instance belongs to.
        """
        return pulumi.get(self, "subnet_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Parameter Template ID.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter(name="transparentClientIpEnable")
    def transparent_client_ip_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether client IP pass-through is enabled.
        """
        return pulumi.get(self, "transparent_client_ip_enable")

    @_builtins.property
    @pulumi.getter(name="usedMemory")
    def used_memory(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the used memory. Unit: MB.
        """
        return pulumi.get(self, "used_memory")

    @_builtins.property
    @pulumi.getter(name="userId")
    @_utilities.deprecated("""Deprecated""")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    @_utilities.deprecated("""Deprecated""")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of VPC which the instance belongs to.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceWhitelist']]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

