# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DcsAccountArgs', 'DcsAccount']

@pulumi.input_type
class DcsAccountArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 account_password: pulumi.Input[_builtins.str],
                 account_role: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DcsAccount resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the account.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] account_password: Specifies the password of the account.
        :param pulumi.Input[_builtins.str] account_role: Specifies the role of the account.
               Value options:
               + **read**: The account has read-only privilege.
               + **write**: The account has read and write privilege.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the account.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)
        pulumi.set(__self__, "account_role", account_role)
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the account.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of the account.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountRole")
    def account_role(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the role of the account.
        Value options:
        + **read**: The account has read-only privilege.
        + **write**: The account has read and write privilege.
        """
        return pulumi.get(self, "account_role")

    @account_role.setter
    def account_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_role", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the DCS instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DcsAccountState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_role: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DcsAccount resources.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the account.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] account_password: Specifies the password of the account.
        :param pulumi.Input[_builtins.str] account_role: Specifies the role of the account.
               Value options:
               + **read**: The account has read-only privilege.
               + **write**: The account has read and write privilege.
        :param pulumi.Input[_builtins.str] account_type: Indicates the type of the account. The value can be **normal** or **default**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the account.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the account. The value can be **CREATING**, **AVAILABLE**, **CREATEFAILED**,
               **DELETED**, **DELETEFAILED**, **DELETING**, **UPDATING** or **ERROR**.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_role is not None:
            pulumi.set(__self__, "account_role", account_role)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the account.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the account.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountRole")
    def account_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the role of the account.
        Value options:
        + **read**: The account has read-only privilege.
        + **write**: The account has read and write privilege.
        """
        return pulumi.get(self, "account_role")

    @account_role.setter
    def account_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_role", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the type of the account. The value can be **normal** or **default**.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the DCS instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the account. The value can be **CREATING**, **AVAILABLE**, **CREATEFAILED**,
        **DELETED**, **DELETEFAILED**, **DELETING**, **UPDATING** or **ERROR**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:index/dcsAccount:DcsAccount")
class DcsAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DCS account resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DcsAccount("test",
            instance_id=instance_id,
            account_name="user",
            account_role="read",
            account_password="Terraform@123",
            description="add account")
        ```

        ## Import

        The DCS account can be imported using the DCS instance ID and the DCS account ID separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsAccount:DcsAccount test <instance_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `account_password`.

        It is generally recommended running `pulumi preview` after importing the account.

        You can then decide if changes should be applied to the account, or the resource definition should be updated to

        align with the account. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dcs_account" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              account_password,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the account.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] account_password: Specifies the password of the account.
        :param pulumi.Input[_builtins.str] account_role: Specifies the role of the account.
               Value options:
               + **read**: The account has read-only privilege.
               + **write**: The account has read and write privilege.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the account.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DcsAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DCS account resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DcsAccount("test",
            instance_id=instance_id,
            account_name="user",
            account_role="read",
            account_password="Terraform@123",
            description="add account")
        ```

        ## Import

        The DCS account can be imported using the DCS instance ID and the DCS account ID separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsAccount:DcsAccount test <instance_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `account_password`.

        It is generally recommended running `pulumi preview` after importing the account.

        You can then decide if changes should be applied to the account, or the resource definition should be updated to

        align with the account. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dcs_account" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              account_password,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param DcsAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DcsAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DcsAccountArgs.__new__(DcsAccountArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if account_password is None and not opts.urn:
                raise TypeError("Missing required property 'account_password'")
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            if account_role is None and not opts.urn:
                raise TypeError("Missing required property 'account_role'")
            __props__.__dict__["account_role"] = account_role
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            __props__.__dict__["account_type"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DcsAccount, __self__).__init__(
            'sbercloud:index/dcsAccount:DcsAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_password: Optional[pulumi.Input[_builtins.str]] = None,
            account_role: Optional[pulumi.Input[_builtins.str]] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DcsAccount':
        """
        Get an existing DcsAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies the name of the account.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] account_password: Specifies the password of the account.
        :param pulumi.Input[_builtins.str] account_role: Specifies the role of the account.
               Value options:
               + **read**: The account has read-only privilege.
               + **write**: The account has read and write privilege.
        :param pulumi.Input[_builtins.str] account_type: Indicates the type of the account. The value can be **normal** or **default**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the account.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the account. The value can be **CREATING**, **AVAILABLE**, **CREATEFAILED**,
               **DELETED**, **DELETEFAILED**, **DELETING**, **UPDATING** or **ERROR**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DcsAccountState.__new__(_DcsAccountState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["account_role"] = account_role
        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return DcsAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the account.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the password of the account.
        """
        return pulumi.get(self, "account_password")

    @_builtins.property
    @pulumi.getter(name="accountRole")
    def account_role(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the role of the account.
        Value options:
        + **read**: The account has read-only privilege.
        + **write**: The account has read and write privilege.
        """
        return pulumi.get(self, "account_role")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the type of the account. The value can be **normal** or **default**.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the account.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the DCS instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the account. The value can be **CREATING**, **AVAILABLE**, **CREATEFAILED**,
        **DELETED**, **DELETEFAILED**, **DELETING**, **UPDATING** or **ERROR**.
        """
        return pulumi.get(self, "status")

