# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DcsBackupArgs', 'DcsBackup']

@pulumi.input_type
class DcsBackupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 backup_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DcsBackup resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] backup_format: Specifies the format of the DCS instance backup.
               Value options: **aof**, **rdb**. Default to rdb.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of DCS instance backup.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if backup_format is not None:
            pulumi.set(__self__, "backup_format", backup_format)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the DCS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="backupFormat")
    def backup_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the format of the DCS instance backup.
        Value options: **aof**, **rdb**. Default to rdb.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "backup_format")

    @backup_format.setter
    def backup_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_format", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of DCS instance backup.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DcsBackupState:
    def __init__(__self__, *,
                 backup_format: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 begin_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_support_restore: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DcsBackup resources.
        :param pulumi.Input[_builtins.str] backup_format: Specifies the format of the DCS instance backup.
               Value options: **aof**, **rdb**. Default to rdb.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] backup_id: Indicates the ID of the DCS instance backup.
        :param pulumi.Input[_builtins.str] begin_time: Indicates the time when the backup task is created. The format is yyyy-mm-dd hh:mm:ss.
               The value is in UTC format.
        :param pulumi.Input[_builtins.str] description: Specifies the description of DCS instance backup.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] end_time: Indicates the time at which DCS instance backup is completed. The format is yyyy-mm-dd hh:mm:ss.
               The value is in UTC format.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] is_support_restore: Indicates whether restoration is supported. Value Options: **TRUE**, **FALSE**.
        :param pulumi.Input[_builtins.str] name: Indicates the backup name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Indicates the size of the backup file (byte).
        :param pulumi.Input[_builtins.str] status: Indicates the backup status. Valid value:
               + **waiting**: The task is waiting to begin.
               + **backuping**: DCS instance backup is in progress.
               + **succeed**: DCS instance backup succeeded.
               + **failed**: DCS instance backup failed.
               + **expired**: The backup file has expired.
               + **deleted**: The backup file has been deleted manually.
        :param pulumi.Input[_builtins.str] type: Indicates the backup type. Valid value:
               + **manual**: indicates manual backup.
               + **auto**: indicates automatic backup.
        """
        if backup_format is not None:
            pulumi.set(__self__, "backup_format", backup_format)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if begin_time is not None:
            pulumi.set(__self__, "begin_time", begin_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_support_restore is not None:
            pulumi.set(__self__, "is_support_restore", is_support_restore)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="backupFormat")
    def backup_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the format of the DCS instance backup.
        Value options: **aof**, **rdb**. Default to rdb.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "backup_format")

    @backup_format.setter
    def backup_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_format", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the ID of the DCS instance backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time when the backup task is created. The format is yyyy-mm-dd hh:mm:ss.
        The value is in UTC format.
        """
        return pulumi.get(self, "begin_time")

    @begin_time.setter
    def begin_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "begin_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of DCS instance backup.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time at which DCS instance backup is completed. The format is yyyy-mm-dd hh:mm:ss.
        The value is in UTC format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the DCS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isSupportRestore")
    def is_support_restore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether restoration is supported. Value Options: **TRUE**, **FALSE**.
        """
        return pulumi.get(self, "is_support_restore")

    @is_support_restore.setter
    def is_support_restore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_support_restore", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the backup name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the size of the backup file (byte).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the backup status. Valid value:
        + **waiting**: The task is waiting to begin.
        + **backuping**: DCS instance backup is in progress.
        + **succeed**: DCS instance backup succeeded.
        + **failed**: DCS instance backup failed.
        + **expired**: The backup file has expired.
        + **deleted**: The backup file has been deleted manually.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the backup type. Valid value:
        + **manual**: indicates manual backup.
        + **auto**: indicates automatic backup.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:index/dcsBackup:DcsBackup")
class DcsBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DCS backup resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        dcs_instance_id = config.require_object("dcsInstanceId")
        test = sbercloud.DcsBackup("test", instance_id=dcs_instance_id)
        ```

        ## Import

        The DCS backup can be imported using the DCS instance ID and backup ID separated by a slash, e.g.:

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsBackup:DcsBackup test <instance_id>/<backup_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_format: Specifies the format of the DCS instance backup.
               Value options: **aof**, **rdb**. Default to rdb.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of DCS instance backup.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DcsBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DCS backup resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        dcs_instance_id = config.require_object("dcsInstanceId")
        test = sbercloud.DcsBackup("test", instance_id=dcs_instance_id)
        ```

        ## Import

        The DCS backup can be imported using the DCS instance ID and backup ID separated by a slash, e.g.:

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsBackup:DcsBackup test <instance_id>/<backup_id>
        ```

        :param str resource_name: The name of the resource.
        :param DcsBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DcsBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_format: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DcsBackupArgs.__new__(DcsBackupArgs)

            __props__.__dict__["backup_format"] = backup_format
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            __props__.__dict__["backup_id"] = None
            __props__.__dict__["begin_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["is_support_restore"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        super(DcsBackup, __self__).__init__(
            'sbercloud:index/dcsBackup:DcsBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_format: Optional[pulumi.Input[_builtins.str]] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            begin_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_support_restore: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DcsBackup':
        """
        Get an existing DcsBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_format: Specifies the format of the DCS instance backup.
               Value options: **aof**, **rdb**. Default to rdb.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] backup_id: Indicates the ID of the DCS instance backup.
        :param pulumi.Input[_builtins.str] begin_time: Indicates the time when the backup task is created. The format is yyyy-mm-dd hh:mm:ss.
               The value is in UTC format.
        :param pulumi.Input[_builtins.str] description: Specifies the description of DCS instance backup.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] end_time: Indicates the time at which DCS instance backup is completed. The format is yyyy-mm-dd hh:mm:ss.
               The value is in UTC format.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DCS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] is_support_restore: Indicates whether restoration is supported. Value Options: **TRUE**, **FALSE**.
        :param pulumi.Input[_builtins.str] name: Indicates the backup name.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Indicates the size of the backup file (byte).
        :param pulumi.Input[_builtins.str] status: Indicates the backup status. Valid value:
               + **waiting**: The task is waiting to begin.
               + **backuping**: DCS instance backup is in progress.
               + **succeed**: DCS instance backup succeeded.
               + **failed**: DCS instance backup failed.
               + **expired**: The backup file has expired.
               + **deleted**: The backup file has been deleted manually.
        :param pulumi.Input[_builtins.str] type: Indicates the backup type. Valid value:
               + **manual**: indicates manual backup.
               + **auto**: indicates automatic backup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DcsBackupState.__new__(_DcsBackupState)

        __props__.__dict__["backup_format"] = backup_format
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["begin_time"] = begin_time
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_support_restore"] = is_support_restore
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return DcsBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupFormat")
    def backup_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the format of the DCS instance backup.
        Value options: **aof**, **rdb**. Default to rdb.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "backup_format")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the ID of the DCS instance backup.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time when the backup task is created. The format is yyyy-mm-dd hh:mm:ss.
        The value is in UTC format.
        """
        return pulumi.get(self, "begin_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of DCS instance backup.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time at which DCS instance backup is completed. The format is yyyy-mm-dd hh:mm:ss.
        The value is in UTC format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the DCS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isSupportRestore")
    def is_support_restore(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether restoration is supported. Value Options: **TRUE**, **FALSE**.
        """
        return pulumi.get(self, "is_support_restore")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the backup name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the size of the backup file (byte).
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the backup status. Valid value:
        + **waiting**: The task is waiting to begin.
        + **backuping**: DCS instance backup is in progress.
        + **succeed**: DCS instance backup succeeded.
        + **failed**: DCS instance backup failed.
        + **expired**: The backup file has expired.
        + **deleted**: The backup file has been deleted manually.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the backup type. Valid value:
        + **manual**: indicates manual backup.
        + **auto**: indicates automatic backup.
        """
        return pulumi.get(self, "type")

