# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DcsRestoreArgs', 'DcsRestore']

@pulumi.input_type
class DcsRestoreArgs:
    def __init__(__self__, *,
                 backup_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 remark: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DcsRestore resource.
        :param pulumi.Input[_builtins.str] backup_id: ID of the backup record.
        :param pulumi.Input[_builtins.str] instance_id: A dcs_instance ID in UUID format.
        :param pulumi.Input[_builtins.str] project_id: The enterprise project id of the dcs instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] remark: Description of DCS instance restoration.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project_id", project_id)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the backup record.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        A dcs_instance ID in UUID format.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The enterprise project id of the dcs instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of DCS instance restoration.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)


@pulumi.input_type
class _DcsRestoreState:
    def __init__(__self__, *,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_records: Optional[pulumi.Input[Sequence[pulumi.Input['DcsRestoreRestoreRecordArgs']]]] = None):
        """
        Input properties used for looking up and filtering DcsRestore resources.
        :param pulumi.Input[_builtins.str] backup_id: ID of the backup record.
        :param pulumi.Input[_builtins.str] instance_id: A dcs_instance ID in UUID format.
        :param pulumi.Input[_builtins.str] project_id: The enterprise project id of the dcs instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] remark: Description of DCS instance restoration.
        :param pulumi.Input[Sequence[pulumi.Input['DcsRestoreRestoreRecordArgs']]] restore_records: Array of the restoration records.
        """
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if restore_records is not None:
            pulumi.set(__self__, "restore_records", restore_records)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the backup record.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A dcs_instance ID in UUID format.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the dcs instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of DCS instance restoration.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter(name="restoreRecords")
    def restore_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DcsRestoreRestoreRecordArgs']]]]:
        """
        Array of the restoration records.
        """
        return pulumi.get(self, "restore_records")

    @restore_records.setter
    def restore_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DcsRestoreRestoreRecordArgs']]]]):
        pulumi.set(self, "restore_records", value)


@pulumi.type_token("sbercloud:index/dcsRestore:DcsRestore")
class DcsRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DCS instance within SberCloud.

        ## Example Usage

        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        project_id = config.require_object("projectId")
        instance_id = config.require_object("instanceId")
        backup_id = config.require_object("backupId")
        test = sbercloud.DcsRestore("test",
            project_id=project_id,
            instance_id=instance_id,
            backup_id=backup_id,
            remark="restore instance")
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsRestore:DcsRestore instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `auto_renew`, `period`, `period_unit`, `rename_commands`,

        `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dcs_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, rename_commands,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: ID of the backup record.
        :param pulumi.Input[_builtins.str] instance_id: A dcs_instance ID in UUID format.
        :param pulumi.Input[_builtins.str] project_id: The enterprise project id of the dcs instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] remark: Description of DCS instance restoration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DcsRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DCS instance within SberCloud.

        ## Example Usage

        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        project_id = config.require_object("projectId")
        instance_id = config.require_object("instanceId")
        backup_id = config.require_object("backupId")
        test = sbercloud.DcsRestore("test",
            project_id=project_id,
            instance_id=instance_id,
            backup_id=backup_id,
            remark="restore instance")
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dcsRestore:DcsRestore instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `auto_renew`, `period`, `period_unit`, `rename_commands`,

        `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dcs_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, rename_commands,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param DcsRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DcsRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DcsRestoreArgs.__new__(DcsRestoreArgs)

            if backup_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_id'")
            __props__.__dict__["backup_id"] = backup_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["remark"] = remark
            __props__.__dict__["restore_records"] = None
        super(DcsRestore, __self__).__init__(
            'sbercloud:index/dcsRestore:DcsRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            remark: Optional[pulumi.Input[_builtins.str]] = None,
            restore_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DcsRestoreRestoreRecordArgs', 'DcsRestoreRestoreRecordArgsDict']]]]] = None) -> 'DcsRestore':
        """
        Get an existing DcsRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: ID of the backup record.
        :param pulumi.Input[_builtins.str] instance_id: A dcs_instance ID in UUID format.
        :param pulumi.Input[_builtins.str] project_id: The enterprise project id of the dcs instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] remark: Description of DCS instance restoration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DcsRestoreRestoreRecordArgs', 'DcsRestoreRestoreRecordArgsDict']]]] restore_records: Array of the restoration records.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DcsRestoreState.__new__(_DcsRestoreState)

        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["remark"] = remark
        __props__.__dict__["restore_records"] = restore_records
        return DcsRestore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the backup record.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        A dcs_instance ID in UUID format.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the dcs instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of DCS instance restoration.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="restoreRecords")
    def restore_records(self) -> pulumi.Output[Sequence['outputs.DcsRestoreRestoreRecord']]:
        """
        Array of the restoration records.
        """
        return pulumi.get(self, "restore_records")

