# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceBackupStrategyArgs',
    'InstanceBackupStrategyArgsDict',
    'InstanceConfigurationArgs',
    'InstanceConfigurationArgsDict',
    'InstanceDatastoreArgs',
    'InstanceDatastoreArgsDict',
    'InstanceFlavorArgs',
    'InstanceFlavorArgsDict',
    'InstanceGroupArgs',
    'InstanceGroupArgsDict',
    'InstanceGroupNodeArgs',
    'InstanceGroupNodeArgsDict',
    'InstanceNodeArgs',
    'InstanceNodeArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceBackupStrategyArgsDict(TypedDict):
        keep_days: pulumi.Input[_builtins.int]
        """
        Specifies the number of days to retain the generated backup files. The value range is
        from 0 to 732.
        + If this parameter is set to 0, the automated backup policy is not set.
        + If this parameter is not transferred, the automated backup policy is enabled by default. Backup files are stored
        for seven days by default.
        """
        start_time: pulumi.Input[_builtins.str]
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. The value cannot be empty. It must be a valid value in the
        "hh:mm-HH:MM" format. The current time is in the UTC format.
        + The HH value must be 1 greater than the hh value.
        + The values from mm and MM must be the same and must be set to any of the following 00, 15, 30, or 45.
        """
        period: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
elif False:
    InstanceBackupStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBackupStrategyArgs:
    def __init__(__self__, *,
                 keep_days: pulumi.Input[_builtins.int],
                 start_time: pulumi.Input[_builtins.str],
                 period: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] keep_days: Specifies the number of days to retain the generated backup files. The value range is
               from 0 to 732.
               + If this parameter is set to 0, the automated backup policy is not set.
               + If this parameter is not transferred, the automated backup policy is enabled by default. Backup files are stored
               for seven days by default.
        :param pulumi.Input[_builtins.str] start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. The value cannot be empty. It must be a valid value in the
               "hh:mm-HH:MM" format. The current time is in the UTC format.
               + The HH value must be 1 greater than the hh value.
               + The values from mm and MM must be the same and must be set to any of the following 00, 15, 30, or 45.
        :param pulumi.Input[_builtins.str] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of days to retain the generated backup files. The value range is
        from 0 to 732.
        + If this parameter is set to 0, the automated backup policy is not set.
        + If this parameter is not transferred, the automated backup policy is enabled by default. Backup files are stored
        for seven days by default.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "keep_days", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. The value cannot be empty. It must be a valid value in the
        "hh:mm-HH:MM" format. The current time is in the UTC format.
        + The HH value must be 1 greater than the hh value.
        + The values from mm and MM must be the same and must be set to any of the following 00, 15, 30, or 45.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)


if not MYPY:
    class InstanceConfigurationArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        Specifies the ID of the template.
        Changing this creates a new instance.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the node type. Valid value:
        + For a Community Edition cluster instance, the value can be **mongos**, **shard** or **config**.
        + For a Community Edition replica set instance, the value is **replica**.
        + For a Community Edition single node instance, the value is **single**.
        Changing this creates a new instance.
        """
elif False:
    InstanceConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceConfigurationArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] id: Specifies the ID of the template.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] type: Specifies the node type. Valid value:
               + For a Community Edition cluster instance, the value can be **mongos**, **shard** or **config**.
               + For a Community Edition replica set instance, the value is **replica**.
               + For a Community Edition single node instance, the value is **single**.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the template.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the node type. Valid value:
        + For a Community Edition cluster instance, the value can be **mongos**, **shard** or **config**.
        + For a Community Edition replica set instance, the value is **replica**.
        + For a Community Edition single node instance, the value is **single**.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class InstanceDatastoreArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the DB engine. **DDS-Community** is supported.
        """
        version: pulumi.Input[_builtins.str]
        """
        Specifies the DB instance version. For the Community Edition, the valid
        values are `3.2`, `3.4`, `4.0`, `4.2`, or `4.4`.
        """
        storage_engine: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the storage engine of the DB instance.
        If `version` is set to `3.2`, `3.4`, or `4.0`, the value is **wiredTiger**.
        If `period_unit` is set to `4.2`, or `4.4`, the value is **rocksDB**.
        """
elif False:
    InstanceDatastoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDatastoreArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 storage_engine: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the DB engine. **DDS-Community** is supported.
        :param pulumi.Input[_builtins.str] version: Specifies the DB instance version. For the Community Edition, the valid
               values are `3.2`, `3.4`, `4.0`, `4.2`, or `4.4`.
        :param pulumi.Input[_builtins.str] storage_engine: Specifies the storage engine of the DB instance.
               If `version` is set to `3.2`, `3.4`, or `4.0`, the value is **wiredTiger**.
               If `period_unit` is set to `4.2`, or `4.4`, the value is **rocksDB**.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if storage_engine is not None:
            pulumi.set(__self__, "storage_engine", storage_engine)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DB engine. **DDS-Community** is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DB instance version. For the Community Edition, the valid
        values are `3.2`, `3.4`, `4.0`, `4.2`, or `4.4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage engine of the DB instance.
        If `version` is set to `3.2`, `3.4`, or `4.0`, the value is **wiredTiger**.
        If `period_unit` is set to `4.2`, or `4.4`, the value is **rocksDB**.
        """
        return pulumi.get(self, "storage_engine")

    @storage_engine.setter
    def storage_engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_engine", value)


if not MYPY:
    class InstanceFlavorArgsDict(TypedDict):
        num: pulumi.Input[_builtins.int]
        """
        Specifies the node quantity. Valid value:
        + In a Community Edition cluster instance,the number of mongos ranges from 2 to 16.
        + In a Community Edition cluster instance,the number of shards ranges from 2 to 16.
        + In an Enhanced Edition cluster instance, the number of shards ranges from 2 to 12.
        + config: the value is 1.
        + replica: the value is 1.
        + single: The value is 1. This parameter can be updated when the value of `type` is mongos or shard.
        """
        spec_code: pulumi.Input[_builtins.str]
        """
        Specifies the resource specification code. In a cluster instance, multiple
        specifications need to be specified. All specifications must be of the same series, that is, general-purpose (s6),
        enhanced (c3), or enhanced II (c6). For example:
        + dds.mongodb.s6.large.4.mongos and dds.mongodb.s6.large.4.config have the same specifications.
        + dds.mongodb.s6.large.4.mongos and dds.mongodb.c3.large.4.config are not of the same specifications. This parameter
        can be updated when the value of `type` is mongos, shard, replica or single.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the node type. Valid value:
        + For a Community Edition cluster instance, the value can be **mongos**, **shard**, or **config**.
        + For an Enhanced Edition cluster instance, the value is **shard**.
        + For a Community Edition replica set instance, the value is **replica**.
        + For a Community Edition single node instance, the value is **single**.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
        is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
        shard, replica or single.
        """
        storage: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the disk type.
        Valid value: **ULTRAHIGH** which indicates the type SSD.
        """
elif False:
    InstanceFlavorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceFlavorArgs:
    def __init__(__self__, *,
                 num: pulumi.Input[_builtins.int],
                 spec_code: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 storage: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] num: Specifies the node quantity. Valid value:
               + In a Community Edition cluster instance,the number of mongos ranges from 2 to 16.
               + In a Community Edition cluster instance,the number of shards ranges from 2 to 16.
               + In an Enhanced Edition cluster instance, the number of shards ranges from 2 to 12.
               + config: the value is 1.
               + replica: the value is 1.
               + single: The value is 1. This parameter can be updated when the value of `type` is mongos or shard.
        :param pulumi.Input[_builtins.str] spec_code: Specifies the resource specification code. In a cluster instance, multiple
               specifications need to be specified. All specifications must be of the same series, that is, general-purpose (s6),
               enhanced (c3), or enhanced II (c6). For example:
               + dds.mongodb.s6.large.4.mongos and dds.mongodb.s6.large.4.config have the same specifications.
               + dds.mongodb.s6.large.4.mongos and dds.mongodb.c3.large.4.config are not of the same specifications. This parameter
               can be updated when the value of `type` is mongos, shard, replica or single.
        :param pulumi.Input[_builtins.str] type: Specifies the node type. Valid value:
               + For a Community Edition cluster instance, the value can be **mongos**, **shard**, or **config**.
               + For an Enhanced Edition cluster instance, the value is **shard**.
               + For a Community Edition replica set instance, the value is **replica**.
               + For a Community Edition single node instance, the value is **single**.
        :param pulumi.Input[_builtins.int] size: Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
               is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
               shard, replica or single.
        :param pulumi.Input[_builtins.str] storage: Specifies the disk type.
               Valid value: **ULTRAHIGH** which indicates the type SSD.
        """
        pulumi.set(__self__, "num", num)
        pulumi.set(__self__, "spec_code", spec_code)
        pulumi.set(__self__, "type", type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @_builtins.property
    @pulumi.getter
    def num(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the node quantity. Valid value:
        + In a Community Edition cluster instance,the number of mongos ranges from 2 to 16.
        + In a Community Edition cluster instance,the number of shards ranges from 2 to 16.
        + In an Enhanced Edition cluster instance, the number of shards ranges from 2 to 12.
        + config: the value is 1.
        + replica: the value is 1.
        + single: The value is 1. This parameter can be updated when the value of `type` is mongos or shard.
        """
        return pulumi.get(self, "num")

    @num.setter
    def num(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num", value)

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource specification code. In a cluster instance, multiple
        specifications need to be specified. All specifications must be of the same series, that is, general-purpose (s6),
        enhanced (c3), or enhanced II (c6). For example:
        + dds.mongodb.s6.large.4.mongos and dds.mongodb.s6.large.4.config have the same specifications.
        + dds.mongodb.s6.large.4.mongos and dds.mongodb.c3.large.4.config are not of the same specifications. This parameter
        can be updated when the value of `type` is mongos, shard, replica or single.
        """
        return pulumi.get(self, "spec_code")

    @spec_code.setter
    def spec_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spec_code", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the node type. Valid value:
        + For a Community Edition cluster instance, the value can be **mongos**, **shard**, or **config**.
        + For an Enhanced Edition cluster instance, the value is **shard**.
        + For a Community Edition replica set instance, the value is **replica**.
        + For a Community Edition single node instance, the value is **single**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
        is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
        shard, replica or single.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk type.
        Valid value: **ULTRAHIGH** which indicates the type SSD.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage", value)


if not MYPY:
    class InstanceGroupArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node ID.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceGroupNodeArgsDict']]]]
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        size: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
        is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
        shard, replica or single.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node status.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node type.
        """
        used: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    InstanceGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGroupArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupNodeArgs']]]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: Indicates the node ID.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[_builtins.str] size: Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
               is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
               shard, replica or single.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] type: Indicates the node type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk size. The value must be a multiple of 10. The unit is GB. This parameter
        is mandatory for nodes except mongos and invalid for mongos. This parameter can be updated when the value of `type` is
        shard, replica or single.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used", value)


if not MYPY:
    class InstanceGroupNodeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node ID.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
        instances, and single node instances.
        """
        public_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
        cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node role.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node status.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node type.
        """
elif False:
    InstanceGroupNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceGroupNodeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: Indicates the node ID.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
               instances, and single node instances.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
               cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        :param pulumi.Input[_builtins.str] role: Indicates the node role.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] type: Indicates the node type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
        instances, and single node instances.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
        cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class InstanceNodeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node ID.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
        instances, and single node instances.
        """
        public_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
        cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node role.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node status.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node type.
        """
elif False:
    InstanceNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNodeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: Indicates the node ID.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
               instances, and single node instances.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
               cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        :param pulumi.Input[_builtins.str] role: Indicates the node role.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] type: Indicates the node type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the private IP address of a node. This parameter is valid only for mongos nodes, replica set
        instances, and single node instances.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the EIP that has been bound on a node. This parameter is valid only for mongos nodes of
        cluster instances, primary nodes and secondary nodes of replica set instances, and single node instances.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


